/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.script;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.script.ScriptRequest;
import com.google.api.services.script.ScriptRequestInitializer;
import com.google.api.services.script.model.Content;
import com.google.api.services.script.model.CreateProjectRequest;
import com.google.api.services.script.model.Deployment;
import com.google.api.services.script.model.DeploymentConfig;
import com.google.api.services.script.model.Empty;
import com.google.api.services.script.model.ExecutionRequest;
import com.google.api.services.script.model.ListDeploymentsResponse;
import com.google.api.services.script.model.ListScriptProcessesResponse;
import com.google.api.services.script.model.ListUserProcessesResponse;
import com.google.api.services.script.model.ListVersionsResponse;
import com.google.api.services.script.model.Metrics;
import com.google.api.services.script.model.Operation;
import com.google.api.services.script.model.Project;
import com.google.api.services.script.model.UpdateDeploymentRequest;
import com.google.api.services.script.model.Version;
import java.io.IOException;
import java.util.List;

public class Script
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://script.googleapis.com/";
    public static final String DEFAULT_MTLS_ROOT_URL = "https://script.mtls.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "";
    public static final String DEFAULT_BATCH_PATH = "batch";
    public static final String DEFAULT_BASE_URL = "https://script.googleapis.com/";

    public Script(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(transport, jsonFactory, httpRequestInitializer));
    }

    Script(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> httpClientRequest) throws IOException {
        super.initialize(httpClientRequest);
    }

    public Processes processes() {
        return new Processes();
    }

    public Projects projects() {
        return new Projects();
    }

    public Scripts scripts() {
        return new Scripts();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && (GoogleUtils.MINOR_VERSION >= 32 || GoogleUtils.MINOR_VERSION == 31 && GoogleUtils.BUGFIX_VERSION >= 1) ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.31.1 of google-api-client to run version 1.31.0 of the Apps Script API library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        private static String chooseEndpoint(HttpTransport transport) {
            String useMtlsEndpoint = System.getenv("GOOGLE_API_USE_MTLS_ENDPOINT");
            String string = useMtlsEndpoint = useMtlsEndpoint == null ? "auto" : useMtlsEndpoint;
            if ("always".equals(useMtlsEndpoint) || "auto".equals(useMtlsEndpoint) && transport != null && transport.isMtls()) {
                return Script.DEFAULT_MTLS_ROOT_URL;
            }
            return "https://script.googleapis.com/";
        }

        public Builder(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(transport, jsonFactory, Builder.chooseEndpoint(transport), Script.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
            this.setBatchPath(Script.DEFAULT_BATCH_PATH);
        }

        public Script build() {
            return new Script(this);
        }

        public Builder setRootUrl(String rootUrl) {
            return (Builder)super.setRootUrl(rootUrl);
        }

        public Builder setServicePath(String servicePath) {
            return (Builder)super.setServicePath(servicePath);
        }

        public Builder setBatchPath(String batchPath) {
            return (Builder)super.setBatchPath(batchPath);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String applicationName) {
            return (Builder)super.setApplicationName(applicationName);
        }

        public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
            return (Builder)super.setSuppressPatternChecks(suppressPatternChecks);
        }

        public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
            return (Builder)super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
        }

        public Builder setSuppressAllChecks(boolean suppressAllChecks) {
            return (Builder)super.setSuppressAllChecks(suppressAllChecks);
        }

        public Builder setScriptRequestInitializer(ScriptRequestInitializer scriptRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)scriptRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }
    }

    public class Scripts {
        public Run run(String scriptId, ExecutionRequest content) throws IOException {
            Run result = new Run(scriptId, content);
            Script.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Run
        extends ScriptRequest<Operation> {
            private static final String REST_PATH = "v1/scripts/{scriptId}:run";
            @Key
            private String scriptId;

            protected Run(String scriptId, ExecutionRequest content) {
                super(Script.this, "POST", REST_PATH, (Object)content, Operation.class);
                this.scriptId = (String)Preconditions.checkNotNull((Object)scriptId, (Object)"Required parameter scriptId must be specified.");
            }

            public Run set$Xgafv(String $Xgafv) {
                return (Run)super.set$Xgafv($Xgafv);
            }

            public Run setAccessToken(String accessToken) {
                return (Run)super.setAccessToken(accessToken);
            }

            public Run setAlt(String alt) {
                return (Run)super.setAlt(alt);
            }

            public Run setCallback(String callback) {
                return (Run)super.setCallback(callback);
            }

            public Run setFields(String fields) {
                return (Run)super.setFields(fields);
            }

            public Run setKey(String key) {
                return (Run)super.setKey(key);
            }

            public Run setOauthToken(String oauthToken) {
                return (Run)super.setOauthToken(oauthToken);
            }

            public Run setPrettyPrint(Boolean prettyPrint) {
                return (Run)super.setPrettyPrint(prettyPrint);
            }

            public Run setQuotaUser(String quotaUser) {
                return (Run)super.setQuotaUser(quotaUser);
            }

            public Run setUploadType(String uploadType) {
                return (Run)super.setUploadType(uploadType);
            }

            public Run setUploadProtocol(String uploadProtocol) {
                return (Run)super.setUploadProtocol(uploadProtocol);
            }

            public String getScriptId() {
                return this.scriptId;
            }

            public Run setScriptId(String scriptId) {
                this.scriptId = scriptId;
                return this;
            }

            @Override
            public Run set(String parameterName, Object value) {
                return (Run)super.set(parameterName, value);
            }
        }
    }

    public class Projects {
        public Create create(CreateProjectRequest content) throws IOException {
            Create result = new Create(content);
            Script.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(String scriptId) throws IOException {
            Get result = new Get(scriptId);
            Script.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public GetContent getContent(String scriptId) throws IOException {
            GetContent result = new GetContent(scriptId);
            Script.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public GetMetrics getMetrics(String scriptId) throws IOException {
            GetMetrics result = new GetMetrics(scriptId);
            Script.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public UpdateContent updateContent(String scriptId, Content content) throws IOException {
            UpdateContent result = new UpdateContent(scriptId, content);
            Script.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Deployments deployments() {
            return new Deployments();
        }

        public Versions versions() {
            return new Versions();
        }

        public class Versions {
            public Create create(String scriptId, Version content) throws IOException {
                Create result = new Create(scriptId, content);
                Script.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Get get(String scriptId, Integer versionNumber) throws IOException {
                Get result = new Get(scriptId, versionNumber);
                Script.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public List list(String scriptId) throws IOException {
                List result = new List(scriptId);
                Script.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class List
            extends ScriptRequest<ListVersionsResponse> {
                private static final String REST_PATH = "v1/projects/{scriptId}/versions";
                @Key
                private String scriptId;
                @Key
                private Integer pageSize;
                @Key
                private String pageToken;

                protected List(String scriptId) {
                    super(Script.this, "GET", REST_PATH, null, ListVersionsResponse.class);
                    this.scriptId = (String)Preconditions.checkNotNull((Object)scriptId, (Object)"Required parameter scriptId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String $Xgafv) {
                    return (List)super.set$Xgafv($Xgafv);
                }

                public List setAccessToken(String accessToken) {
                    return (List)super.setAccessToken(accessToken);
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setCallback(String callback) {
                    return (List)super.setCallback(callback);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUploadType(String uploadType) {
                    return (List)super.setUploadType(uploadType);
                }

                public List setUploadProtocol(String uploadProtocol) {
                    return (List)super.setUploadProtocol(uploadProtocol);
                }

                public String getScriptId() {
                    return this.scriptId;
                }

                public List setScriptId(String scriptId) {
                    this.scriptId = scriptId;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer pageSize) {
                    this.pageSize = pageSize;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String pageToken) {
                    this.pageToken = pageToken;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }

            public class Get
            extends ScriptRequest<Version> {
                private static final String REST_PATH = "v1/projects/{scriptId}/versions/{versionNumber}";
                @Key
                private String scriptId;
                @Key
                private Integer versionNumber;

                protected Get(String scriptId, Integer versionNumber) {
                    super(Script.this, "GET", REST_PATH, null, Version.class);
                    this.scriptId = (String)Preconditions.checkNotNull((Object)scriptId, (Object)"Required parameter scriptId must be specified.");
                    this.versionNumber = (Integer)Preconditions.checkNotNull((Object)versionNumber, (Object)"Required parameter versionNumber must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String $Xgafv) {
                    return (Get)super.set$Xgafv($Xgafv);
                }

                public Get setAccessToken(String accessToken) {
                    return (Get)super.setAccessToken(accessToken);
                }

                public Get setAlt(String alt) {
                    return (Get)super.setAlt(alt);
                }

                public Get setCallback(String callback) {
                    return (Get)super.setCallback(callback);
                }

                public Get setFields(String fields) {
                    return (Get)super.setFields(fields);
                }

                public Get setKey(String key) {
                    return (Get)super.setKey(key);
                }

                public Get setOauthToken(String oauthToken) {
                    return (Get)super.setOauthToken(oauthToken);
                }

                public Get setPrettyPrint(Boolean prettyPrint) {
                    return (Get)super.setPrettyPrint(prettyPrint);
                }

                public Get setQuotaUser(String quotaUser) {
                    return (Get)super.setQuotaUser(quotaUser);
                }

                public Get setUploadType(String uploadType) {
                    return (Get)super.setUploadType(uploadType);
                }

                public Get setUploadProtocol(String uploadProtocol) {
                    return (Get)super.setUploadProtocol(uploadProtocol);
                }

                public String getScriptId() {
                    return this.scriptId;
                }

                public Get setScriptId(String scriptId) {
                    this.scriptId = scriptId;
                    return this;
                }

                public Integer getVersionNumber() {
                    return this.versionNumber;
                }

                public Get setVersionNumber(Integer versionNumber) {
                    this.versionNumber = versionNumber;
                    return this;
                }

                @Override
                public Get set(String parameterName, Object value) {
                    return (Get)super.set(parameterName, value);
                }
            }

            public class Create
            extends ScriptRequest<Version> {
                private static final String REST_PATH = "v1/projects/{scriptId}/versions";
                @Key
                private String scriptId;

                protected Create(String scriptId, Version content) {
                    super(Script.this, "POST", REST_PATH, (Object)content, Version.class);
                    this.scriptId = (String)Preconditions.checkNotNull((Object)scriptId, (Object)"Required parameter scriptId must be specified.");
                }

                public Create set$Xgafv(String $Xgafv) {
                    return (Create)super.set$Xgafv($Xgafv);
                }

                public Create setAccessToken(String accessToken) {
                    return (Create)super.setAccessToken(accessToken);
                }

                public Create setAlt(String alt) {
                    return (Create)super.setAlt(alt);
                }

                public Create setCallback(String callback) {
                    return (Create)super.setCallback(callback);
                }

                public Create setFields(String fields) {
                    return (Create)super.setFields(fields);
                }

                public Create setKey(String key) {
                    return (Create)super.setKey(key);
                }

                public Create setOauthToken(String oauthToken) {
                    return (Create)super.setOauthToken(oauthToken);
                }

                public Create setPrettyPrint(Boolean prettyPrint) {
                    return (Create)super.setPrettyPrint(prettyPrint);
                }

                public Create setQuotaUser(String quotaUser) {
                    return (Create)super.setQuotaUser(quotaUser);
                }

                public Create setUploadType(String uploadType) {
                    return (Create)super.setUploadType(uploadType);
                }

                public Create setUploadProtocol(String uploadProtocol) {
                    return (Create)super.setUploadProtocol(uploadProtocol);
                }

                public String getScriptId() {
                    return this.scriptId;
                }

                public Create setScriptId(String scriptId) {
                    this.scriptId = scriptId;
                    return this;
                }

                @Override
                public Create set(String parameterName, Object value) {
                    return (Create)super.set(parameterName, value);
                }
            }
        }

        public class Deployments {
            public Create create(String scriptId, DeploymentConfig content) throws IOException {
                Create result = new Create(scriptId, content);
                Script.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Delete delete(String scriptId, String deploymentId) throws IOException {
                Delete result = new Delete(scriptId, deploymentId);
                Script.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Get get(String scriptId, String deploymentId) throws IOException {
                Get result = new Get(scriptId, deploymentId);
                Script.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public List list(String scriptId) throws IOException {
                List result = new List(scriptId);
                Script.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Update update(String scriptId, String deploymentId, UpdateDeploymentRequest content) throws IOException {
                Update result = new Update(scriptId, deploymentId, content);
                Script.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class Update
            extends ScriptRequest<Deployment> {
                private static final String REST_PATH = "v1/projects/{scriptId}/deployments/{deploymentId}";
                @Key
                private String scriptId;
                @Key
                private String deploymentId;

                protected Update(String scriptId, String deploymentId, UpdateDeploymentRequest content) {
                    super(Script.this, "PUT", REST_PATH, (Object)content, Deployment.class);
                    this.scriptId = (String)Preconditions.checkNotNull((Object)scriptId, (Object)"Required parameter scriptId must be specified.");
                    this.deploymentId = (String)Preconditions.checkNotNull((Object)deploymentId, (Object)"Required parameter deploymentId must be specified.");
                }

                public Update set$Xgafv(String $Xgafv) {
                    return (Update)super.set$Xgafv($Xgafv);
                }

                public Update setAccessToken(String accessToken) {
                    return (Update)super.setAccessToken(accessToken);
                }

                public Update setAlt(String alt) {
                    return (Update)super.setAlt(alt);
                }

                public Update setCallback(String callback) {
                    return (Update)super.setCallback(callback);
                }

                public Update setFields(String fields) {
                    return (Update)super.setFields(fields);
                }

                public Update setKey(String key) {
                    return (Update)super.setKey(key);
                }

                public Update setOauthToken(String oauthToken) {
                    return (Update)super.setOauthToken(oauthToken);
                }

                public Update setPrettyPrint(Boolean prettyPrint) {
                    return (Update)super.setPrettyPrint(prettyPrint);
                }

                public Update setQuotaUser(String quotaUser) {
                    return (Update)super.setQuotaUser(quotaUser);
                }

                public Update setUploadType(String uploadType) {
                    return (Update)super.setUploadType(uploadType);
                }

                public Update setUploadProtocol(String uploadProtocol) {
                    return (Update)super.setUploadProtocol(uploadProtocol);
                }

                public String getScriptId() {
                    return this.scriptId;
                }

                public Update setScriptId(String scriptId) {
                    this.scriptId = scriptId;
                    return this;
                }

                public String getDeploymentId() {
                    return this.deploymentId;
                }

                public Update setDeploymentId(String deploymentId) {
                    this.deploymentId = deploymentId;
                    return this;
                }

                @Override
                public Update set(String parameterName, Object value) {
                    return (Update)super.set(parameterName, value);
                }
            }

            public class List
            extends ScriptRequest<ListDeploymentsResponse> {
                private static final String REST_PATH = "v1/projects/{scriptId}/deployments";
                @Key
                private String scriptId;
                @Key
                private Integer pageSize;
                @Key
                private String pageToken;

                protected List(String scriptId) {
                    super(Script.this, "GET", REST_PATH, null, ListDeploymentsResponse.class);
                    this.scriptId = (String)Preconditions.checkNotNull((Object)scriptId, (Object)"Required parameter scriptId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String $Xgafv) {
                    return (List)super.set$Xgafv($Xgafv);
                }

                public List setAccessToken(String accessToken) {
                    return (List)super.setAccessToken(accessToken);
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setCallback(String callback) {
                    return (List)super.setCallback(callback);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUploadType(String uploadType) {
                    return (List)super.setUploadType(uploadType);
                }

                public List setUploadProtocol(String uploadProtocol) {
                    return (List)super.setUploadProtocol(uploadProtocol);
                }

                public String getScriptId() {
                    return this.scriptId;
                }

                public List setScriptId(String scriptId) {
                    this.scriptId = scriptId;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer pageSize) {
                    this.pageSize = pageSize;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String pageToken) {
                    this.pageToken = pageToken;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }

            public class Get
            extends ScriptRequest<Deployment> {
                private static final String REST_PATH = "v1/projects/{scriptId}/deployments/{deploymentId}";
                @Key
                private String scriptId;
                @Key
                private String deploymentId;

                protected Get(String scriptId, String deploymentId) {
                    super(Script.this, "GET", REST_PATH, null, Deployment.class);
                    this.scriptId = (String)Preconditions.checkNotNull((Object)scriptId, (Object)"Required parameter scriptId must be specified.");
                    this.deploymentId = (String)Preconditions.checkNotNull((Object)deploymentId, (Object)"Required parameter deploymentId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String $Xgafv) {
                    return (Get)super.set$Xgafv($Xgafv);
                }

                public Get setAccessToken(String accessToken) {
                    return (Get)super.setAccessToken(accessToken);
                }

                public Get setAlt(String alt) {
                    return (Get)super.setAlt(alt);
                }

                public Get setCallback(String callback) {
                    return (Get)super.setCallback(callback);
                }

                public Get setFields(String fields) {
                    return (Get)super.setFields(fields);
                }

                public Get setKey(String key) {
                    return (Get)super.setKey(key);
                }

                public Get setOauthToken(String oauthToken) {
                    return (Get)super.setOauthToken(oauthToken);
                }

                public Get setPrettyPrint(Boolean prettyPrint) {
                    return (Get)super.setPrettyPrint(prettyPrint);
                }

                public Get setQuotaUser(String quotaUser) {
                    return (Get)super.setQuotaUser(quotaUser);
                }

                public Get setUploadType(String uploadType) {
                    return (Get)super.setUploadType(uploadType);
                }

                public Get setUploadProtocol(String uploadProtocol) {
                    return (Get)super.setUploadProtocol(uploadProtocol);
                }

                public String getScriptId() {
                    return this.scriptId;
                }

                public Get setScriptId(String scriptId) {
                    this.scriptId = scriptId;
                    return this;
                }

                public String getDeploymentId() {
                    return this.deploymentId;
                }

                public Get setDeploymentId(String deploymentId) {
                    this.deploymentId = deploymentId;
                    return this;
                }

                @Override
                public Get set(String parameterName, Object value) {
                    return (Get)super.set(parameterName, value);
                }
            }

            public class Delete
            extends ScriptRequest<Empty> {
                private static final String REST_PATH = "v1/projects/{scriptId}/deployments/{deploymentId}";
                @Key
                private String scriptId;
                @Key
                private String deploymentId;

                protected Delete(String scriptId, String deploymentId) {
                    super(Script.this, "DELETE", REST_PATH, null, Empty.class);
                    this.scriptId = (String)Preconditions.checkNotNull((Object)scriptId, (Object)"Required parameter scriptId must be specified.");
                    this.deploymentId = (String)Preconditions.checkNotNull((Object)deploymentId, (Object)"Required parameter deploymentId must be specified.");
                }

                public Delete set$Xgafv(String $Xgafv) {
                    return (Delete)super.set$Xgafv($Xgafv);
                }

                public Delete setAccessToken(String accessToken) {
                    return (Delete)super.setAccessToken(accessToken);
                }

                public Delete setAlt(String alt) {
                    return (Delete)super.setAlt(alt);
                }

                public Delete setCallback(String callback) {
                    return (Delete)super.setCallback(callback);
                }

                public Delete setFields(String fields) {
                    return (Delete)super.setFields(fields);
                }

                public Delete setKey(String key) {
                    return (Delete)super.setKey(key);
                }

                public Delete setOauthToken(String oauthToken) {
                    return (Delete)super.setOauthToken(oauthToken);
                }

                public Delete setPrettyPrint(Boolean prettyPrint) {
                    return (Delete)super.setPrettyPrint(prettyPrint);
                }

                public Delete setQuotaUser(String quotaUser) {
                    return (Delete)super.setQuotaUser(quotaUser);
                }

                public Delete setUploadType(String uploadType) {
                    return (Delete)super.setUploadType(uploadType);
                }

                public Delete setUploadProtocol(String uploadProtocol) {
                    return (Delete)super.setUploadProtocol(uploadProtocol);
                }

                public String getScriptId() {
                    return this.scriptId;
                }

                public Delete setScriptId(String scriptId) {
                    this.scriptId = scriptId;
                    return this;
                }

                public String getDeploymentId() {
                    return this.deploymentId;
                }

                public Delete setDeploymentId(String deploymentId) {
                    this.deploymentId = deploymentId;
                    return this;
                }

                @Override
                public Delete set(String parameterName, Object value) {
                    return (Delete)super.set(parameterName, value);
                }
            }

            public class Create
            extends ScriptRequest<Deployment> {
                private static final String REST_PATH = "v1/projects/{scriptId}/deployments";
                @Key
                private String scriptId;

                protected Create(String scriptId, DeploymentConfig content) {
                    super(Script.this, "POST", REST_PATH, (Object)content, Deployment.class);
                    this.scriptId = (String)Preconditions.checkNotNull((Object)scriptId, (Object)"Required parameter scriptId must be specified.");
                }

                public Create set$Xgafv(String $Xgafv) {
                    return (Create)super.set$Xgafv($Xgafv);
                }

                public Create setAccessToken(String accessToken) {
                    return (Create)super.setAccessToken(accessToken);
                }

                public Create setAlt(String alt) {
                    return (Create)super.setAlt(alt);
                }

                public Create setCallback(String callback) {
                    return (Create)super.setCallback(callback);
                }

                public Create setFields(String fields) {
                    return (Create)super.setFields(fields);
                }

                public Create setKey(String key) {
                    return (Create)super.setKey(key);
                }

                public Create setOauthToken(String oauthToken) {
                    return (Create)super.setOauthToken(oauthToken);
                }

                public Create setPrettyPrint(Boolean prettyPrint) {
                    return (Create)super.setPrettyPrint(prettyPrint);
                }

                public Create setQuotaUser(String quotaUser) {
                    return (Create)super.setQuotaUser(quotaUser);
                }

                public Create setUploadType(String uploadType) {
                    return (Create)super.setUploadType(uploadType);
                }

                public Create setUploadProtocol(String uploadProtocol) {
                    return (Create)super.setUploadProtocol(uploadProtocol);
                }

                public String getScriptId() {
                    return this.scriptId;
                }

                public Create setScriptId(String scriptId) {
                    this.scriptId = scriptId;
                    return this;
                }

                @Override
                public Create set(String parameterName, Object value) {
                    return (Create)super.set(parameterName, value);
                }
            }
        }

        public class UpdateContent
        extends ScriptRequest<Content> {
            private static final String REST_PATH = "v1/projects/{scriptId}/content";
            @Key
            private String scriptId;

            protected UpdateContent(String scriptId, Content content) {
                super(Script.this, "PUT", REST_PATH, (Object)content, Content.class);
                this.scriptId = (String)Preconditions.checkNotNull((Object)scriptId, (Object)"Required parameter scriptId must be specified.");
            }

            public UpdateContent set$Xgafv(String $Xgafv) {
                return (UpdateContent)super.set$Xgafv($Xgafv);
            }

            public UpdateContent setAccessToken(String accessToken) {
                return (UpdateContent)super.setAccessToken(accessToken);
            }

            public UpdateContent setAlt(String alt) {
                return (UpdateContent)super.setAlt(alt);
            }

            public UpdateContent setCallback(String callback) {
                return (UpdateContent)super.setCallback(callback);
            }

            public UpdateContent setFields(String fields) {
                return (UpdateContent)super.setFields(fields);
            }

            public UpdateContent setKey(String key) {
                return (UpdateContent)super.setKey(key);
            }

            public UpdateContent setOauthToken(String oauthToken) {
                return (UpdateContent)super.setOauthToken(oauthToken);
            }

            public UpdateContent setPrettyPrint(Boolean prettyPrint) {
                return (UpdateContent)super.setPrettyPrint(prettyPrint);
            }

            public UpdateContent setQuotaUser(String quotaUser) {
                return (UpdateContent)super.setQuotaUser(quotaUser);
            }

            public UpdateContent setUploadType(String uploadType) {
                return (UpdateContent)super.setUploadType(uploadType);
            }

            public UpdateContent setUploadProtocol(String uploadProtocol) {
                return (UpdateContent)super.setUploadProtocol(uploadProtocol);
            }

            public String getScriptId() {
                return this.scriptId;
            }

            public UpdateContent setScriptId(String scriptId) {
                this.scriptId = scriptId;
                return this;
            }

            @Override
            public UpdateContent set(String parameterName, Object value) {
                return (UpdateContent)super.set(parameterName, value);
            }
        }

        public class GetMetrics
        extends ScriptRequest<Metrics> {
            private static final String REST_PATH = "v1/projects/{scriptId}/metrics";
            @Key
            private String scriptId;
            @Key(value="metricsFilter.deploymentId")
            private String metricsFilterDeploymentId;
            @Key
            private String metricsGranularity;

            protected GetMetrics(String scriptId) {
                super(Script.this, "GET", REST_PATH, null, Metrics.class);
                this.scriptId = (String)Preconditions.checkNotNull((Object)scriptId, (Object)"Required parameter scriptId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public GetMetrics set$Xgafv(String $Xgafv) {
                return (GetMetrics)super.set$Xgafv($Xgafv);
            }

            public GetMetrics setAccessToken(String accessToken) {
                return (GetMetrics)super.setAccessToken(accessToken);
            }

            public GetMetrics setAlt(String alt) {
                return (GetMetrics)super.setAlt(alt);
            }

            public GetMetrics setCallback(String callback) {
                return (GetMetrics)super.setCallback(callback);
            }

            public GetMetrics setFields(String fields) {
                return (GetMetrics)super.setFields(fields);
            }

            public GetMetrics setKey(String key) {
                return (GetMetrics)super.setKey(key);
            }

            public GetMetrics setOauthToken(String oauthToken) {
                return (GetMetrics)super.setOauthToken(oauthToken);
            }

            public GetMetrics setPrettyPrint(Boolean prettyPrint) {
                return (GetMetrics)super.setPrettyPrint(prettyPrint);
            }

            public GetMetrics setQuotaUser(String quotaUser) {
                return (GetMetrics)super.setQuotaUser(quotaUser);
            }

            public GetMetrics setUploadType(String uploadType) {
                return (GetMetrics)super.setUploadType(uploadType);
            }

            public GetMetrics setUploadProtocol(String uploadProtocol) {
                return (GetMetrics)super.setUploadProtocol(uploadProtocol);
            }

            public String getScriptId() {
                return this.scriptId;
            }

            public GetMetrics setScriptId(String scriptId) {
                this.scriptId = scriptId;
                return this;
            }

            public String getMetricsFilterDeploymentId() {
                return this.metricsFilterDeploymentId;
            }

            public GetMetrics setMetricsFilterDeploymentId(String metricsFilterDeploymentId) {
                this.metricsFilterDeploymentId = metricsFilterDeploymentId;
                return this;
            }

            public String getMetricsGranularity() {
                return this.metricsGranularity;
            }

            public GetMetrics setMetricsGranularity(String metricsGranularity) {
                this.metricsGranularity = metricsGranularity;
                return this;
            }

            @Override
            public GetMetrics set(String parameterName, Object value) {
                return (GetMetrics)super.set(parameterName, value);
            }
        }

        public class GetContent
        extends ScriptRequest<Content> {
            private static final String REST_PATH = "v1/projects/{scriptId}/content";
            @Key
            private String scriptId;
            @Key
            private Integer versionNumber;

            protected GetContent(String scriptId) {
                super(Script.this, "GET", REST_PATH, null, Content.class);
                this.scriptId = (String)Preconditions.checkNotNull((Object)scriptId, (Object)"Required parameter scriptId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public GetContent set$Xgafv(String $Xgafv) {
                return (GetContent)super.set$Xgafv($Xgafv);
            }

            public GetContent setAccessToken(String accessToken) {
                return (GetContent)super.setAccessToken(accessToken);
            }

            public GetContent setAlt(String alt) {
                return (GetContent)super.setAlt(alt);
            }

            public GetContent setCallback(String callback) {
                return (GetContent)super.setCallback(callback);
            }

            public GetContent setFields(String fields) {
                return (GetContent)super.setFields(fields);
            }

            public GetContent setKey(String key) {
                return (GetContent)super.setKey(key);
            }

            public GetContent setOauthToken(String oauthToken) {
                return (GetContent)super.setOauthToken(oauthToken);
            }

            public GetContent setPrettyPrint(Boolean prettyPrint) {
                return (GetContent)super.setPrettyPrint(prettyPrint);
            }

            public GetContent setQuotaUser(String quotaUser) {
                return (GetContent)super.setQuotaUser(quotaUser);
            }

            public GetContent setUploadType(String uploadType) {
                return (GetContent)super.setUploadType(uploadType);
            }

            public GetContent setUploadProtocol(String uploadProtocol) {
                return (GetContent)super.setUploadProtocol(uploadProtocol);
            }

            public String getScriptId() {
                return this.scriptId;
            }

            public GetContent setScriptId(String scriptId) {
                this.scriptId = scriptId;
                return this;
            }

            public Integer getVersionNumber() {
                return this.versionNumber;
            }

            public GetContent setVersionNumber(Integer versionNumber) {
                this.versionNumber = versionNumber;
                return this;
            }

            @Override
            public GetContent set(String parameterName, Object value) {
                return (GetContent)super.set(parameterName, value);
            }
        }

        public class Get
        extends ScriptRequest<Project> {
            private static final String REST_PATH = "v1/projects/{scriptId}";
            @Key
            private String scriptId;

            protected Get(String scriptId) {
                super(Script.this, "GET", REST_PATH, null, Project.class);
                this.scriptId = (String)Preconditions.checkNotNull((Object)scriptId, (Object)"Required parameter scriptId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public String getScriptId() {
                return this.scriptId;
            }

            public Get setScriptId(String scriptId) {
                this.scriptId = scriptId;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class Create
        extends ScriptRequest<Project> {
            private static final String REST_PATH = "v1/projects";

            protected Create(CreateProjectRequest content) {
                super(Script.this, "POST", REST_PATH, (Object)content, Project.class);
            }

            public Create set$Xgafv(String $Xgafv) {
                return (Create)super.set$Xgafv($Xgafv);
            }

            public Create setAccessToken(String accessToken) {
                return (Create)super.setAccessToken(accessToken);
            }

            public Create setAlt(String alt) {
                return (Create)super.setAlt(alt);
            }

            public Create setCallback(String callback) {
                return (Create)super.setCallback(callback);
            }

            public Create setFields(String fields) {
                return (Create)super.setFields(fields);
            }

            public Create setKey(String key) {
                return (Create)super.setKey(key);
            }

            public Create setOauthToken(String oauthToken) {
                return (Create)super.setOauthToken(oauthToken);
            }

            public Create setPrettyPrint(Boolean prettyPrint) {
                return (Create)super.setPrettyPrint(prettyPrint);
            }

            public Create setQuotaUser(String quotaUser) {
                return (Create)super.setQuotaUser(quotaUser);
            }

            public Create setUploadType(String uploadType) {
                return (Create)super.setUploadType(uploadType);
            }

            public Create setUploadProtocol(String uploadProtocol) {
                return (Create)super.setUploadProtocol(uploadProtocol);
            }

            @Override
            public Create set(String parameterName, Object value) {
                return (Create)super.set(parameterName, value);
            }
        }
    }

    public class Processes {
        public List list() throws IOException {
            List result = new List();
            Script.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public ListScriptProcesses listScriptProcesses() throws IOException {
            ListScriptProcesses result = new ListScriptProcesses();
            Script.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class ListScriptProcesses
        extends ScriptRequest<ListScriptProcessesResponse> {
            private static final String REST_PATH = "v1/processes:listScriptProcesses";
            @Key
            private Integer pageSize;
            @Key
            private String pageToken;
            @Key
            private String scriptId;
            @Key(value="scriptProcessFilter.deploymentId")
            private String scriptProcessFilterDeploymentId;
            @Key(value="scriptProcessFilter.endTime")
            private String scriptProcessFilterEndTime;
            @Key(value="scriptProcessFilter.functionName")
            private String scriptProcessFilterFunctionName;
            @Key(value="scriptProcessFilter.startTime")
            private String scriptProcessFilterStartTime;
            @Key(value="scriptProcessFilter.statuses")
            private java.util.List<String> scriptProcessFilterStatuses;
            @Key(value="scriptProcessFilter.types")
            private java.util.List<String> scriptProcessFilterTypes;
            @Key(value="scriptProcessFilter.userAccessLevels")
            private java.util.List<String> scriptProcessFilterUserAccessLevels;

            protected ListScriptProcesses() {
                super(Script.this, "GET", REST_PATH, null, ListScriptProcessesResponse.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public ListScriptProcesses set$Xgafv(String $Xgafv) {
                return (ListScriptProcesses)super.set$Xgafv($Xgafv);
            }

            public ListScriptProcesses setAccessToken(String accessToken) {
                return (ListScriptProcesses)super.setAccessToken(accessToken);
            }

            public ListScriptProcesses setAlt(String alt) {
                return (ListScriptProcesses)super.setAlt(alt);
            }

            public ListScriptProcesses setCallback(String callback) {
                return (ListScriptProcesses)super.setCallback(callback);
            }

            public ListScriptProcesses setFields(String fields) {
                return (ListScriptProcesses)super.setFields(fields);
            }

            public ListScriptProcesses setKey(String key) {
                return (ListScriptProcesses)super.setKey(key);
            }

            public ListScriptProcesses setOauthToken(String oauthToken) {
                return (ListScriptProcesses)super.setOauthToken(oauthToken);
            }

            public ListScriptProcesses setPrettyPrint(Boolean prettyPrint) {
                return (ListScriptProcesses)super.setPrettyPrint(prettyPrint);
            }

            public ListScriptProcesses setQuotaUser(String quotaUser) {
                return (ListScriptProcesses)super.setQuotaUser(quotaUser);
            }

            public ListScriptProcesses setUploadType(String uploadType) {
                return (ListScriptProcesses)super.setUploadType(uploadType);
            }

            public ListScriptProcesses setUploadProtocol(String uploadProtocol) {
                return (ListScriptProcesses)super.setUploadProtocol(uploadProtocol);
            }

            public Integer getPageSize() {
                return this.pageSize;
            }

            public ListScriptProcesses setPageSize(Integer pageSize) {
                this.pageSize = pageSize;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public ListScriptProcesses setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            public String getScriptId() {
                return this.scriptId;
            }

            public ListScriptProcesses setScriptId(String scriptId) {
                this.scriptId = scriptId;
                return this;
            }

            public String getScriptProcessFilterDeploymentId() {
                return this.scriptProcessFilterDeploymentId;
            }

            public ListScriptProcesses setScriptProcessFilterDeploymentId(String scriptProcessFilterDeploymentId) {
                this.scriptProcessFilterDeploymentId = scriptProcessFilterDeploymentId;
                return this;
            }

            public String getScriptProcessFilterEndTime() {
                return this.scriptProcessFilterEndTime;
            }

            public ListScriptProcesses setScriptProcessFilterEndTime(String scriptProcessFilterEndTime) {
                this.scriptProcessFilterEndTime = scriptProcessFilterEndTime;
                return this;
            }

            public String getScriptProcessFilterFunctionName() {
                return this.scriptProcessFilterFunctionName;
            }

            public ListScriptProcesses setScriptProcessFilterFunctionName(String scriptProcessFilterFunctionName) {
                this.scriptProcessFilterFunctionName = scriptProcessFilterFunctionName;
                return this;
            }

            public String getScriptProcessFilterStartTime() {
                return this.scriptProcessFilterStartTime;
            }

            public ListScriptProcesses setScriptProcessFilterStartTime(String scriptProcessFilterStartTime) {
                this.scriptProcessFilterStartTime = scriptProcessFilterStartTime;
                return this;
            }

            public java.util.List<String> getScriptProcessFilterStatuses() {
                return this.scriptProcessFilterStatuses;
            }

            public ListScriptProcesses setScriptProcessFilterStatuses(java.util.List<String> scriptProcessFilterStatuses) {
                this.scriptProcessFilterStatuses = scriptProcessFilterStatuses;
                return this;
            }

            public java.util.List<String> getScriptProcessFilterTypes() {
                return this.scriptProcessFilterTypes;
            }

            public ListScriptProcesses setScriptProcessFilterTypes(java.util.List<String> scriptProcessFilterTypes) {
                this.scriptProcessFilterTypes = scriptProcessFilterTypes;
                return this;
            }

            public java.util.List<String> getScriptProcessFilterUserAccessLevels() {
                return this.scriptProcessFilterUserAccessLevels;
            }

            public ListScriptProcesses setScriptProcessFilterUserAccessLevels(java.util.List<String> scriptProcessFilterUserAccessLevels) {
                this.scriptProcessFilterUserAccessLevels = scriptProcessFilterUserAccessLevels;
                return this;
            }

            @Override
            public ListScriptProcesses set(String parameterName, Object value) {
                return (ListScriptProcesses)super.set(parameterName, value);
            }
        }

        public class List
        extends ScriptRequest<ListUserProcessesResponse> {
            private static final String REST_PATH = "v1/processes";
            @Key
            private Integer pageSize;
            @Key
            private String pageToken;
            @Key(value="userProcessFilter.deploymentId")
            private String userProcessFilterDeploymentId;
            @Key(value="userProcessFilter.endTime")
            private String userProcessFilterEndTime;
            @Key(value="userProcessFilter.functionName")
            private String userProcessFilterFunctionName;
            @Key(value="userProcessFilter.projectName")
            private String userProcessFilterProjectName;
            @Key(value="userProcessFilter.scriptId")
            private String userProcessFilterScriptId;
            @Key(value="userProcessFilter.startTime")
            private String userProcessFilterStartTime;
            @Key(value="userProcessFilter.statuses")
            private java.util.List<String> userProcessFilterStatuses;
            @Key(value="userProcessFilter.types")
            private java.util.List<String> userProcessFilterTypes;
            @Key(value="userProcessFilter.userAccessLevels")
            private java.util.List<String> userProcessFilterUserAccessLevels;

            protected List() {
                super(Script.this, "GET", REST_PATH, null, ListUserProcessesResponse.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public Integer getPageSize() {
                return this.pageSize;
            }

            public List setPageSize(Integer pageSize) {
                this.pageSize = pageSize;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            public String getUserProcessFilterDeploymentId() {
                return this.userProcessFilterDeploymentId;
            }

            public List setUserProcessFilterDeploymentId(String userProcessFilterDeploymentId) {
                this.userProcessFilterDeploymentId = userProcessFilterDeploymentId;
                return this;
            }

            public String getUserProcessFilterEndTime() {
                return this.userProcessFilterEndTime;
            }

            public List setUserProcessFilterEndTime(String userProcessFilterEndTime) {
                this.userProcessFilterEndTime = userProcessFilterEndTime;
                return this;
            }

            public String getUserProcessFilterFunctionName() {
                return this.userProcessFilterFunctionName;
            }

            public List setUserProcessFilterFunctionName(String userProcessFilterFunctionName) {
                this.userProcessFilterFunctionName = userProcessFilterFunctionName;
                return this;
            }

            public String getUserProcessFilterProjectName() {
                return this.userProcessFilterProjectName;
            }

            public List setUserProcessFilterProjectName(String userProcessFilterProjectName) {
                this.userProcessFilterProjectName = userProcessFilterProjectName;
                return this;
            }

            public String getUserProcessFilterScriptId() {
                return this.userProcessFilterScriptId;
            }

            public List setUserProcessFilterScriptId(String userProcessFilterScriptId) {
                this.userProcessFilterScriptId = userProcessFilterScriptId;
                return this;
            }

            public String getUserProcessFilterStartTime() {
                return this.userProcessFilterStartTime;
            }

            public List setUserProcessFilterStartTime(String userProcessFilterStartTime) {
                this.userProcessFilterStartTime = userProcessFilterStartTime;
                return this;
            }

            public java.util.List<String> getUserProcessFilterStatuses() {
                return this.userProcessFilterStatuses;
            }

            public List setUserProcessFilterStatuses(java.util.List<String> userProcessFilterStatuses) {
                this.userProcessFilterStatuses = userProcessFilterStatuses;
                return this;
            }

            public java.util.List<String> getUserProcessFilterTypes() {
                return this.userProcessFilterTypes;
            }

            public List setUserProcessFilterTypes(java.util.List<String> userProcessFilterTypes) {
                this.userProcessFilterTypes = userProcessFilterTypes;
                return this;
            }

            public java.util.List<String> getUserProcessFilterUserAccessLevels() {
                return this.userProcessFilterUserAccessLevels;
            }

            public List setUserProcessFilterUserAccessLevels(java.util.List<String> userProcessFilterUserAccessLevels) {
                this.userProcessFilterUserAccessLevels = userProcessFilterUserAccessLevels;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }
    }
}

