/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2018-12-11 at 04:08:12 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.script.model;

/**
 * A stack trace through the script that shows where the execution failed.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Apps Script API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ScriptStackTraceElement extends com.google.api.client.json.GenericJson {

  /**
   * The name of the function that failed.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String function;

  /**
   * The line number where the script failed.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer lineNumber;

  /**
   * The name of the function that failed.
   * @return value or {@code null} for none
   */
  public java.lang.String getFunction() {
    return function;
  }

  /**
   * The name of the function that failed.
   * @param function function or {@code null} for none
   */
  public ScriptStackTraceElement setFunction(java.lang.String function) {
    this.function = function;
    return this;
  }

  /**
   * The line number where the script failed.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getLineNumber() {
    return lineNumber;
  }

  /**
   * The line number where the script failed.
   * @param lineNumber lineNumber or {@code null} for none
   */
  public ScriptStackTraceElement setLineNumber(java.lang.Integer lineNumber) {
    this.lineNumber = lineNumber;
    return this;
  }

  @Override
  public ScriptStackTraceElement set(String fieldName, Object value) {
    return (ScriptStackTraceElement) super.set(fieldName, value);
  }

  @Override
  public ScriptStackTraceElement clone() {
    return (ScriptStackTraceElement) super.clone();
  }

}
