/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2019-02-12 at 10:44:33 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.script.model;

/**
 * An individual file within a script project. A file is a third-party source code created by one or
 * more developers. It can be a server-side JS code, HTML, or a configuration file. Each script
 * project can contain multiple files.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Apps Script API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class File extends com.google.api.client.json.GenericJson {

  /**
   * Creation date timestamp. This read-only field is only visible to users who have WRITER
   * permission for the script project.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String createTime;

  /**
   * The defined set of functions in the script file, if any.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private GoogleAppsScriptTypeFunctionSet functionSet;

  /**
   * The user who modified the file most recently. This read-only field is only visible to users who
   * have WRITER permission for the script project.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private GoogleAppsScriptTypeUser lastModifyUser;

  /**
   * The name of the file. The file extension is not part of the file name, which can be identified
   * from the type field.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * The file content.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String source;

  /**
   * The type of the file.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String type;

  /**
   * Last modified date timestamp. This read-only field is only visible to users who have WRITER
   * permission for the script project.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String updateTime;

  /**
   * Creation date timestamp. This read-only field is only visible to users who have WRITER
   * permission for the script project.
   * @return value or {@code null} for none
   */
  public String getCreateTime() {
    return createTime;
  }

  /**
   * Creation date timestamp. This read-only field is only visible to users who have WRITER
   * permission for the script project.
   * @param createTime createTime or {@code null} for none
   */
  public File setCreateTime(String createTime) {
    this.createTime = createTime;
    return this;
  }

  /**
   * The defined set of functions in the script file, if any.
   * @return value or {@code null} for none
   */
  public GoogleAppsScriptTypeFunctionSet getFunctionSet() {
    return functionSet;
  }

  /**
   * The defined set of functions in the script file, if any.
   * @param functionSet functionSet or {@code null} for none
   */
  public File setFunctionSet(GoogleAppsScriptTypeFunctionSet functionSet) {
    this.functionSet = functionSet;
    return this;
  }

  /**
   * The user who modified the file most recently. This read-only field is only visible to users who
   * have WRITER permission for the script project.
   * @return value or {@code null} for none
   */
  public GoogleAppsScriptTypeUser getLastModifyUser() {
    return lastModifyUser;
  }

  /**
   * The user who modified the file most recently. This read-only field is only visible to users who
   * have WRITER permission for the script project.
   * @param lastModifyUser lastModifyUser or {@code null} for none
   */
  public File setLastModifyUser(GoogleAppsScriptTypeUser lastModifyUser) {
    this.lastModifyUser = lastModifyUser;
    return this;
  }

  /**
   * The name of the file. The file extension is not part of the file name, which can be identified
   * from the type field.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * The name of the file. The file extension is not part of the file name, which can be identified
   * from the type field.
   * @param name name or {@code null} for none
   */
  public File setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * The file content.
   * @return value or {@code null} for none
   */
  public java.lang.String getSource() {
    return source;
  }

  /**
   * The file content.
   * @param source source or {@code null} for none
   */
  public File setSource(java.lang.String source) {
    this.source = source;
    return this;
  }

  /**
   * The type of the file.
   * @return value or {@code null} for none
   */
  public java.lang.String getType() {
    return type;
  }

  /**
   * The type of the file.
   * @param type type or {@code null} for none
   */
  public File setType(java.lang.String type) {
    this.type = type;
    return this;
  }

  /**
   * Last modified date timestamp. This read-only field is only visible to users who have WRITER
   * permission for the script project.
   * @return value or {@code null} for none
   */
  public String getUpdateTime() {
    return updateTime;
  }

  /**
   * Last modified date timestamp. This read-only field is only visible to users who have WRITER
   * permission for the script project.
   * @param updateTime updateTime or {@code null} for none
   */
  public File setUpdateTime(String updateTime) {
    this.updateTime = updateTime;
    return this;
  }

  @Override
  public File set(String fieldName, Object value) {
    return (File) super.set(fieldName, value);
  }

  @Override
  public File clone() {
    return (File) super.clone();
  }

}
