/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2019-02-20 at 22:25:16 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.script.model;

/**
 * A resource representing a script project version. A version is a "snapshot" of a script project
 * and is similar to a read-only branched release. When creating deployments, the version to use
 * must be specified.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Apps Script API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Version extends com.google.api.client.json.GenericJson {

  /**
   * When the version was created.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String createTime;

  /**
   * The description for this version.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String description;

  /**
   * The script project's Drive ID.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String scriptId;

  /**
   * The incremental ID that is created by Apps Script when a version is created. This is system
   * assigned number and is immutable once created.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer versionNumber;

  /**
   * When the version was created.
   * @return value or {@code null} for none
   */
  public String getCreateTime() {
    return createTime;
  }

  /**
   * When the version was created.
   * @param createTime createTime or {@code null} for none
   */
  public Version setCreateTime(String createTime) {
    this.createTime = createTime;
    return this;
  }

  /**
   * The description for this version.
   * @return value or {@code null} for none
   */
  public java.lang.String getDescription() {
    return description;
  }

  /**
   * The description for this version.
   * @param description description or {@code null} for none
   */
  public Version setDescription(java.lang.String description) {
    this.description = description;
    return this;
  }

  /**
   * The script project's Drive ID.
   * @return value or {@code null} for none
   */
  public java.lang.String getScriptId() {
    return scriptId;
  }

  /**
   * The script project's Drive ID.
   * @param scriptId scriptId or {@code null} for none
   */
  public Version setScriptId(java.lang.String scriptId) {
    this.scriptId = scriptId;
    return this;
  }

  /**
   * The incremental ID that is created by Apps Script when a version is created. This is system
   * assigned number and is immutable once created.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getVersionNumber() {
    return versionNumber;
  }

  /**
   * The incremental ID that is created by Apps Script when a version is created. This is system
   * assigned number and is immutable once created.
   * @param versionNumber versionNumber or {@code null} for none
   */
  public Version setVersionNumber(java.lang.Integer versionNumber) {
    this.versionNumber = versionNumber;
    return this;
  }

  @Override
  public Version set(String fieldName, Object value) {
    return (Version) super.set(fieldName, value);
  }

  @Override
  public Version clone() {
    return (Version) super.clone();
  }

}
