/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2019-03-15 at 10:12:08 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.script.model;

/**
 * Response with the list of the versions for the specified script project.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Apps Script API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ListVersionsResponse extends com.google.api.client.json.GenericJson {

  /**
   * The token use to fetch the next page of records. if not exist in the response, that means no
   * more versions to list.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String nextPageToken;

  /**
   * The list of versions.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Version> versions;

  /**
   * The token use to fetch the next page of records. if not exist in the response, that means no
   * more versions to list.
   * @return value or {@code null} for none
   */
  public java.lang.String getNextPageToken() {
    return nextPageToken;
  }

  /**
   * The token use to fetch the next page of records. if not exist in the response, that means no
   * more versions to list.
   * @param nextPageToken nextPageToken or {@code null} for none
   */
  public ListVersionsResponse setNextPageToken(java.lang.String nextPageToken) {
    this.nextPageToken = nextPageToken;
    return this;
  }

  /**
   * The list of versions.
   * @return value or {@code null} for none
   */
  public java.util.List<Version> getVersions() {
    return versions;
  }

  /**
   * The list of versions.
   * @param versions versions or {@code null} for none
   */
  public ListVersionsResponse setVersions(java.util.List<Version> versions) {
    this.versions = versions;
    return this;
  }

  @Override
  public ListVersionsResponse set(String fieldName, Object value) {
    return (ListVersionsResponse) super.set(fieldName, value);
  }

  @Override
  public ListVersionsResponse clone() {
    return (ListVersionsResponse) super.clone();
  }

}
