/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2019-03-16 at 05:31:09 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.script.model;

/**
 * If a `run` call succeeds but the script function (or Apps Script itself) throws an exception, the
 * response body's error field contains this `Status` object.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Apps Script API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Status extends com.google.api.client.json.GenericJson {

  /**
   * The status code. For this API, this value either:   10, indicating a `SCRIPT_TIMEOUT` error,
   * 3, indicating an `INVALID_ARGUMENT` error, or  1, indicating a `CANCELLED` execution.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer code;

  /**
   * An array that contains a single ExecutionError object that provides information about the
   * nature of the error.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.util.Map<String, java.lang.Object>> details;

  /**
   * A developer-facing error message, which is in English. Any user-facing error message is
   * localized and sent in the details field, or localized by the client.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String message;

  /**
   * The status code. For this API, this value either:   10, indicating a `SCRIPT_TIMEOUT` error,
   * 3, indicating an `INVALID_ARGUMENT` error, or  1, indicating a `CANCELLED` execution.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getCode() {
    return code;
  }

  /**
   * The status code. For this API, this value either:   10, indicating a `SCRIPT_TIMEOUT` error,
   * 3, indicating an `INVALID_ARGUMENT` error, or  1, indicating a `CANCELLED` execution.
   * @param code code or {@code null} for none
   */
  public Status setCode(java.lang.Integer code) {
    this.code = code;
    return this;
  }

  /**
   * An array that contains a single ExecutionError object that provides information about the
   * nature of the error.
   * @return value or {@code null} for none
   */
  public java.util.List<java.util.Map<String, java.lang.Object>> getDetails() {
    return details;
  }

  /**
   * An array that contains a single ExecutionError object that provides information about the
   * nature of the error.
   * @param details details or {@code null} for none
   */
  public Status setDetails(java.util.List<java.util.Map<String, java.lang.Object>> details) {
    this.details = details;
    return this;
  }

  /**
   * A developer-facing error message, which is in English. Any user-facing error message is
   * localized and sent in the details field, or localized by the client.
   * @return value or {@code null} for none
   */
  public java.lang.String getMessage() {
    return message;
  }

  /**
   * A developer-facing error message, which is in English. Any user-facing error message is
   * localized and sent in the details field, or localized by the client.
   * @param message message or {@code null} for none
   */
  public Status setMessage(java.lang.String message) {
    this.message = message;
    return this;
  }

  @Override
  public Status set(String fieldName, Object value) {
    return (Status) super.set(fieldName, value);
  }

  @Override
  public Status clone() {
    return (Status) super.clone();
  }

}
