/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2019-03-28 at 05:48:20 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.script;

/**
 * Service definition for Script (v1).
 *
 * <p>
 * Manages and executes Google Apps Script projects.

 * </p>
 *
 * <p>
 * For more information about this service, see the
 * <a href="https://developers.google.com/apps-script/api/" target="_blank">API Documentation</a>
 * </p>
 *
 * <p>
 * This service uses {@link ScriptRequestInitializer} to initialize global parameters via its
 * {@link Builder}.
 * </p>
 *
 * @since 1.3
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public class Script extends com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient {

  // Note: Leave this static initializer at the top of the file.
  static {
    com.google.api.client.util.Preconditions.checkState(
        com.google.api.client.googleapis.GoogleUtils.MAJOR_VERSION == 1 &&
        com.google.api.client.googleapis.GoogleUtils.MINOR_VERSION >= 15,
        "You are currently running with version %s of google-api-client. " +
        "You need at least version 1.15 of google-api-client to run version " +
        "1.22.0 of the Apps Script API library.", com.google.api.client.googleapis.GoogleUtils.VERSION);
  }

  /**
   * The default encoded root URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   *
   * @since 1.7
   */
  public static final String DEFAULT_ROOT_URL = "https://script.googleapis.com/";

  /**
   * The default encoded service path of the service. This is determined when the library is
   * generated and normally should not be changed.
   *
   * @since 1.7
   */
  public static final String DEFAULT_SERVICE_PATH = "";

  /**
   * The default encoded base URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   */
  public static final String DEFAULT_BASE_URL = DEFAULT_ROOT_URL + DEFAULT_SERVICE_PATH;

  /**
   * Constructor.
   *
   * <p>
   * Use {@link Builder} if you need to specify any of the optional parameters.
   * </p>
   *
   * @param transport HTTP transport, which should normally be:
   *        <ul>
   *        <li>Google App Engine:
   *        {@code com.google.api.client.extensions.appengine.http.UrlFetchTransport}</li>
   *        <li>Android: {@code newCompatibleTransport} from
   *        {@code com.google.api.client.extensions.android.http.AndroidHttp}</li>
   *        <li>Java: {@link com.google.api.client.googleapis.javanet.GoogleNetHttpTransport#newTrustedTransport()}
   *        </li>
   *        </ul>
   * @param jsonFactory JSON factory, which may be:
   *        <ul>
   *        <li>Jackson: {@code com.google.api.client.json.jackson2.JacksonFactory}</li>
   *        <li>Google GSON: {@code com.google.api.client.json.gson.GsonFactory}</li>
   *        <li>Android Honeycomb or higher:
   *        {@code com.google.api.client.extensions.android.json.AndroidJsonFactory}</li>
   *        </ul>
   * @param httpRequestInitializer HTTP request initializer or {@code null} for none
   * @since 1.7
   */
  public Script(com.google.api.client.http.HttpTransport transport, com.google.api.client.json.JsonFactory jsonFactory,
      com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
    this(new Builder(transport, jsonFactory, httpRequestInitializer));
  }

  /**
   * @param builder builder
   */
  Script(Builder builder) {
    super(builder);
  }

  @Override
  protected void initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest<?> httpClientRequest) throws java.io.IOException {
    super.initialize(httpClientRequest);
  }

  /**
   * An accessor for creating requests from the Processes collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Script script = new Script(...);}
   *   {@code Script.Processes.List request = script.processes().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Processes processes() {
    return new Processes();
  }

  /**
   * The "processes" collection of methods.
   */
  public class Processes {

    /**
     * List information about processes made by or on behalf of a user, such as process type and current
     * status.
     *
     * Create a request for the method "processes.list".
     *
     * This request holds the parameters needed by the script server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @return the request
     */
    public List list() throws java.io.IOException {
      List result = new List();
      initialize(result);
      return result;
    }

    public class List extends ScriptRequest<com.google.api.services.script.model.ListUserProcessesResponse> {

      private static final String REST_PATH = "v1/processes";

      /**
       * List information about processes made by or on behalf of a user, such as process type and
       * current status.
       *
       * Create a request for the method "processes.list".
       *
       * This request holds the parameters needed by the the script server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @since 1.13
       */
      protected List() {
        super(Script.this, "GET", REST_PATH, null, com.google.api.services.script.model.ListUserProcessesResponse.class);
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List set$Xgafv(java.lang.String $Xgafv) {
        return (List) super.set$Xgafv($Xgafv);
      }

      @Override
      public List setAccessToken(java.lang.String accessToken) {
        return (List) super.setAccessToken(accessToken);
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setCallback(java.lang.String callback) {
        return (List) super.setCallback(callback);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUploadType(java.lang.String uploadType) {
        return (List) super.setUploadType(uploadType);
      }

      @Override
      public List setUploadProtocol(java.lang.String uploadProtocol) {
        return (List) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * Optional field used to limit returned processes to those having one of the specified
       * process types.
       */
      @com.google.api.client.util.Key("userProcessFilter.types")
      private java.util.List<java.lang.String> userProcessFilterTypes;

      /** Optional field used to limit returned processes to those having one of the specified process types.
       */
      public java.util.List<java.lang.String> getUserProcessFilterTypes() {
        return userProcessFilterTypes;
      }

      /**
       * Optional field used to limit returned processes to those having one of the specified
       * process types.
       */
      public List setUserProcessFilterTypes(java.util.List<java.lang.String> userProcessFilterTypes) {
        this.userProcessFilterTypes = userProcessFilterTypes;
        return this;
      }

      /**
       * Optional field used to limit returned processes to those having one of the specified
       * process statuses.
       */
      @com.google.api.client.util.Key("userProcessFilter.statuses")
      private java.util.List<java.lang.String> userProcessFilterStatuses;

      /** Optional field used to limit returned processes to those having one of the specified process
     statuses.
       */
      public java.util.List<java.lang.String> getUserProcessFilterStatuses() {
        return userProcessFilterStatuses;
      }

      /**
       * Optional field used to limit returned processes to those having one of the specified
       * process statuses.
       */
      public List setUserProcessFilterStatuses(java.util.List<java.lang.String> userProcessFilterStatuses) {
        this.userProcessFilterStatuses = userProcessFilterStatuses;
        return this;
      }

      /**
       * Optional field used to limit returned processes to those originating from projects with a
       * specific deployment ID.
       */
      @com.google.api.client.util.Key("userProcessFilter.deploymentId")
      private java.lang.String userProcessFilterDeploymentId;

      /** Optional field used to limit returned processes to those originating from projects with a specific
     deployment ID.
       */
      public java.lang.String getUserProcessFilterDeploymentId() {
        return userProcessFilterDeploymentId;
      }

      /**
       * Optional field used to limit returned processes to those originating from projects with a
       * specific deployment ID.
       */
      public List setUserProcessFilterDeploymentId(java.lang.String userProcessFilterDeploymentId) {
        this.userProcessFilterDeploymentId = userProcessFilterDeploymentId;
        return this;
      }

      /**
       * The token for continuing a previous list request on the next page. This should be set to
       * the value of `nextPageToken` from a previous response.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** The token for continuing a previous list request on the next page. This should be set to the value
     of `nextPageToken` from a previous response.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * The token for continuing a previous list request on the next page. This should be set to
       * the value of `nextPageToken` from a previous response.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /**
       * Optional field used to limit returned processes to those that completed on or before the
       * given timestamp.
       */
      @com.google.api.client.util.Key("userProcessFilter.endTime")
      private String userProcessFilterEndTime;

      /** Optional field used to limit returned processes to those that completed on or before the given
     timestamp.
       */
      public String getUserProcessFilterEndTime() {
        return userProcessFilterEndTime;
      }

      /**
       * Optional field used to limit returned processes to those that completed on or before the
       * given timestamp.
       */
      public List setUserProcessFilterEndTime(String userProcessFilterEndTime) {
        this.userProcessFilterEndTime = userProcessFilterEndTime;
        return this;
      }

      /**
       * The maximum number of returned processes per page of results. Defaults to 50.
       */
      @com.google.api.client.util.Key
      private java.lang.Integer pageSize;

      /** The maximum number of returned processes per page of results. Defaults to 50.
       */
      public java.lang.Integer getPageSize() {
        return pageSize;
      }

      /**
       * The maximum number of returned processes per page of results. Defaults to 50.
       */
      public List setPageSize(java.lang.Integer pageSize) {
        this.pageSize = pageSize;
        return this;
      }

      /**
       * Optional field used to limit returned processes to those that were started on or after the
       * given timestamp.
       */
      @com.google.api.client.util.Key("userProcessFilter.startTime")
      private String userProcessFilterStartTime;

      /** Optional field used to limit returned processes to those that were started on or after the given
     timestamp.
       */
      public String getUserProcessFilterStartTime() {
        return userProcessFilterStartTime;
      }

      /**
       * Optional field used to limit returned processes to those that were started on or after the
       * given timestamp.
       */
      public List setUserProcessFilterStartTime(String userProcessFilterStartTime) {
        this.userProcessFilterStartTime = userProcessFilterStartTime;
        return this;
      }

      /**
       * Optional field used to limit returned processes to those originating from projects with
       * project names containing a specific string.
       */
      @com.google.api.client.util.Key("userProcessFilter.projectName")
      private java.lang.String userProcessFilterProjectName;

      /** Optional field used to limit returned processes to those originating from projects with project
     names containing a specific string.
       */
      public java.lang.String getUserProcessFilterProjectName() {
        return userProcessFilterProjectName;
      }

      /**
       * Optional field used to limit returned processes to those originating from projects with
       * project names containing a specific string.
       */
      public List setUserProcessFilterProjectName(java.lang.String userProcessFilterProjectName) {
        this.userProcessFilterProjectName = userProcessFilterProjectName;
        return this;
      }

      /**
       * Optional field used to limit returned processes to those having one of the specified user
       * access levels.
       */
      @com.google.api.client.util.Key("userProcessFilter.userAccessLevels")
      private java.util.List<java.lang.String> userProcessFilterUserAccessLevels;

      /** Optional field used to limit returned processes to those having one of the specified user access
     levels.
       */
      public java.util.List<java.lang.String> getUserProcessFilterUserAccessLevels() {
        return userProcessFilterUserAccessLevels;
      }

      /**
       * Optional field used to limit returned processes to those having one of the specified user
       * access levels.
       */
      public List setUserProcessFilterUserAccessLevels(java.util.List<java.lang.String> userProcessFilterUserAccessLevels) {
        this.userProcessFilterUserAccessLevels = userProcessFilterUserAccessLevels;
        return this;
      }

      /**
       * Optional field used to limit returned processes to those originating from a script function
       * with the given function name.
       */
      @com.google.api.client.util.Key("userProcessFilter.functionName")
      private java.lang.String userProcessFilterFunctionName;

      /** Optional field used to limit returned processes to those originating from a script function with
     the given function name.
       */
      public java.lang.String getUserProcessFilterFunctionName() {
        return userProcessFilterFunctionName;
      }

      /**
       * Optional field used to limit returned processes to those originating from a script function
       * with the given function name.
       */
      public List setUserProcessFilterFunctionName(java.lang.String userProcessFilterFunctionName) {
        this.userProcessFilterFunctionName = userProcessFilterFunctionName;
        return this;
      }

      /**
       * Optional field used to limit returned processes to those originating from projects with a
       * specific script ID.
       */
      @com.google.api.client.util.Key("userProcessFilter.scriptId")
      private java.lang.String userProcessFilterScriptId;

      /** Optional field used to limit returned processes to those originating from projects with a specific
     script ID.
       */
      public java.lang.String getUserProcessFilterScriptId() {
        return userProcessFilterScriptId;
      }

      /**
       * Optional field used to limit returned processes to those originating from projects with a
       * specific script ID.
       */
      public List setUserProcessFilterScriptId(java.lang.String userProcessFilterScriptId) {
        this.userProcessFilterScriptId = userProcessFilterScriptId;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }
    /**
     * List information about a script's executed processes, such as process type and current status.
     *
     * Create a request for the method "processes.listScriptProcesses".
     *
     * This request holds the parameters needed by the script server.  After setting any optional
     * parameters, call the {@link ListScriptProcesses#execute()} method to invoke the remote operation.
     *
     * @return the request
     */
    public ListScriptProcesses listScriptProcesses() throws java.io.IOException {
      ListScriptProcesses result = new ListScriptProcesses();
      initialize(result);
      return result;
    }

    public class ListScriptProcesses extends ScriptRequest<com.google.api.services.script.model.ListScriptProcessesResponse> {

      private static final String REST_PATH = "v1/processes:listScriptProcesses";

      /**
       * List information about a script's executed processes, such as process type and current status.
       *
       * Create a request for the method "processes.listScriptProcesses".
       *
       * This request holds the parameters needed by the the script server.  After setting any optional
       * parameters, call the {@link ListScriptProcesses#execute()} method to invoke the remote
       * operation. <p> {@link ListScriptProcesses#initialize(com.google.api.client.googleapis.services.
       * AbstractGoogleClientRequest)} must be called to initialize this instance immediately after
       * invoking the constructor. </p>
       *
       * @since 1.13
       */
      protected ListScriptProcesses() {
        super(Script.this, "GET", REST_PATH, null, com.google.api.services.script.model.ListScriptProcessesResponse.class);
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public ListScriptProcesses set$Xgafv(java.lang.String $Xgafv) {
        return (ListScriptProcesses) super.set$Xgafv($Xgafv);
      }

      @Override
      public ListScriptProcesses setAccessToken(java.lang.String accessToken) {
        return (ListScriptProcesses) super.setAccessToken(accessToken);
      }

      @Override
      public ListScriptProcesses setAlt(java.lang.String alt) {
        return (ListScriptProcesses) super.setAlt(alt);
      }

      @Override
      public ListScriptProcesses setCallback(java.lang.String callback) {
        return (ListScriptProcesses) super.setCallback(callback);
      }

      @Override
      public ListScriptProcesses setFields(java.lang.String fields) {
        return (ListScriptProcesses) super.setFields(fields);
      }

      @Override
      public ListScriptProcesses setKey(java.lang.String key) {
        return (ListScriptProcesses) super.setKey(key);
      }

      @Override
      public ListScriptProcesses setOauthToken(java.lang.String oauthToken) {
        return (ListScriptProcesses) super.setOauthToken(oauthToken);
      }

      @Override
      public ListScriptProcesses setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (ListScriptProcesses) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public ListScriptProcesses setQuotaUser(java.lang.String quotaUser) {
        return (ListScriptProcesses) super.setQuotaUser(quotaUser);
      }

      @Override
      public ListScriptProcesses setUploadType(java.lang.String uploadType) {
        return (ListScriptProcesses) super.setUploadType(uploadType);
      }

      @Override
      public ListScriptProcesses setUploadProtocol(java.lang.String uploadProtocol) {
        return (ListScriptProcesses) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * Optional field used to limit returned processes to those that were started on or after the
       * given timestamp.
       */
      @com.google.api.client.util.Key("scriptProcessFilter.startTime")
      private String scriptProcessFilterStartTime;

      /** Optional field used to limit returned processes to those that were started on or after the given
     timestamp.
       */
      public String getScriptProcessFilterStartTime() {
        return scriptProcessFilterStartTime;
      }

      /**
       * Optional field used to limit returned processes to those that were started on or after the
       * given timestamp.
       */
      public ListScriptProcesses setScriptProcessFilterStartTime(String scriptProcessFilterStartTime) {
        this.scriptProcessFilterStartTime = scriptProcessFilterStartTime;
        return this;
      }

      /**
       * Optional field used to limit returned processes to those originating from a script function
       * with the given function name.
       */
      @com.google.api.client.util.Key("scriptProcessFilter.functionName")
      private java.lang.String scriptProcessFilterFunctionName;

      /** Optional field used to limit returned processes to those originating from a script function with
     the given function name.
       */
      public java.lang.String getScriptProcessFilterFunctionName() {
        return scriptProcessFilterFunctionName;
      }

      /**
       * Optional field used to limit returned processes to those originating from a script function
       * with the given function name.
       */
      public ListScriptProcesses setScriptProcessFilterFunctionName(java.lang.String scriptProcessFilterFunctionName) {
        this.scriptProcessFilterFunctionName = scriptProcessFilterFunctionName;
        return this;
      }

      /**
       * Optional field used to limit returned processes to those having one of the specified
       * process types.
       */
      @com.google.api.client.util.Key("scriptProcessFilter.types")
      private java.util.List<java.lang.String> scriptProcessFilterTypes;

      /** Optional field used to limit returned processes to those having one of the specified process types.
       */
      public java.util.List<java.lang.String> getScriptProcessFilterTypes() {
        return scriptProcessFilterTypes;
      }

      /**
       * Optional field used to limit returned processes to those having one of the specified
       * process types.
       */
      public ListScriptProcesses setScriptProcessFilterTypes(java.util.List<java.lang.String> scriptProcessFilterTypes) {
        this.scriptProcessFilterTypes = scriptProcessFilterTypes;
        return this;
      }

      /** The script ID of the project whose processes are listed. */
      @com.google.api.client.util.Key
      private java.lang.String scriptId;

      /** The script ID of the project whose processes are listed.
       */
      public java.lang.String getScriptId() {
        return scriptId;
      }

      /** The script ID of the project whose processes are listed. */
      public ListScriptProcesses setScriptId(java.lang.String scriptId) {
        this.scriptId = scriptId;
        return this;
      }

      /**
       * Optional field used to limit returned processes to those originating from projects with a
       * specific deployment ID.
       */
      @com.google.api.client.util.Key("scriptProcessFilter.deploymentId")
      private java.lang.String scriptProcessFilterDeploymentId;

      /** Optional field used to limit returned processes to those originating from projects with a specific
     deployment ID.
       */
      public java.lang.String getScriptProcessFilterDeploymentId() {
        return scriptProcessFilterDeploymentId;
      }

      /**
       * Optional field used to limit returned processes to those originating from projects with a
       * specific deployment ID.
       */
      public ListScriptProcesses setScriptProcessFilterDeploymentId(java.lang.String scriptProcessFilterDeploymentId) {
        this.scriptProcessFilterDeploymentId = scriptProcessFilterDeploymentId;
        return this;
      }

      /**
       * The token for continuing a previous list request on the next page. This should be set to
       * the value of `nextPageToken` from a previous response.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** The token for continuing a previous list request on the next page. This should be set to the value
     of `nextPageToken` from a previous response.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * The token for continuing a previous list request on the next page. This should be set to
       * the value of `nextPageToken` from a previous response.
       */
      public ListScriptProcesses setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /**
       * The maximum number of returned processes per page of results. Defaults to 50.
       */
      @com.google.api.client.util.Key
      private java.lang.Integer pageSize;

      /** The maximum number of returned processes per page of results. Defaults to 50.
       */
      public java.lang.Integer getPageSize() {
        return pageSize;
      }

      /**
       * The maximum number of returned processes per page of results. Defaults to 50.
       */
      public ListScriptProcesses setPageSize(java.lang.Integer pageSize) {
        this.pageSize = pageSize;
        return this;
      }

      /**
       * Optional field used to limit returned processes to those that completed on or before the
       * given timestamp.
       */
      @com.google.api.client.util.Key("scriptProcessFilter.endTime")
      private String scriptProcessFilterEndTime;

      /** Optional field used to limit returned processes to those that completed on or before the given
     timestamp.
       */
      public String getScriptProcessFilterEndTime() {
        return scriptProcessFilterEndTime;
      }

      /**
       * Optional field used to limit returned processes to those that completed on or before the
       * given timestamp.
       */
      public ListScriptProcesses setScriptProcessFilterEndTime(String scriptProcessFilterEndTime) {
        this.scriptProcessFilterEndTime = scriptProcessFilterEndTime;
        return this;
      }

      /**
       * Optional field used to limit returned processes to those having one of the specified user
       * access levels.
       */
      @com.google.api.client.util.Key("scriptProcessFilter.userAccessLevels")
      private java.util.List<java.lang.String> scriptProcessFilterUserAccessLevels;

      /** Optional field used to limit returned processes to those having one of the specified user access
     levels.
       */
      public java.util.List<java.lang.String> getScriptProcessFilterUserAccessLevels() {
        return scriptProcessFilterUserAccessLevels;
      }

      /**
       * Optional field used to limit returned processes to those having one of the specified user
       * access levels.
       */
      public ListScriptProcesses setScriptProcessFilterUserAccessLevels(java.util.List<java.lang.String> scriptProcessFilterUserAccessLevels) {
        this.scriptProcessFilterUserAccessLevels = scriptProcessFilterUserAccessLevels;
        return this;
      }

      /**
       * Optional field used to limit returned processes to those having one of the specified
       * process statuses.
       */
      @com.google.api.client.util.Key("scriptProcessFilter.statuses")
      private java.util.List<java.lang.String> scriptProcessFilterStatuses;

      /** Optional field used to limit returned processes to those having one of the specified process
     statuses.
       */
      public java.util.List<java.lang.String> getScriptProcessFilterStatuses() {
        return scriptProcessFilterStatuses;
      }

      /**
       * Optional field used to limit returned processes to those having one of the specified
       * process statuses.
       */
      public ListScriptProcesses setScriptProcessFilterStatuses(java.util.List<java.lang.String> scriptProcessFilterStatuses) {
        this.scriptProcessFilterStatuses = scriptProcessFilterStatuses;
        return this;
      }

      @Override
      public ListScriptProcesses set(String parameterName, Object value) {
        return (ListScriptProcesses) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Projects collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Script script = new Script(...);}
   *   {@code Script.Projects.List request = script.projects().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Projects projects() {
    return new Projects();
  }

  /**
   * The "projects" collection of methods.
   */
  public class Projects {

    /**
     * Creates a new, empty script project with no script files and a base manifest file.
     *
     * Create a request for the method "projects.create".
     *
     * This request holds the parameters needed by the script server.  After setting any optional
     * parameters, call the {@link Create#execute()} method to invoke the remote operation.
     *
     * @param content the {@link com.google.api.services.script.model.CreateProjectRequest}
     * @return the request
     */
    public Create create(com.google.api.services.script.model.CreateProjectRequest content) throws java.io.IOException {
      Create result = new Create(content);
      initialize(result);
      return result;
    }

    public class Create extends ScriptRequest<com.google.api.services.script.model.Project> {

      private static final String REST_PATH = "v1/projects";

      /**
       * Creates a new, empty script project with no script files and a base manifest file.
       *
       * Create a request for the method "projects.create".
       *
       * This request holds the parameters needed by the the script server.  After setting any optional
       * parameters, call the {@link Create#execute()} method to invoke the remote operation. <p> {@link
       * Create#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param content the {@link com.google.api.services.script.model.CreateProjectRequest}
       * @since 1.13
       */
      protected Create(com.google.api.services.script.model.CreateProjectRequest content) {
        super(Script.this, "POST", REST_PATH, content, com.google.api.services.script.model.Project.class);
      }

      @Override
      public Create set$Xgafv(java.lang.String $Xgafv) {
        return (Create) super.set$Xgafv($Xgafv);
      }

      @Override
      public Create setAccessToken(java.lang.String accessToken) {
        return (Create) super.setAccessToken(accessToken);
      }

      @Override
      public Create setAlt(java.lang.String alt) {
        return (Create) super.setAlt(alt);
      }

      @Override
      public Create setCallback(java.lang.String callback) {
        return (Create) super.setCallback(callback);
      }

      @Override
      public Create setFields(java.lang.String fields) {
        return (Create) super.setFields(fields);
      }

      @Override
      public Create setKey(java.lang.String key) {
        return (Create) super.setKey(key);
      }

      @Override
      public Create setOauthToken(java.lang.String oauthToken) {
        return (Create) super.setOauthToken(oauthToken);
      }

      @Override
      public Create setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Create) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Create setQuotaUser(java.lang.String quotaUser) {
        return (Create) super.setQuotaUser(quotaUser);
      }

      @Override
      public Create setUploadType(java.lang.String uploadType) {
        return (Create) super.setUploadType(uploadType);
      }

      @Override
      public Create setUploadProtocol(java.lang.String uploadProtocol) {
        return (Create) super.setUploadProtocol(uploadProtocol);
      }

      @Override
      public Create set(String parameterName, Object value) {
        return (Create) super.set(parameterName, value);
      }
    }
    /**
     * Gets a script project's metadata.
     *
     * Create a request for the method "projects.get".
     *
     * This request holds the parameters needed by the script server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param scriptId The script project's Drive ID.
     * @return the request
     */
    public Get get(java.lang.String scriptId) throws java.io.IOException {
      Get result = new Get(scriptId);
      initialize(result);
      return result;
    }

    public class Get extends ScriptRequest<com.google.api.services.script.model.Project> {

      private static final String REST_PATH = "v1/projects/{scriptId}";

      /**
       * Gets a script project's metadata.
       *
       * Create a request for the method "projects.get".
       *
       * This request holds the parameters needed by the the script server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param scriptId The script project's Drive ID.
       * @since 1.13
       */
      protected Get(java.lang.String scriptId) {
        super(Script.this, "GET", REST_PATH, null, com.google.api.services.script.model.Project.class);
        this.scriptId = com.google.api.client.util.Preconditions.checkNotNull(scriptId, "Required parameter scriptId must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get set$Xgafv(java.lang.String $Xgafv) {
        return (Get) super.set$Xgafv($Xgafv);
      }

      @Override
      public Get setAccessToken(java.lang.String accessToken) {
        return (Get) super.setAccessToken(accessToken);
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setCallback(java.lang.String callback) {
        return (Get) super.setCallback(callback);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUploadType(java.lang.String uploadType) {
        return (Get) super.setUploadType(uploadType);
      }

      @Override
      public Get setUploadProtocol(java.lang.String uploadProtocol) {
        return (Get) super.setUploadProtocol(uploadProtocol);
      }

      /** The script project's Drive ID. */
      @com.google.api.client.util.Key
      private java.lang.String scriptId;

      /** The script project's Drive ID.
       */
      public java.lang.String getScriptId() {
        return scriptId;
      }

      /** The script project's Drive ID. */
      public Get setScriptId(java.lang.String scriptId) {
        this.scriptId = scriptId;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Gets the content of the script project, including the code source and metadata for each script
     * file.
     *
     * Create a request for the method "projects.getContent".
     *
     * This request holds the parameters needed by the script server.  After setting any optional
     * parameters, call the {@link GetContent#execute()} method to invoke the remote operation.
     *
     * @param scriptId The script project's Drive ID.
     * @return the request
     */
    public GetContent getContent(java.lang.String scriptId) throws java.io.IOException {
      GetContent result = new GetContent(scriptId);
      initialize(result);
      return result;
    }

    public class GetContent extends ScriptRequest<com.google.api.services.script.model.Content> {

      private static final String REST_PATH = "v1/projects/{scriptId}/content";

      /**
       * Gets the content of the script project, including the code source and metadata for each script
       * file.
       *
       * Create a request for the method "projects.getContent".
       *
       * This request holds the parameters needed by the the script server.  After setting any optional
       * parameters, call the {@link GetContent#execute()} method to invoke the remote operation. <p>
       * {@link
       * GetContent#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param scriptId The script project's Drive ID.
       * @since 1.13
       */
      protected GetContent(java.lang.String scriptId) {
        super(Script.this, "GET", REST_PATH, null, com.google.api.services.script.model.Content.class);
        this.scriptId = com.google.api.client.util.Preconditions.checkNotNull(scriptId, "Required parameter scriptId must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public GetContent set$Xgafv(java.lang.String $Xgafv) {
        return (GetContent) super.set$Xgafv($Xgafv);
      }

      @Override
      public GetContent setAccessToken(java.lang.String accessToken) {
        return (GetContent) super.setAccessToken(accessToken);
      }

      @Override
      public GetContent setAlt(java.lang.String alt) {
        return (GetContent) super.setAlt(alt);
      }

      @Override
      public GetContent setCallback(java.lang.String callback) {
        return (GetContent) super.setCallback(callback);
      }

      @Override
      public GetContent setFields(java.lang.String fields) {
        return (GetContent) super.setFields(fields);
      }

      @Override
      public GetContent setKey(java.lang.String key) {
        return (GetContent) super.setKey(key);
      }

      @Override
      public GetContent setOauthToken(java.lang.String oauthToken) {
        return (GetContent) super.setOauthToken(oauthToken);
      }

      @Override
      public GetContent setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (GetContent) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public GetContent setQuotaUser(java.lang.String quotaUser) {
        return (GetContent) super.setQuotaUser(quotaUser);
      }

      @Override
      public GetContent setUploadType(java.lang.String uploadType) {
        return (GetContent) super.setUploadType(uploadType);
      }

      @Override
      public GetContent setUploadProtocol(java.lang.String uploadProtocol) {
        return (GetContent) super.setUploadProtocol(uploadProtocol);
      }

      /** The script project's Drive ID. */
      @com.google.api.client.util.Key
      private java.lang.String scriptId;

      /** The script project's Drive ID.
       */
      public java.lang.String getScriptId() {
        return scriptId;
      }

      /** The script project's Drive ID. */
      public GetContent setScriptId(java.lang.String scriptId) {
        this.scriptId = scriptId;
        return this;
      }

      /**
       * The version number of the project to retrieve. If not provided, the project's HEAD version
       * is returned.
       */
      @com.google.api.client.util.Key
      private java.lang.Integer versionNumber;

      /** The version number of the project to retrieve. If not provided, the project's HEAD version is
     returned.
       */
      public java.lang.Integer getVersionNumber() {
        return versionNumber;
      }

      /**
       * The version number of the project to retrieve. If not provided, the project's HEAD version
       * is returned.
       */
      public GetContent setVersionNumber(java.lang.Integer versionNumber) {
        this.versionNumber = versionNumber;
        return this;
      }

      @Override
      public GetContent set(String parameterName, Object value) {
        return (GetContent) super.set(parameterName, value);
      }
    }
    /**
     * Get metrics data for scripts, such as number of executions and active users.
     *
     * Create a request for the method "projects.getMetrics".
     *
     * This request holds the parameters needed by the script server.  After setting any optional
     * parameters, call the {@link GetMetrics#execute()} method to invoke the remote operation.
     *
     * @param scriptId Required field indicating the script to get metrics for.
     * @return the request
     */
    public GetMetrics getMetrics(java.lang.String scriptId) throws java.io.IOException {
      GetMetrics result = new GetMetrics(scriptId);
      initialize(result);
      return result;
    }

    public class GetMetrics extends ScriptRequest<com.google.api.services.script.model.Metrics> {

      private static final String REST_PATH = "v1/projects/{scriptId}/metrics";

      /**
       * Get metrics data for scripts, such as number of executions and active users.
       *
       * Create a request for the method "projects.getMetrics".
       *
       * This request holds the parameters needed by the the script server.  After setting any optional
       * parameters, call the {@link GetMetrics#execute()} method to invoke the remote operation. <p>
       * {@link
       * GetMetrics#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param scriptId Required field indicating the script to get metrics for.
       * @since 1.13
       */
      protected GetMetrics(java.lang.String scriptId) {
        super(Script.this, "GET", REST_PATH, null, com.google.api.services.script.model.Metrics.class);
        this.scriptId = com.google.api.client.util.Preconditions.checkNotNull(scriptId, "Required parameter scriptId must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public GetMetrics set$Xgafv(java.lang.String $Xgafv) {
        return (GetMetrics) super.set$Xgafv($Xgafv);
      }

      @Override
      public GetMetrics setAccessToken(java.lang.String accessToken) {
        return (GetMetrics) super.setAccessToken(accessToken);
      }

      @Override
      public GetMetrics setAlt(java.lang.String alt) {
        return (GetMetrics) super.setAlt(alt);
      }

      @Override
      public GetMetrics setCallback(java.lang.String callback) {
        return (GetMetrics) super.setCallback(callback);
      }

      @Override
      public GetMetrics setFields(java.lang.String fields) {
        return (GetMetrics) super.setFields(fields);
      }

      @Override
      public GetMetrics setKey(java.lang.String key) {
        return (GetMetrics) super.setKey(key);
      }

      @Override
      public GetMetrics setOauthToken(java.lang.String oauthToken) {
        return (GetMetrics) super.setOauthToken(oauthToken);
      }

      @Override
      public GetMetrics setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (GetMetrics) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public GetMetrics setQuotaUser(java.lang.String quotaUser) {
        return (GetMetrics) super.setQuotaUser(quotaUser);
      }

      @Override
      public GetMetrics setUploadType(java.lang.String uploadType) {
        return (GetMetrics) super.setUploadType(uploadType);
      }

      @Override
      public GetMetrics setUploadProtocol(java.lang.String uploadProtocol) {
        return (GetMetrics) super.setUploadProtocol(uploadProtocol);
      }

      /** Required field indicating the script to get metrics for. */
      @com.google.api.client.util.Key
      private java.lang.String scriptId;

      /** Required field indicating the script to get metrics for.
       */
      public java.lang.String getScriptId() {
        return scriptId;
      }

      /** Required field indicating the script to get metrics for. */
      public GetMetrics setScriptId(java.lang.String scriptId) {
        this.scriptId = scriptId;
        return this;
      }

      /** Optional field indicating a specific deployment to retrieve metrics from. */
      @com.google.api.client.util.Key("metricsFilter.deploymentId")
      private java.lang.String metricsFilterDeploymentId;

      /** Optional field indicating a specific deployment to retrieve metrics from.
       */
      public java.lang.String getMetricsFilterDeploymentId() {
        return metricsFilterDeploymentId;
      }

      /** Optional field indicating a specific deployment to retrieve metrics from. */
      public GetMetrics setMetricsFilterDeploymentId(java.lang.String metricsFilterDeploymentId) {
        this.metricsFilterDeploymentId = metricsFilterDeploymentId;
        return this;
      }

      /** Required field indicating what granularity of metrics are returned. */
      @com.google.api.client.util.Key
      private java.lang.String metricsGranularity;

      /** Required field indicating what granularity of metrics are returned.
       */
      public java.lang.String getMetricsGranularity() {
        return metricsGranularity;
      }

      /** Required field indicating what granularity of metrics are returned. */
      public GetMetrics setMetricsGranularity(java.lang.String metricsGranularity) {
        this.metricsGranularity = metricsGranularity;
        return this;
      }

      @Override
      public GetMetrics set(String parameterName, Object value) {
        return (GetMetrics) super.set(parameterName, value);
      }
    }
    /**
     * Updates the content of the specified script project. This content is stored as the HEAD version,
     * and is used when the script is executed as a trigger, in the script editor, in add-on preview
     * mode, or as a web app or Apps Script API in development mode. This clears all the existing files
     * in the project.
     *
     * Create a request for the method "projects.updateContent".
     *
     * This request holds the parameters needed by the script server.  After setting any optional
     * parameters, call the {@link UpdateContent#execute()} method to invoke the remote operation.
     *
     * @param scriptId The script project's Drive ID.
     * @param content the {@link com.google.api.services.script.model.Content}
     * @return the request
     */
    public UpdateContent updateContent(java.lang.String scriptId, com.google.api.services.script.model.Content content) throws java.io.IOException {
      UpdateContent result = new UpdateContent(scriptId, content);
      initialize(result);
      return result;
    }

    public class UpdateContent extends ScriptRequest<com.google.api.services.script.model.Content> {

      private static final String REST_PATH = "v1/projects/{scriptId}/content";

      /**
       * Updates the content of the specified script project. This content is stored as the HEAD
       * version, and is used when the script is executed as a trigger, in the script editor, in add-on
       * preview mode, or as a web app or Apps Script API in development mode. This clears all the
       * existing files in the project.
       *
       * Create a request for the method "projects.updateContent".
       *
       * This request holds the parameters needed by the the script server.  After setting any optional
       * parameters, call the {@link UpdateContent#execute()} method to invoke the remote operation. <p>
       * {@link UpdateContent#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientR
       * equest)} must be called to initialize this instance immediately after invoking the constructor.
       * </p>
       *
       * @param scriptId The script project's Drive ID.
       * @param content the {@link com.google.api.services.script.model.Content}
       * @since 1.13
       */
      protected UpdateContent(java.lang.String scriptId, com.google.api.services.script.model.Content content) {
        super(Script.this, "PUT", REST_PATH, content, com.google.api.services.script.model.Content.class);
        this.scriptId = com.google.api.client.util.Preconditions.checkNotNull(scriptId, "Required parameter scriptId must be specified.");
      }

      @Override
      public UpdateContent set$Xgafv(java.lang.String $Xgafv) {
        return (UpdateContent) super.set$Xgafv($Xgafv);
      }

      @Override
      public UpdateContent setAccessToken(java.lang.String accessToken) {
        return (UpdateContent) super.setAccessToken(accessToken);
      }

      @Override
      public UpdateContent setAlt(java.lang.String alt) {
        return (UpdateContent) super.setAlt(alt);
      }

      @Override
      public UpdateContent setCallback(java.lang.String callback) {
        return (UpdateContent) super.setCallback(callback);
      }

      @Override
      public UpdateContent setFields(java.lang.String fields) {
        return (UpdateContent) super.setFields(fields);
      }

      @Override
      public UpdateContent setKey(java.lang.String key) {
        return (UpdateContent) super.setKey(key);
      }

      @Override
      public UpdateContent setOauthToken(java.lang.String oauthToken) {
        return (UpdateContent) super.setOauthToken(oauthToken);
      }

      @Override
      public UpdateContent setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (UpdateContent) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public UpdateContent setQuotaUser(java.lang.String quotaUser) {
        return (UpdateContent) super.setQuotaUser(quotaUser);
      }

      @Override
      public UpdateContent setUploadType(java.lang.String uploadType) {
        return (UpdateContent) super.setUploadType(uploadType);
      }

      @Override
      public UpdateContent setUploadProtocol(java.lang.String uploadProtocol) {
        return (UpdateContent) super.setUploadProtocol(uploadProtocol);
      }

      /** The script project's Drive ID. */
      @com.google.api.client.util.Key
      private java.lang.String scriptId;

      /** The script project's Drive ID.
       */
      public java.lang.String getScriptId() {
        return scriptId;
      }

      /** The script project's Drive ID. */
      public UpdateContent setScriptId(java.lang.String scriptId) {
        this.scriptId = scriptId;
        return this;
      }

      @Override
      public UpdateContent set(String parameterName, Object value) {
        return (UpdateContent) super.set(parameterName, value);
      }
    }

    /**
     * An accessor for creating requests from the Deployments collection.
     *
     * <p>The typical use is:</p>
     * <pre>
     *   {@code Script script = new Script(...);}
     *   {@code Script.Deployments.List request = script.deployments().list(parameters ...)}
     * </pre>
     *
     * @return the resource collection
     */
    public Deployments deployments() {
      return new Deployments();
    }

    /**
     * The "deployments" collection of methods.
     */
    public class Deployments {

      /**
       * Creates a deployment of an Apps Script project.
       *
       * Create a request for the method "deployments.create".
       *
       * This request holds the parameters needed by the script server.  After setting any optional
       * parameters, call the {@link Create#execute()} method to invoke the remote operation.
       *
       * @param scriptId The script project's Drive ID.
       * @param content the {@link com.google.api.services.script.model.DeploymentConfig}
       * @return the request
       */
      public Create create(java.lang.String scriptId, com.google.api.services.script.model.DeploymentConfig content) throws java.io.IOException {
        Create result = new Create(scriptId, content);
        initialize(result);
        return result;
      }

      public class Create extends ScriptRequest<com.google.api.services.script.model.Deployment> {

        private static final String REST_PATH = "v1/projects/{scriptId}/deployments";

        /**
         * Creates a deployment of an Apps Script project.
         *
         * Create a request for the method "deployments.create".
         *
         * This request holds the parameters needed by the the script server.  After setting any optional
         * parameters, call the {@link Create#execute()} method to invoke the remote operation. <p> {@link
         * Create#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param scriptId The script project's Drive ID.
         * @param content the {@link com.google.api.services.script.model.DeploymentConfig}
         * @since 1.13
         */
        protected Create(java.lang.String scriptId, com.google.api.services.script.model.DeploymentConfig content) {
          super(Script.this, "POST", REST_PATH, content, com.google.api.services.script.model.Deployment.class);
          this.scriptId = com.google.api.client.util.Preconditions.checkNotNull(scriptId, "Required parameter scriptId must be specified.");
        }

        @Override
        public Create set$Xgafv(java.lang.String $Xgafv) {
          return (Create) super.set$Xgafv($Xgafv);
        }

        @Override
        public Create setAccessToken(java.lang.String accessToken) {
          return (Create) super.setAccessToken(accessToken);
        }

        @Override
        public Create setAlt(java.lang.String alt) {
          return (Create) super.setAlt(alt);
        }

        @Override
        public Create setCallback(java.lang.String callback) {
          return (Create) super.setCallback(callback);
        }

        @Override
        public Create setFields(java.lang.String fields) {
          return (Create) super.setFields(fields);
        }

        @Override
        public Create setKey(java.lang.String key) {
          return (Create) super.setKey(key);
        }

        @Override
        public Create setOauthToken(java.lang.String oauthToken) {
          return (Create) super.setOauthToken(oauthToken);
        }

        @Override
        public Create setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Create) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Create setQuotaUser(java.lang.String quotaUser) {
          return (Create) super.setQuotaUser(quotaUser);
        }

        @Override
        public Create setUploadType(java.lang.String uploadType) {
          return (Create) super.setUploadType(uploadType);
        }

        @Override
        public Create setUploadProtocol(java.lang.String uploadProtocol) {
          return (Create) super.setUploadProtocol(uploadProtocol);
        }

        /** The script project's Drive ID. */
        @com.google.api.client.util.Key
        private java.lang.String scriptId;

        /** The script project's Drive ID.
         */
        public java.lang.String getScriptId() {
          return scriptId;
        }

        /** The script project's Drive ID. */
        public Create setScriptId(java.lang.String scriptId) {
          this.scriptId = scriptId;
          return this;
        }

        @Override
        public Create set(String parameterName, Object value) {
          return (Create) super.set(parameterName, value);
        }
      }
      /**
       * Deletes a deployment of an Apps Script project.
       *
       * Create a request for the method "deployments.delete".
       *
       * This request holds the parameters needed by the script server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
       *
       * @param scriptId The script project's Drive ID.
       * @param deploymentId The deployment ID to be undeployed.
       * @return the request
       */
      public Delete delete(java.lang.String scriptId, java.lang.String deploymentId) throws java.io.IOException {
        Delete result = new Delete(scriptId, deploymentId);
        initialize(result);
        return result;
      }

      public class Delete extends ScriptRequest<com.google.api.services.script.model.Empty> {

        private static final String REST_PATH = "v1/projects/{scriptId}/deployments/{deploymentId}";

        /**
         * Deletes a deployment of an Apps Script project.
         *
         * Create a request for the method "deployments.delete".
         *
         * This request holds the parameters needed by the the script server.  After setting any optional
         * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
         * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param scriptId The script project's Drive ID.
         * @param deploymentId The deployment ID to be undeployed.
         * @since 1.13
         */
        protected Delete(java.lang.String scriptId, java.lang.String deploymentId) {
          super(Script.this, "DELETE", REST_PATH, null, com.google.api.services.script.model.Empty.class);
          this.scriptId = com.google.api.client.util.Preconditions.checkNotNull(scriptId, "Required parameter scriptId must be specified.");
          this.deploymentId = com.google.api.client.util.Preconditions.checkNotNull(deploymentId, "Required parameter deploymentId must be specified.");
        }

        @Override
        public Delete set$Xgafv(java.lang.String $Xgafv) {
          return (Delete) super.set$Xgafv($Xgafv);
        }

        @Override
        public Delete setAccessToken(java.lang.String accessToken) {
          return (Delete) super.setAccessToken(accessToken);
        }

        @Override
        public Delete setAlt(java.lang.String alt) {
          return (Delete) super.setAlt(alt);
        }

        @Override
        public Delete setCallback(java.lang.String callback) {
          return (Delete) super.setCallback(callback);
        }

        @Override
        public Delete setFields(java.lang.String fields) {
          return (Delete) super.setFields(fields);
        }

        @Override
        public Delete setKey(java.lang.String key) {
          return (Delete) super.setKey(key);
        }

        @Override
        public Delete setOauthToken(java.lang.String oauthToken) {
          return (Delete) super.setOauthToken(oauthToken);
        }

        @Override
        public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Delete) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Delete setQuotaUser(java.lang.String quotaUser) {
          return (Delete) super.setQuotaUser(quotaUser);
        }

        @Override
        public Delete setUploadType(java.lang.String uploadType) {
          return (Delete) super.setUploadType(uploadType);
        }

        @Override
        public Delete setUploadProtocol(java.lang.String uploadProtocol) {
          return (Delete) super.setUploadProtocol(uploadProtocol);
        }

        /** The script project's Drive ID. */
        @com.google.api.client.util.Key
        private java.lang.String scriptId;

        /** The script project's Drive ID.
         */
        public java.lang.String getScriptId() {
          return scriptId;
        }

        /** The script project's Drive ID. */
        public Delete setScriptId(java.lang.String scriptId) {
          this.scriptId = scriptId;
          return this;
        }

        /** The deployment ID to be undeployed. */
        @com.google.api.client.util.Key
        private java.lang.String deploymentId;

        /** The deployment ID to be undeployed.
         */
        public java.lang.String getDeploymentId() {
          return deploymentId;
        }

        /** The deployment ID to be undeployed. */
        public Delete setDeploymentId(java.lang.String deploymentId) {
          this.deploymentId = deploymentId;
          return this;
        }

        @Override
        public Delete set(String parameterName, Object value) {
          return (Delete) super.set(parameterName, value);
        }
      }
      /**
       * Gets a deployment of an Apps Script project.
       *
       * Create a request for the method "deployments.get".
       *
       * This request holds the parameters needed by the script server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation.
       *
       * @param scriptId The script project's Drive ID.
       * @param deploymentId The deployment ID.
       * @return the request
       */
      public Get get(java.lang.String scriptId, java.lang.String deploymentId) throws java.io.IOException {
        Get result = new Get(scriptId, deploymentId);
        initialize(result);
        return result;
      }

      public class Get extends ScriptRequest<com.google.api.services.script.model.Deployment> {

        private static final String REST_PATH = "v1/projects/{scriptId}/deployments/{deploymentId}";

        /**
         * Gets a deployment of an Apps Script project.
         *
         * Create a request for the method "deployments.get".
         *
         * This request holds the parameters needed by the the script server.  After setting any optional
         * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
         * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
         * called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param scriptId The script project's Drive ID.
         * @param deploymentId The deployment ID.
         * @since 1.13
         */
        protected Get(java.lang.String scriptId, java.lang.String deploymentId) {
          super(Script.this, "GET", REST_PATH, null, com.google.api.services.script.model.Deployment.class);
          this.scriptId = com.google.api.client.util.Preconditions.checkNotNull(scriptId, "Required parameter scriptId must be specified.");
          this.deploymentId = com.google.api.client.util.Preconditions.checkNotNull(deploymentId, "Required parameter deploymentId must be specified.");
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public Get set$Xgafv(java.lang.String $Xgafv) {
          return (Get) super.set$Xgafv($Xgafv);
        }

        @Override
        public Get setAccessToken(java.lang.String accessToken) {
          return (Get) super.setAccessToken(accessToken);
        }

        @Override
        public Get setAlt(java.lang.String alt) {
          return (Get) super.setAlt(alt);
        }

        @Override
        public Get setCallback(java.lang.String callback) {
          return (Get) super.setCallback(callback);
        }

        @Override
        public Get setFields(java.lang.String fields) {
          return (Get) super.setFields(fields);
        }

        @Override
        public Get setKey(java.lang.String key) {
          return (Get) super.setKey(key);
        }

        @Override
        public Get setOauthToken(java.lang.String oauthToken) {
          return (Get) super.setOauthToken(oauthToken);
        }

        @Override
        public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Get) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Get setQuotaUser(java.lang.String quotaUser) {
          return (Get) super.setQuotaUser(quotaUser);
        }

        @Override
        public Get setUploadType(java.lang.String uploadType) {
          return (Get) super.setUploadType(uploadType);
        }

        @Override
        public Get setUploadProtocol(java.lang.String uploadProtocol) {
          return (Get) super.setUploadProtocol(uploadProtocol);
        }

        /** The script project's Drive ID. */
        @com.google.api.client.util.Key
        private java.lang.String scriptId;

        /** The script project's Drive ID.
         */
        public java.lang.String getScriptId() {
          return scriptId;
        }

        /** The script project's Drive ID. */
        public Get setScriptId(java.lang.String scriptId) {
          this.scriptId = scriptId;
          return this;
        }

        /** The deployment ID. */
        @com.google.api.client.util.Key
        private java.lang.String deploymentId;

        /** The deployment ID.
         */
        public java.lang.String getDeploymentId() {
          return deploymentId;
        }

        /** The deployment ID. */
        public Get setDeploymentId(java.lang.String deploymentId) {
          this.deploymentId = deploymentId;
          return this;
        }

        @Override
        public Get set(String parameterName, Object value) {
          return (Get) super.set(parameterName, value);
        }
      }
      /**
       * Lists the deployments of an Apps Script project.
       *
       * Create a request for the method "deployments.list".
       *
       * This request holds the parameters needed by the script server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation.
       *
       * @param scriptId The script project's Drive ID.
       * @return the request
       */
      public List list(java.lang.String scriptId) throws java.io.IOException {
        List result = new List(scriptId);
        initialize(result);
        return result;
      }

      public class List extends ScriptRequest<com.google.api.services.script.model.ListDeploymentsResponse> {

        private static final String REST_PATH = "v1/projects/{scriptId}/deployments";

        /**
         * Lists the deployments of an Apps Script project.
         *
         * Create a request for the method "deployments.list".
         *
         * This request holds the parameters needed by the the script server.  After setting any optional
         * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
         * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
         * called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param scriptId The script project's Drive ID.
         * @since 1.13
         */
        protected List(java.lang.String scriptId) {
          super(Script.this, "GET", REST_PATH, null, com.google.api.services.script.model.ListDeploymentsResponse.class);
          this.scriptId = com.google.api.client.util.Preconditions.checkNotNull(scriptId, "Required parameter scriptId must be specified.");
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public List set$Xgafv(java.lang.String $Xgafv) {
          return (List) super.set$Xgafv($Xgafv);
        }

        @Override
        public List setAccessToken(java.lang.String accessToken) {
          return (List) super.setAccessToken(accessToken);
        }

        @Override
        public List setAlt(java.lang.String alt) {
          return (List) super.setAlt(alt);
        }

        @Override
        public List setCallback(java.lang.String callback) {
          return (List) super.setCallback(callback);
        }

        @Override
        public List setFields(java.lang.String fields) {
          return (List) super.setFields(fields);
        }

        @Override
        public List setKey(java.lang.String key) {
          return (List) super.setKey(key);
        }

        @Override
        public List setOauthToken(java.lang.String oauthToken) {
          return (List) super.setOauthToken(oauthToken);
        }

        @Override
        public List setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (List) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public List setQuotaUser(java.lang.String quotaUser) {
          return (List) super.setQuotaUser(quotaUser);
        }

        @Override
        public List setUploadType(java.lang.String uploadType) {
          return (List) super.setUploadType(uploadType);
        }

        @Override
        public List setUploadProtocol(java.lang.String uploadProtocol) {
          return (List) super.setUploadProtocol(uploadProtocol);
        }

        /** The script project's Drive ID. */
        @com.google.api.client.util.Key
        private java.lang.String scriptId;

        /** The script project's Drive ID.
         */
        public java.lang.String getScriptId() {
          return scriptId;
        }

        /** The script project's Drive ID. */
        public List setScriptId(java.lang.String scriptId) {
          this.scriptId = scriptId;
          return this;
        }

        /**
         * The token for continuing a previous list request on the next page. This should be set to
         * the value of `nextPageToken` from a previous response.
         */
        @com.google.api.client.util.Key
        private java.lang.String pageToken;

        /** The token for continuing a previous list request on the next page. This should be set to the value
       of `nextPageToken` from a previous response.
         */
        public java.lang.String getPageToken() {
          return pageToken;
        }

        /**
         * The token for continuing a previous list request on the next page. This should be set to
         * the value of `nextPageToken` from a previous response.
         */
        public List setPageToken(java.lang.String pageToken) {
          this.pageToken = pageToken;
          return this;
        }

        /** The maximum number of deployments on each returned page. Defaults to 50. */
        @com.google.api.client.util.Key
        private java.lang.Integer pageSize;

        /** The maximum number of deployments on each returned page. Defaults to 50.
         */
        public java.lang.Integer getPageSize() {
          return pageSize;
        }

        /** The maximum number of deployments on each returned page. Defaults to 50. */
        public List setPageSize(java.lang.Integer pageSize) {
          this.pageSize = pageSize;
          return this;
        }

        @Override
        public List set(String parameterName, Object value) {
          return (List) super.set(parameterName, value);
        }
      }
      /**
       * Updates a deployment of an Apps Script project.
       *
       * Create a request for the method "deployments.update".
       *
       * This request holds the parameters needed by the script server.  After setting any optional
       * parameters, call the {@link Update#execute()} method to invoke the remote operation.
       *
       * @param scriptId The script project's Drive ID.
       * @param deploymentId The deployment ID for this deployment.
       * @param content the {@link com.google.api.services.script.model.UpdateDeploymentRequest}
       * @return the request
       */
      public Update update(java.lang.String scriptId, java.lang.String deploymentId, com.google.api.services.script.model.UpdateDeploymentRequest content) throws java.io.IOException {
        Update result = new Update(scriptId, deploymentId, content);
        initialize(result);
        return result;
      }

      public class Update extends ScriptRequest<com.google.api.services.script.model.Deployment> {

        private static final String REST_PATH = "v1/projects/{scriptId}/deployments/{deploymentId}";

        /**
         * Updates a deployment of an Apps Script project.
         *
         * Create a request for the method "deployments.update".
         *
         * This request holds the parameters needed by the the script server.  After setting any optional
         * parameters, call the {@link Update#execute()} method to invoke the remote operation. <p> {@link
         * Update#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param scriptId The script project's Drive ID.
         * @param deploymentId The deployment ID for this deployment.
         * @param content the {@link com.google.api.services.script.model.UpdateDeploymentRequest}
         * @since 1.13
         */
        protected Update(java.lang.String scriptId, java.lang.String deploymentId, com.google.api.services.script.model.UpdateDeploymentRequest content) {
          super(Script.this, "PUT", REST_PATH, content, com.google.api.services.script.model.Deployment.class);
          this.scriptId = com.google.api.client.util.Preconditions.checkNotNull(scriptId, "Required parameter scriptId must be specified.");
          this.deploymentId = com.google.api.client.util.Preconditions.checkNotNull(deploymentId, "Required parameter deploymentId must be specified.");
        }

        @Override
        public Update set$Xgafv(java.lang.String $Xgafv) {
          return (Update) super.set$Xgafv($Xgafv);
        }

        @Override
        public Update setAccessToken(java.lang.String accessToken) {
          return (Update) super.setAccessToken(accessToken);
        }

        @Override
        public Update setAlt(java.lang.String alt) {
          return (Update) super.setAlt(alt);
        }

        @Override
        public Update setCallback(java.lang.String callback) {
          return (Update) super.setCallback(callback);
        }

        @Override
        public Update setFields(java.lang.String fields) {
          return (Update) super.setFields(fields);
        }

        @Override
        public Update setKey(java.lang.String key) {
          return (Update) super.setKey(key);
        }

        @Override
        public Update setOauthToken(java.lang.String oauthToken) {
          return (Update) super.setOauthToken(oauthToken);
        }

        @Override
        public Update setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Update) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Update setQuotaUser(java.lang.String quotaUser) {
          return (Update) super.setQuotaUser(quotaUser);
        }

        @Override
        public Update setUploadType(java.lang.String uploadType) {
          return (Update) super.setUploadType(uploadType);
        }

        @Override
        public Update setUploadProtocol(java.lang.String uploadProtocol) {
          return (Update) super.setUploadProtocol(uploadProtocol);
        }

        /** The script project's Drive ID. */
        @com.google.api.client.util.Key
        private java.lang.String scriptId;

        /** The script project's Drive ID.
         */
        public java.lang.String getScriptId() {
          return scriptId;
        }

        /** The script project's Drive ID. */
        public Update setScriptId(java.lang.String scriptId) {
          this.scriptId = scriptId;
          return this;
        }

        /** The deployment ID for this deployment. */
        @com.google.api.client.util.Key
        private java.lang.String deploymentId;

        /** The deployment ID for this deployment.
         */
        public java.lang.String getDeploymentId() {
          return deploymentId;
        }

        /** The deployment ID for this deployment. */
        public Update setDeploymentId(java.lang.String deploymentId) {
          this.deploymentId = deploymentId;
          return this;
        }

        @Override
        public Update set(String parameterName, Object value) {
          return (Update) super.set(parameterName, value);
        }
      }

    }
    /**
     * An accessor for creating requests from the Versions collection.
     *
     * <p>The typical use is:</p>
     * <pre>
     *   {@code Script script = new Script(...);}
     *   {@code Script.Versions.List request = script.versions().list(parameters ...)}
     * </pre>
     *
     * @return the resource collection
     */
    public Versions versions() {
      return new Versions();
    }

    /**
     * The "versions" collection of methods.
     */
    public class Versions {

      /**
       * Creates a new immutable version using the current code, with a unique version number.
       *
       * Create a request for the method "versions.create".
       *
       * This request holds the parameters needed by the script server.  After setting any optional
       * parameters, call the {@link Create#execute()} method to invoke the remote operation.
       *
       * @param scriptId The script project's Drive ID.
       * @param content the {@link com.google.api.services.script.model.Version}
       * @return the request
       */
      public Create create(java.lang.String scriptId, com.google.api.services.script.model.Version content) throws java.io.IOException {
        Create result = new Create(scriptId, content);
        initialize(result);
        return result;
      }

      public class Create extends ScriptRequest<com.google.api.services.script.model.Version> {

        private static final String REST_PATH = "v1/projects/{scriptId}/versions";

        /**
         * Creates a new immutable version using the current code, with a unique version number.
         *
         * Create a request for the method "versions.create".
         *
         * This request holds the parameters needed by the the script server.  After setting any optional
         * parameters, call the {@link Create#execute()} method to invoke the remote operation. <p> {@link
         * Create#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param scriptId The script project's Drive ID.
         * @param content the {@link com.google.api.services.script.model.Version}
         * @since 1.13
         */
        protected Create(java.lang.String scriptId, com.google.api.services.script.model.Version content) {
          super(Script.this, "POST", REST_PATH, content, com.google.api.services.script.model.Version.class);
          this.scriptId = com.google.api.client.util.Preconditions.checkNotNull(scriptId, "Required parameter scriptId must be specified.");
        }

        @Override
        public Create set$Xgafv(java.lang.String $Xgafv) {
          return (Create) super.set$Xgafv($Xgafv);
        }

        @Override
        public Create setAccessToken(java.lang.String accessToken) {
          return (Create) super.setAccessToken(accessToken);
        }

        @Override
        public Create setAlt(java.lang.String alt) {
          return (Create) super.setAlt(alt);
        }

        @Override
        public Create setCallback(java.lang.String callback) {
          return (Create) super.setCallback(callback);
        }

        @Override
        public Create setFields(java.lang.String fields) {
          return (Create) super.setFields(fields);
        }

        @Override
        public Create setKey(java.lang.String key) {
          return (Create) super.setKey(key);
        }

        @Override
        public Create setOauthToken(java.lang.String oauthToken) {
          return (Create) super.setOauthToken(oauthToken);
        }

        @Override
        public Create setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Create) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Create setQuotaUser(java.lang.String quotaUser) {
          return (Create) super.setQuotaUser(quotaUser);
        }

        @Override
        public Create setUploadType(java.lang.String uploadType) {
          return (Create) super.setUploadType(uploadType);
        }

        @Override
        public Create setUploadProtocol(java.lang.String uploadProtocol) {
          return (Create) super.setUploadProtocol(uploadProtocol);
        }

        /** The script project's Drive ID. */
        @com.google.api.client.util.Key
        private java.lang.String scriptId;

        /** The script project's Drive ID.
         */
        public java.lang.String getScriptId() {
          return scriptId;
        }

        /** The script project's Drive ID. */
        public Create setScriptId(java.lang.String scriptId) {
          this.scriptId = scriptId;
          return this;
        }

        @Override
        public Create set(String parameterName, Object value) {
          return (Create) super.set(parameterName, value);
        }
      }
      /**
       * Gets a version of a script project.
       *
       * Create a request for the method "versions.get".
       *
       * This request holds the parameters needed by the script server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation.
       *
       * @param scriptId The script project's Drive ID.
       * @param versionNumber The version number.
       * @return the request
       */
      public Get get(java.lang.String scriptId, java.lang.Integer versionNumber) throws java.io.IOException {
        Get result = new Get(scriptId, versionNumber);
        initialize(result);
        return result;
      }

      public class Get extends ScriptRequest<com.google.api.services.script.model.Version> {

        private static final String REST_PATH = "v1/projects/{scriptId}/versions/{versionNumber}";

        /**
         * Gets a version of a script project.
         *
         * Create a request for the method "versions.get".
         *
         * This request holds the parameters needed by the the script server.  After setting any optional
         * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
         * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
         * called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param scriptId The script project's Drive ID.
         * @param versionNumber The version number.
         * @since 1.13
         */
        protected Get(java.lang.String scriptId, java.lang.Integer versionNumber) {
          super(Script.this, "GET", REST_PATH, null, com.google.api.services.script.model.Version.class);
          this.scriptId = com.google.api.client.util.Preconditions.checkNotNull(scriptId, "Required parameter scriptId must be specified.");
          this.versionNumber = com.google.api.client.util.Preconditions.checkNotNull(versionNumber, "Required parameter versionNumber must be specified.");
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public Get set$Xgafv(java.lang.String $Xgafv) {
          return (Get) super.set$Xgafv($Xgafv);
        }

        @Override
        public Get setAccessToken(java.lang.String accessToken) {
          return (Get) super.setAccessToken(accessToken);
        }

        @Override
        public Get setAlt(java.lang.String alt) {
          return (Get) super.setAlt(alt);
        }

        @Override
        public Get setCallback(java.lang.String callback) {
          return (Get) super.setCallback(callback);
        }

        @Override
        public Get setFields(java.lang.String fields) {
          return (Get) super.setFields(fields);
        }

        @Override
        public Get setKey(java.lang.String key) {
          return (Get) super.setKey(key);
        }

        @Override
        public Get setOauthToken(java.lang.String oauthToken) {
          return (Get) super.setOauthToken(oauthToken);
        }

        @Override
        public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Get) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Get setQuotaUser(java.lang.String quotaUser) {
          return (Get) super.setQuotaUser(quotaUser);
        }

        @Override
        public Get setUploadType(java.lang.String uploadType) {
          return (Get) super.setUploadType(uploadType);
        }

        @Override
        public Get setUploadProtocol(java.lang.String uploadProtocol) {
          return (Get) super.setUploadProtocol(uploadProtocol);
        }

        /** The script project's Drive ID. */
        @com.google.api.client.util.Key
        private java.lang.String scriptId;

        /** The script project's Drive ID.
         */
        public java.lang.String getScriptId() {
          return scriptId;
        }

        /** The script project's Drive ID. */
        public Get setScriptId(java.lang.String scriptId) {
          this.scriptId = scriptId;
          return this;
        }

        /** The version number. */
        @com.google.api.client.util.Key
        private java.lang.Integer versionNumber;

        /** The version number.
         */
        public java.lang.Integer getVersionNumber() {
          return versionNumber;
        }

        /** The version number. */
        public Get setVersionNumber(java.lang.Integer versionNumber) {
          this.versionNumber = versionNumber;
          return this;
        }

        @Override
        public Get set(String parameterName, Object value) {
          return (Get) super.set(parameterName, value);
        }
      }
      /**
       * List the versions of a script project.
       *
       * Create a request for the method "versions.list".
       *
       * This request holds the parameters needed by the script server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation.
       *
       * @param scriptId The script project's Drive ID.
       * @return the request
       */
      public List list(java.lang.String scriptId) throws java.io.IOException {
        List result = new List(scriptId);
        initialize(result);
        return result;
      }

      public class List extends ScriptRequest<com.google.api.services.script.model.ListVersionsResponse> {

        private static final String REST_PATH = "v1/projects/{scriptId}/versions";

        /**
         * List the versions of a script project.
         *
         * Create a request for the method "versions.list".
         *
         * This request holds the parameters needed by the the script server.  After setting any optional
         * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
         * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
         * called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param scriptId The script project's Drive ID.
         * @since 1.13
         */
        protected List(java.lang.String scriptId) {
          super(Script.this, "GET", REST_PATH, null, com.google.api.services.script.model.ListVersionsResponse.class);
          this.scriptId = com.google.api.client.util.Preconditions.checkNotNull(scriptId, "Required parameter scriptId must be specified.");
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public List set$Xgafv(java.lang.String $Xgafv) {
          return (List) super.set$Xgafv($Xgafv);
        }

        @Override
        public List setAccessToken(java.lang.String accessToken) {
          return (List) super.setAccessToken(accessToken);
        }

        @Override
        public List setAlt(java.lang.String alt) {
          return (List) super.setAlt(alt);
        }

        @Override
        public List setCallback(java.lang.String callback) {
          return (List) super.setCallback(callback);
        }

        @Override
        public List setFields(java.lang.String fields) {
          return (List) super.setFields(fields);
        }

        @Override
        public List setKey(java.lang.String key) {
          return (List) super.setKey(key);
        }

        @Override
        public List setOauthToken(java.lang.String oauthToken) {
          return (List) super.setOauthToken(oauthToken);
        }

        @Override
        public List setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (List) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public List setQuotaUser(java.lang.String quotaUser) {
          return (List) super.setQuotaUser(quotaUser);
        }

        @Override
        public List setUploadType(java.lang.String uploadType) {
          return (List) super.setUploadType(uploadType);
        }

        @Override
        public List setUploadProtocol(java.lang.String uploadProtocol) {
          return (List) super.setUploadProtocol(uploadProtocol);
        }

        /** The script project's Drive ID. */
        @com.google.api.client.util.Key
        private java.lang.String scriptId;

        /** The script project's Drive ID.
         */
        public java.lang.String getScriptId() {
          return scriptId;
        }

        /** The script project's Drive ID. */
        public List setScriptId(java.lang.String scriptId) {
          this.scriptId = scriptId;
          return this;
        }

        /**
         * The token for continuing a previous list request on the next page. This should be set to
         * the value of `nextPageToken` from a previous response.
         */
        @com.google.api.client.util.Key
        private java.lang.String pageToken;

        /** The token for continuing a previous list request on the next page. This should be set to the value
       of `nextPageToken` from a previous response.
         */
        public java.lang.String getPageToken() {
          return pageToken;
        }

        /**
         * The token for continuing a previous list request on the next page. This should be set to
         * the value of `nextPageToken` from a previous response.
         */
        public List setPageToken(java.lang.String pageToken) {
          this.pageToken = pageToken;
          return this;
        }

        /** The maximum number of versions on each returned page. Defaults to 50. */
        @com.google.api.client.util.Key
        private java.lang.Integer pageSize;

        /** The maximum number of versions on each returned page. Defaults to 50.
         */
        public java.lang.Integer getPageSize() {
          return pageSize;
        }

        /** The maximum number of versions on each returned page. Defaults to 50. */
        public List setPageSize(java.lang.Integer pageSize) {
          this.pageSize = pageSize;
          return this;
        }

        @Override
        public List set(String parameterName, Object value) {
          return (List) super.set(parameterName, value);
        }
      }

    }
  }

  /**
   * An accessor for creating requests from the Scripts collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Script script = new Script(...);}
   *   {@code Script.Scripts.List request = script.scripts().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Scripts scripts() {
    return new Scripts();
  }

  /**
   * The "scripts" collection of methods.
   */
  public class Scripts {

    /**
     * Runs a function in an Apps Script project. The script project must be deployed for use with the
     * Apps Script API and the calling application must share the same Cloud Platform project.
     *
     * This method requires authorization with an OAuth 2.0 token that includes at least one of the
     * scopes listed in the [Authorization](#authorization) section; script projects that do not require
     * authorization cannot be executed through this API. To find the correct scopes to include in the
     * authentication token, open the project in the script editor, then select **File > Project
     * properties** and click the **Scopes** tab.
     *
     * The error `403, PERMISSION_DENIED: The caller does not have permission` indicates that the Cloud
     * Platform project used to authorize the request is not the same as the one used by the script.
     *
     * Create a request for the method "scripts.run".
     *
     * This request holds the parameters needed by the script server.  After setting any optional
     * parameters, call the {@link Run#execute()} method to invoke the remote operation.
     *
     * @param scriptId The script ID of the script to be executed. To find the script ID, open
    the project in the script
     *        editor and select **File > Project properties**.
     * @param content the {@link com.google.api.services.script.model.ExecutionRequest}
     * @return the request
     */
    public Run run(java.lang.String scriptId, com.google.api.services.script.model.ExecutionRequest content) throws java.io.IOException {
      Run result = new Run(scriptId, content);
      initialize(result);
      return result;
    }

    public class Run extends ScriptRequest<com.google.api.services.script.model.Operation> {

      private static final String REST_PATH = "v1/scripts/{scriptId}:run";

      /**
       * Runs a function in an Apps Script project. The script project must be deployed for use with the
       * Apps Script API and the calling application must share the same Cloud Platform project.
       *
       * This method requires authorization with an OAuth 2.0 token that includes at least one of the
       * scopes listed in the [Authorization](#authorization) section; script projects that do not
       * require authorization cannot be executed through this API. To find the correct scopes to
       * include in the authentication token, open the project in the script editor, then select **File
       * > Project properties** and click the **Scopes** tab.
       *
       * The error `403, PERMISSION_DENIED: The caller does not have permission` indicates that the
       * Cloud Platform project used to authorize the request is not the same as the one used by the
       * script.
       *
       * Create a request for the method "scripts.run".
       *
       * This request holds the parameters needed by the the script server.  After setting any optional
       * parameters, call the {@link Run#execute()} method to invoke the remote operation. <p> {@link
       * Run#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param scriptId The script ID of the script to be executed. To find the script ID, open
    the project in the script
     *        editor and select **File > Project properties**.
       * @param content the {@link com.google.api.services.script.model.ExecutionRequest}
       * @since 1.13
       */
      protected Run(java.lang.String scriptId, com.google.api.services.script.model.ExecutionRequest content) {
        super(Script.this, "POST", REST_PATH, content, com.google.api.services.script.model.Operation.class);
        this.scriptId = com.google.api.client.util.Preconditions.checkNotNull(scriptId, "Required parameter scriptId must be specified.");
      }

      @Override
      public Run set$Xgafv(java.lang.String $Xgafv) {
        return (Run) super.set$Xgafv($Xgafv);
      }

      @Override
      public Run setAccessToken(java.lang.String accessToken) {
        return (Run) super.setAccessToken(accessToken);
      }

      @Override
      public Run setAlt(java.lang.String alt) {
        return (Run) super.setAlt(alt);
      }

      @Override
      public Run setCallback(java.lang.String callback) {
        return (Run) super.setCallback(callback);
      }

      @Override
      public Run setFields(java.lang.String fields) {
        return (Run) super.setFields(fields);
      }

      @Override
      public Run setKey(java.lang.String key) {
        return (Run) super.setKey(key);
      }

      @Override
      public Run setOauthToken(java.lang.String oauthToken) {
        return (Run) super.setOauthToken(oauthToken);
      }

      @Override
      public Run setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Run) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Run setQuotaUser(java.lang.String quotaUser) {
        return (Run) super.setQuotaUser(quotaUser);
      }

      @Override
      public Run setUploadType(java.lang.String uploadType) {
        return (Run) super.setUploadType(uploadType);
      }

      @Override
      public Run setUploadProtocol(java.lang.String uploadProtocol) {
        return (Run) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * The script ID of the script to be executed. To find the script ID, open the project in the
       * script editor and select **File > Project properties**.
       */
      @com.google.api.client.util.Key
      private java.lang.String scriptId;

      /** The script ID of the script to be executed. To find the script ID, open the project in the script
     editor and select **File > Project properties**.
       */
      public java.lang.String getScriptId() {
        return scriptId;
      }

      /**
       * The script ID of the script to be executed. To find the script ID, open the project in the
       * script editor and select **File > Project properties**.
       */
      public Run setScriptId(java.lang.String scriptId) {
        this.scriptId = scriptId;
        return this;
      }

      @Override
      public Run set(String parameterName, Object value) {
        return (Run) super.set(parameterName, value);
      }
    }

  }

  /**
   * Builder for {@link Script}.
   *
   * <p>
   * Implementation is not thread-safe.
   * </p>
   *
   * @since 1.3.0
   */
  public static final class Builder extends com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient.Builder {

    /**
     * Returns an instance of a new builder.
     *
     * @param transport HTTP transport, which should normally be:
     *        <ul>
     *        <li>Google App Engine:
     *        {@code com.google.api.client.extensions.appengine.http.UrlFetchTransport}</li>
     *        <li>Android: {@code newCompatibleTransport} from
     *        {@code com.google.api.client.extensions.android.http.AndroidHttp}</li>
     *        <li>Java: {@link com.google.api.client.googleapis.javanet.GoogleNetHttpTransport#newTrustedTransport()}
     *        </li>
     *        </ul>
     * @param jsonFactory JSON factory, which may be:
     *        <ul>
     *        <li>Jackson: {@code com.google.api.client.json.jackson2.JacksonFactory}</li>
     *        <li>Google GSON: {@code com.google.api.client.json.gson.GsonFactory}</li>
     *        <li>Android Honeycomb or higher:
     *        {@code com.google.api.client.extensions.android.json.AndroidJsonFactory}</li>
     *        </ul>
     * @param httpRequestInitializer HTTP request initializer or {@code null} for none
     * @since 1.7
     */
    public Builder(com.google.api.client.http.HttpTransport transport, com.google.api.client.json.JsonFactory jsonFactory,
        com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
      super(
          transport,
          jsonFactory,
          DEFAULT_ROOT_URL,
          DEFAULT_SERVICE_PATH,
          httpRequestInitializer,
          false);
    }

    /** Builds a new instance of {@link Script}. */
    @Override
    public Script build() {
      return new Script(this);
    }

    @Override
    public Builder setRootUrl(String rootUrl) {
      return (Builder) super.setRootUrl(rootUrl);
    }

    @Override
    public Builder setServicePath(String servicePath) {
      return (Builder) super.setServicePath(servicePath);
    }

    @Override
    public Builder setHttpRequestInitializer(com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
      return (Builder) super.setHttpRequestInitializer(httpRequestInitializer);
    }

    @Override
    public Builder setApplicationName(String applicationName) {
      return (Builder) super.setApplicationName(applicationName);
    }

    @Override
    public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
      return (Builder) super.setSuppressPatternChecks(suppressPatternChecks);
    }

    @Override
    public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
      return (Builder) super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
    }

    @Override
    public Builder setSuppressAllChecks(boolean suppressAllChecks) {
      return (Builder) super.setSuppressAllChecks(suppressAllChecks);
    }

    /**
     * Set the {@link ScriptRequestInitializer}.
     *
     * @since 1.12
     */
    public Builder setScriptRequestInitializer(
        ScriptRequestInitializer scriptRequestInitializer) {
      return (Builder) super.setGoogleClientRequestInitializer(scriptRequestInitializer);
    }

    @Override
    public Builder setGoogleClientRequestInitializer(
        com.google.api.client.googleapis.services.GoogleClientRequestInitializer googleClientRequestInitializer) {
      return (Builder) super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
    }
  }
}
