/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2019-04-24 at 04:58:05 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.script.model;

/**
 * A representation of an execution of an Apps Script function started with run. The execution
 * response does not arrive until the function finishes executing. The maximum execution runtime is
 * listed in the [Apps Script quotas guide](/apps-
 * script/guides/services/quotas#current_limitations). After execution has started, it can have one
 * of four outcomes:   If the script function returns successfully, the   response field contains an
 * ExecutionResponse object   with the function's return value in the object's `result` field.  If
 * the script function (or Apps Script itself) throws an exception, the   error field contains a
 * Status object. The `Status` object's `details`   field contains an array with a single
 * ExecutionError object that   provides information about the nature of the error.  If the
 * execution has not yet completed,   the done field is `false` and   the neither the `response` nor
 * `error` fields are present.  If the `run` call itself fails (for example, because of a
 * malformed request or an authorization error), the method returns an HTTP   response code in the
 * 4XX range with a different format for the response   body. Client libraries automatically convert
 * a 4XX response into an   exception class.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Apps Script API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Operation extends com.google.api.client.json.GenericJson {

  /**
   * This field indicates whether the script execution has completed. A completed execution has a
   * populated `response` field containing the ExecutionResponse from function that was executed.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean done;

  /**
   * If a `run` call succeeds but the script function (or Apps Script itself) throws an exception,
   * this field contains a Status object. The `Status` object's `details` field contains an array
   * with a single ExecutionError object that provides information about the nature of the error.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Status error;

  /**
   * If the script function returns successfully, this field contains an ExecutionResponse object
   * with the function's return value.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, java.lang.Object> response;

  /**
   * This field indicates whether the script execution has completed. A completed execution has a
   * populated `response` field containing the ExecutionResponse from function that was executed.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getDone() {
    return done;
  }

  /**
   * This field indicates whether the script execution has completed. A completed execution has a
   * populated `response` field containing the ExecutionResponse from function that was executed.
   * @param done done or {@code null} for none
   */
  public Operation setDone(java.lang.Boolean done) {
    this.done = done;
    return this;
  }

  /**
   * If a `run` call succeeds but the script function (or Apps Script itself) throws an exception,
   * this field contains a Status object. The `Status` object's `details` field contains an array
   * with a single ExecutionError object that provides information about the nature of the error.
   * @return value or {@code null} for none
   */
  public Status getError() {
    return error;
  }

  /**
   * If a `run` call succeeds but the script function (or Apps Script itself) throws an exception,
   * this field contains a Status object. The `Status` object's `details` field contains an array
   * with a single ExecutionError object that provides information about the nature of the error.
   * @param error error or {@code null} for none
   */
  public Operation setError(Status error) {
    this.error = error;
    return this;
  }

  /**
   * If the script function returns successfully, this field contains an ExecutionResponse object
   * with the function's return value.
   * @return value or {@code null} for none
   */
  public java.util.Map<String, java.lang.Object> getResponse() {
    return response;
  }

  /**
   * If the script function returns successfully, this field contains an ExecutionResponse object
   * with the function's return value.
   * @param response response or {@code null} for none
   */
  public Operation setResponse(java.util.Map<String, java.lang.Object> response) {
    this.response = response;
    return this;
  }

  @Override
  public Operation set(String fieldName, Object value) {
    return (Operation) super.set(fieldName, value);
  }

  @Override
  public Operation clone() {
    return (Operation) super.clone();
  }

}
