/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2019-05-07 at 02:23:18 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.script.model;

/**
 * The Content resource.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Apps Script API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Content extends com.google.api.client.json.GenericJson {

  /**
   * The list of script project files. One of the files is a script manifest; it must be named
   * "appsscript", must have type of JSON, and include the manifest configurations for the project.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<File> files;

  static {
    // hack to force ProGuard to consider File used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(File.class);
  }

  /**
   * The script project's Drive ID.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String scriptId;

  /**
   * The list of script project files. One of the files is a script manifest; it must be named
   * "appsscript", must have type of JSON, and include the manifest configurations for the project.
   * @return value or {@code null} for none
   */
  public java.util.List<File> getFiles() {
    return files;
  }

  /**
   * The list of script project files. One of the files is a script manifest; it must be named
   * "appsscript", must have type of JSON, and include the manifest configurations for the project.
   * @param files files or {@code null} for none
   */
  public Content setFiles(java.util.List<File> files) {
    this.files = files;
    return this;
  }

  /**
   * The script project's Drive ID.
   * @return value or {@code null} for none
   */
  public java.lang.String getScriptId() {
    return scriptId;
  }

  /**
   * The script project's Drive ID.
   * @param scriptId scriptId or {@code null} for none
   */
  public Content setScriptId(java.lang.String scriptId) {
    this.scriptId = scriptId;
    return this;
  }

  @Override
  public Content set(String fieldName, Object value) {
    return (Content) super.set(fieldName, value);
  }

  @Override
  public Content clone() {
    return (Content) super.clone();
  }

}
