/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2019-05-22 at 03:53:06 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.script;

/**
 * Available OAuth 2.0 scopes for use with the Apps Script API.
 *
 * @since 1.4
 */
public class ScriptScopes {

  /** Read, compose, send, and permanently delete all your email from Gmail. */
  public static final String MAIL_GOOGLE_COM = "https://mail.google.com/";

  /** See, edit, share, and permanently delete all the calendars you can access using Google Calendar. */
  public static final String WWW_GOOGLE_COM_CALENDAR_FEEDS = "https://www.google.com/calendar/feeds";

  /** See, edit, download, and permanently delete your contacts. */
  public static final String WWW_GOOGLE_COM_M8_FEEDS = "https://www.google.com/m8/feeds";

  /** View and manage the provisioning of groups on your domain. */
  public static final String ADMIN_DIRECTORY_GROUP = "https://www.googleapis.com/auth/admin.directory.group";

  /** View and manage the provisioning of users on your domain. */
  public static final String ADMIN_DIRECTORY_USER = "https://www.googleapis.com/auth/admin.directory.user";

  /** View and manage your Google Docs documents. */
  public static final String DOCUMENTS = "https://www.googleapis.com/auth/documents";

  /** See, edit, create, and delete all of your Google Drive files. */
  public static final String DRIVE = "https://www.googleapis.com/auth/drive";

  /** View and manage your forms in Google Drive. */
  public static final String FORMS = "https://www.googleapis.com/auth/forms";

  /** View and manage forms that this application has been installed in. */
  public static final String FORMS_CURRENTONLY = "https://www.googleapis.com/auth/forms.currentonly";

  /** View and manage your Google Groups. */
  public static final String GROUPS = "https://www.googleapis.com/auth/groups";

  /** Create and update Google Apps Script deployments. */
  public static final String SCRIPT_DEPLOYMENTS = "https://www.googleapis.com/auth/script.deployments";

  /** View Google Apps Script deployments. */
  public static final String SCRIPT_DEPLOYMENTS_READONLY = "https://www.googleapis.com/auth/script.deployments.readonly";

  /** View Google Apps Script project's metrics. */
  public static final String SCRIPT_METRICS = "https://www.googleapis.com/auth/script.metrics";

  /** View Google Apps Script processes. */
  public static final String SCRIPT_PROCESSES = "https://www.googleapis.com/auth/script.processes";

  /** Create and update Google Apps Script projects. */
  public static final String SCRIPT_PROJECTS = "https://www.googleapis.com/auth/script.projects";

  /** View Google Apps Script projects. */
  public static final String SCRIPT_PROJECTS_READONLY = "https://www.googleapis.com/auth/script.projects.readonly";

  /** See, edit, create, and delete your spreadsheets in Google Drive. */
  public static final String SPREADSHEETS = "https://www.googleapis.com/auth/spreadsheets";

  /** View your email address. */
  public static final String USERINFO_EMAIL = "https://www.googleapis.com/auth/userinfo.email";

  /**
   * Returns an unmodifiable set that contains all scopes declared by this class.
   *
   * @since 1.16
   */
  public static java.util.Set<String> all() {
    java.util.Set<String> set = new java.util.HashSet<String>();
    set.add(MAIL_GOOGLE_COM);
    set.add(WWW_GOOGLE_COM_CALENDAR_FEEDS);
    set.add(WWW_GOOGLE_COM_M8_FEEDS);
    set.add(ADMIN_DIRECTORY_GROUP);
    set.add(ADMIN_DIRECTORY_USER);
    set.add(DOCUMENTS);
    set.add(DRIVE);
    set.add(FORMS);
    set.add(FORMS_CURRENTONLY);
    set.add(GROUPS);
    set.add(SCRIPT_DEPLOYMENTS);
    set.add(SCRIPT_DEPLOYMENTS_READONLY);
    set.add(SCRIPT_METRICS);
    set.add(SCRIPT_PROCESSES);
    set.add(SCRIPT_PROJECTS);
    set.add(SCRIPT_PROJECTS_READONLY);
    set.add(SPREADSHEETS);
    set.add(USERINFO_EMAIL);
    return java.util.Collections.unmodifiableSet(set);
  }

  private ScriptScopes() {
  }
}
