/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2019-05-22 at 03:53:06 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.script.model;

/**
 * An object that provides the return value of a function executed using the Apps Script API. If the
 * script function returns successfully, the response body's response field contains this
 * `ExecutionResponse` object.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Apps Script API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ExecutionResponse extends com.google.api.client.json.GenericJson {

  /**
   * The return value of the script function. The type matches the object type returned in Apps
   * Script. Functions called using the Apps Script API cannot return Apps Script-specific objects
   * (such as a `Document` or a `Calendar`); they can only return primitive types such as a
   * `string`, `number`, `array`, `object`, or `boolean`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Object result;

  /**
   * The return value of the script function. The type matches the object type returned in Apps
   * Script. Functions called using the Apps Script API cannot return Apps Script-specific objects
   * (such as a `Document` or a `Calendar`); they can only return primitive types such as a
   * `string`, `number`, `array`, `object`, or `boolean`.
   * @return value or {@code null} for none
   */
  public java.lang.Object getResult() {
    return result;
  }

  /**
   * The return value of the script function. The type matches the object type returned in Apps
   * Script. Functions called using the Apps Script API cannot return Apps Script-specific objects
   * (such as a `Document` or a `Calendar`); they can only return primitive types such as a
   * `string`, `number`, `array`, `object`, or `boolean`.
   * @param result result or {@code null} for none
   */
  public ExecutionResponse setResult(java.lang.Object result) {
    this.result = result;
    return this;
  }

  @Override
  public ExecutionResponse set(String fieldName, Object value) {
    return (ExecutionResponse) super.set(fieldName, value);
  }

  @Override
  public ExecutionResponse clone() {
    return (ExecutionResponse) super.clone();
  }

}
