/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.script;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.script.ScriptRequest;
import com.google.api.services.script.ScriptRequestInitializer;
import com.google.api.services.script.model.Content;
import com.google.api.services.script.model.CreateProjectRequest;
import com.google.api.services.script.model.Deployment;
import com.google.api.services.script.model.DeploymentConfig;
import com.google.api.services.script.model.Empty;
import com.google.api.services.script.model.ExecutionRequest;
import com.google.api.services.script.model.ListDeploymentsResponse;
import com.google.api.services.script.model.ListScriptProcessesResponse;
import com.google.api.services.script.model.ListUserProcessesResponse;
import com.google.api.services.script.model.ListVersionsResponse;
import com.google.api.services.script.model.Metrics;
import com.google.api.services.script.model.Operation;
import com.google.api.services.script.model.Project;
import com.google.api.services.script.model.UpdateDeploymentRequest;
import com.google.api.services.script.model.Version;
import java.io.IOException;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Script
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://script.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "";
    public static final String DEFAULT_BATCH_PATH = "batch";
    public static final String DEFAULT_BASE_URL = "https://script.googleapis.com/";

    public Script(HttpTransport httpTransport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(httpTransport, jsonFactory, httpRequestInitializer));
    }

    Script(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> abstractGoogleClientRequest) throws IOException {
        super.initialize(abstractGoogleClientRequest);
    }

    public Processes processes() {
        return new Processes();
    }

    public Projects projects() {
        return new Projects();
    }

    public Scripts scripts() {
        return new Scripts();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && GoogleUtils.MINOR_VERSION >= 15 ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.15 of google-api-client to run version 1.25.0 of the Apps Script API library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        public Builder(HttpTransport httpTransport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(httpTransport, jsonFactory, "https://script.googleapis.com/", Script.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
            this.setBatchPath(Script.DEFAULT_BATCH_PATH);
        }

        public Script build() {
            return new Script(this);
        }

        public Builder setRootUrl(String string) {
            return (Builder)super.setRootUrl(string);
        }

        public Builder setServicePath(String string) {
            return (Builder)super.setServicePath(string);
        }

        public Builder setBatchPath(String string) {
            return (Builder)super.setBatchPath(string);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String string) {
            return (Builder)super.setApplicationName(string);
        }

        public Builder setSuppressPatternChecks(boolean bl) {
            return (Builder)super.setSuppressPatternChecks(bl);
        }

        public Builder setSuppressRequiredParameterChecks(boolean bl) {
            return (Builder)super.setSuppressRequiredParameterChecks(bl);
        }

        public Builder setSuppressAllChecks(boolean bl) {
            return (Builder)super.setSuppressAllChecks(bl);
        }

        public Builder setScriptRequestInitializer(ScriptRequestInitializer scriptRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)scriptRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }
    }

    public class Scripts {
        public Run run(String string, ExecutionRequest executionRequest) throws IOException {
            Run run = new Run(string, executionRequest);
            Script.this.initialize((AbstractGoogleClientRequest<?>)run);
            return run;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Run
        extends ScriptRequest<Operation> {
            private static final String REST_PATH = "v1/scripts/{scriptId}:run";
            @Key
            private String scriptId;

            protected Run(String string, ExecutionRequest executionRequest) {
                super(Script.this, "POST", REST_PATH, (Object)executionRequest, Operation.class);
                this.scriptId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter scriptId must be specified.");
            }

            public Run set$Xgafv(String string) {
                return (Run)super.set$Xgafv(string);
            }

            public Run setAccessToken(String string) {
                return (Run)super.setAccessToken(string);
            }

            public Run setAlt(String string) {
                return (Run)super.setAlt(string);
            }

            public Run setCallback(String string) {
                return (Run)super.setCallback(string);
            }

            public Run setFields(String string) {
                return (Run)super.setFields(string);
            }

            public Run setKey(String string) {
                return (Run)super.setKey(string);
            }

            public Run setOauthToken(String string) {
                return (Run)super.setOauthToken(string);
            }

            public Run setPrettyPrint(Boolean bl) {
                return (Run)super.setPrettyPrint(bl);
            }

            public Run setQuotaUser(String string) {
                return (Run)super.setQuotaUser(string);
            }

            public Run setUploadType(String string) {
                return (Run)super.setUploadType(string);
            }

            public Run setUploadProtocol(String string) {
                return (Run)super.setUploadProtocol(string);
            }

            public String getScriptId() {
                return this.scriptId;
            }

            public Run setScriptId(String string) {
                this.scriptId = string;
                return this;
            }

            @Override
            public Run set(String string, Object object) {
                return (Run)super.set(string, object);
            }
        }
    }

    public class Projects {
        public Create create(CreateProjectRequest createProjectRequest) throws IOException {
            Create create = new Create(createProjectRequest);
            Script.this.initialize((AbstractGoogleClientRequest<?>)create);
            return create;
        }

        public Get get(String string) throws IOException {
            Get get = new Get(string);
            Script.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public GetContent getContent(String string) throws IOException {
            GetContent getContent = new GetContent(string);
            Script.this.initialize((AbstractGoogleClientRequest<?>)getContent);
            return getContent;
        }

        public GetMetrics getMetrics(String string) throws IOException {
            GetMetrics getMetrics = new GetMetrics(string);
            Script.this.initialize((AbstractGoogleClientRequest<?>)getMetrics);
            return getMetrics;
        }

        public UpdateContent updateContent(String string, Content content) throws IOException {
            UpdateContent updateContent = new UpdateContent(string, content);
            Script.this.initialize((AbstractGoogleClientRequest<?>)updateContent);
            return updateContent;
        }

        public Deployments deployments() {
            return new Deployments();
        }

        public Versions versions() {
            return new Versions();
        }

        public class Versions {
            public Create create(String string, Version version) throws IOException {
                Create create = new Create(string, version);
                Script.this.initialize((AbstractGoogleClientRequest<?>)create);
                return create;
            }

            public Get get(String string, Integer n) throws IOException {
                Get get = new Get(string, n);
                Script.this.initialize((AbstractGoogleClientRequest<?>)get);
                return get;
            }

            public List list(String string) throws IOException {
                List list = new List(string);
                Script.this.initialize((AbstractGoogleClientRequest<?>)list);
                return list;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class List
            extends ScriptRequest<ListVersionsResponse> {
                private static final String REST_PATH = "v1/projects/{scriptId}/versions";
                @Key
                private String scriptId;
                @Key
                private String pageToken;
                @Key
                private Integer pageSize;

                protected List(String string) {
                    super(Script.this, "GET", REST_PATH, null, ListVersionsResponse.class);
                    this.scriptId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter scriptId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String string) {
                    return (List)super.set$Xgafv(string);
                }

                public List setAccessToken(String string) {
                    return (List)super.setAccessToken(string);
                }

                public List setAlt(String string) {
                    return (List)super.setAlt(string);
                }

                public List setCallback(String string) {
                    return (List)super.setCallback(string);
                }

                public List setFields(String string) {
                    return (List)super.setFields(string);
                }

                public List setKey(String string) {
                    return (List)super.setKey(string);
                }

                public List setOauthToken(String string) {
                    return (List)super.setOauthToken(string);
                }

                public List setPrettyPrint(Boolean bl) {
                    return (List)super.setPrettyPrint(bl);
                }

                public List setQuotaUser(String string) {
                    return (List)super.setQuotaUser(string);
                }

                public List setUploadType(String string) {
                    return (List)super.setUploadType(string);
                }

                public List setUploadProtocol(String string) {
                    return (List)super.setUploadProtocol(string);
                }

                public String getScriptId() {
                    return this.scriptId;
                }

                public List setScriptId(String string) {
                    this.scriptId = string;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String string) {
                    this.pageToken = string;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer n) {
                    this.pageSize = n;
                    return this;
                }

                @Override
                public List set(String string, Object object) {
                    return (List)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Get
            extends ScriptRequest<Version> {
                private static final String REST_PATH = "v1/projects/{scriptId}/versions/{versionNumber}";
                @Key
                private String scriptId;
                @Key
                private Integer versionNumber;

                protected Get(String string, Integer n) {
                    super(Script.this, "GET", REST_PATH, null, Version.class);
                    this.scriptId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter scriptId must be specified.");
                    this.versionNumber = (Integer)Preconditions.checkNotNull((Object)n, (Object)"Required parameter versionNumber must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String string) {
                    return (Get)super.set$Xgafv(string);
                }

                public Get setAccessToken(String string) {
                    return (Get)super.setAccessToken(string);
                }

                public Get setAlt(String string) {
                    return (Get)super.setAlt(string);
                }

                public Get setCallback(String string) {
                    return (Get)super.setCallback(string);
                }

                public Get setFields(String string) {
                    return (Get)super.setFields(string);
                }

                public Get setKey(String string) {
                    return (Get)super.setKey(string);
                }

                public Get setOauthToken(String string) {
                    return (Get)super.setOauthToken(string);
                }

                public Get setPrettyPrint(Boolean bl) {
                    return (Get)super.setPrettyPrint(bl);
                }

                public Get setQuotaUser(String string) {
                    return (Get)super.setQuotaUser(string);
                }

                public Get setUploadType(String string) {
                    return (Get)super.setUploadType(string);
                }

                public Get setUploadProtocol(String string) {
                    return (Get)super.setUploadProtocol(string);
                }

                public String getScriptId() {
                    return this.scriptId;
                }

                public Get setScriptId(String string) {
                    this.scriptId = string;
                    return this;
                }

                public Integer getVersionNumber() {
                    return this.versionNumber;
                }

                public Get setVersionNumber(Integer n) {
                    this.versionNumber = n;
                    return this;
                }

                @Override
                public Get set(String string, Object object) {
                    return (Get)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Create
            extends ScriptRequest<Version> {
                private static final String REST_PATH = "v1/projects/{scriptId}/versions";
                @Key
                private String scriptId;

                protected Create(String string, Version version) {
                    super(Script.this, "POST", REST_PATH, (Object)version, Version.class);
                    this.scriptId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter scriptId must be specified.");
                }

                public Create set$Xgafv(String string) {
                    return (Create)super.set$Xgafv(string);
                }

                public Create setAccessToken(String string) {
                    return (Create)super.setAccessToken(string);
                }

                public Create setAlt(String string) {
                    return (Create)super.setAlt(string);
                }

                public Create setCallback(String string) {
                    return (Create)super.setCallback(string);
                }

                public Create setFields(String string) {
                    return (Create)super.setFields(string);
                }

                public Create setKey(String string) {
                    return (Create)super.setKey(string);
                }

                public Create setOauthToken(String string) {
                    return (Create)super.setOauthToken(string);
                }

                public Create setPrettyPrint(Boolean bl) {
                    return (Create)super.setPrettyPrint(bl);
                }

                public Create setQuotaUser(String string) {
                    return (Create)super.setQuotaUser(string);
                }

                public Create setUploadType(String string) {
                    return (Create)super.setUploadType(string);
                }

                public Create setUploadProtocol(String string) {
                    return (Create)super.setUploadProtocol(string);
                }

                public String getScriptId() {
                    return this.scriptId;
                }

                public Create setScriptId(String string) {
                    this.scriptId = string;
                    return this;
                }

                @Override
                public Create set(String string, Object object) {
                    return (Create)super.set(string, object);
                }
            }
        }

        public class Deployments {
            public Create create(String string, DeploymentConfig deploymentConfig) throws IOException {
                Create create = new Create(string, deploymentConfig);
                Script.this.initialize((AbstractGoogleClientRequest<?>)create);
                return create;
            }

            public Delete delete(String string, String string2) throws IOException {
                Delete delete = new Delete(string, string2);
                Script.this.initialize((AbstractGoogleClientRequest<?>)delete);
                return delete;
            }

            public Get get(String string, String string2) throws IOException {
                Get get = new Get(string, string2);
                Script.this.initialize((AbstractGoogleClientRequest<?>)get);
                return get;
            }

            public List list(String string) throws IOException {
                List list = new List(string);
                Script.this.initialize((AbstractGoogleClientRequest<?>)list);
                return list;
            }

            public Update update(String string, String string2, UpdateDeploymentRequest updateDeploymentRequest) throws IOException {
                Update update = new Update(string, string2, updateDeploymentRequest);
                Script.this.initialize((AbstractGoogleClientRequest<?>)update);
                return update;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Update
            extends ScriptRequest<Deployment> {
                private static final String REST_PATH = "v1/projects/{scriptId}/deployments/{deploymentId}";
                @Key
                private String scriptId;
                @Key
                private String deploymentId;

                protected Update(String string, String string2, UpdateDeploymentRequest updateDeploymentRequest) {
                    super(Script.this, "PUT", REST_PATH, (Object)updateDeploymentRequest, Deployment.class);
                    this.scriptId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter scriptId must be specified.");
                    this.deploymentId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter deploymentId must be specified.");
                }

                public Update set$Xgafv(String string) {
                    return (Update)super.set$Xgafv(string);
                }

                public Update setAccessToken(String string) {
                    return (Update)super.setAccessToken(string);
                }

                public Update setAlt(String string) {
                    return (Update)super.setAlt(string);
                }

                public Update setCallback(String string) {
                    return (Update)super.setCallback(string);
                }

                public Update setFields(String string) {
                    return (Update)super.setFields(string);
                }

                public Update setKey(String string) {
                    return (Update)super.setKey(string);
                }

                public Update setOauthToken(String string) {
                    return (Update)super.setOauthToken(string);
                }

                public Update setPrettyPrint(Boolean bl) {
                    return (Update)super.setPrettyPrint(bl);
                }

                public Update setQuotaUser(String string) {
                    return (Update)super.setQuotaUser(string);
                }

                public Update setUploadType(String string) {
                    return (Update)super.setUploadType(string);
                }

                public Update setUploadProtocol(String string) {
                    return (Update)super.setUploadProtocol(string);
                }

                public String getScriptId() {
                    return this.scriptId;
                }

                public Update setScriptId(String string) {
                    this.scriptId = string;
                    return this;
                }

                public String getDeploymentId() {
                    return this.deploymentId;
                }

                public Update setDeploymentId(String string) {
                    this.deploymentId = string;
                    return this;
                }

                @Override
                public Update set(String string, Object object) {
                    return (Update)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class List
            extends ScriptRequest<ListDeploymentsResponse> {
                private static final String REST_PATH = "v1/projects/{scriptId}/deployments";
                @Key
                private String scriptId;
                @Key
                private String pageToken;
                @Key
                private Integer pageSize;

                protected List(String string) {
                    super(Script.this, "GET", REST_PATH, null, ListDeploymentsResponse.class);
                    this.scriptId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter scriptId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String string) {
                    return (List)super.set$Xgafv(string);
                }

                public List setAccessToken(String string) {
                    return (List)super.setAccessToken(string);
                }

                public List setAlt(String string) {
                    return (List)super.setAlt(string);
                }

                public List setCallback(String string) {
                    return (List)super.setCallback(string);
                }

                public List setFields(String string) {
                    return (List)super.setFields(string);
                }

                public List setKey(String string) {
                    return (List)super.setKey(string);
                }

                public List setOauthToken(String string) {
                    return (List)super.setOauthToken(string);
                }

                public List setPrettyPrint(Boolean bl) {
                    return (List)super.setPrettyPrint(bl);
                }

                public List setQuotaUser(String string) {
                    return (List)super.setQuotaUser(string);
                }

                public List setUploadType(String string) {
                    return (List)super.setUploadType(string);
                }

                public List setUploadProtocol(String string) {
                    return (List)super.setUploadProtocol(string);
                }

                public String getScriptId() {
                    return this.scriptId;
                }

                public List setScriptId(String string) {
                    this.scriptId = string;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String string) {
                    this.pageToken = string;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer n) {
                    this.pageSize = n;
                    return this;
                }

                @Override
                public List set(String string, Object object) {
                    return (List)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Get
            extends ScriptRequest<Deployment> {
                private static final String REST_PATH = "v1/projects/{scriptId}/deployments/{deploymentId}";
                @Key
                private String scriptId;
                @Key
                private String deploymentId;

                protected Get(String string, String string2) {
                    super(Script.this, "GET", REST_PATH, null, Deployment.class);
                    this.scriptId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter scriptId must be specified.");
                    this.deploymentId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter deploymentId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String string) {
                    return (Get)super.set$Xgafv(string);
                }

                public Get setAccessToken(String string) {
                    return (Get)super.setAccessToken(string);
                }

                public Get setAlt(String string) {
                    return (Get)super.setAlt(string);
                }

                public Get setCallback(String string) {
                    return (Get)super.setCallback(string);
                }

                public Get setFields(String string) {
                    return (Get)super.setFields(string);
                }

                public Get setKey(String string) {
                    return (Get)super.setKey(string);
                }

                public Get setOauthToken(String string) {
                    return (Get)super.setOauthToken(string);
                }

                public Get setPrettyPrint(Boolean bl) {
                    return (Get)super.setPrettyPrint(bl);
                }

                public Get setQuotaUser(String string) {
                    return (Get)super.setQuotaUser(string);
                }

                public Get setUploadType(String string) {
                    return (Get)super.setUploadType(string);
                }

                public Get setUploadProtocol(String string) {
                    return (Get)super.setUploadProtocol(string);
                }

                public String getScriptId() {
                    return this.scriptId;
                }

                public Get setScriptId(String string) {
                    this.scriptId = string;
                    return this;
                }

                public String getDeploymentId() {
                    return this.deploymentId;
                }

                public Get setDeploymentId(String string) {
                    this.deploymentId = string;
                    return this;
                }

                @Override
                public Get set(String string, Object object) {
                    return (Get)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Delete
            extends ScriptRequest<Empty> {
                private static final String REST_PATH = "v1/projects/{scriptId}/deployments/{deploymentId}";
                @Key
                private String scriptId;
                @Key
                private String deploymentId;

                protected Delete(String string, String string2) {
                    super(Script.this, "DELETE", REST_PATH, null, Empty.class);
                    this.scriptId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter scriptId must be specified.");
                    this.deploymentId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter deploymentId must be specified.");
                }

                public Delete set$Xgafv(String string) {
                    return (Delete)super.set$Xgafv(string);
                }

                public Delete setAccessToken(String string) {
                    return (Delete)super.setAccessToken(string);
                }

                public Delete setAlt(String string) {
                    return (Delete)super.setAlt(string);
                }

                public Delete setCallback(String string) {
                    return (Delete)super.setCallback(string);
                }

                public Delete setFields(String string) {
                    return (Delete)super.setFields(string);
                }

                public Delete setKey(String string) {
                    return (Delete)super.setKey(string);
                }

                public Delete setOauthToken(String string) {
                    return (Delete)super.setOauthToken(string);
                }

                public Delete setPrettyPrint(Boolean bl) {
                    return (Delete)super.setPrettyPrint(bl);
                }

                public Delete setQuotaUser(String string) {
                    return (Delete)super.setQuotaUser(string);
                }

                public Delete setUploadType(String string) {
                    return (Delete)super.setUploadType(string);
                }

                public Delete setUploadProtocol(String string) {
                    return (Delete)super.setUploadProtocol(string);
                }

                public String getScriptId() {
                    return this.scriptId;
                }

                public Delete setScriptId(String string) {
                    this.scriptId = string;
                    return this;
                }

                public String getDeploymentId() {
                    return this.deploymentId;
                }

                public Delete setDeploymentId(String string) {
                    this.deploymentId = string;
                    return this;
                }

                @Override
                public Delete set(String string, Object object) {
                    return (Delete)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Create
            extends ScriptRequest<Deployment> {
                private static final String REST_PATH = "v1/projects/{scriptId}/deployments";
                @Key
                private String scriptId;

                protected Create(String string, DeploymentConfig deploymentConfig) {
                    super(Script.this, "POST", REST_PATH, (Object)deploymentConfig, Deployment.class);
                    this.scriptId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter scriptId must be specified.");
                }

                public Create set$Xgafv(String string) {
                    return (Create)super.set$Xgafv(string);
                }

                public Create setAccessToken(String string) {
                    return (Create)super.setAccessToken(string);
                }

                public Create setAlt(String string) {
                    return (Create)super.setAlt(string);
                }

                public Create setCallback(String string) {
                    return (Create)super.setCallback(string);
                }

                public Create setFields(String string) {
                    return (Create)super.setFields(string);
                }

                public Create setKey(String string) {
                    return (Create)super.setKey(string);
                }

                public Create setOauthToken(String string) {
                    return (Create)super.setOauthToken(string);
                }

                public Create setPrettyPrint(Boolean bl) {
                    return (Create)super.setPrettyPrint(bl);
                }

                public Create setQuotaUser(String string) {
                    return (Create)super.setQuotaUser(string);
                }

                public Create setUploadType(String string) {
                    return (Create)super.setUploadType(string);
                }

                public Create setUploadProtocol(String string) {
                    return (Create)super.setUploadProtocol(string);
                }

                public String getScriptId() {
                    return this.scriptId;
                }

                public Create setScriptId(String string) {
                    this.scriptId = string;
                    return this;
                }

                @Override
                public Create set(String string, Object object) {
                    return (Create)super.set(string, object);
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class UpdateContent
        extends ScriptRequest<Content> {
            private static final String REST_PATH = "v1/projects/{scriptId}/content";
            @Key
            private String scriptId;

            protected UpdateContent(String string, Content content) {
                super(Script.this, "PUT", REST_PATH, (Object)content, Content.class);
                this.scriptId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter scriptId must be specified.");
            }

            public UpdateContent set$Xgafv(String string) {
                return (UpdateContent)super.set$Xgafv(string);
            }

            public UpdateContent setAccessToken(String string) {
                return (UpdateContent)super.setAccessToken(string);
            }

            public UpdateContent setAlt(String string) {
                return (UpdateContent)super.setAlt(string);
            }

            public UpdateContent setCallback(String string) {
                return (UpdateContent)super.setCallback(string);
            }

            public UpdateContent setFields(String string) {
                return (UpdateContent)super.setFields(string);
            }

            public UpdateContent setKey(String string) {
                return (UpdateContent)super.setKey(string);
            }

            public UpdateContent setOauthToken(String string) {
                return (UpdateContent)super.setOauthToken(string);
            }

            public UpdateContent setPrettyPrint(Boolean bl) {
                return (UpdateContent)super.setPrettyPrint(bl);
            }

            public UpdateContent setQuotaUser(String string) {
                return (UpdateContent)super.setQuotaUser(string);
            }

            public UpdateContent setUploadType(String string) {
                return (UpdateContent)super.setUploadType(string);
            }

            public UpdateContent setUploadProtocol(String string) {
                return (UpdateContent)super.setUploadProtocol(string);
            }

            public String getScriptId() {
                return this.scriptId;
            }

            public UpdateContent setScriptId(String string) {
                this.scriptId = string;
                return this;
            }

            @Override
            public UpdateContent set(String string, Object object) {
                return (UpdateContent)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class GetMetrics
        extends ScriptRequest<Metrics> {
            private static final String REST_PATH = "v1/projects/{scriptId}/metrics";
            @Key
            private String scriptId;
            @Key(value="metricsFilter.deploymentId")
            private String metricsFilterDeploymentId;
            @Key
            private String metricsGranularity;

            protected GetMetrics(String string) {
                super(Script.this, "GET", REST_PATH, null, Metrics.class);
                this.scriptId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter scriptId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public GetMetrics set$Xgafv(String string) {
                return (GetMetrics)super.set$Xgafv(string);
            }

            public GetMetrics setAccessToken(String string) {
                return (GetMetrics)super.setAccessToken(string);
            }

            public GetMetrics setAlt(String string) {
                return (GetMetrics)super.setAlt(string);
            }

            public GetMetrics setCallback(String string) {
                return (GetMetrics)super.setCallback(string);
            }

            public GetMetrics setFields(String string) {
                return (GetMetrics)super.setFields(string);
            }

            public GetMetrics setKey(String string) {
                return (GetMetrics)super.setKey(string);
            }

            public GetMetrics setOauthToken(String string) {
                return (GetMetrics)super.setOauthToken(string);
            }

            public GetMetrics setPrettyPrint(Boolean bl) {
                return (GetMetrics)super.setPrettyPrint(bl);
            }

            public GetMetrics setQuotaUser(String string) {
                return (GetMetrics)super.setQuotaUser(string);
            }

            public GetMetrics setUploadType(String string) {
                return (GetMetrics)super.setUploadType(string);
            }

            public GetMetrics setUploadProtocol(String string) {
                return (GetMetrics)super.setUploadProtocol(string);
            }

            public String getScriptId() {
                return this.scriptId;
            }

            public GetMetrics setScriptId(String string) {
                this.scriptId = string;
                return this;
            }

            public String getMetricsFilterDeploymentId() {
                return this.metricsFilterDeploymentId;
            }

            public GetMetrics setMetricsFilterDeploymentId(String string) {
                this.metricsFilterDeploymentId = string;
                return this;
            }

            public String getMetricsGranularity() {
                return this.metricsGranularity;
            }

            public GetMetrics setMetricsGranularity(String string) {
                this.metricsGranularity = string;
                return this;
            }

            @Override
            public GetMetrics set(String string, Object object) {
                return (GetMetrics)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class GetContent
        extends ScriptRequest<Content> {
            private static final String REST_PATH = "v1/projects/{scriptId}/content";
            @Key
            private String scriptId;
            @Key
            private Integer versionNumber;

            protected GetContent(String string) {
                super(Script.this, "GET", REST_PATH, null, Content.class);
                this.scriptId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter scriptId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public GetContent set$Xgafv(String string) {
                return (GetContent)super.set$Xgafv(string);
            }

            public GetContent setAccessToken(String string) {
                return (GetContent)super.setAccessToken(string);
            }

            public GetContent setAlt(String string) {
                return (GetContent)super.setAlt(string);
            }

            public GetContent setCallback(String string) {
                return (GetContent)super.setCallback(string);
            }

            public GetContent setFields(String string) {
                return (GetContent)super.setFields(string);
            }

            public GetContent setKey(String string) {
                return (GetContent)super.setKey(string);
            }

            public GetContent setOauthToken(String string) {
                return (GetContent)super.setOauthToken(string);
            }

            public GetContent setPrettyPrint(Boolean bl) {
                return (GetContent)super.setPrettyPrint(bl);
            }

            public GetContent setQuotaUser(String string) {
                return (GetContent)super.setQuotaUser(string);
            }

            public GetContent setUploadType(String string) {
                return (GetContent)super.setUploadType(string);
            }

            public GetContent setUploadProtocol(String string) {
                return (GetContent)super.setUploadProtocol(string);
            }

            public String getScriptId() {
                return this.scriptId;
            }

            public GetContent setScriptId(String string) {
                this.scriptId = string;
                return this;
            }

            public Integer getVersionNumber() {
                return this.versionNumber;
            }

            public GetContent setVersionNumber(Integer n) {
                this.versionNumber = n;
                return this;
            }

            @Override
            public GetContent set(String string, Object object) {
                return (GetContent)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends ScriptRequest<Project> {
            private static final String REST_PATH = "v1/projects/{scriptId}";
            @Key
            private String scriptId;

            protected Get(String string) {
                super(Script.this, "GET", REST_PATH, null, Project.class);
                this.scriptId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter scriptId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String string) {
                return (Get)super.set$Xgafv(string);
            }

            public Get setAccessToken(String string) {
                return (Get)super.setAccessToken(string);
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setCallback(String string) {
                return (Get)super.setCallback(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUploadType(String string) {
                return (Get)super.setUploadType(string);
            }

            public Get setUploadProtocol(String string) {
                return (Get)super.setUploadProtocol(string);
            }

            public String getScriptId() {
                return this.scriptId;
            }

            public Get setScriptId(String string) {
                this.scriptId = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Create
        extends ScriptRequest<Project> {
            private static final String REST_PATH = "v1/projects";

            protected Create(CreateProjectRequest createProjectRequest) {
                super(Script.this, "POST", REST_PATH, (Object)createProjectRequest, Project.class);
            }

            public Create set$Xgafv(String string) {
                return (Create)super.set$Xgafv(string);
            }

            public Create setAccessToken(String string) {
                return (Create)super.setAccessToken(string);
            }

            public Create setAlt(String string) {
                return (Create)super.setAlt(string);
            }

            public Create setCallback(String string) {
                return (Create)super.setCallback(string);
            }

            public Create setFields(String string) {
                return (Create)super.setFields(string);
            }

            public Create setKey(String string) {
                return (Create)super.setKey(string);
            }

            public Create setOauthToken(String string) {
                return (Create)super.setOauthToken(string);
            }

            public Create setPrettyPrint(Boolean bl) {
                return (Create)super.setPrettyPrint(bl);
            }

            public Create setQuotaUser(String string) {
                return (Create)super.setQuotaUser(string);
            }

            public Create setUploadType(String string) {
                return (Create)super.setUploadType(string);
            }

            public Create setUploadProtocol(String string) {
                return (Create)super.setUploadProtocol(string);
            }

            @Override
            public Create set(String string, Object object) {
                return (Create)super.set(string, object);
            }
        }
    }

    public class Processes {
        public List list() throws IOException {
            List list = new List();
            Script.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        public ListScriptProcesses listScriptProcesses() throws IOException {
            ListScriptProcesses listScriptProcesses = new ListScriptProcesses();
            Script.this.initialize((AbstractGoogleClientRequest<?>)listScriptProcesses);
            return listScriptProcesses;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class ListScriptProcesses
        extends ScriptRequest<ListScriptProcessesResponse> {
            private static final String REST_PATH = "v1/processes:listScriptProcesses";
            @Key
            private String pageToken;
            @Key
            private Integer pageSize;
            @Key(value="scriptProcessFilter.endTime")
            private String scriptProcessFilterEndTime;
            @Key(value="scriptProcessFilter.userAccessLevels")
            private java.util.List<String> scriptProcessFilterUserAccessLevels;
            @Key(value="scriptProcessFilter.statuses")
            private java.util.List<String> scriptProcessFilterStatuses;
            @Key(value="scriptProcessFilter.startTime")
            private String scriptProcessFilterStartTime;
            @Key(value="scriptProcessFilter.functionName")
            private String scriptProcessFilterFunctionName;
            @Key(value="scriptProcessFilter.deploymentId")
            private String scriptProcessFilterDeploymentId;
            @Key
            private String scriptId;
            @Key(value="scriptProcessFilter.types")
            private java.util.List<String> scriptProcessFilterTypes;

            protected ListScriptProcesses() {
                super(Script.this, "GET", REST_PATH, null, ListScriptProcessesResponse.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public ListScriptProcesses set$Xgafv(String string) {
                return (ListScriptProcesses)super.set$Xgafv(string);
            }

            public ListScriptProcesses setAccessToken(String string) {
                return (ListScriptProcesses)super.setAccessToken(string);
            }

            public ListScriptProcesses setAlt(String string) {
                return (ListScriptProcesses)super.setAlt(string);
            }

            public ListScriptProcesses setCallback(String string) {
                return (ListScriptProcesses)super.setCallback(string);
            }

            public ListScriptProcesses setFields(String string) {
                return (ListScriptProcesses)super.setFields(string);
            }

            public ListScriptProcesses setKey(String string) {
                return (ListScriptProcesses)super.setKey(string);
            }

            public ListScriptProcesses setOauthToken(String string) {
                return (ListScriptProcesses)super.setOauthToken(string);
            }

            public ListScriptProcesses setPrettyPrint(Boolean bl) {
                return (ListScriptProcesses)super.setPrettyPrint(bl);
            }

            public ListScriptProcesses setQuotaUser(String string) {
                return (ListScriptProcesses)super.setQuotaUser(string);
            }

            public ListScriptProcesses setUploadType(String string) {
                return (ListScriptProcesses)super.setUploadType(string);
            }

            public ListScriptProcesses setUploadProtocol(String string) {
                return (ListScriptProcesses)super.setUploadProtocol(string);
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public ListScriptProcesses setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            public Integer getPageSize() {
                return this.pageSize;
            }

            public ListScriptProcesses setPageSize(Integer n) {
                this.pageSize = n;
                return this;
            }

            public String getScriptProcessFilterEndTime() {
                return this.scriptProcessFilterEndTime;
            }

            public ListScriptProcesses setScriptProcessFilterEndTime(String string) {
                this.scriptProcessFilterEndTime = string;
                return this;
            }

            public java.util.List<String> getScriptProcessFilterUserAccessLevels() {
                return this.scriptProcessFilterUserAccessLevels;
            }

            public ListScriptProcesses setScriptProcessFilterUserAccessLevels(java.util.List<String> list) {
                this.scriptProcessFilterUserAccessLevels = list;
                return this;
            }

            public java.util.List<String> getScriptProcessFilterStatuses() {
                return this.scriptProcessFilterStatuses;
            }

            public ListScriptProcesses setScriptProcessFilterStatuses(java.util.List<String> list) {
                this.scriptProcessFilterStatuses = list;
                return this;
            }

            public String getScriptProcessFilterStartTime() {
                return this.scriptProcessFilterStartTime;
            }

            public ListScriptProcesses setScriptProcessFilterStartTime(String string) {
                this.scriptProcessFilterStartTime = string;
                return this;
            }

            public String getScriptProcessFilterFunctionName() {
                return this.scriptProcessFilterFunctionName;
            }

            public ListScriptProcesses setScriptProcessFilterFunctionName(String string) {
                this.scriptProcessFilterFunctionName = string;
                return this;
            }

            public String getScriptProcessFilterDeploymentId() {
                return this.scriptProcessFilterDeploymentId;
            }

            public ListScriptProcesses setScriptProcessFilterDeploymentId(String string) {
                this.scriptProcessFilterDeploymentId = string;
                return this;
            }

            public String getScriptId() {
                return this.scriptId;
            }

            public ListScriptProcesses setScriptId(String string) {
                this.scriptId = string;
                return this;
            }

            public java.util.List<String> getScriptProcessFilterTypes() {
                return this.scriptProcessFilterTypes;
            }

            public ListScriptProcesses setScriptProcessFilterTypes(java.util.List<String> list) {
                this.scriptProcessFilterTypes = list;
                return this;
            }

            @Override
            public ListScriptProcesses set(String string, Object object) {
                return (ListScriptProcesses)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends ScriptRequest<ListUserProcessesResponse> {
            private static final String REST_PATH = "v1/processes";
            @Key(value="userProcessFilter.projectName")
            private String userProcessFilterProjectName;
            @Key(value="userProcessFilter.userAccessLevels")
            private java.util.List<String> userProcessFilterUserAccessLevels;
            @Key(value="userProcessFilter.functionName")
            private String userProcessFilterFunctionName;
            @Key(value="userProcessFilter.scriptId")
            private String userProcessFilterScriptId;
            @Key(value="userProcessFilter.types")
            private java.util.List<String> userProcessFilterTypes;
            @Key(value="userProcessFilter.statuses")
            private java.util.List<String> userProcessFilterStatuses;
            @Key(value="userProcessFilter.deploymentId")
            private String userProcessFilterDeploymentId;
            @Key
            private String pageToken;
            @Key(value="userProcessFilter.endTime")
            private String userProcessFilterEndTime;
            @Key
            private Integer pageSize;
            @Key(value="userProcessFilter.startTime")
            private String userProcessFilterStartTime;

            protected List() {
                super(Script.this, "GET", REST_PATH, null, ListUserProcessesResponse.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String string) {
                return (List)super.set$Xgafv(string);
            }

            public List setAccessToken(String string) {
                return (List)super.setAccessToken(string);
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setCallback(String string) {
                return (List)super.setCallback(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUploadType(String string) {
                return (List)super.setUploadType(string);
            }

            public List setUploadProtocol(String string) {
                return (List)super.setUploadProtocol(string);
            }

            public String getUserProcessFilterProjectName() {
                return this.userProcessFilterProjectName;
            }

            public List setUserProcessFilterProjectName(String string) {
                this.userProcessFilterProjectName = string;
                return this;
            }

            public java.util.List<String> getUserProcessFilterUserAccessLevels() {
                return this.userProcessFilterUserAccessLevels;
            }

            public List setUserProcessFilterUserAccessLevels(java.util.List<String> list) {
                this.userProcessFilterUserAccessLevels = list;
                return this;
            }

            public String getUserProcessFilterFunctionName() {
                return this.userProcessFilterFunctionName;
            }

            public List setUserProcessFilterFunctionName(String string) {
                this.userProcessFilterFunctionName = string;
                return this;
            }

            public String getUserProcessFilterScriptId() {
                return this.userProcessFilterScriptId;
            }

            public List setUserProcessFilterScriptId(String string) {
                this.userProcessFilterScriptId = string;
                return this;
            }

            public java.util.List<String> getUserProcessFilterTypes() {
                return this.userProcessFilterTypes;
            }

            public List setUserProcessFilterTypes(java.util.List<String> list) {
                this.userProcessFilterTypes = list;
                return this;
            }

            public java.util.List<String> getUserProcessFilterStatuses() {
                return this.userProcessFilterStatuses;
            }

            public List setUserProcessFilterStatuses(java.util.List<String> list) {
                this.userProcessFilterStatuses = list;
                return this;
            }

            public String getUserProcessFilterDeploymentId() {
                return this.userProcessFilterDeploymentId;
            }

            public List setUserProcessFilterDeploymentId(String string) {
                this.userProcessFilterDeploymentId = string;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            public String getUserProcessFilterEndTime() {
                return this.userProcessFilterEndTime;
            }

            public List setUserProcessFilterEndTime(String string) {
                this.userProcessFilterEndTime = string;
                return this;
            }

            public Integer getPageSize() {
                return this.pageSize;
            }

            public List setPageSize(Integer n) {
                this.pageSize = n;
                return this;
            }

            public String getUserProcessFilterStartTime() {
                return this.userProcessFilterStartTime;
            }

            public List setUserProcessFilterStartTime(String string) {
                this.userProcessFilterStartTime = string;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }
    }
}

