/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2020-03-06 at 06:28:55 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.script.model;

/**
 * Response with the list of Process resources.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Apps Script API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ListScriptProcessesResponse extends com.google.api.client.json.GenericJson {

  /**
   * Token for the next page of results. If empty, there are no more pages remaining.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String nextPageToken;

  /**
   * List of processes matching request parameters.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<GoogleAppsScriptTypeProcess> processes;

  static {
    // hack to force ProGuard to consider GoogleAppsScriptTypeProcess used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(GoogleAppsScriptTypeProcess.class);
  }

  /**
   * Token for the next page of results. If empty, there are no more pages remaining.
   * @return value or {@code null} for none
   */
  public java.lang.String getNextPageToken() {
    return nextPageToken;
  }

  /**
   * Token for the next page of results. If empty, there are no more pages remaining.
   * @param nextPageToken nextPageToken or {@code null} for none
   */
  public ListScriptProcessesResponse setNextPageToken(java.lang.String nextPageToken) {
    this.nextPageToken = nextPageToken;
    return this;
  }

  /**
   * List of processes matching request parameters.
   * @return value or {@code null} for none
   */
  public java.util.List<GoogleAppsScriptTypeProcess> getProcesses() {
    return processes;
  }

  /**
   * List of processes matching request parameters.
   * @param processes processes or {@code null} for none
   */
  public ListScriptProcessesResponse setProcesses(java.util.List<GoogleAppsScriptTypeProcess> processes) {
    this.processes = processes;
    return this;
  }

  @Override
  public ListScriptProcessesResponse set(String fieldName, Object value) {
    return (ListScriptProcessesResponse) super.set(fieldName, value);
  }

  @Override
  public ListScriptProcessesResponse clone() {
    return (ListScriptProcessesResponse) super.clone();
  }

}
