/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2020-03-11 at 00:03:38 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.script.model;

/**
 * Representation of a single script process execution that was started from the script editor, a
 * trigger, an application, or using the Apps Script API. This is distinct from the `Operation`
 * resource, which only represents executions started via the Apps Script API.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Apps Script API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class GoogleAppsScriptTypeProcess extends com.google.api.client.json.GenericJson {

  /**
   * Duration the execution spent executing.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String duration;

  /**
   * Name of the function the started the execution.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String functionName;

  /**
   * The executions status.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String processStatus;

  /**
   * The executions type.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String processType;

  /**
   * Name of the script being executed.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String projectName;

  /**
   * Time the execution started.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String startTime;

  /**
   * The executing users access level to the script.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String userAccessLevel;

  /**
   * Duration the execution spent executing.
   * @return value or {@code null} for none
   */
  public String getDuration() {
    return duration;
  }

  /**
   * Duration the execution spent executing.
   * @param duration duration or {@code null} for none
   */
  public GoogleAppsScriptTypeProcess setDuration(String duration) {
    this.duration = duration;
    return this;
  }

  /**
   * Name of the function the started the execution.
   * @return value or {@code null} for none
   */
  public java.lang.String getFunctionName() {
    return functionName;
  }

  /**
   * Name of the function the started the execution.
   * @param functionName functionName or {@code null} for none
   */
  public GoogleAppsScriptTypeProcess setFunctionName(java.lang.String functionName) {
    this.functionName = functionName;
    return this;
  }

  /**
   * The executions status.
   * @return value or {@code null} for none
   */
  public java.lang.String getProcessStatus() {
    return processStatus;
  }

  /**
   * The executions status.
   * @param processStatus processStatus or {@code null} for none
   */
  public GoogleAppsScriptTypeProcess setProcessStatus(java.lang.String processStatus) {
    this.processStatus = processStatus;
    return this;
  }

  /**
   * The executions type.
   * @return value or {@code null} for none
   */
  public java.lang.String getProcessType() {
    return processType;
  }

  /**
   * The executions type.
   * @param processType processType or {@code null} for none
   */
  public GoogleAppsScriptTypeProcess setProcessType(java.lang.String processType) {
    this.processType = processType;
    return this;
  }

  /**
   * Name of the script being executed.
   * @return value or {@code null} for none
   */
  public java.lang.String getProjectName() {
    return projectName;
  }

  /**
   * Name of the script being executed.
   * @param projectName projectName or {@code null} for none
   */
  public GoogleAppsScriptTypeProcess setProjectName(java.lang.String projectName) {
    this.projectName = projectName;
    return this;
  }

  /**
   * Time the execution started.
   * @return value or {@code null} for none
   */
  public String getStartTime() {
    return startTime;
  }

  /**
   * Time the execution started.
   * @param startTime startTime or {@code null} for none
   */
  public GoogleAppsScriptTypeProcess setStartTime(String startTime) {
    this.startTime = startTime;
    return this;
  }

  /**
   * The executing users access level to the script.
   * @return value or {@code null} for none
   */
  public java.lang.String getUserAccessLevel() {
    return userAccessLevel;
  }

  /**
   * The executing users access level to the script.
   * @param userAccessLevel userAccessLevel or {@code null} for none
   */
  public GoogleAppsScriptTypeProcess setUserAccessLevel(java.lang.String userAccessLevel) {
    this.userAccessLevel = userAccessLevel;
    return this;
  }

  @Override
  public GoogleAppsScriptTypeProcess set(String fieldName, Object value) {
    return (GoogleAppsScriptTypeProcess) super.set(fieldName, value);
  }

  @Override
  public GoogleAppsScriptTypeProcess clone() {
    return (GoogleAppsScriptTypeProcess) super.clone();
  }

}
