/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2020-03-24 at 01:33:59 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.script.model;

/**
 * Response with the list of deployments for the specified Apps Script project.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Apps Script API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ListDeploymentsResponse extends com.google.api.client.json.GenericJson {

  /**
   * The list of deployments.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Deployment> deployments;

  static {
    // hack to force ProGuard to consider Deployment used, since otherwise it would be stripped out
    // see http://code.google.com/p/google-api-java-client/issues/detail?id=528
    com.google.api.client.util.Data.nullOf(Deployment.class);
  }

  /**
   * The token that can be used in the next call to get the next page of results.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String nextPageToken;

  /**
   * The list of deployments.
   * @return value or {@code null} for none
   */
  public java.util.List<Deployment> getDeployments() {
    return deployments;
  }

  /**
   * The list of deployments.
   * @param deployments deployments or {@code null} for none
   */
  public ListDeploymentsResponse setDeployments(java.util.List<Deployment> deployments) {
    this.deployments = deployments;
    return this;
  }

  /**
   * The token that can be used in the next call to get the next page of results.
   * @return value or {@code null} for none
   */
  public java.lang.String getNextPageToken() {
    return nextPageToken;
  }

  /**
   * The token that can be used in the next call to get the next page of results.
   * @param nextPageToken nextPageToken or {@code null} for none
   */
  public ListDeploymentsResponse setNextPageToken(java.lang.String nextPageToken) {
    this.nextPageToken = nextPageToken;
    return this;
  }

  @Override
  public ListDeploymentsResponse set(String fieldName, Object value) {
    return (ListDeploymentsResponse) super.set(fieldName, value);
  }

  @Override
  public ListDeploymentsResponse clone() {
    return (ListDeploymentsResponse) super.clone();
  }

}
