# Google Search Console API Client Library for Java

The Search Console API provides access to both Search Console data (verified users only) and to public information on an URL basis (anyone)

This page contains information about getting started with the Google Search Console API
using the Google API Client Library for Java. In addition, you may be interested
in the following documentation:

* Browse the [Javadoc reference for the Google Search Console API][javadoc]
* Read the [Developer's Guide for the Google API Client Library for Java][google-api-client].
* Interact with this API in your browser using the [APIs Explorer for the Google Search Console API][api-explorer]

## Installation

### Maven

Add the following lines to your `pom.xml` file:

```xml
<project>
  <dependencies>
    <dependency>
      <groupId>com.google.apis</groupId>
      <artifactId>google-api-services-searchconsole</artifactId>
      <version>v1-rev20250122-2.0.0</version>
    </dependency>
  </dependencies>
</project>
```

### Gradle

```gradle
repositories {
  mavenCentral()
}
dependencies {
  implementation 'com.google.apis:google-api-services-searchconsole:v1-rev20250122-2.0.0'
}
```

[javadoc]: https://googleapis.dev/java/google-api-services-searchconsole/latest/index.html
[google-api-client]: https://github.com/googleapis/google-api-java-client/
[api-explorer]: https://developers.google.com/apis-explorer/#p/searchconsole/v1/
