/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.searchconsole.v1.model;

/**
 * AMP inspection result of the live page or the current information from Google's index, depending
 * on whether you requested a live inspection or not.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Search Console API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class AmpInspectionResult extends com.google.api.client.json.GenericJson {

  /**
   * Index status of the AMP URL.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String ampIndexStatusVerdict;

  /**
   * URL of the AMP that was inspected. If the submitted URL is a desktop page that refers to an AMP
   * version, the AMP version will be inspected.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String ampUrl;

  /**
   * Whether or not the page blocks indexing through a noindex rule.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String indexingState;

  /**
   * A list of zero or more AMP issues found for the inspected URL.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<AmpIssue> issues;

  /**
   * Last time this AMP version was crawled by Google. Absent if the URL was never crawled
   * successfully.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String lastCrawlTime;

  /**
   * Whether or not Google could fetch the AMP.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String pageFetchState;

  /**
   * Whether or not the page is blocked to Google by a robots.txt rule.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String robotsTxtState;

  /**
   * The status of the most severe error on the page. If a page has both warnings and errors, the
   * page status is error. Error status means the page cannot be shown in Search results.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String verdict;

  /**
   * Index status of the AMP URL.
   * @return value or {@code null} for none
   */
  public java.lang.String getAmpIndexStatusVerdict() {
    return ampIndexStatusVerdict;
  }

  /**
   * Index status of the AMP URL.
   * @param ampIndexStatusVerdict ampIndexStatusVerdict or {@code null} for none
   */
  public AmpInspectionResult setAmpIndexStatusVerdict(java.lang.String ampIndexStatusVerdict) {
    this.ampIndexStatusVerdict = ampIndexStatusVerdict;
    return this;
  }

  /**
   * URL of the AMP that was inspected. If the submitted URL is a desktop page that refers to an AMP
   * version, the AMP version will be inspected.
   * @return value or {@code null} for none
   */
  public java.lang.String getAmpUrl() {
    return ampUrl;
  }

  /**
   * URL of the AMP that was inspected. If the submitted URL is a desktop page that refers to an AMP
   * version, the AMP version will be inspected.
   * @param ampUrl ampUrl or {@code null} for none
   */
  public AmpInspectionResult setAmpUrl(java.lang.String ampUrl) {
    this.ampUrl = ampUrl;
    return this;
  }

  /**
   * Whether or not the page blocks indexing through a noindex rule.
   * @return value or {@code null} for none
   */
  public java.lang.String getIndexingState() {
    return indexingState;
  }

  /**
   * Whether or not the page blocks indexing through a noindex rule.
   * @param indexingState indexingState or {@code null} for none
   */
  public AmpInspectionResult setIndexingState(java.lang.String indexingState) {
    this.indexingState = indexingState;
    return this;
  }

  /**
   * A list of zero or more AMP issues found for the inspected URL.
   * @return value or {@code null} for none
   */
  public java.util.List<AmpIssue> getIssues() {
    return issues;
  }

  /**
   * A list of zero or more AMP issues found for the inspected URL.
   * @param issues issues or {@code null} for none
   */
  public AmpInspectionResult setIssues(java.util.List<AmpIssue> issues) {
    this.issues = issues;
    return this;
  }

  /**
   * Last time this AMP version was crawled by Google. Absent if the URL was never crawled
   * successfully.
   * @return value or {@code null} for none
   */
  public String getLastCrawlTime() {
    return lastCrawlTime;
  }

  /**
   * Last time this AMP version was crawled by Google. Absent if the URL was never crawled
   * successfully.
   * @param lastCrawlTime lastCrawlTime or {@code null} for none
   */
  public AmpInspectionResult setLastCrawlTime(String lastCrawlTime) {
    this.lastCrawlTime = lastCrawlTime;
    return this;
  }

  /**
   * Whether or not Google could fetch the AMP.
   * @return value or {@code null} for none
   */
  public java.lang.String getPageFetchState() {
    return pageFetchState;
  }

  /**
   * Whether or not Google could fetch the AMP.
   * @param pageFetchState pageFetchState or {@code null} for none
   */
  public AmpInspectionResult setPageFetchState(java.lang.String pageFetchState) {
    this.pageFetchState = pageFetchState;
    return this;
  }

  /**
   * Whether or not the page is blocked to Google by a robots.txt rule.
   * @return value or {@code null} for none
   */
  public java.lang.String getRobotsTxtState() {
    return robotsTxtState;
  }

  /**
   * Whether or not the page is blocked to Google by a robots.txt rule.
   * @param robotsTxtState robotsTxtState or {@code null} for none
   */
  public AmpInspectionResult setRobotsTxtState(java.lang.String robotsTxtState) {
    this.robotsTxtState = robotsTxtState;
    return this;
  }

  /**
   * The status of the most severe error on the page. If a page has both warnings and errors, the
   * page status is error. Error status means the page cannot be shown in Search results.
   * @return value or {@code null} for none
   */
  public java.lang.String getVerdict() {
    return verdict;
  }

  /**
   * The status of the most severe error on the page. If a page has both warnings and errors, the
   * page status is error. Error status means the page cannot be shown in Search results.
   * @param verdict verdict or {@code null} for none
   */
  public AmpInspectionResult setVerdict(java.lang.String verdict) {
    this.verdict = verdict;
    return this;
  }

  @Override
  public AmpInspectionResult set(String fieldName, Object value) {
    return (AmpInspectionResult) super.set(fieldName, value);
  }

  @Override
  public AmpInspectionResult clone() {
    return (AmpInspectionResult) super.clone();
  }

}
