/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.searchconsole.v1.model;

/**
 * Results of index status inspection for either the live page or the version in Google's index,
 * depending on whether you requested a live inspection or not. For more information, see the [Index
 * coverage report documentation](https://support.google.com/webmasters/answer/7440203).
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Search Console API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class IndexStatusInspectionResult extends com.google.api.client.json.GenericJson {

  /**
   * Could Google find and index the page. More details about page indexing appear in
   * 'indexing_state'.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String coverageState;

  /**
   * Primary crawler that was used by Google to crawl your site.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String crawledAs;

  /**
   * The URL of the page that Google selected as canonical. If the page was not indexed, this field
   * is absent.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String googleCanonical;

  /**
   * Whether or not the page blocks indexing through a noindex rule.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String indexingState;

  /**
   * Last time this URL was crawled by Google using the [primary
   * crawler](https://support.google.com/webmasters/answer/7440203#primary_crawler). Absent if the
   * URL was never crawled successfully.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String lastCrawlTime;

  /**
   * Whether or not Google could retrieve the page from your server. Equivalent to ["page
   * fetch"](https://support.google.com/webmasters/answer/9012289#index_coverage) in the URL
   * inspection report.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String pageFetchState;

  /**
   * URLs that link to the inspected URL, directly and indirectly.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> referringUrls;

  /**
   * Whether or not the page is blocked to Google by a robots.txt rule.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String robotsTxtState;

  /**
   * Any sitemaps that this URL was listed in, as known by Google. Not guaranteed to be an
   * exhaustive list, especially if Google did not discover this URL through a sitemap. Absent if no
   * sitemaps were found.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> sitemap;

  /**
   * The URL that your page or site [declares as
   * canonical](https://developers.google.com/search/docs/advanced/crawling/consolidate-duplicate-
   * urls?#define-canonical). If you did not declare a canonical URL, this field is absent.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String userCanonical;

  /**
   * High level verdict about whether the URL *is* indexed (indexed status), or *can be* indexed
   * (live inspection).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String verdict;

  /**
   * Could Google find and index the page. More details about page indexing appear in
   * 'indexing_state'.
   * @return value or {@code null} for none
   */
  public java.lang.String getCoverageState() {
    return coverageState;
  }

  /**
   * Could Google find and index the page. More details about page indexing appear in
   * 'indexing_state'.
   * @param coverageState coverageState or {@code null} for none
   */
  public IndexStatusInspectionResult setCoverageState(java.lang.String coverageState) {
    this.coverageState = coverageState;
    return this;
  }

  /**
   * Primary crawler that was used by Google to crawl your site.
   * @return value or {@code null} for none
   */
  public java.lang.String getCrawledAs() {
    return crawledAs;
  }

  /**
   * Primary crawler that was used by Google to crawl your site.
   * @param crawledAs crawledAs or {@code null} for none
   */
  public IndexStatusInspectionResult setCrawledAs(java.lang.String crawledAs) {
    this.crawledAs = crawledAs;
    return this;
  }

  /**
   * The URL of the page that Google selected as canonical. If the page was not indexed, this field
   * is absent.
   * @return value or {@code null} for none
   */
  public java.lang.String getGoogleCanonical() {
    return googleCanonical;
  }

  /**
   * The URL of the page that Google selected as canonical. If the page was not indexed, this field
   * is absent.
   * @param googleCanonical googleCanonical or {@code null} for none
   */
  public IndexStatusInspectionResult setGoogleCanonical(java.lang.String googleCanonical) {
    this.googleCanonical = googleCanonical;
    return this;
  }

  /**
   * Whether or not the page blocks indexing through a noindex rule.
   * @return value or {@code null} for none
   */
  public java.lang.String getIndexingState() {
    return indexingState;
  }

  /**
   * Whether or not the page blocks indexing through a noindex rule.
   * @param indexingState indexingState or {@code null} for none
   */
  public IndexStatusInspectionResult setIndexingState(java.lang.String indexingState) {
    this.indexingState = indexingState;
    return this;
  }

  /**
   * Last time this URL was crawled by Google using the [primary
   * crawler](https://support.google.com/webmasters/answer/7440203#primary_crawler). Absent if the
   * URL was never crawled successfully.
   * @return value or {@code null} for none
   */
  public String getLastCrawlTime() {
    return lastCrawlTime;
  }

  /**
   * Last time this URL was crawled by Google using the [primary
   * crawler](https://support.google.com/webmasters/answer/7440203#primary_crawler). Absent if the
   * URL was never crawled successfully.
   * @param lastCrawlTime lastCrawlTime or {@code null} for none
   */
  public IndexStatusInspectionResult setLastCrawlTime(String lastCrawlTime) {
    this.lastCrawlTime = lastCrawlTime;
    return this;
  }

  /**
   * Whether or not Google could retrieve the page from your server. Equivalent to ["page
   * fetch"](https://support.google.com/webmasters/answer/9012289#index_coverage) in the URL
   * inspection report.
   * @return value or {@code null} for none
   */
  public java.lang.String getPageFetchState() {
    return pageFetchState;
  }

  /**
   * Whether or not Google could retrieve the page from your server. Equivalent to ["page
   * fetch"](https://support.google.com/webmasters/answer/9012289#index_coverage) in the URL
   * inspection report.
   * @param pageFetchState pageFetchState or {@code null} for none
   */
  public IndexStatusInspectionResult setPageFetchState(java.lang.String pageFetchState) {
    this.pageFetchState = pageFetchState;
    return this;
  }

  /**
   * URLs that link to the inspected URL, directly and indirectly.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getReferringUrls() {
    return referringUrls;
  }

  /**
   * URLs that link to the inspected URL, directly and indirectly.
   * @param referringUrls referringUrls or {@code null} for none
   */
  public IndexStatusInspectionResult setReferringUrls(java.util.List<java.lang.String> referringUrls) {
    this.referringUrls = referringUrls;
    return this;
  }

  /**
   * Whether or not the page is blocked to Google by a robots.txt rule.
   * @return value or {@code null} for none
   */
  public java.lang.String getRobotsTxtState() {
    return robotsTxtState;
  }

  /**
   * Whether or not the page is blocked to Google by a robots.txt rule.
   * @param robotsTxtState robotsTxtState or {@code null} for none
   */
  public IndexStatusInspectionResult setRobotsTxtState(java.lang.String robotsTxtState) {
    this.robotsTxtState = robotsTxtState;
    return this;
  }

  /**
   * Any sitemaps that this URL was listed in, as known by Google. Not guaranteed to be an
   * exhaustive list, especially if Google did not discover this URL through a sitemap. Absent if no
   * sitemaps were found.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getSitemap() {
    return sitemap;
  }

  /**
   * Any sitemaps that this URL was listed in, as known by Google. Not guaranteed to be an
   * exhaustive list, especially if Google did not discover this URL through a sitemap. Absent if no
   * sitemaps were found.
   * @param sitemap sitemap or {@code null} for none
   */
  public IndexStatusInspectionResult setSitemap(java.util.List<java.lang.String> sitemap) {
    this.sitemap = sitemap;
    return this;
  }

  /**
   * The URL that your page or site [declares as
   * canonical](https://developers.google.com/search/docs/advanced/crawling/consolidate-duplicate-
   * urls?#define-canonical). If you did not declare a canonical URL, this field is absent.
   * @return value or {@code null} for none
   */
  public java.lang.String getUserCanonical() {
    return userCanonical;
  }

  /**
   * The URL that your page or site [declares as
   * canonical](https://developers.google.com/search/docs/advanced/crawling/consolidate-duplicate-
   * urls?#define-canonical). If you did not declare a canonical URL, this field is absent.
   * @param userCanonical userCanonical or {@code null} for none
   */
  public IndexStatusInspectionResult setUserCanonical(java.lang.String userCanonical) {
    this.userCanonical = userCanonical;
    return this;
  }

  /**
   * High level verdict about whether the URL *is* indexed (indexed status), or *can be* indexed
   * (live inspection).
   * @return value or {@code null} for none
   */
  public java.lang.String getVerdict() {
    return verdict;
  }

  /**
   * High level verdict about whether the URL *is* indexed (indexed status), or *can be* indexed
   * (live inspection).
   * @param verdict verdict or {@code null} for none
   */
  public IndexStatusInspectionResult setVerdict(java.lang.String verdict) {
    this.verdict = verdict;
    return this;
  }

  @Override
  public IndexStatusInspectionResult set(String fieldName, Object value) {
    return (IndexStatusInspectionResult) super.set(fieldName, value);
  }

  @Override
  public IndexStatusInspectionResult clone() {
    return (IndexStatusInspectionResult) super.clone();
  }

}
