/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.searchconsole.v1.model;

/**
 * Index inspection request.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Search Console API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class InspectUrlIndexRequest extends com.google.api.client.json.GenericJson {

  /**
   * Required. URL to inspect. Must be under the property specified in "site_url".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String inspectionUrl;

  /**
   * Optional. An [IETF BCP-47](https://en.wikipedia.org/wiki/IETF_language_tag) language code
   * representing the requested language for translated issue messages, e.g. "en-US", "or "de-CH".
   * Default value is "en-US".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String languageCode;

  /**
   * Required. The URL of the property as defined in Search Console. **Examples:**
   * `http://www.example.com/` for a URL-prefix property, or `sc-domain:example.com` for a Domain
   * property.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String siteUrl;

  /**
   * Required. URL to inspect. Must be under the property specified in "site_url".
   * @return value or {@code null} for none
   */
  public java.lang.String getInspectionUrl() {
    return inspectionUrl;
  }

  /**
   * Required. URL to inspect. Must be under the property specified in "site_url".
   * @param inspectionUrl inspectionUrl or {@code null} for none
   */
  public InspectUrlIndexRequest setInspectionUrl(java.lang.String inspectionUrl) {
    this.inspectionUrl = inspectionUrl;
    return this;
  }

  /**
   * Optional. An [IETF BCP-47](https://en.wikipedia.org/wiki/IETF_language_tag) language code
   * representing the requested language for translated issue messages, e.g. "en-US", "or "de-CH".
   * Default value is "en-US".
   * @return value or {@code null} for none
   */
  public java.lang.String getLanguageCode() {
    return languageCode;
  }

  /**
   * Optional. An [IETF BCP-47](https://en.wikipedia.org/wiki/IETF_language_tag) language code
   * representing the requested language for translated issue messages, e.g. "en-US", "or "de-CH".
   * Default value is "en-US".
   * @param languageCode languageCode or {@code null} for none
   */
  public InspectUrlIndexRequest setLanguageCode(java.lang.String languageCode) {
    this.languageCode = languageCode;
    return this;
  }

  /**
   * Required. The URL of the property as defined in Search Console. **Examples:**
   * `http://www.example.com/` for a URL-prefix property, or `sc-domain:example.com` for a Domain
   * property.
   * @return value or {@code null} for none
   */
  public java.lang.String getSiteUrl() {
    return siteUrl;
  }

  /**
   * Required. The URL of the property as defined in Search Console. **Examples:**
   * `http://www.example.com/` for a URL-prefix property, or `sc-domain:example.com` for a Domain
   * property.
   * @param siteUrl siteUrl or {@code null} for none
   */
  public InspectUrlIndexRequest setSiteUrl(java.lang.String siteUrl) {
    this.siteUrl = siteUrl;
    return this;
  }

  @Override
  public InspectUrlIndexRequest set(String fieldName, Object value) {
    return (InspectUrlIndexRequest) super.set(fieldName, value);
  }

  @Override
  public InspectUrlIndexRequest clone() {
    return (InspectUrlIndexRequest) super.clone();
  }

}
