/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.searchconsole.v1.model;

/**
 * Mobile-usability issue.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Search Console API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class MobileUsabilityIssue extends com.google.api.client.json.GenericJson {

  /**
   * Mobile-usability issue type.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String issueType;

  /**
   * Additional information regarding the issue.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String message;

  /**
   * Not returned; reserved for future use.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String severity;

  /**
   * Mobile-usability issue type.
   * @return value or {@code null} for none
   */
  public java.lang.String getIssueType() {
    return issueType;
  }

  /**
   * Mobile-usability issue type.
   * @param issueType issueType or {@code null} for none
   */
  public MobileUsabilityIssue setIssueType(java.lang.String issueType) {
    this.issueType = issueType;
    return this;
  }

  /**
   * Additional information regarding the issue.
   * @return value or {@code null} for none
   */
  public java.lang.String getMessage() {
    return message;
  }

  /**
   * Additional information regarding the issue.
   * @param message message or {@code null} for none
   */
  public MobileUsabilityIssue setMessage(java.lang.String message) {
    this.message = message;
    return this;
  }

  /**
   * Not returned; reserved for future use.
   * @return value or {@code null} for none
   */
  public java.lang.String getSeverity() {
    return severity;
  }

  /**
   * Not returned; reserved for future use.
   * @param severity severity or {@code null} for none
   */
  public MobileUsabilityIssue setSeverity(java.lang.String severity) {
    this.severity = severity;
    return this;
  }

  @Override
  public MobileUsabilityIssue set(String fieldName, Object value) {
    return (MobileUsabilityIssue) super.set(fieldName, value);
  }

  @Override
  public MobileUsabilityIssue clone() {
    return (MobileUsabilityIssue) super.clone();
  }

}
