/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.searchconsole.v1.model;

/**
 * Information about a resource with issue.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Search Console API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ResourceIssue extends com.google.api.client.json.GenericJson {

  /**
   * Describes a blocked resource issue.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private BlockedResource blockedResource;

  /**
   * Describes a blocked resource issue.
   * @return value or {@code null} for none
   */
  public BlockedResource getBlockedResource() {
    return blockedResource;
  }

  /**
   * Describes a blocked resource issue.
   * @param blockedResource blockedResource or {@code null} for none
   */
  public ResourceIssue setBlockedResource(BlockedResource blockedResource) {
    this.blockedResource = blockedResource;
    return this;
  }

  @Override
  public ResourceIssue set(String fieldName, Object value) {
    return (ResourceIssue) super.set(fieldName, value);
  }

  @Override
  public ResourceIssue clone() {
    return (ResourceIssue) super.clone();
  }

}
