/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.searchconsole.v1.model;

/**
 * Rich-Results inspection result, including any rich results found at this URL.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Search Console API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class RichResultsInspectionResult extends com.google.api.client.json.GenericJson {

  /**
   * A list of zero or more rich results detected on this page. Rich results that cannot even be
   * parsed due to syntactic issues will not be listed here.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<DetectedItems> detectedItems;

  static {
    // hack to force ProGuard to consider DetectedItems used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(DetectedItems.class);
  }

  /**
   * High-level rich results inspection result for this URL.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String verdict;

  /**
   * A list of zero or more rich results detected on this page. Rich results that cannot even be
   * parsed due to syntactic issues will not be listed here.
   * @return value or {@code null} for none
   */
  public java.util.List<DetectedItems> getDetectedItems() {
    return detectedItems;
  }

  /**
   * A list of zero or more rich results detected on this page. Rich results that cannot even be
   * parsed due to syntactic issues will not be listed here.
   * @param detectedItems detectedItems or {@code null} for none
   */
  public RichResultsInspectionResult setDetectedItems(java.util.List<DetectedItems> detectedItems) {
    this.detectedItems = detectedItems;
    return this;
  }

  /**
   * High-level rich results inspection result for this URL.
   * @return value or {@code null} for none
   */
  public java.lang.String getVerdict() {
    return verdict;
  }

  /**
   * High-level rich results inspection result for this URL.
   * @param verdict verdict or {@code null} for none
   */
  public RichResultsInspectionResult setVerdict(java.lang.String verdict) {
    this.verdict = verdict;
    return this;
  }

  @Override
  public RichResultsInspectionResult set(String fieldName, Object value) {
    return (RichResultsInspectionResult) super.set(fieldName, value);
  }

  @Override
  public RichResultsInspectionResult clone() {
    return (RichResultsInspectionResult) super.clone();
  }

}
