/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.searchconsole.v1.model;

/**
 * Severity and status of a single issue affecting a single rich result instance on a page.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Search Console API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class RichResultsIssue extends com.google.api.client.json.GenericJson {

  /**
   * Rich Results issue type.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String issueMessage;

  /**
   * Severity of this issue: WARNING, or ERROR. Items with an issue of status ERROR cannot appear
   * with rich result features in Google Search results.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String severity;

  /**
   * Rich Results issue type.
   * @return value or {@code null} for none
   */
  public java.lang.String getIssueMessage() {
    return issueMessage;
  }

  /**
   * Rich Results issue type.
   * @param issueMessage issueMessage or {@code null} for none
   */
  public RichResultsIssue setIssueMessage(java.lang.String issueMessage) {
    this.issueMessage = issueMessage;
    return this;
  }

  /**
   * Severity of this issue: WARNING, or ERROR. Items with an issue of status ERROR cannot appear
   * with rich result features in Google Search results.
   * @return value or {@code null} for none
   */
  public java.lang.String getSeverity() {
    return severity;
  }

  /**
   * Severity of this issue: WARNING, or ERROR. Items with an issue of status ERROR cannot appear
   * with rich result features in Google Search results.
   * @param severity severity or {@code null} for none
   */
  public RichResultsIssue setSeverity(java.lang.String severity) {
    this.severity = severity;
    return this;
  }

  @Override
  public RichResultsIssue set(String fieldName, Object value) {
    return (RichResultsIssue) super.set(fieldName, value);
  }

  @Override
  public RichResultsIssue clone() {
    return (RichResultsIssue) super.clone();
  }

}
