/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.searchconsole.v1.model;

/**
 * Mobile-friendly test response, including mobile-friendly issues and resource issues.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Search Console API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class RunMobileFriendlyTestResponse extends com.google.api.client.json.GenericJson {

  /**
   * Test verdict, whether the page is mobile friendly or not.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String mobileFriendliness;

  /**
   * List of mobile-usability issues.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<MobileFriendlyIssue> mobileFriendlyIssues;

  static {
    // hack to force ProGuard to consider MobileFriendlyIssue used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(MobileFriendlyIssue.class);
  }

  /**
   * Information about embedded resources issues.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<ResourceIssue> resourceIssues;

  static {
    // hack to force ProGuard to consider ResourceIssue used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(ResourceIssue.class);
  }

  /**
   * Screenshot of the requested URL.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Image screenshot;

  /**
   * Final state of the test, can be either complete or an error.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private TestStatus testStatus;

  /**
   * Test verdict, whether the page is mobile friendly or not.
   * @return value or {@code null} for none
   */
  public java.lang.String getMobileFriendliness() {
    return mobileFriendliness;
  }

  /**
   * Test verdict, whether the page is mobile friendly or not.
   * @param mobileFriendliness mobileFriendliness or {@code null} for none
   */
  public RunMobileFriendlyTestResponse setMobileFriendliness(java.lang.String mobileFriendliness) {
    this.mobileFriendliness = mobileFriendliness;
    return this;
  }

  /**
   * List of mobile-usability issues.
   * @return value or {@code null} for none
   */
  public java.util.List<MobileFriendlyIssue> getMobileFriendlyIssues() {
    return mobileFriendlyIssues;
  }

  /**
   * List of mobile-usability issues.
   * @param mobileFriendlyIssues mobileFriendlyIssues or {@code null} for none
   */
  public RunMobileFriendlyTestResponse setMobileFriendlyIssues(java.util.List<MobileFriendlyIssue> mobileFriendlyIssues) {
    this.mobileFriendlyIssues = mobileFriendlyIssues;
    return this;
  }

  /**
   * Information about embedded resources issues.
   * @return value or {@code null} for none
   */
  public java.util.List<ResourceIssue> getResourceIssues() {
    return resourceIssues;
  }

  /**
   * Information about embedded resources issues.
   * @param resourceIssues resourceIssues or {@code null} for none
   */
  public RunMobileFriendlyTestResponse setResourceIssues(java.util.List<ResourceIssue> resourceIssues) {
    this.resourceIssues = resourceIssues;
    return this;
  }

  /**
   * Screenshot of the requested URL.
   * @return value or {@code null} for none
   */
  public Image getScreenshot() {
    return screenshot;
  }

  /**
   * Screenshot of the requested URL.
   * @param screenshot screenshot or {@code null} for none
   */
  public RunMobileFriendlyTestResponse setScreenshot(Image screenshot) {
    this.screenshot = screenshot;
    return this;
  }

  /**
   * Final state of the test, can be either complete or an error.
   * @return value or {@code null} for none
   */
  public TestStatus getTestStatus() {
    return testStatus;
  }

  /**
   * Final state of the test, can be either complete or an error.
   * @param testStatus testStatus or {@code null} for none
   */
  public RunMobileFriendlyTestResponse setTestStatus(TestStatus testStatus) {
    this.testStatus = testStatus;
    return this;
  }

  @Override
  public RunMobileFriendlyTestResponse set(String fieldName, Object value) {
    return (RunMobileFriendlyTestResponse) super.set(fieldName, value);
  }

  @Override
  public RunMobileFriendlyTestResponse clone() {
    return (RunMobileFriendlyTestResponse) super.clone();
  }

}
