/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.searchconsole.v1.model;

/**
 * A list of rows, one per result, grouped by key. Metrics in each row are aggregated for all data
 * grouped by that key either by page or property, as specified by the aggregation type parameter.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Search Console API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class SearchAnalyticsQueryResponse extends com.google.api.client.json.GenericJson {

  /**
   * How the results were aggregated.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String responseAggregationType;

  /**
   * A list of rows grouped by the key values in the order given in the query.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<ApiDataRow> rows;

  static {
    // hack to force ProGuard to consider ApiDataRow used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(ApiDataRow.class);
  }

  /**
   * How the results were aggregated.
   * @return value or {@code null} for none
   */
  public java.lang.String getResponseAggregationType() {
    return responseAggregationType;
  }

  /**
   * How the results were aggregated.
   * @param responseAggregationType responseAggregationType or {@code null} for none
   */
  public SearchAnalyticsQueryResponse setResponseAggregationType(java.lang.String responseAggregationType) {
    this.responseAggregationType = responseAggregationType;
    return this;
  }

  /**
   * A list of rows grouped by the key values in the order given in the query.
   * @return value or {@code null} for none
   */
  public java.util.List<ApiDataRow> getRows() {
    return rows;
  }

  /**
   * A list of rows grouped by the key values in the order given in the query.
   * @param rows rows or {@code null} for none
   */
  public SearchAnalyticsQueryResponse setRows(java.util.List<ApiDataRow> rows) {
    this.rows = rows;
    return this;
  }

  @Override
  public SearchAnalyticsQueryResponse set(String fieldName, Object value) {
    return (SearchAnalyticsQueryResponse) super.set(fieldName, value);
  }

  @Override
  public SearchAnalyticsQueryResponse clone() {
    return (SearchAnalyticsQueryResponse) super.clone();
  }

}
