/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.searchconsole.v1.model;

/**
 * URL inspection result, including all inspection results.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Search Console API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class UrlInspectionResult extends com.google.api.client.json.GenericJson {

  /**
   * Result of the AMP analysis. Absent if the page is not an AMP page.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private AmpInspectionResult ampResult;

  /**
   * Result of the index status analysis.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private IndexStatusInspectionResult indexStatusResult;

  /**
   * Link to Search Console URL inspection.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String inspectionResultLink;

  /**
   * Result of the Mobile usability analysis.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private MobileUsabilityInspectionResult mobileUsabilityResult;

  /**
   * Result of the Rich Results analysis. Absent if there are no rich results found.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private RichResultsInspectionResult richResultsResult;

  /**
   * Result of the AMP analysis. Absent if the page is not an AMP page.
   * @return value or {@code null} for none
   */
  public AmpInspectionResult getAmpResult() {
    return ampResult;
  }

  /**
   * Result of the AMP analysis. Absent if the page is not an AMP page.
   * @param ampResult ampResult or {@code null} for none
   */
  public UrlInspectionResult setAmpResult(AmpInspectionResult ampResult) {
    this.ampResult = ampResult;
    return this;
  }

  /**
   * Result of the index status analysis.
   * @return value or {@code null} for none
   */
  public IndexStatusInspectionResult getIndexStatusResult() {
    return indexStatusResult;
  }

  /**
   * Result of the index status analysis.
   * @param indexStatusResult indexStatusResult or {@code null} for none
   */
  public UrlInspectionResult setIndexStatusResult(IndexStatusInspectionResult indexStatusResult) {
    this.indexStatusResult = indexStatusResult;
    return this;
  }

  /**
   * Link to Search Console URL inspection.
   * @return value or {@code null} for none
   */
  public java.lang.String getInspectionResultLink() {
    return inspectionResultLink;
  }

  /**
   * Link to Search Console URL inspection.
   * @param inspectionResultLink inspectionResultLink or {@code null} for none
   */
  public UrlInspectionResult setInspectionResultLink(java.lang.String inspectionResultLink) {
    this.inspectionResultLink = inspectionResultLink;
    return this;
  }

  /**
   * Result of the Mobile usability analysis.
   * @return value or {@code null} for none
   */
  public MobileUsabilityInspectionResult getMobileUsabilityResult() {
    return mobileUsabilityResult;
  }

  /**
   * Result of the Mobile usability analysis.
   * @param mobileUsabilityResult mobileUsabilityResult or {@code null} for none
   */
  public UrlInspectionResult setMobileUsabilityResult(MobileUsabilityInspectionResult mobileUsabilityResult) {
    this.mobileUsabilityResult = mobileUsabilityResult;
    return this;
  }

  /**
   * Result of the Rich Results analysis. Absent if there are no rich results found.
   * @return value or {@code null} for none
   */
  public RichResultsInspectionResult getRichResultsResult() {
    return richResultsResult;
  }

  /**
   * Result of the Rich Results analysis. Absent if there are no rich results found.
   * @param richResultsResult richResultsResult or {@code null} for none
   */
  public UrlInspectionResult setRichResultsResult(RichResultsInspectionResult richResultsResult) {
    this.richResultsResult = richResultsResult;
    return this;
  }

  @Override
  public UrlInspectionResult set(String fieldName, Object value) {
    return (UrlInspectionResult) super.set(fieldName, value);
  }

  @Override
  public UrlInspectionResult clone() {
    return (UrlInspectionResult) super.clone();
  }

}
