/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.secretmanager.v1;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.secretmanager.v1.SecretManagerRequest;
import com.google.api.services.secretmanager.v1.SecretManagerRequestInitializer;
import com.google.api.services.secretmanager.v1.model.AccessSecretVersionResponse;
import com.google.api.services.secretmanager.v1.model.AddSecretVersionRequest;
import com.google.api.services.secretmanager.v1.model.DestroySecretVersionRequest;
import com.google.api.services.secretmanager.v1.model.DisableSecretVersionRequest;
import com.google.api.services.secretmanager.v1.model.Empty;
import com.google.api.services.secretmanager.v1.model.EnableSecretVersionRequest;
import com.google.api.services.secretmanager.v1.model.ListLocationsResponse;
import com.google.api.services.secretmanager.v1.model.ListSecretVersionsResponse;
import com.google.api.services.secretmanager.v1.model.ListSecretsResponse;
import com.google.api.services.secretmanager.v1.model.Location;
import com.google.api.services.secretmanager.v1.model.Policy;
import com.google.api.services.secretmanager.v1.model.Secret;
import com.google.api.services.secretmanager.v1.model.SecretVersion;
import com.google.api.services.secretmanager.v1.model.SetIamPolicyRequest;
import com.google.api.services.secretmanager.v1.model.TestIamPermissionsRequest;
import com.google.api.services.secretmanager.v1.model.TestIamPermissionsResponse;
import java.io.IOException;
import java.util.regex.Pattern;

public class SecretManager
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://secretmanager.googleapis.com/";
    public static final String DEFAULT_MTLS_ROOT_URL = "https://secretmanager.mtls.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "";
    public static final String DEFAULT_BATCH_PATH = "batch";
    public static final String DEFAULT_BASE_URL = "https://secretmanager.googleapis.com/";

    public SecretManager(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(transport, jsonFactory, httpRequestInitializer));
    }

    SecretManager(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> httpClientRequest) throws IOException {
        super.initialize(httpClientRequest);
    }

    public Projects projects() {
        return new Projects();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && (GoogleUtils.MINOR_VERSION >= 32 || GoogleUtils.MINOR_VERSION == 31 && GoogleUtils.BUGFIX_VERSION >= 1) || GoogleUtils.MAJOR_VERSION >= 2 ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.31.1 of google-api-client to run version 2.0.0 of the Secret Manager API library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        private static String chooseEndpoint(HttpTransport transport) {
            String useMtlsEndpoint = System.getenv("GOOGLE_API_USE_MTLS_ENDPOINT");
            String string = useMtlsEndpoint = useMtlsEndpoint == null ? "auto" : useMtlsEndpoint;
            if ("always".equals(useMtlsEndpoint) || "auto".equals(useMtlsEndpoint) && transport != null && transport.isMtls()) {
                return SecretManager.DEFAULT_MTLS_ROOT_URL;
            }
            return "https://secretmanager.googleapis.com/";
        }

        public Builder(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(transport, jsonFactory, Builder.chooseEndpoint(transport), SecretManager.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
            this.setBatchPath(SecretManager.DEFAULT_BATCH_PATH);
        }

        public SecretManager build() {
            return new SecretManager(this);
        }

        public Builder setRootUrl(String rootUrl) {
            return (Builder)super.setRootUrl(rootUrl);
        }

        public Builder setServicePath(String servicePath) {
            return (Builder)super.setServicePath(servicePath);
        }

        public Builder setBatchPath(String batchPath) {
            return (Builder)super.setBatchPath(batchPath);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String applicationName) {
            return (Builder)super.setApplicationName(applicationName);
        }

        public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
            return (Builder)super.setSuppressPatternChecks(suppressPatternChecks);
        }

        public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
            return (Builder)super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
        }

        public Builder setSuppressAllChecks(boolean suppressAllChecks) {
            return (Builder)super.setSuppressAllChecks(suppressAllChecks);
        }

        public Builder setSecretManagerRequestInitializer(SecretManagerRequestInitializer secretmanagerRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)secretmanagerRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }
    }

    public class Projects {
        public Locations locations() {
            return new Locations();
        }

        public Secrets secrets() {
            return new Secrets();
        }

        public class Secrets {
            public AddVersion addVersion(String parent, AddSecretVersionRequest content) throws IOException {
                AddVersion result = new AddVersion(parent, content);
                SecretManager.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Create create(String parent, Secret content) throws IOException {
                Create result = new Create(parent, content);
                SecretManager.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Delete delete(String name) throws IOException {
                Delete result = new Delete(name);
                SecretManager.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Get get(String name) throws IOException {
                Get result = new Get(name);
                SecretManager.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public GetIamPolicy getIamPolicy(String resource) throws IOException {
                GetIamPolicy result = new GetIamPolicy(resource);
                SecretManager.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public List list(String parent) throws IOException {
                List result = new List(parent);
                SecretManager.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Patch patch(String name, Secret content) throws IOException {
                Patch result = new Patch(name, content);
                SecretManager.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public SetIamPolicy setIamPolicy(String resource, SetIamPolicyRequest content) throws IOException {
                SetIamPolicy result = new SetIamPolicy(resource, content);
                SecretManager.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public TestIamPermissions testIamPermissions(String resource, TestIamPermissionsRequest content) throws IOException {
                TestIamPermissions result = new TestIamPermissions(resource, content);
                SecretManager.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Versions versions() {
                return new Versions();
            }

            public class Versions {
                public Access access(String name) throws IOException {
                    Access result = new Access(name);
                    SecretManager.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Destroy destroy(String name, DestroySecretVersionRequest content) throws IOException {
                    Destroy result = new Destroy(name, content);
                    SecretManager.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Disable disable(String name, DisableSecretVersionRequest content) throws IOException {
                    Disable result = new Disable(name, content);
                    SecretManager.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Enable enable(String name, EnableSecretVersionRequest content) throws IOException {
                    Enable result = new Enable(name, content);
                    SecretManager.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Get get(String name) throws IOException {
                    Get result = new Get(name);
                    SecretManager.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public List list(String parent) throws IOException {
                    List result = new List(parent);
                    SecretManager.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public class List
                extends SecretManagerRequest<ListSecretVersionsResponse> {
                    private static final String REST_PATH = "v1/{+parent}/versions";
                    private final Pattern PARENT_PATTERN;
                    @Key
                    private String parent;
                    @Key
                    private String filter;
                    @Key
                    private Integer pageSize;
                    @Key
                    private String pageToken;

                    protected List(String parent) {
                        super(SecretManager.this, "GET", REST_PATH, null, ListSecretVersionsResponse.class);
                        this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/secrets/[^/]+$");
                        this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                        if (!SecretManager.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/secrets/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public List set$Xgafv(String $Xgafv) {
                        return (List)super.set$Xgafv($Xgafv);
                    }

                    public List setAccessToken(String accessToken) {
                        return (List)super.setAccessToken(accessToken);
                    }

                    public List setAlt(String alt) {
                        return (List)super.setAlt(alt);
                    }

                    public List setCallback(String callback) {
                        return (List)super.setCallback(callback);
                    }

                    public List setFields(String fields) {
                        return (List)super.setFields(fields);
                    }

                    public List setKey(String key) {
                        return (List)super.setKey(key);
                    }

                    public List setOauthToken(String oauthToken) {
                        return (List)super.setOauthToken(oauthToken);
                    }

                    public List setPrettyPrint(Boolean prettyPrint) {
                        return (List)super.setPrettyPrint(prettyPrint);
                    }

                    public List setQuotaUser(String quotaUser) {
                        return (List)super.setQuotaUser(quotaUser);
                    }

                    public List setUploadType(String uploadType) {
                        return (List)super.setUploadType(uploadType);
                    }

                    public List setUploadProtocol(String uploadProtocol) {
                        return (List)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getParent() {
                        return this.parent;
                    }

                    public List setParent(String parent) {
                        if (!SecretManager.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/secrets/[^/]+$");
                        }
                        this.parent = parent;
                        return this;
                    }

                    public String getFilter() {
                        return this.filter;
                    }

                    public List setFilter(String filter) {
                        this.filter = filter;
                        return this;
                    }

                    public Integer getPageSize() {
                        return this.pageSize;
                    }

                    public List setPageSize(Integer pageSize) {
                        this.pageSize = pageSize;
                        return this;
                    }

                    public String getPageToken() {
                        return this.pageToken;
                    }

                    public List setPageToken(String pageToken) {
                        this.pageToken = pageToken;
                        return this;
                    }

                    @Override
                    public List set(String parameterName, Object value) {
                        return (List)super.set(parameterName, value);
                    }
                }

                public class Get
                extends SecretManagerRequest<SecretVersion> {
                    private static final String REST_PATH = "v1/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected Get(String name) {
                        super(SecretManager.this, "GET", REST_PATH, null, SecretVersion.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/secrets/[^/]+/versions/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!SecretManager.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/secrets/[^/]+/versions/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public Get set$Xgafv(String $Xgafv) {
                        return (Get)super.set$Xgafv($Xgafv);
                    }

                    public Get setAccessToken(String accessToken) {
                        return (Get)super.setAccessToken(accessToken);
                    }

                    public Get setAlt(String alt) {
                        return (Get)super.setAlt(alt);
                    }

                    public Get setCallback(String callback) {
                        return (Get)super.setCallback(callback);
                    }

                    public Get setFields(String fields) {
                        return (Get)super.setFields(fields);
                    }

                    public Get setKey(String key) {
                        return (Get)super.setKey(key);
                    }

                    public Get setOauthToken(String oauthToken) {
                        return (Get)super.setOauthToken(oauthToken);
                    }

                    public Get setPrettyPrint(Boolean prettyPrint) {
                        return (Get)super.setPrettyPrint(prettyPrint);
                    }

                    public Get setQuotaUser(String quotaUser) {
                        return (Get)super.setQuotaUser(quotaUser);
                    }

                    public Get setUploadType(String uploadType) {
                        return (Get)super.setUploadType(uploadType);
                    }

                    public Get setUploadProtocol(String uploadProtocol) {
                        return (Get)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Get setName(String name) {
                        if (!SecretManager.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/secrets/[^/]+/versions/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    @Override
                    public Get set(String parameterName, Object value) {
                        return (Get)super.set(parameterName, value);
                    }
                }

                public class Enable
                extends SecretManagerRequest<SecretVersion> {
                    private static final String REST_PATH = "v1/{+name}:enable";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected Enable(String name, EnableSecretVersionRequest content) {
                        super(SecretManager.this, "POST", REST_PATH, (Object)content, SecretVersion.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/secrets/[^/]+/versions/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!SecretManager.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/secrets/[^/]+/versions/[^/]+$");
                        }
                    }

                    public Enable set$Xgafv(String $Xgafv) {
                        return (Enable)super.set$Xgafv($Xgafv);
                    }

                    public Enable setAccessToken(String accessToken) {
                        return (Enable)super.setAccessToken(accessToken);
                    }

                    public Enable setAlt(String alt) {
                        return (Enable)super.setAlt(alt);
                    }

                    public Enable setCallback(String callback) {
                        return (Enable)super.setCallback(callback);
                    }

                    public Enable setFields(String fields) {
                        return (Enable)super.setFields(fields);
                    }

                    public Enable setKey(String key) {
                        return (Enable)super.setKey(key);
                    }

                    public Enable setOauthToken(String oauthToken) {
                        return (Enable)super.setOauthToken(oauthToken);
                    }

                    public Enable setPrettyPrint(Boolean prettyPrint) {
                        return (Enable)super.setPrettyPrint(prettyPrint);
                    }

                    public Enable setQuotaUser(String quotaUser) {
                        return (Enable)super.setQuotaUser(quotaUser);
                    }

                    public Enable setUploadType(String uploadType) {
                        return (Enable)super.setUploadType(uploadType);
                    }

                    public Enable setUploadProtocol(String uploadProtocol) {
                        return (Enable)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Enable setName(String name) {
                        if (!SecretManager.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/secrets/[^/]+/versions/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    @Override
                    public Enable set(String parameterName, Object value) {
                        return (Enable)super.set(parameterName, value);
                    }
                }

                public class Disable
                extends SecretManagerRequest<SecretVersion> {
                    private static final String REST_PATH = "v1/{+name}:disable";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected Disable(String name, DisableSecretVersionRequest content) {
                        super(SecretManager.this, "POST", REST_PATH, (Object)content, SecretVersion.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/secrets/[^/]+/versions/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!SecretManager.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/secrets/[^/]+/versions/[^/]+$");
                        }
                    }

                    public Disable set$Xgafv(String $Xgafv) {
                        return (Disable)super.set$Xgafv($Xgafv);
                    }

                    public Disable setAccessToken(String accessToken) {
                        return (Disable)super.setAccessToken(accessToken);
                    }

                    public Disable setAlt(String alt) {
                        return (Disable)super.setAlt(alt);
                    }

                    public Disable setCallback(String callback) {
                        return (Disable)super.setCallback(callback);
                    }

                    public Disable setFields(String fields) {
                        return (Disable)super.setFields(fields);
                    }

                    public Disable setKey(String key) {
                        return (Disable)super.setKey(key);
                    }

                    public Disable setOauthToken(String oauthToken) {
                        return (Disable)super.setOauthToken(oauthToken);
                    }

                    public Disable setPrettyPrint(Boolean prettyPrint) {
                        return (Disable)super.setPrettyPrint(prettyPrint);
                    }

                    public Disable setQuotaUser(String quotaUser) {
                        return (Disable)super.setQuotaUser(quotaUser);
                    }

                    public Disable setUploadType(String uploadType) {
                        return (Disable)super.setUploadType(uploadType);
                    }

                    public Disable setUploadProtocol(String uploadProtocol) {
                        return (Disable)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Disable setName(String name) {
                        if (!SecretManager.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/secrets/[^/]+/versions/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    @Override
                    public Disable set(String parameterName, Object value) {
                        return (Disable)super.set(parameterName, value);
                    }
                }

                public class Destroy
                extends SecretManagerRequest<SecretVersion> {
                    private static final String REST_PATH = "v1/{+name}:destroy";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected Destroy(String name, DestroySecretVersionRequest content) {
                        super(SecretManager.this, "POST", REST_PATH, (Object)content, SecretVersion.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/secrets/[^/]+/versions/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!SecretManager.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/secrets/[^/]+/versions/[^/]+$");
                        }
                    }

                    public Destroy set$Xgafv(String $Xgafv) {
                        return (Destroy)super.set$Xgafv($Xgafv);
                    }

                    public Destroy setAccessToken(String accessToken) {
                        return (Destroy)super.setAccessToken(accessToken);
                    }

                    public Destroy setAlt(String alt) {
                        return (Destroy)super.setAlt(alt);
                    }

                    public Destroy setCallback(String callback) {
                        return (Destroy)super.setCallback(callback);
                    }

                    public Destroy setFields(String fields) {
                        return (Destroy)super.setFields(fields);
                    }

                    public Destroy setKey(String key) {
                        return (Destroy)super.setKey(key);
                    }

                    public Destroy setOauthToken(String oauthToken) {
                        return (Destroy)super.setOauthToken(oauthToken);
                    }

                    public Destroy setPrettyPrint(Boolean prettyPrint) {
                        return (Destroy)super.setPrettyPrint(prettyPrint);
                    }

                    public Destroy setQuotaUser(String quotaUser) {
                        return (Destroy)super.setQuotaUser(quotaUser);
                    }

                    public Destroy setUploadType(String uploadType) {
                        return (Destroy)super.setUploadType(uploadType);
                    }

                    public Destroy setUploadProtocol(String uploadProtocol) {
                        return (Destroy)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Destroy setName(String name) {
                        if (!SecretManager.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/secrets/[^/]+/versions/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    @Override
                    public Destroy set(String parameterName, Object value) {
                        return (Destroy)super.set(parameterName, value);
                    }
                }

                public class Access
                extends SecretManagerRequest<AccessSecretVersionResponse> {
                    private static final String REST_PATH = "v1/{+name}:access";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected Access(String name) {
                        super(SecretManager.this, "GET", REST_PATH, null, AccessSecretVersionResponse.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/secrets/[^/]+/versions/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!SecretManager.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/secrets/[^/]+/versions/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public Access set$Xgafv(String $Xgafv) {
                        return (Access)super.set$Xgafv($Xgafv);
                    }

                    public Access setAccessToken(String accessToken) {
                        return (Access)super.setAccessToken(accessToken);
                    }

                    public Access setAlt(String alt) {
                        return (Access)super.setAlt(alt);
                    }

                    public Access setCallback(String callback) {
                        return (Access)super.setCallback(callback);
                    }

                    public Access setFields(String fields) {
                        return (Access)super.setFields(fields);
                    }

                    public Access setKey(String key) {
                        return (Access)super.setKey(key);
                    }

                    public Access setOauthToken(String oauthToken) {
                        return (Access)super.setOauthToken(oauthToken);
                    }

                    public Access setPrettyPrint(Boolean prettyPrint) {
                        return (Access)super.setPrettyPrint(prettyPrint);
                    }

                    public Access setQuotaUser(String quotaUser) {
                        return (Access)super.setQuotaUser(quotaUser);
                    }

                    public Access setUploadType(String uploadType) {
                        return (Access)super.setUploadType(uploadType);
                    }

                    public Access setUploadProtocol(String uploadProtocol) {
                        return (Access)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Access setName(String name) {
                        if (!SecretManager.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/secrets/[^/]+/versions/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    @Override
                    public Access set(String parameterName, Object value) {
                        return (Access)super.set(parameterName, value);
                    }
                }
            }

            public class TestIamPermissions
            extends SecretManagerRequest<TestIamPermissionsResponse> {
                private static final String REST_PATH = "v1/{+resource}:testIamPermissions";
                private final Pattern RESOURCE_PATTERN;
                @Key
                private String resource;

                protected TestIamPermissions(String resource, TestIamPermissionsRequest content) {
                    super(SecretManager.this, "POST", REST_PATH, (Object)content, TestIamPermissionsResponse.class);
                    this.RESOURCE_PATTERN = Pattern.compile("^projects/[^/]+/secrets/[^/]+$");
                    this.resource = (String)Preconditions.checkNotNull((Object)resource, (Object)"Required parameter resource must be specified.");
                    if (!SecretManager.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/secrets/[^/]+$");
                    }
                }

                public TestIamPermissions set$Xgafv(String $Xgafv) {
                    return (TestIamPermissions)super.set$Xgafv($Xgafv);
                }

                public TestIamPermissions setAccessToken(String accessToken) {
                    return (TestIamPermissions)super.setAccessToken(accessToken);
                }

                public TestIamPermissions setAlt(String alt) {
                    return (TestIamPermissions)super.setAlt(alt);
                }

                public TestIamPermissions setCallback(String callback) {
                    return (TestIamPermissions)super.setCallback(callback);
                }

                public TestIamPermissions setFields(String fields) {
                    return (TestIamPermissions)super.setFields(fields);
                }

                public TestIamPermissions setKey(String key) {
                    return (TestIamPermissions)super.setKey(key);
                }

                public TestIamPermissions setOauthToken(String oauthToken) {
                    return (TestIamPermissions)super.setOauthToken(oauthToken);
                }

                public TestIamPermissions setPrettyPrint(Boolean prettyPrint) {
                    return (TestIamPermissions)super.setPrettyPrint(prettyPrint);
                }

                public TestIamPermissions setQuotaUser(String quotaUser) {
                    return (TestIamPermissions)super.setQuotaUser(quotaUser);
                }

                public TestIamPermissions setUploadType(String uploadType) {
                    return (TestIamPermissions)super.setUploadType(uploadType);
                }

                public TestIamPermissions setUploadProtocol(String uploadProtocol) {
                    return (TestIamPermissions)super.setUploadProtocol(uploadProtocol);
                }

                public String getResource() {
                    return this.resource;
                }

                public TestIamPermissions setResource(String resource) {
                    if (!SecretManager.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/secrets/[^/]+$");
                    }
                    this.resource = resource;
                    return this;
                }

                @Override
                public TestIamPermissions set(String parameterName, Object value) {
                    return (TestIamPermissions)super.set(parameterName, value);
                }
            }

            public class SetIamPolicy
            extends SecretManagerRequest<Policy> {
                private static final String REST_PATH = "v1/{+resource}:setIamPolicy";
                private final Pattern RESOURCE_PATTERN;
                @Key
                private String resource;

                protected SetIamPolicy(String resource, SetIamPolicyRequest content) {
                    super(SecretManager.this, "POST", REST_PATH, (Object)content, Policy.class);
                    this.RESOURCE_PATTERN = Pattern.compile("^projects/[^/]+/secrets/[^/]+$");
                    this.resource = (String)Preconditions.checkNotNull((Object)resource, (Object)"Required parameter resource must be specified.");
                    if (!SecretManager.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/secrets/[^/]+$");
                    }
                }

                public SetIamPolicy set$Xgafv(String $Xgafv) {
                    return (SetIamPolicy)super.set$Xgafv($Xgafv);
                }

                public SetIamPolicy setAccessToken(String accessToken) {
                    return (SetIamPolicy)super.setAccessToken(accessToken);
                }

                public SetIamPolicy setAlt(String alt) {
                    return (SetIamPolicy)super.setAlt(alt);
                }

                public SetIamPolicy setCallback(String callback) {
                    return (SetIamPolicy)super.setCallback(callback);
                }

                public SetIamPolicy setFields(String fields) {
                    return (SetIamPolicy)super.setFields(fields);
                }

                public SetIamPolicy setKey(String key) {
                    return (SetIamPolicy)super.setKey(key);
                }

                public SetIamPolicy setOauthToken(String oauthToken) {
                    return (SetIamPolicy)super.setOauthToken(oauthToken);
                }

                public SetIamPolicy setPrettyPrint(Boolean prettyPrint) {
                    return (SetIamPolicy)super.setPrettyPrint(prettyPrint);
                }

                public SetIamPolicy setQuotaUser(String quotaUser) {
                    return (SetIamPolicy)super.setQuotaUser(quotaUser);
                }

                public SetIamPolicy setUploadType(String uploadType) {
                    return (SetIamPolicy)super.setUploadType(uploadType);
                }

                public SetIamPolicy setUploadProtocol(String uploadProtocol) {
                    return (SetIamPolicy)super.setUploadProtocol(uploadProtocol);
                }

                public String getResource() {
                    return this.resource;
                }

                public SetIamPolicy setResource(String resource) {
                    if (!SecretManager.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/secrets/[^/]+$");
                    }
                    this.resource = resource;
                    return this;
                }

                @Override
                public SetIamPolicy set(String parameterName, Object value) {
                    return (SetIamPolicy)super.set(parameterName, value);
                }
            }

            public class Patch
            extends SecretManagerRequest<Secret> {
                private static final String REST_PATH = "v1/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;
                @Key
                private String updateMask;

                protected Patch(String name, Secret content) {
                    super(SecretManager.this, "PATCH", REST_PATH, (Object)content, Secret.class);
                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/secrets/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!SecretManager.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/secrets/[^/]+$");
                    }
                }

                public Patch set$Xgafv(String $Xgafv) {
                    return (Patch)super.set$Xgafv($Xgafv);
                }

                public Patch setAccessToken(String accessToken) {
                    return (Patch)super.setAccessToken(accessToken);
                }

                public Patch setAlt(String alt) {
                    return (Patch)super.setAlt(alt);
                }

                public Patch setCallback(String callback) {
                    return (Patch)super.setCallback(callback);
                }

                public Patch setFields(String fields) {
                    return (Patch)super.setFields(fields);
                }

                public Patch setKey(String key) {
                    return (Patch)super.setKey(key);
                }

                public Patch setOauthToken(String oauthToken) {
                    return (Patch)super.setOauthToken(oauthToken);
                }

                public Patch setPrettyPrint(Boolean prettyPrint) {
                    return (Patch)super.setPrettyPrint(prettyPrint);
                }

                public Patch setQuotaUser(String quotaUser) {
                    return (Patch)super.setQuotaUser(quotaUser);
                }

                public Patch setUploadType(String uploadType) {
                    return (Patch)super.setUploadType(uploadType);
                }

                public Patch setUploadProtocol(String uploadProtocol) {
                    return (Patch)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public Patch setName(String name) {
                    if (!SecretManager.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/secrets/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                public String getUpdateMask() {
                    return this.updateMask;
                }

                public Patch setUpdateMask(String updateMask) {
                    this.updateMask = updateMask;
                    return this;
                }

                @Override
                public Patch set(String parameterName, Object value) {
                    return (Patch)super.set(parameterName, value);
                }
            }

            public class List
            extends SecretManagerRequest<ListSecretsResponse> {
                private static final String REST_PATH = "v1/{+parent}/secrets";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;
                @Key
                private String filter;
                @Key
                private Integer pageSize;
                @Key
                private String pageToken;

                protected List(String parent) {
                    super(SecretManager.this, "GET", REST_PATH, null, ListSecretsResponse.class);
                    this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                    if (!SecretManager.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String $Xgafv) {
                    return (List)super.set$Xgafv($Xgafv);
                }

                public List setAccessToken(String accessToken) {
                    return (List)super.setAccessToken(accessToken);
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setCallback(String callback) {
                    return (List)super.setCallback(callback);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUploadType(String uploadType) {
                    return (List)super.setUploadType(uploadType);
                }

                public List setUploadProtocol(String uploadProtocol) {
                    return (List)super.setUploadProtocol(uploadProtocol);
                }

                public String getParent() {
                    return this.parent;
                }

                public List setParent(String parent) {
                    if (!SecretManager.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+$");
                    }
                    this.parent = parent;
                    return this;
                }

                public String getFilter() {
                    return this.filter;
                }

                public List setFilter(String filter) {
                    this.filter = filter;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer pageSize) {
                    this.pageSize = pageSize;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String pageToken) {
                    this.pageToken = pageToken;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }

            public class GetIamPolicy
            extends SecretManagerRequest<Policy> {
                private static final String REST_PATH = "v1/{+resource}:getIamPolicy";
                private final Pattern RESOURCE_PATTERN;
                @Key
                private String resource;
                @Key(value="options.requestedPolicyVersion")
                private Integer optionsRequestedPolicyVersion;

                protected GetIamPolicy(String resource) {
                    super(SecretManager.this, "GET", REST_PATH, null, Policy.class);
                    this.RESOURCE_PATTERN = Pattern.compile("^projects/[^/]+/secrets/[^/]+$");
                    this.resource = (String)Preconditions.checkNotNull((Object)resource, (Object)"Required parameter resource must be specified.");
                    if (!SecretManager.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/secrets/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public GetIamPolicy set$Xgafv(String $Xgafv) {
                    return (GetIamPolicy)super.set$Xgafv($Xgafv);
                }

                public GetIamPolicy setAccessToken(String accessToken) {
                    return (GetIamPolicy)super.setAccessToken(accessToken);
                }

                public GetIamPolicy setAlt(String alt) {
                    return (GetIamPolicy)super.setAlt(alt);
                }

                public GetIamPolicy setCallback(String callback) {
                    return (GetIamPolicy)super.setCallback(callback);
                }

                public GetIamPolicy setFields(String fields) {
                    return (GetIamPolicy)super.setFields(fields);
                }

                public GetIamPolicy setKey(String key) {
                    return (GetIamPolicy)super.setKey(key);
                }

                public GetIamPolicy setOauthToken(String oauthToken) {
                    return (GetIamPolicy)super.setOauthToken(oauthToken);
                }

                public GetIamPolicy setPrettyPrint(Boolean prettyPrint) {
                    return (GetIamPolicy)super.setPrettyPrint(prettyPrint);
                }

                public GetIamPolicy setQuotaUser(String quotaUser) {
                    return (GetIamPolicy)super.setQuotaUser(quotaUser);
                }

                public GetIamPolicy setUploadType(String uploadType) {
                    return (GetIamPolicy)super.setUploadType(uploadType);
                }

                public GetIamPolicy setUploadProtocol(String uploadProtocol) {
                    return (GetIamPolicy)super.setUploadProtocol(uploadProtocol);
                }

                public String getResource() {
                    return this.resource;
                }

                public GetIamPolicy setResource(String resource) {
                    if (!SecretManager.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/secrets/[^/]+$");
                    }
                    this.resource = resource;
                    return this;
                }

                public Integer getOptionsRequestedPolicyVersion() {
                    return this.optionsRequestedPolicyVersion;
                }

                public GetIamPolicy setOptionsRequestedPolicyVersion(Integer optionsRequestedPolicyVersion) {
                    this.optionsRequestedPolicyVersion = optionsRequestedPolicyVersion;
                    return this;
                }

                @Override
                public GetIamPolicy set(String parameterName, Object value) {
                    return (GetIamPolicy)super.set(parameterName, value);
                }
            }

            public class Get
            extends SecretManagerRequest<Secret> {
                private static final String REST_PATH = "v1/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected Get(String name) {
                    super(SecretManager.this, "GET", REST_PATH, null, Secret.class);
                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/secrets/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!SecretManager.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/secrets/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String $Xgafv) {
                    return (Get)super.set$Xgafv($Xgafv);
                }

                public Get setAccessToken(String accessToken) {
                    return (Get)super.setAccessToken(accessToken);
                }

                public Get setAlt(String alt) {
                    return (Get)super.setAlt(alt);
                }

                public Get setCallback(String callback) {
                    return (Get)super.setCallback(callback);
                }

                public Get setFields(String fields) {
                    return (Get)super.setFields(fields);
                }

                public Get setKey(String key) {
                    return (Get)super.setKey(key);
                }

                public Get setOauthToken(String oauthToken) {
                    return (Get)super.setOauthToken(oauthToken);
                }

                public Get setPrettyPrint(Boolean prettyPrint) {
                    return (Get)super.setPrettyPrint(prettyPrint);
                }

                public Get setQuotaUser(String quotaUser) {
                    return (Get)super.setQuotaUser(quotaUser);
                }

                public Get setUploadType(String uploadType) {
                    return (Get)super.setUploadType(uploadType);
                }

                public Get setUploadProtocol(String uploadProtocol) {
                    return (Get)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public Get setName(String name) {
                    if (!SecretManager.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/secrets/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                @Override
                public Get set(String parameterName, Object value) {
                    return (Get)super.set(parameterName, value);
                }
            }

            public class Delete
            extends SecretManagerRequest<Empty> {
                private static final String REST_PATH = "v1/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;
                @Key
                private String etag;

                protected Delete(String name) {
                    super(SecretManager.this, "DELETE", REST_PATH, null, Empty.class);
                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/secrets/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!SecretManager.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/secrets/[^/]+$");
                    }
                }

                public Delete set$Xgafv(String $Xgafv) {
                    return (Delete)super.set$Xgafv($Xgafv);
                }

                public Delete setAccessToken(String accessToken) {
                    return (Delete)super.setAccessToken(accessToken);
                }

                public Delete setAlt(String alt) {
                    return (Delete)super.setAlt(alt);
                }

                public Delete setCallback(String callback) {
                    return (Delete)super.setCallback(callback);
                }

                public Delete setFields(String fields) {
                    return (Delete)super.setFields(fields);
                }

                public Delete setKey(String key) {
                    return (Delete)super.setKey(key);
                }

                public Delete setOauthToken(String oauthToken) {
                    return (Delete)super.setOauthToken(oauthToken);
                }

                public Delete setPrettyPrint(Boolean prettyPrint) {
                    return (Delete)super.setPrettyPrint(prettyPrint);
                }

                public Delete setQuotaUser(String quotaUser) {
                    return (Delete)super.setQuotaUser(quotaUser);
                }

                public Delete setUploadType(String uploadType) {
                    return (Delete)super.setUploadType(uploadType);
                }

                public Delete setUploadProtocol(String uploadProtocol) {
                    return (Delete)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public Delete setName(String name) {
                    if (!SecretManager.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/secrets/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                public String getEtag() {
                    return this.etag;
                }

                public Delete setEtag(String etag) {
                    this.etag = etag;
                    return this;
                }

                @Override
                public Delete set(String parameterName, Object value) {
                    return (Delete)super.set(parameterName, value);
                }
            }

            public class Create
            extends SecretManagerRequest<Secret> {
                private static final String REST_PATH = "v1/{+parent}/secrets";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;
                @Key
                private String secretId;

                protected Create(String parent, Secret content) {
                    super(SecretManager.this, "POST", REST_PATH, (Object)content, Secret.class);
                    this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                    if (!SecretManager.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+$");
                    }
                }

                public Create set$Xgafv(String $Xgafv) {
                    return (Create)super.set$Xgafv($Xgafv);
                }

                public Create setAccessToken(String accessToken) {
                    return (Create)super.setAccessToken(accessToken);
                }

                public Create setAlt(String alt) {
                    return (Create)super.setAlt(alt);
                }

                public Create setCallback(String callback) {
                    return (Create)super.setCallback(callback);
                }

                public Create setFields(String fields) {
                    return (Create)super.setFields(fields);
                }

                public Create setKey(String key) {
                    return (Create)super.setKey(key);
                }

                public Create setOauthToken(String oauthToken) {
                    return (Create)super.setOauthToken(oauthToken);
                }

                public Create setPrettyPrint(Boolean prettyPrint) {
                    return (Create)super.setPrettyPrint(prettyPrint);
                }

                public Create setQuotaUser(String quotaUser) {
                    return (Create)super.setQuotaUser(quotaUser);
                }

                public Create setUploadType(String uploadType) {
                    return (Create)super.setUploadType(uploadType);
                }

                public Create setUploadProtocol(String uploadProtocol) {
                    return (Create)super.setUploadProtocol(uploadProtocol);
                }

                public String getParent() {
                    return this.parent;
                }

                public Create setParent(String parent) {
                    if (!SecretManager.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+$");
                    }
                    this.parent = parent;
                    return this;
                }

                public String getSecretId() {
                    return this.secretId;
                }

                public Create setSecretId(String secretId) {
                    this.secretId = secretId;
                    return this;
                }

                @Override
                public Create set(String parameterName, Object value) {
                    return (Create)super.set(parameterName, value);
                }
            }

            public class AddVersion
            extends SecretManagerRequest<SecretVersion> {
                private static final String REST_PATH = "v1/{+parent}:addVersion";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;

                protected AddVersion(String parent, AddSecretVersionRequest content) {
                    super(SecretManager.this, "POST", REST_PATH, (Object)content, SecretVersion.class);
                    this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/secrets/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                    if (!SecretManager.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/secrets/[^/]+$");
                    }
                }

                public AddVersion set$Xgafv(String $Xgafv) {
                    return (AddVersion)super.set$Xgafv($Xgafv);
                }

                public AddVersion setAccessToken(String accessToken) {
                    return (AddVersion)super.setAccessToken(accessToken);
                }

                public AddVersion setAlt(String alt) {
                    return (AddVersion)super.setAlt(alt);
                }

                public AddVersion setCallback(String callback) {
                    return (AddVersion)super.setCallback(callback);
                }

                public AddVersion setFields(String fields) {
                    return (AddVersion)super.setFields(fields);
                }

                public AddVersion setKey(String key) {
                    return (AddVersion)super.setKey(key);
                }

                public AddVersion setOauthToken(String oauthToken) {
                    return (AddVersion)super.setOauthToken(oauthToken);
                }

                public AddVersion setPrettyPrint(Boolean prettyPrint) {
                    return (AddVersion)super.setPrettyPrint(prettyPrint);
                }

                public AddVersion setQuotaUser(String quotaUser) {
                    return (AddVersion)super.setQuotaUser(quotaUser);
                }

                public AddVersion setUploadType(String uploadType) {
                    return (AddVersion)super.setUploadType(uploadType);
                }

                public AddVersion setUploadProtocol(String uploadProtocol) {
                    return (AddVersion)super.setUploadProtocol(uploadProtocol);
                }

                public String getParent() {
                    return this.parent;
                }

                public AddVersion setParent(String parent) {
                    if (!SecretManager.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/secrets/[^/]+$");
                    }
                    this.parent = parent;
                    return this;
                }

                @Override
                public AddVersion set(String parameterName, Object value) {
                    return (AddVersion)super.set(parameterName, value);
                }
            }
        }

        public class Locations {
            public Get get(String name) throws IOException {
                Get result = new Get(name);
                SecretManager.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public List list(String name) throws IOException {
                List result = new List(name);
                SecretManager.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class List
            extends SecretManagerRequest<ListLocationsResponse> {
                private static final String REST_PATH = "v1/{+name}/locations";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;
                @Key
                private String filter;
                @Key
                private Integer pageSize;
                @Key
                private String pageToken;

                protected List(String name) {
                    super(SecretManager.this, "GET", REST_PATH, null, ListLocationsResponse.class);
                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!SecretManager.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String $Xgafv) {
                    return (List)super.set$Xgafv($Xgafv);
                }

                public List setAccessToken(String accessToken) {
                    return (List)super.setAccessToken(accessToken);
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setCallback(String callback) {
                    return (List)super.setCallback(callback);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUploadType(String uploadType) {
                    return (List)super.setUploadType(uploadType);
                }

                public List setUploadProtocol(String uploadProtocol) {
                    return (List)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public List setName(String name) {
                    if (!SecretManager.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                public String getFilter() {
                    return this.filter;
                }

                public List setFilter(String filter) {
                    this.filter = filter;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer pageSize) {
                    this.pageSize = pageSize;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String pageToken) {
                    this.pageToken = pageToken;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }

            public class Get
            extends SecretManagerRequest<Location> {
                private static final String REST_PATH = "v1/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected Get(String name) {
                    super(SecretManager.this, "GET", REST_PATH, null, Location.class);
                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!SecretManager.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String $Xgafv) {
                    return (Get)super.set$Xgafv($Xgafv);
                }

                public Get setAccessToken(String accessToken) {
                    return (Get)super.setAccessToken(accessToken);
                }

                public Get setAlt(String alt) {
                    return (Get)super.setAlt(alt);
                }

                public Get setCallback(String callback) {
                    return (Get)super.setCallback(callback);
                }

                public Get setFields(String fields) {
                    return (Get)super.setFields(fields);
                }

                public Get setKey(String key) {
                    return (Get)super.setKey(key);
                }

                public Get setOauthToken(String oauthToken) {
                    return (Get)super.setOauthToken(oauthToken);
                }

                public Get setPrettyPrint(Boolean prettyPrint) {
                    return (Get)super.setPrettyPrint(prettyPrint);
                }

                public Get setQuotaUser(String quotaUser) {
                    return (Get)super.setQuotaUser(quotaUser);
                }

                public Get setUploadType(String uploadType) {
                    return (Get)super.setUploadType(uploadType);
                }

                public Get setUploadProtocol(String uploadProtocol) {
                    return (Get)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public Get setName(String name) {
                    if (!SecretManager.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                @Override
                public Get set(String parameterName, Object value) {
                    return (Get)super.set(parameterName, value);
                }
            }
        }
    }
}

