/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.servicemanagement;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.servicemanagement.ServiceManagementRequest;
import com.google.api.services.servicemanagement.ServiceManagementRequestInitializer;
import com.google.api.services.servicemanagement.model.GenerateConfigReportRequest;
import com.google.api.services.servicemanagement.model.GenerateConfigReportResponse;
import com.google.api.services.servicemanagement.model.GetIamPolicyRequest;
import com.google.api.services.servicemanagement.model.ListOperationsResponse;
import com.google.api.services.servicemanagement.model.ListServiceConfigsResponse;
import com.google.api.services.servicemanagement.model.ListServiceRolloutsResponse;
import com.google.api.services.servicemanagement.model.ListServicesResponse;
import com.google.api.services.servicemanagement.model.ManagedService;
import com.google.api.services.servicemanagement.model.Operation;
import com.google.api.services.servicemanagement.model.Policy;
import com.google.api.services.servicemanagement.model.Rollout;
import com.google.api.services.servicemanagement.model.Service;
import com.google.api.services.servicemanagement.model.SetIamPolicyRequest;
import com.google.api.services.servicemanagement.model.SubmitConfigSourceRequest;
import com.google.api.services.servicemanagement.model.TestIamPermissionsRequest;
import com.google.api.services.servicemanagement.model.TestIamPermissionsResponse;
import java.io.IOException;
import java.util.regex.Pattern;

public class ServiceManagement
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://servicemanagement.googleapis.com/";
    public static final String DEFAULT_MTLS_ROOT_URL = "https://servicemanagement.mtls.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "";
    public static final String DEFAULT_BATCH_PATH = "batch";
    public static final String DEFAULT_BASE_URL = "https://servicemanagement.googleapis.com/";

    public ServiceManagement(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(transport, jsonFactory, httpRequestInitializer));
    }

    ServiceManagement(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> httpClientRequest) throws IOException {
        super.initialize(httpClientRequest);
    }

    public Operations operations() {
        return new Operations();
    }

    public Services services() {
        return new Services();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && (GoogleUtils.MINOR_VERSION >= 32 || GoogleUtils.MINOR_VERSION == 31 && GoogleUtils.BUGFIX_VERSION >= 1) || GoogleUtils.MAJOR_VERSION >= 2 ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.31.1 of google-api-client to run version 2.0.0 of the Service Management API library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        private static String chooseEndpoint(HttpTransport transport) {
            String useMtlsEndpoint = System.getenv("GOOGLE_API_USE_MTLS_ENDPOINT");
            String string = useMtlsEndpoint = useMtlsEndpoint == null ? "auto" : useMtlsEndpoint;
            if ("always".equals(useMtlsEndpoint) || "auto".equals(useMtlsEndpoint) && transport != null && transport.isMtls()) {
                return ServiceManagement.DEFAULT_MTLS_ROOT_URL;
            }
            return "https://servicemanagement.googleapis.com/";
        }

        public Builder(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(transport, jsonFactory, Builder.chooseEndpoint(transport), ServiceManagement.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
            this.setBatchPath(ServiceManagement.DEFAULT_BATCH_PATH);
        }

        public ServiceManagement build() {
            return new ServiceManagement(this);
        }

        public Builder setRootUrl(String rootUrl) {
            return (Builder)super.setRootUrl(rootUrl);
        }

        public Builder setServicePath(String servicePath) {
            return (Builder)super.setServicePath(servicePath);
        }

        public Builder setBatchPath(String batchPath) {
            return (Builder)super.setBatchPath(batchPath);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String applicationName) {
            return (Builder)super.setApplicationName(applicationName);
        }

        public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
            return (Builder)super.setSuppressPatternChecks(suppressPatternChecks);
        }

        public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
            return (Builder)super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
        }

        public Builder setSuppressAllChecks(boolean suppressAllChecks) {
            return (Builder)super.setSuppressAllChecks(suppressAllChecks);
        }

        public Builder setServiceManagementRequestInitializer(ServiceManagementRequestInitializer servicemanagementRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)servicemanagementRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }

        public Builder setUniverseDomain(String universeDomain) {
            return (Builder)super.setUniverseDomain(universeDomain);
        }
    }

    public class Services {
        public Create create(ManagedService content) throws IOException {
            Create result = new Create(content);
            ServiceManagement.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Delete delete(String serviceName) throws IOException {
            Delete result = new Delete(serviceName);
            ServiceManagement.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public GenerateConfigReport generateConfigReport(GenerateConfigReportRequest content) throws IOException {
            GenerateConfigReport result = new GenerateConfigReport(content);
            ServiceManagement.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(String serviceName) throws IOException {
            Get result = new Get(serviceName);
            ServiceManagement.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public GetConfig getConfig(String serviceName) throws IOException {
            GetConfig result = new GetConfig(serviceName);
            ServiceManagement.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public GetIamPolicy getIamPolicy(String resource, GetIamPolicyRequest content) throws IOException {
            GetIamPolicy result = new GetIamPolicy(resource, content);
            ServiceManagement.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list() throws IOException {
            List result = new List();
            ServiceManagement.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public SetIamPolicy setIamPolicy(String resource, SetIamPolicyRequest content) throws IOException {
            SetIamPolicy result = new SetIamPolicy(resource, content);
            ServiceManagement.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public TestIamPermissions testIamPermissions(String resource, TestIamPermissionsRequest content) throws IOException {
            TestIamPermissions result = new TestIamPermissions(resource, content);
            ServiceManagement.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Undelete undelete(String serviceName) throws IOException {
            Undelete result = new Undelete(serviceName);
            ServiceManagement.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Configs configs() {
            return new Configs();
        }

        public Consumers consumers() {
            return new Consumers();
        }

        public Rollouts rollouts() {
            return new Rollouts();
        }

        public class Rollouts {
            public Create create(String serviceName, Rollout content) throws IOException {
                Create result = new Create(serviceName, content);
                ServiceManagement.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Get get(String serviceName, String rolloutId) throws IOException {
                Get result = new Get(serviceName, rolloutId);
                ServiceManagement.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public List list(String serviceName) throws IOException {
                List result = new List(serviceName);
                ServiceManagement.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class List
            extends ServiceManagementRequest<ListServiceRolloutsResponse> {
                private static final String REST_PATH = "v1/services/{serviceName}/rollouts";
                @Key
                private String serviceName;
                @Key
                private String filter;
                @Key
                private Integer pageSize;
                @Key
                private String pageToken;

                protected List(String serviceName) {
                    super(ServiceManagement.this, "GET", REST_PATH, null, ListServiceRolloutsResponse.class);
                    this.serviceName = (String)Preconditions.checkNotNull((Object)serviceName, (Object)"Required parameter serviceName must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String $Xgafv) {
                    return (List)super.set$Xgafv($Xgafv);
                }

                public List setAccessToken(String accessToken) {
                    return (List)super.setAccessToken(accessToken);
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setCallback(String callback) {
                    return (List)super.setCallback(callback);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUploadType(String uploadType) {
                    return (List)super.setUploadType(uploadType);
                }

                public List setUploadProtocol(String uploadProtocol) {
                    return (List)super.setUploadProtocol(uploadProtocol);
                }

                public String getServiceName() {
                    return this.serviceName;
                }

                public List setServiceName(String serviceName) {
                    this.serviceName = serviceName;
                    return this;
                }

                public String getFilter() {
                    return this.filter;
                }

                public List setFilter(String filter) {
                    this.filter = filter;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer pageSize) {
                    this.pageSize = pageSize;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String pageToken) {
                    this.pageToken = pageToken;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }

            public class Get
            extends ServiceManagementRequest<Rollout> {
                private static final String REST_PATH = "v1/services/{serviceName}/rollouts/{rolloutId}";
                @Key
                private String serviceName;
                @Key
                private String rolloutId;

                protected Get(String serviceName, String rolloutId) {
                    super(ServiceManagement.this, "GET", REST_PATH, null, Rollout.class);
                    this.serviceName = (String)Preconditions.checkNotNull((Object)serviceName, (Object)"Required parameter serviceName must be specified.");
                    this.rolloutId = (String)Preconditions.checkNotNull((Object)rolloutId, (Object)"Required parameter rolloutId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String $Xgafv) {
                    return (Get)super.set$Xgafv($Xgafv);
                }

                public Get setAccessToken(String accessToken) {
                    return (Get)super.setAccessToken(accessToken);
                }

                public Get setAlt(String alt) {
                    return (Get)super.setAlt(alt);
                }

                public Get setCallback(String callback) {
                    return (Get)super.setCallback(callback);
                }

                public Get setFields(String fields) {
                    return (Get)super.setFields(fields);
                }

                public Get setKey(String key) {
                    return (Get)super.setKey(key);
                }

                public Get setOauthToken(String oauthToken) {
                    return (Get)super.setOauthToken(oauthToken);
                }

                public Get setPrettyPrint(Boolean prettyPrint) {
                    return (Get)super.setPrettyPrint(prettyPrint);
                }

                public Get setQuotaUser(String quotaUser) {
                    return (Get)super.setQuotaUser(quotaUser);
                }

                public Get setUploadType(String uploadType) {
                    return (Get)super.setUploadType(uploadType);
                }

                public Get setUploadProtocol(String uploadProtocol) {
                    return (Get)super.setUploadProtocol(uploadProtocol);
                }

                public String getServiceName() {
                    return this.serviceName;
                }

                public Get setServiceName(String serviceName) {
                    this.serviceName = serviceName;
                    return this;
                }

                public String getRolloutId() {
                    return this.rolloutId;
                }

                public Get setRolloutId(String rolloutId) {
                    this.rolloutId = rolloutId;
                    return this;
                }

                @Override
                public Get set(String parameterName, Object value) {
                    return (Get)super.set(parameterName, value);
                }
            }

            public class Create
            extends ServiceManagementRequest<Operation> {
                private static final String REST_PATH = "v1/services/{serviceName}/rollouts";
                @Key
                private String serviceName;

                protected Create(String serviceName, Rollout content) {
                    super(ServiceManagement.this, "POST", REST_PATH, (Object)content, Operation.class);
                    this.serviceName = (String)Preconditions.checkNotNull((Object)serviceName, (Object)"Required parameter serviceName must be specified.");
                }

                public Create set$Xgafv(String $Xgafv) {
                    return (Create)super.set$Xgafv($Xgafv);
                }

                public Create setAccessToken(String accessToken) {
                    return (Create)super.setAccessToken(accessToken);
                }

                public Create setAlt(String alt) {
                    return (Create)super.setAlt(alt);
                }

                public Create setCallback(String callback) {
                    return (Create)super.setCallback(callback);
                }

                public Create setFields(String fields) {
                    return (Create)super.setFields(fields);
                }

                public Create setKey(String key) {
                    return (Create)super.setKey(key);
                }

                public Create setOauthToken(String oauthToken) {
                    return (Create)super.setOauthToken(oauthToken);
                }

                public Create setPrettyPrint(Boolean prettyPrint) {
                    return (Create)super.setPrettyPrint(prettyPrint);
                }

                public Create setQuotaUser(String quotaUser) {
                    return (Create)super.setQuotaUser(quotaUser);
                }

                public Create setUploadType(String uploadType) {
                    return (Create)super.setUploadType(uploadType);
                }

                public Create setUploadProtocol(String uploadProtocol) {
                    return (Create)super.setUploadProtocol(uploadProtocol);
                }

                public String getServiceName() {
                    return this.serviceName;
                }

                public Create setServiceName(String serviceName) {
                    this.serviceName = serviceName;
                    return this;
                }

                @Override
                public Create set(String parameterName, Object value) {
                    return (Create)super.set(parameterName, value);
                }
            }
        }

        public class Consumers {
            public GetIamPolicy getIamPolicy(String resource, GetIamPolicyRequest content) throws IOException {
                GetIamPolicy result = new GetIamPolicy(resource, content);
                ServiceManagement.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public SetIamPolicy setIamPolicy(String resource, SetIamPolicyRequest content) throws IOException {
                SetIamPolicy result = new SetIamPolicy(resource, content);
                ServiceManagement.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public TestIamPermissions testIamPermissions(String resource, TestIamPermissionsRequest content) throws IOException {
                TestIamPermissions result = new TestIamPermissions(resource, content);
                ServiceManagement.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class TestIamPermissions
            extends ServiceManagementRequest<TestIamPermissionsResponse> {
                private static final String REST_PATH = "v1/{+resource}:testIamPermissions";
                private final Pattern RESOURCE_PATTERN;
                @Key
                private String resource;

                protected TestIamPermissions(String resource, TestIamPermissionsRequest content) {
                    super(ServiceManagement.this, "POST", REST_PATH, (Object)content, TestIamPermissionsResponse.class);
                    this.RESOURCE_PATTERN = Pattern.compile("^services/[^/]+/consumers/[^/]+$");
                    this.resource = (String)Preconditions.checkNotNull((Object)resource, (Object)"Required parameter resource must be specified.");
                    if (!ServiceManagement.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^services/[^/]+/consumers/[^/]+$");
                    }
                }

                public TestIamPermissions set$Xgafv(String $Xgafv) {
                    return (TestIamPermissions)super.set$Xgafv($Xgafv);
                }

                public TestIamPermissions setAccessToken(String accessToken) {
                    return (TestIamPermissions)super.setAccessToken(accessToken);
                }

                public TestIamPermissions setAlt(String alt) {
                    return (TestIamPermissions)super.setAlt(alt);
                }

                public TestIamPermissions setCallback(String callback) {
                    return (TestIamPermissions)super.setCallback(callback);
                }

                public TestIamPermissions setFields(String fields) {
                    return (TestIamPermissions)super.setFields(fields);
                }

                public TestIamPermissions setKey(String key) {
                    return (TestIamPermissions)super.setKey(key);
                }

                public TestIamPermissions setOauthToken(String oauthToken) {
                    return (TestIamPermissions)super.setOauthToken(oauthToken);
                }

                public TestIamPermissions setPrettyPrint(Boolean prettyPrint) {
                    return (TestIamPermissions)super.setPrettyPrint(prettyPrint);
                }

                public TestIamPermissions setQuotaUser(String quotaUser) {
                    return (TestIamPermissions)super.setQuotaUser(quotaUser);
                }

                public TestIamPermissions setUploadType(String uploadType) {
                    return (TestIamPermissions)super.setUploadType(uploadType);
                }

                public TestIamPermissions setUploadProtocol(String uploadProtocol) {
                    return (TestIamPermissions)super.setUploadProtocol(uploadProtocol);
                }

                public String getResource() {
                    return this.resource;
                }

                public TestIamPermissions setResource(String resource) {
                    if (!ServiceManagement.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^services/[^/]+/consumers/[^/]+$");
                    }
                    this.resource = resource;
                    return this;
                }

                @Override
                public TestIamPermissions set(String parameterName, Object value) {
                    return (TestIamPermissions)super.set(parameterName, value);
                }
            }

            public class SetIamPolicy
            extends ServiceManagementRequest<Policy> {
                private static final String REST_PATH = "v1/{+resource}:setIamPolicy";
                private final Pattern RESOURCE_PATTERN;
                @Key
                private String resource;

                protected SetIamPolicy(String resource, SetIamPolicyRequest content) {
                    super(ServiceManagement.this, "POST", REST_PATH, (Object)content, Policy.class);
                    this.RESOURCE_PATTERN = Pattern.compile("^services/[^/]+/consumers/[^/]+$");
                    this.resource = (String)Preconditions.checkNotNull((Object)resource, (Object)"Required parameter resource must be specified.");
                    if (!ServiceManagement.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^services/[^/]+/consumers/[^/]+$");
                    }
                }

                public SetIamPolicy set$Xgafv(String $Xgafv) {
                    return (SetIamPolicy)super.set$Xgafv($Xgafv);
                }

                public SetIamPolicy setAccessToken(String accessToken) {
                    return (SetIamPolicy)super.setAccessToken(accessToken);
                }

                public SetIamPolicy setAlt(String alt) {
                    return (SetIamPolicy)super.setAlt(alt);
                }

                public SetIamPolicy setCallback(String callback) {
                    return (SetIamPolicy)super.setCallback(callback);
                }

                public SetIamPolicy setFields(String fields) {
                    return (SetIamPolicy)super.setFields(fields);
                }

                public SetIamPolicy setKey(String key) {
                    return (SetIamPolicy)super.setKey(key);
                }

                public SetIamPolicy setOauthToken(String oauthToken) {
                    return (SetIamPolicy)super.setOauthToken(oauthToken);
                }

                public SetIamPolicy setPrettyPrint(Boolean prettyPrint) {
                    return (SetIamPolicy)super.setPrettyPrint(prettyPrint);
                }

                public SetIamPolicy setQuotaUser(String quotaUser) {
                    return (SetIamPolicy)super.setQuotaUser(quotaUser);
                }

                public SetIamPolicy setUploadType(String uploadType) {
                    return (SetIamPolicy)super.setUploadType(uploadType);
                }

                public SetIamPolicy setUploadProtocol(String uploadProtocol) {
                    return (SetIamPolicy)super.setUploadProtocol(uploadProtocol);
                }

                public String getResource() {
                    return this.resource;
                }

                public SetIamPolicy setResource(String resource) {
                    if (!ServiceManagement.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^services/[^/]+/consumers/[^/]+$");
                    }
                    this.resource = resource;
                    return this;
                }

                @Override
                public SetIamPolicy set(String parameterName, Object value) {
                    return (SetIamPolicy)super.set(parameterName, value);
                }
            }

            public class GetIamPolicy
            extends ServiceManagementRequest<Policy> {
                private static final String REST_PATH = "v1/{+resource}:getIamPolicy";
                private final Pattern RESOURCE_PATTERN;
                @Key
                private String resource;

                protected GetIamPolicy(String resource, GetIamPolicyRequest content) {
                    super(ServiceManagement.this, "POST", REST_PATH, (Object)content, Policy.class);
                    this.RESOURCE_PATTERN = Pattern.compile("^services/[^/]+/consumers/[^/]+$");
                    this.resource = (String)Preconditions.checkNotNull((Object)resource, (Object)"Required parameter resource must be specified.");
                    if (!ServiceManagement.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^services/[^/]+/consumers/[^/]+$");
                    }
                }

                public GetIamPolicy set$Xgafv(String $Xgafv) {
                    return (GetIamPolicy)super.set$Xgafv($Xgafv);
                }

                public GetIamPolicy setAccessToken(String accessToken) {
                    return (GetIamPolicy)super.setAccessToken(accessToken);
                }

                public GetIamPolicy setAlt(String alt) {
                    return (GetIamPolicy)super.setAlt(alt);
                }

                public GetIamPolicy setCallback(String callback) {
                    return (GetIamPolicy)super.setCallback(callback);
                }

                public GetIamPolicy setFields(String fields) {
                    return (GetIamPolicy)super.setFields(fields);
                }

                public GetIamPolicy setKey(String key) {
                    return (GetIamPolicy)super.setKey(key);
                }

                public GetIamPolicy setOauthToken(String oauthToken) {
                    return (GetIamPolicy)super.setOauthToken(oauthToken);
                }

                public GetIamPolicy setPrettyPrint(Boolean prettyPrint) {
                    return (GetIamPolicy)super.setPrettyPrint(prettyPrint);
                }

                public GetIamPolicy setQuotaUser(String quotaUser) {
                    return (GetIamPolicy)super.setQuotaUser(quotaUser);
                }

                public GetIamPolicy setUploadType(String uploadType) {
                    return (GetIamPolicy)super.setUploadType(uploadType);
                }

                public GetIamPolicy setUploadProtocol(String uploadProtocol) {
                    return (GetIamPolicy)super.setUploadProtocol(uploadProtocol);
                }

                public String getResource() {
                    return this.resource;
                }

                public GetIamPolicy setResource(String resource) {
                    if (!ServiceManagement.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^services/[^/]+/consumers/[^/]+$");
                    }
                    this.resource = resource;
                    return this;
                }

                @Override
                public GetIamPolicy set(String parameterName, Object value) {
                    return (GetIamPolicy)super.set(parameterName, value);
                }
            }
        }

        public class Configs {
            public Create create(String serviceName, Service content) throws IOException {
                Create result = new Create(serviceName, content);
                ServiceManagement.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Get get(String serviceName, String configId) throws IOException {
                Get result = new Get(serviceName, configId);
                ServiceManagement.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public List list(String serviceName) throws IOException {
                List result = new List(serviceName);
                ServiceManagement.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Submit submit(String serviceName, SubmitConfigSourceRequest content) throws IOException {
                Submit result = new Submit(serviceName, content);
                ServiceManagement.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class Submit
            extends ServiceManagementRequest<Operation> {
                private static final String REST_PATH = "v1/services/{serviceName}/configs:submit";
                @Key
                private String serviceName;

                protected Submit(String serviceName, SubmitConfigSourceRequest content) {
                    super(ServiceManagement.this, "POST", REST_PATH, (Object)content, Operation.class);
                    this.serviceName = (String)Preconditions.checkNotNull((Object)serviceName, (Object)"Required parameter serviceName must be specified.");
                }

                public Submit set$Xgafv(String $Xgafv) {
                    return (Submit)super.set$Xgafv($Xgafv);
                }

                public Submit setAccessToken(String accessToken) {
                    return (Submit)super.setAccessToken(accessToken);
                }

                public Submit setAlt(String alt) {
                    return (Submit)super.setAlt(alt);
                }

                public Submit setCallback(String callback) {
                    return (Submit)super.setCallback(callback);
                }

                public Submit setFields(String fields) {
                    return (Submit)super.setFields(fields);
                }

                public Submit setKey(String key) {
                    return (Submit)super.setKey(key);
                }

                public Submit setOauthToken(String oauthToken) {
                    return (Submit)super.setOauthToken(oauthToken);
                }

                public Submit setPrettyPrint(Boolean prettyPrint) {
                    return (Submit)super.setPrettyPrint(prettyPrint);
                }

                public Submit setQuotaUser(String quotaUser) {
                    return (Submit)super.setQuotaUser(quotaUser);
                }

                public Submit setUploadType(String uploadType) {
                    return (Submit)super.setUploadType(uploadType);
                }

                public Submit setUploadProtocol(String uploadProtocol) {
                    return (Submit)super.setUploadProtocol(uploadProtocol);
                }

                public String getServiceName() {
                    return this.serviceName;
                }

                public Submit setServiceName(String serviceName) {
                    this.serviceName = serviceName;
                    return this;
                }

                @Override
                public Submit set(String parameterName, Object value) {
                    return (Submit)super.set(parameterName, value);
                }
            }

            public class List
            extends ServiceManagementRequest<ListServiceConfigsResponse> {
                private static final String REST_PATH = "v1/services/{serviceName}/configs";
                @Key
                private String serviceName;
                @Key
                private Integer pageSize;
                @Key
                private String pageToken;

                protected List(String serviceName) {
                    super(ServiceManagement.this, "GET", REST_PATH, null, ListServiceConfigsResponse.class);
                    this.serviceName = (String)Preconditions.checkNotNull((Object)serviceName, (Object)"Required parameter serviceName must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String $Xgafv) {
                    return (List)super.set$Xgafv($Xgafv);
                }

                public List setAccessToken(String accessToken) {
                    return (List)super.setAccessToken(accessToken);
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setCallback(String callback) {
                    return (List)super.setCallback(callback);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUploadType(String uploadType) {
                    return (List)super.setUploadType(uploadType);
                }

                public List setUploadProtocol(String uploadProtocol) {
                    return (List)super.setUploadProtocol(uploadProtocol);
                }

                public String getServiceName() {
                    return this.serviceName;
                }

                public List setServiceName(String serviceName) {
                    this.serviceName = serviceName;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer pageSize) {
                    this.pageSize = pageSize;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String pageToken) {
                    this.pageToken = pageToken;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }

            public class Get
            extends ServiceManagementRequest<Service> {
                private static final String REST_PATH = "v1/services/{serviceName}/configs/{configId}";
                @Key
                private String serviceName;
                @Key
                private String configId;
                @Key
                private String view;

                protected Get(String serviceName, String configId) {
                    super(ServiceManagement.this, "GET", REST_PATH, null, Service.class);
                    this.serviceName = (String)Preconditions.checkNotNull((Object)serviceName, (Object)"Required parameter serviceName must be specified.");
                    this.configId = (String)Preconditions.checkNotNull((Object)configId, (Object)"Required parameter configId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String $Xgafv) {
                    return (Get)super.set$Xgafv($Xgafv);
                }

                public Get setAccessToken(String accessToken) {
                    return (Get)super.setAccessToken(accessToken);
                }

                public Get setAlt(String alt) {
                    return (Get)super.setAlt(alt);
                }

                public Get setCallback(String callback) {
                    return (Get)super.setCallback(callback);
                }

                public Get setFields(String fields) {
                    return (Get)super.setFields(fields);
                }

                public Get setKey(String key) {
                    return (Get)super.setKey(key);
                }

                public Get setOauthToken(String oauthToken) {
                    return (Get)super.setOauthToken(oauthToken);
                }

                public Get setPrettyPrint(Boolean prettyPrint) {
                    return (Get)super.setPrettyPrint(prettyPrint);
                }

                public Get setQuotaUser(String quotaUser) {
                    return (Get)super.setQuotaUser(quotaUser);
                }

                public Get setUploadType(String uploadType) {
                    return (Get)super.setUploadType(uploadType);
                }

                public Get setUploadProtocol(String uploadProtocol) {
                    return (Get)super.setUploadProtocol(uploadProtocol);
                }

                public String getServiceName() {
                    return this.serviceName;
                }

                public Get setServiceName(String serviceName) {
                    this.serviceName = serviceName;
                    return this;
                }

                public String getConfigId() {
                    return this.configId;
                }

                public Get setConfigId(String configId) {
                    this.configId = configId;
                    return this;
                }

                public String getView() {
                    return this.view;
                }

                public Get setView(String view) {
                    this.view = view;
                    return this;
                }

                @Override
                public Get set(String parameterName, Object value) {
                    return (Get)super.set(parameterName, value);
                }
            }

            public class Create
            extends ServiceManagementRequest<Service> {
                private static final String REST_PATH = "v1/services/{serviceName}/configs";
                @Key
                private String serviceName;

                protected Create(String serviceName, Service content) {
                    super(ServiceManagement.this, "POST", REST_PATH, (Object)content, Service.class);
                    this.serviceName = (String)Preconditions.checkNotNull((Object)serviceName, (Object)"Required parameter serviceName must be specified.");
                }

                public Create set$Xgafv(String $Xgafv) {
                    return (Create)super.set$Xgafv($Xgafv);
                }

                public Create setAccessToken(String accessToken) {
                    return (Create)super.setAccessToken(accessToken);
                }

                public Create setAlt(String alt) {
                    return (Create)super.setAlt(alt);
                }

                public Create setCallback(String callback) {
                    return (Create)super.setCallback(callback);
                }

                public Create setFields(String fields) {
                    return (Create)super.setFields(fields);
                }

                public Create setKey(String key) {
                    return (Create)super.setKey(key);
                }

                public Create setOauthToken(String oauthToken) {
                    return (Create)super.setOauthToken(oauthToken);
                }

                public Create setPrettyPrint(Boolean prettyPrint) {
                    return (Create)super.setPrettyPrint(prettyPrint);
                }

                public Create setQuotaUser(String quotaUser) {
                    return (Create)super.setQuotaUser(quotaUser);
                }

                public Create setUploadType(String uploadType) {
                    return (Create)super.setUploadType(uploadType);
                }

                public Create setUploadProtocol(String uploadProtocol) {
                    return (Create)super.setUploadProtocol(uploadProtocol);
                }

                public String getServiceName() {
                    return this.serviceName;
                }

                public Create setServiceName(String serviceName) {
                    this.serviceName = serviceName;
                    return this;
                }

                @Override
                public Create set(String parameterName, Object value) {
                    return (Create)super.set(parameterName, value);
                }
            }
        }

        public class Undelete
        extends ServiceManagementRequest<Operation> {
            private static final String REST_PATH = "v1/services/{serviceName}:undelete";
            @Key
            private String serviceName;

            protected Undelete(String serviceName) {
                super(ServiceManagement.this, "POST", REST_PATH, null, Operation.class);
                this.serviceName = (String)Preconditions.checkNotNull((Object)serviceName, (Object)"Required parameter serviceName must be specified.");
            }

            public Undelete set$Xgafv(String $Xgafv) {
                return (Undelete)super.set$Xgafv($Xgafv);
            }

            public Undelete setAccessToken(String accessToken) {
                return (Undelete)super.setAccessToken(accessToken);
            }

            public Undelete setAlt(String alt) {
                return (Undelete)super.setAlt(alt);
            }

            public Undelete setCallback(String callback) {
                return (Undelete)super.setCallback(callback);
            }

            public Undelete setFields(String fields) {
                return (Undelete)super.setFields(fields);
            }

            public Undelete setKey(String key) {
                return (Undelete)super.setKey(key);
            }

            public Undelete setOauthToken(String oauthToken) {
                return (Undelete)super.setOauthToken(oauthToken);
            }

            public Undelete setPrettyPrint(Boolean prettyPrint) {
                return (Undelete)super.setPrettyPrint(prettyPrint);
            }

            public Undelete setQuotaUser(String quotaUser) {
                return (Undelete)super.setQuotaUser(quotaUser);
            }

            public Undelete setUploadType(String uploadType) {
                return (Undelete)super.setUploadType(uploadType);
            }

            public Undelete setUploadProtocol(String uploadProtocol) {
                return (Undelete)super.setUploadProtocol(uploadProtocol);
            }

            public String getServiceName() {
                return this.serviceName;
            }

            public Undelete setServiceName(String serviceName) {
                this.serviceName = serviceName;
                return this;
            }

            @Override
            public Undelete set(String parameterName, Object value) {
                return (Undelete)super.set(parameterName, value);
            }
        }

        public class TestIamPermissions
        extends ServiceManagementRequest<TestIamPermissionsResponse> {
            private static final String REST_PATH = "v1/{+resource}:testIamPermissions";
            private final Pattern RESOURCE_PATTERN;
            @Key
            private String resource;

            protected TestIamPermissions(String resource, TestIamPermissionsRequest content) {
                super(ServiceManagement.this, "POST", REST_PATH, (Object)content, TestIamPermissionsResponse.class);
                this.RESOURCE_PATTERN = Pattern.compile("^services/[^/]+$");
                this.resource = (String)Preconditions.checkNotNull((Object)resource, (Object)"Required parameter resource must be specified.");
                if (!ServiceManagement.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^services/[^/]+$");
                }
            }

            public TestIamPermissions set$Xgafv(String $Xgafv) {
                return (TestIamPermissions)super.set$Xgafv($Xgafv);
            }

            public TestIamPermissions setAccessToken(String accessToken) {
                return (TestIamPermissions)super.setAccessToken(accessToken);
            }

            public TestIamPermissions setAlt(String alt) {
                return (TestIamPermissions)super.setAlt(alt);
            }

            public TestIamPermissions setCallback(String callback) {
                return (TestIamPermissions)super.setCallback(callback);
            }

            public TestIamPermissions setFields(String fields) {
                return (TestIamPermissions)super.setFields(fields);
            }

            public TestIamPermissions setKey(String key) {
                return (TestIamPermissions)super.setKey(key);
            }

            public TestIamPermissions setOauthToken(String oauthToken) {
                return (TestIamPermissions)super.setOauthToken(oauthToken);
            }

            public TestIamPermissions setPrettyPrint(Boolean prettyPrint) {
                return (TestIamPermissions)super.setPrettyPrint(prettyPrint);
            }

            public TestIamPermissions setQuotaUser(String quotaUser) {
                return (TestIamPermissions)super.setQuotaUser(quotaUser);
            }

            public TestIamPermissions setUploadType(String uploadType) {
                return (TestIamPermissions)super.setUploadType(uploadType);
            }

            public TestIamPermissions setUploadProtocol(String uploadProtocol) {
                return (TestIamPermissions)super.setUploadProtocol(uploadProtocol);
            }

            public String getResource() {
                return this.resource;
            }

            public TestIamPermissions setResource(String resource) {
                if (!ServiceManagement.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^services/[^/]+$");
                }
                this.resource = resource;
                return this;
            }

            @Override
            public TestIamPermissions set(String parameterName, Object value) {
                return (TestIamPermissions)super.set(parameterName, value);
            }
        }

        public class SetIamPolicy
        extends ServiceManagementRequest<Policy> {
            private static final String REST_PATH = "v1/{+resource}:setIamPolicy";
            private final Pattern RESOURCE_PATTERN;
            @Key
            private String resource;

            protected SetIamPolicy(String resource, SetIamPolicyRequest content) {
                super(ServiceManagement.this, "POST", REST_PATH, (Object)content, Policy.class);
                this.RESOURCE_PATTERN = Pattern.compile("^services/[^/]+$");
                this.resource = (String)Preconditions.checkNotNull((Object)resource, (Object)"Required parameter resource must be specified.");
                if (!ServiceManagement.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^services/[^/]+$");
                }
            }

            public SetIamPolicy set$Xgafv(String $Xgafv) {
                return (SetIamPolicy)super.set$Xgafv($Xgafv);
            }

            public SetIamPolicy setAccessToken(String accessToken) {
                return (SetIamPolicy)super.setAccessToken(accessToken);
            }

            public SetIamPolicy setAlt(String alt) {
                return (SetIamPolicy)super.setAlt(alt);
            }

            public SetIamPolicy setCallback(String callback) {
                return (SetIamPolicy)super.setCallback(callback);
            }

            public SetIamPolicy setFields(String fields) {
                return (SetIamPolicy)super.setFields(fields);
            }

            public SetIamPolicy setKey(String key) {
                return (SetIamPolicy)super.setKey(key);
            }

            public SetIamPolicy setOauthToken(String oauthToken) {
                return (SetIamPolicy)super.setOauthToken(oauthToken);
            }

            public SetIamPolicy setPrettyPrint(Boolean prettyPrint) {
                return (SetIamPolicy)super.setPrettyPrint(prettyPrint);
            }

            public SetIamPolicy setQuotaUser(String quotaUser) {
                return (SetIamPolicy)super.setQuotaUser(quotaUser);
            }

            public SetIamPolicy setUploadType(String uploadType) {
                return (SetIamPolicy)super.setUploadType(uploadType);
            }

            public SetIamPolicy setUploadProtocol(String uploadProtocol) {
                return (SetIamPolicy)super.setUploadProtocol(uploadProtocol);
            }

            public String getResource() {
                return this.resource;
            }

            public SetIamPolicy setResource(String resource) {
                if (!ServiceManagement.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^services/[^/]+$");
                }
                this.resource = resource;
                return this;
            }

            @Override
            public SetIamPolicy set(String parameterName, Object value) {
                return (SetIamPolicy)super.set(parameterName, value);
            }
        }

        public class List
        extends ServiceManagementRequest<ListServicesResponse> {
            private static final String REST_PATH = "v1/services";
            @Key
            private String consumerId;
            @Key
            private Integer pageSize;
            @Key
            private String pageToken;
            @Key
            private String producerProjectId;

            protected List() {
                super(ServiceManagement.this, "GET", REST_PATH, null, ListServicesResponse.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public String getConsumerId() {
                return this.consumerId;
            }

            public List setConsumerId(String consumerId) {
                this.consumerId = consumerId;
                return this;
            }

            public Integer getPageSize() {
                return this.pageSize;
            }

            public List setPageSize(Integer pageSize) {
                this.pageSize = pageSize;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            public String getProducerProjectId() {
                return this.producerProjectId;
            }

            public List setProducerProjectId(String producerProjectId) {
                this.producerProjectId = producerProjectId;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class GetIamPolicy
        extends ServiceManagementRequest<Policy> {
            private static final String REST_PATH = "v1/{+resource}:getIamPolicy";
            private final Pattern RESOURCE_PATTERN;
            @Key
            private String resource;

            protected GetIamPolicy(String resource, GetIamPolicyRequest content) {
                super(ServiceManagement.this, "POST", REST_PATH, (Object)content, Policy.class);
                this.RESOURCE_PATTERN = Pattern.compile("^services/[^/]+$");
                this.resource = (String)Preconditions.checkNotNull((Object)resource, (Object)"Required parameter resource must be specified.");
                if (!ServiceManagement.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^services/[^/]+$");
                }
            }

            public GetIamPolicy set$Xgafv(String $Xgafv) {
                return (GetIamPolicy)super.set$Xgafv($Xgafv);
            }

            public GetIamPolicy setAccessToken(String accessToken) {
                return (GetIamPolicy)super.setAccessToken(accessToken);
            }

            public GetIamPolicy setAlt(String alt) {
                return (GetIamPolicy)super.setAlt(alt);
            }

            public GetIamPolicy setCallback(String callback) {
                return (GetIamPolicy)super.setCallback(callback);
            }

            public GetIamPolicy setFields(String fields) {
                return (GetIamPolicy)super.setFields(fields);
            }

            public GetIamPolicy setKey(String key) {
                return (GetIamPolicy)super.setKey(key);
            }

            public GetIamPolicy setOauthToken(String oauthToken) {
                return (GetIamPolicy)super.setOauthToken(oauthToken);
            }

            public GetIamPolicy setPrettyPrint(Boolean prettyPrint) {
                return (GetIamPolicy)super.setPrettyPrint(prettyPrint);
            }

            public GetIamPolicy setQuotaUser(String quotaUser) {
                return (GetIamPolicy)super.setQuotaUser(quotaUser);
            }

            public GetIamPolicy setUploadType(String uploadType) {
                return (GetIamPolicy)super.setUploadType(uploadType);
            }

            public GetIamPolicy setUploadProtocol(String uploadProtocol) {
                return (GetIamPolicy)super.setUploadProtocol(uploadProtocol);
            }

            public String getResource() {
                return this.resource;
            }

            public GetIamPolicy setResource(String resource) {
                if (!ServiceManagement.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^services/[^/]+$");
                }
                this.resource = resource;
                return this;
            }

            @Override
            public GetIamPolicy set(String parameterName, Object value) {
                return (GetIamPolicy)super.set(parameterName, value);
            }
        }

        public class GetConfig
        extends ServiceManagementRequest<Service> {
            private static final String REST_PATH = "v1/services/{serviceName}/config";
            @Key
            private String serviceName;
            @Key
            private String configId;
            @Key
            private String view;

            protected GetConfig(String serviceName) {
                super(ServiceManagement.this, "GET", REST_PATH, null, Service.class);
                this.serviceName = (String)Preconditions.checkNotNull((Object)serviceName, (Object)"Required parameter serviceName must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public GetConfig set$Xgafv(String $Xgafv) {
                return (GetConfig)super.set$Xgafv($Xgafv);
            }

            public GetConfig setAccessToken(String accessToken) {
                return (GetConfig)super.setAccessToken(accessToken);
            }

            public GetConfig setAlt(String alt) {
                return (GetConfig)super.setAlt(alt);
            }

            public GetConfig setCallback(String callback) {
                return (GetConfig)super.setCallback(callback);
            }

            public GetConfig setFields(String fields) {
                return (GetConfig)super.setFields(fields);
            }

            public GetConfig setKey(String key) {
                return (GetConfig)super.setKey(key);
            }

            public GetConfig setOauthToken(String oauthToken) {
                return (GetConfig)super.setOauthToken(oauthToken);
            }

            public GetConfig setPrettyPrint(Boolean prettyPrint) {
                return (GetConfig)super.setPrettyPrint(prettyPrint);
            }

            public GetConfig setQuotaUser(String quotaUser) {
                return (GetConfig)super.setQuotaUser(quotaUser);
            }

            public GetConfig setUploadType(String uploadType) {
                return (GetConfig)super.setUploadType(uploadType);
            }

            public GetConfig setUploadProtocol(String uploadProtocol) {
                return (GetConfig)super.setUploadProtocol(uploadProtocol);
            }

            public String getServiceName() {
                return this.serviceName;
            }

            public GetConfig setServiceName(String serviceName) {
                this.serviceName = serviceName;
                return this;
            }

            public String getConfigId() {
                return this.configId;
            }

            public GetConfig setConfigId(String configId) {
                this.configId = configId;
                return this;
            }

            public String getView() {
                return this.view;
            }

            public GetConfig setView(String view) {
                this.view = view;
                return this;
            }

            @Override
            public GetConfig set(String parameterName, Object value) {
                return (GetConfig)super.set(parameterName, value);
            }
        }

        public class Get
        extends ServiceManagementRequest<ManagedService> {
            private static final String REST_PATH = "v1/services/{serviceName}";
            @Key
            private String serviceName;

            protected Get(String serviceName) {
                super(ServiceManagement.this, "GET", REST_PATH, null, ManagedService.class);
                this.serviceName = (String)Preconditions.checkNotNull((Object)serviceName, (Object)"Required parameter serviceName must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public String getServiceName() {
                return this.serviceName;
            }

            public Get setServiceName(String serviceName) {
                this.serviceName = serviceName;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class GenerateConfigReport
        extends ServiceManagementRequest<GenerateConfigReportResponse> {
            private static final String REST_PATH = "v1/services:generateConfigReport";

            protected GenerateConfigReport(GenerateConfigReportRequest content) {
                super(ServiceManagement.this, "POST", REST_PATH, (Object)content, GenerateConfigReportResponse.class);
            }

            public GenerateConfigReport set$Xgafv(String $Xgafv) {
                return (GenerateConfigReport)super.set$Xgafv($Xgafv);
            }

            public GenerateConfigReport setAccessToken(String accessToken) {
                return (GenerateConfigReport)super.setAccessToken(accessToken);
            }

            public GenerateConfigReport setAlt(String alt) {
                return (GenerateConfigReport)super.setAlt(alt);
            }

            public GenerateConfigReport setCallback(String callback) {
                return (GenerateConfigReport)super.setCallback(callback);
            }

            public GenerateConfigReport setFields(String fields) {
                return (GenerateConfigReport)super.setFields(fields);
            }

            public GenerateConfigReport setKey(String key) {
                return (GenerateConfigReport)super.setKey(key);
            }

            public GenerateConfigReport setOauthToken(String oauthToken) {
                return (GenerateConfigReport)super.setOauthToken(oauthToken);
            }

            public GenerateConfigReport setPrettyPrint(Boolean prettyPrint) {
                return (GenerateConfigReport)super.setPrettyPrint(prettyPrint);
            }

            public GenerateConfigReport setQuotaUser(String quotaUser) {
                return (GenerateConfigReport)super.setQuotaUser(quotaUser);
            }

            public GenerateConfigReport setUploadType(String uploadType) {
                return (GenerateConfigReport)super.setUploadType(uploadType);
            }

            public GenerateConfigReport setUploadProtocol(String uploadProtocol) {
                return (GenerateConfigReport)super.setUploadProtocol(uploadProtocol);
            }

            @Override
            public GenerateConfigReport set(String parameterName, Object value) {
                return (GenerateConfigReport)super.set(parameterName, value);
            }
        }

        public class Delete
        extends ServiceManagementRequest<Operation> {
            private static final String REST_PATH = "v1/services/{serviceName}";
            @Key
            private String serviceName;

            protected Delete(String serviceName) {
                super(ServiceManagement.this, "DELETE", REST_PATH, null, Operation.class);
                this.serviceName = (String)Preconditions.checkNotNull((Object)serviceName, (Object)"Required parameter serviceName must be specified.");
            }

            public Delete set$Xgafv(String $Xgafv) {
                return (Delete)super.set$Xgafv($Xgafv);
            }

            public Delete setAccessToken(String accessToken) {
                return (Delete)super.setAccessToken(accessToken);
            }

            public Delete setAlt(String alt) {
                return (Delete)super.setAlt(alt);
            }

            public Delete setCallback(String callback) {
                return (Delete)super.setCallback(callback);
            }

            public Delete setFields(String fields) {
                return (Delete)super.setFields(fields);
            }

            public Delete setKey(String key) {
                return (Delete)super.setKey(key);
            }

            public Delete setOauthToken(String oauthToken) {
                return (Delete)super.setOauthToken(oauthToken);
            }

            public Delete setPrettyPrint(Boolean prettyPrint) {
                return (Delete)super.setPrettyPrint(prettyPrint);
            }

            public Delete setQuotaUser(String quotaUser) {
                return (Delete)super.setQuotaUser(quotaUser);
            }

            public Delete setUploadType(String uploadType) {
                return (Delete)super.setUploadType(uploadType);
            }

            public Delete setUploadProtocol(String uploadProtocol) {
                return (Delete)super.setUploadProtocol(uploadProtocol);
            }

            public String getServiceName() {
                return this.serviceName;
            }

            public Delete setServiceName(String serviceName) {
                this.serviceName = serviceName;
                return this;
            }

            @Override
            public Delete set(String parameterName, Object value) {
                return (Delete)super.set(parameterName, value);
            }
        }

        public class Create
        extends ServiceManagementRequest<Operation> {
            private static final String REST_PATH = "v1/services";

            protected Create(ManagedService content) {
                super(ServiceManagement.this, "POST", REST_PATH, (Object)content, Operation.class);
            }

            public Create set$Xgafv(String $Xgafv) {
                return (Create)super.set$Xgafv($Xgafv);
            }

            public Create setAccessToken(String accessToken) {
                return (Create)super.setAccessToken(accessToken);
            }

            public Create setAlt(String alt) {
                return (Create)super.setAlt(alt);
            }

            public Create setCallback(String callback) {
                return (Create)super.setCallback(callback);
            }

            public Create setFields(String fields) {
                return (Create)super.setFields(fields);
            }

            public Create setKey(String key) {
                return (Create)super.setKey(key);
            }

            public Create setOauthToken(String oauthToken) {
                return (Create)super.setOauthToken(oauthToken);
            }

            public Create setPrettyPrint(Boolean prettyPrint) {
                return (Create)super.setPrettyPrint(prettyPrint);
            }

            public Create setQuotaUser(String quotaUser) {
                return (Create)super.setQuotaUser(quotaUser);
            }

            public Create setUploadType(String uploadType) {
                return (Create)super.setUploadType(uploadType);
            }

            public Create setUploadProtocol(String uploadProtocol) {
                return (Create)super.setUploadProtocol(uploadProtocol);
            }

            @Override
            public Create set(String parameterName, Object value) {
                return (Create)super.set(parameterName, value);
            }
        }
    }

    public class Operations {
        public Get get(String name) throws IOException {
            Get result = new Get(name);
            ServiceManagement.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list() throws IOException {
            List result = new List();
            ServiceManagement.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class List
        extends ServiceManagementRequest<ListOperationsResponse> {
            private static final String REST_PATH = "v1/operations";
            @Key
            private String filter;
            @Key
            private String name;
            @Key
            private Integer pageSize;
            @Key
            private String pageToken;

            protected List() {
                super(ServiceManagement.this, "GET", REST_PATH, null, ListOperationsResponse.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public String getFilter() {
                return this.filter;
            }

            public List setFilter(String filter) {
                this.filter = filter;
                return this;
            }

            public String getName() {
                return this.name;
            }

            public List setName(String name) {
                this.name = name;
                return this;
            }

            public Integer getPageSize() {
                return this.pageSize;
            }

            public List setPageSize(Integer pageSize) {
                this.pageSize = pageSize;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Get
        extends ServiceManagementRequest<Operation> {
            private static final String REST_PATH = "v1/{+name}";
            private final Pattern NAME_PATTERN;
            @Key
            private String name;

            protected Get(String name) {
                super(ServiceManagement.this, "GET", REST_PATH, null, Operation.class);
                this.NAME_PATTERN = Pattern.compile("^operations/.*$");
                this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                if (!ServiceManagement.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^operations/.*$");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public String getName() {
                return this.name;
            }

            public Get setName(String name) {
                if (!ServiceManagement.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^operations/.*$");
                }
                this.name = name;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }
    }
}

