/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.serviceusage.v1;

/**
 * Service definition for ServiceUsage (v1).
 *
 * <p>
 * Enables services that service consumers want to use on Google Cloud Platform, lists the available or enabled services, or disables services that service consumers no longer use.
 * </p>
 *
 * <p>
 * For more information about this service, see the
 * <a href="https://cloud.google.com/service-usage/" target="_blank">API Documentation</a>
 * </p>
 *
 * <p>
 * This service uses {@link ServiceUsageRequestInitializer} to initialize global parameters via its
 * {@link Builder}.
 * </p>
 *
 * @since 1.3
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public class ServiceUsage extends com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient {

  // Note: Leave this static initializer at the top of the file.
  static {
    com.google.api.client.util.Preconditions.checkState(
        com.google.api.client.googleapis.GoogleUtils.MAJOR_VERSION == 1 &&
        (com.google.api.client.googleapis.GoogleUtils.MINOR_VERSION >= 32 ||
        (com.google.api.client.googleapis.GoogleUtils.MINOR_VERSION == 31 &&
        com.google.api.client.googleapis.GoogleUtils.BUGFIX_VERSION >= 1)),
        "You are currently running with version %s of google-api-client. " +
        "You need at least version 1.31.1 of google-api-client to run version " +
        "1.32.1 of the Service Usage API library.", com.google.api.client.googleapis.GoogleUtils.VERSION);
  }

  /**
   * The default encoded root URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   *
   * @since 1.7
   */
  public static final String DEFAULT_ROOT_URL = "https://serviceusage.googleapis.com/";

  /**
   * The default encoded mTLS root URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   *
   * @since 1.31
   */
  public static final String DEFAULT_MTLS_ROOT_URL = "https://serviceusage.mtls.googleapis.com/";

  /**
   * The default encoded service path of the service. This is determined when the library is
   * generated and normally should not be changed.
   *
   * @since 1.7
   */
  public static final String DEFAULT_SERVICE_PATH = "";

  /**
   * The default encoded batch path of the service. This is determined when the library is
   * generated and normally should not be changed.
   *
   * @since 1.23
   */
  public static final String DEFAULT_BATCH_PATH = "batch";

  /**
   * The default encoded base URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   */
  public static final String DEFAULT_BASE_URL = DEFAULT_ROOT_URL + DEFAULT_SERVICE_PATH;

  /**
   * Constructor.
   *
   * <p>
   * Use {@link Builder} if you need to specify any of the optional parameters.
   * </p>
   *
   * @param transport HTTP transport, which should normally be:
   *        <ul>
   *        <li>Google App Engine:
   *        {@code com.google.api.client.extensions.appengine.http.UrlFetchTransport}</li>
   *        <li>Android: {@code newCompatibleTransport} from
   *        {@code com.google.api.client.extensions.android.http.AndroidHttp}</li>
   *        <li>Java: {@link com.google.api.client.googleapis.javanet.GoogleNetHttpTransport#newTrustedTransport()}
   *        </li>
   *        </ul>
   * @param jsonFactory JSON factory, which may be:
   *        <ul>
   *        <li>Jackson: {@code com.google.api.client.json.jackson2.JacksonFactory}</li>
   *        <li>Google GSON: {@code com.google.api.client.json.gson.GsonFactory}</li>
   *        <li>Android Honeycomb or higher:
   *        {@code com.google.api.client.extensions.android.json.AndroidJsonFactory}</li>
   *        </ul>
   * @param httpRequestInitializer HTTP request initializer or {@code null} for none
   * @since 1.7
   */
  public ServiceUsage(com.google.api.client.http.HttpTransport transport, com.google.api.client.json.JsonFactory jsonFactory,
      com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
    this(new Builder(transport, jsonFactory, httpRequestInitializer));
  }

  /**
   * @param builder builder
   */
  ServiceUsage(Builder builder) {
    super(builder);
  }

  @Override
  protected void initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest<?> httpClientRequest) throws java.io.IOException {
    super.initialize(httpClientRequest);
  }

  /**
   * An accessor for creating requests from the Operations collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code ServiceUsage serviceusage = new ServiceUsage(...);}
   *   {@code ServiceUsage.Operations.List request = serviceusage.operations().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Operations operations() {
    return new Operations();
  }

  /**
   * The "operations" collection of methods.
   */
  public class Operations {

    /**
     * Starts asynchronous cancellation on a long-running operation. The server makes a best effort to
     * cancel the operation, but success is not guaranteed. If the server doesn't support this method,
     * it returns `google.rpc.Code.UNIMPLEMENTED`. Clients can use Operations.GetOperation or other
     * methods to check whether the cancellation succeeded or whether the operation completed despite
     * cancellation. On successful cancellation, the operation is not deleted; instead, it becomes an
     * operation with an Operation.error value with a google.rpc.Status.code of 1, corresponding to
     * `Code.CANCELLED`.
     *
     * Create a request for the method "operations.cancel".
     *
     * This request holds the parameters needed by the serviceusage server.  After setting any optional
     * parameters, call the {@link Cancel#execute()} method to invoke the remote operation.
     *
     * @param name The name of the operation resource to be cancelled.
     * @param content the {@link com.google.api.services.serviceusage.v1.model.CancelOperationRequest}
     * @return the request
     */
    public Cancel cancel(java.lang.String name, com.google.api.services.serviceusage.v1.model.CancelOperationRequest content) throws java.io.IOException {
      Cancel result = new Cancel(name, content);
      initialize(result);
      return result;
    }

    public class Cancel extends ServiceUsageRequest<com.google.api.services.serviceusage.v1.model.Empty> {

      private static final String REST_PATH = "v1/{+name}:cancel";

      private final java.util.regex.Pattern NAME_PATTERN =
          java.util.regex.Pattern.compile("^operations/.*$");

      /**
       * Starts asynchronous cancellation on a long-running operation. The server makes a best effort to
       * cancel the operation, but success is not guaranteed. If the server doesn't support this method,
       * it returns `google.rpc.Code.UNIMPLEMENTED`. Clients can use Operations.GetOperation or other
       * methods to check whether the cancellation succeeded or whether the operation completed despite
       * cancellation. On successful cancellation, the operation is not deleted; instead, it becomes an
       * operation with an Operation.error value with a google.rpc.Status.code of 1, corresponding to
       * `Code.CANCELLED`.
       *
       * Create a request for the method "operations.cancel".
       *
       * This request holds the parameters needed by the the serviceusage server.  After setting any
       * optional parameters, call the {@link Cancel#execute()} method to invoke the remote operation.
       * <p> {@link
       * Cancel#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param name The name of the operation resource to be cancelled.
       * @param content the {@link com.google.api.services.serviceusage.v1.model.CancelOperationRequest}
       * @since 1.13
       */
      protected Cancel(java.lang.String name, com.google.api.services.serviceusage.v1.model.CancelOperationRequest content) {
        super(ServiceUsage.this, "POST", REST_PATH, content, com.google.api.services.serviceusage.v1.model.Empty.class);
        this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
              "Parameter name must conform to the pattern " +
              "^operations/.*$");
        }
      }

      @Override
      public Cancel set$Xgafv(java.lang.String $Xgafv) {
        return (Cancel) super.set$Xgafv($Xgafv);
      }

      @Override
      public Cancel setAccessToken(java.lang.String accessToken) {
        return (Cancel) super.setAccessToken(accessToken);
      }

      @Override
      public Cancel setAlt(java.lang.String alt) {
        return (Cancel) super.setAlt(alt);
      }

      @Override
      public Cancel setCallback(java.lang.String callback) {
        return (Cancel) super.setCallback(callback);
      }

      @Override
      public Cancel setFields(java.lang.String fields) {
        return (Cancel) super.setFields(fields);
      }

      @Override
      public Cancel setKey(java.lang.String key) {
        return (Cancel) super.setKey(key);
      }

      @Override
      public Cancel setOauthToken(java.lang.String oauthToken) {
        return (Cancel) super.setOauthToken(oauthToken);
      }

      @Override
      public Cancel setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Cancel) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Cancel setQuotaUser(java.lang.String quotaUser) {
        return (Cancel) super.setQuotaUser(quotaUser);
      }

      @Override
      public Cancel setUploadType(java.lang.String uploadType) {
        return (Cancel) super.setUploadType(uploadType);
      }

      @Override
      public Cancel setUploadProtocol(java.lang.String uploadProtocol) {
        return (Cancel) super.setUploadProtocol(uploadProtocol);
      }

      /** The name of the operation resource to be cancelled. */
      @com.google.api.client.util.Key
      private java.lang.String name;

      /** The name of the operation resource to be cancelled.
       */
      public java.lang.String getName() {
        return name;
      }

      /** The name of the operation resource to be cancelled. */
      public Cancel setName(java.lang.String name) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
              "Parameter name must conform to the pattern " +
              "^operations/.*$");
        }
        this.name = name;
        return this;
      }

      @Override
      public Cancel set(String parameterName, Object value) {
        return (Cancel) super.set(parameterName, value);
      }
    }
    /**
     * Deletes a long-running operation. This method indicates that the client is no longer interested
     * in the operation result. It does not cancel the operation. If the server doesn't support this
     * method, it returns `google.rpc.Code.UNIMPLEMENTED`.
     *
     * Create a request for the method "operations.delete".
     *
     * This request holds the parameters needed by the serviceusage server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param name The name of the operation resource to be deleted.
     * @return the request
     */
    public Delete delete(java.lang.String name) throws java.io.IOException {
      Delete result = new Delete(name);
      initialize(result);
      return result;
    }

    public class Delete extends ServiceUsageRequest<com.google.api.services.serviceusage.v1.model.Empty> {

      private static final String REST_PATH = "v1/{+name}";

      private final java.util.regex.Pattern NAME_PATTERN =
          java.util.regex.Pattern.compile("^operations/.*$");

      /**
       * Deletes a long-running operation. This method indicates that the client is no longer interested
       * in the operation result. It does not cancel the operation. If the server doesn't support this
       * method, it returns `google.rpc.Code.UNIMPLEMENTED`.
       *
       * Create a request for the method "operations.delete".
       *
       * This request holds the parameters needed by the the serviceusage server.  After setting any
       * optional parameters, call the {@link Delete#execute()} method to invoke the remote operation.
       * <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param name The name of the operation resource to be deleted.
       * @since 1.13
       */
      protected Delete(java.lang.String name) {
        super(ServiceUsage.this, "DELETE", REST_PATH, null, com.google.api.services.serviceusage.v1.model.Empty.class);
        this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
              "Parameter name must conform to the pattern " +
              "^operations/.*$");
        }
      }

      @Override
      public Delete set$Xgafv(java.lang.String $Xgafv) {
        return (Delete) super.set$Xgafv($Xgafv);
      }

      @Override
      public Delete setAccessToken(java.lang.String accessToken) {
        return (Delete) super.setAccessToken(accessToken);
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setCallback(java.lang.String callback) {
        return (Delete) super.setCallback(callback);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUploadType(java.lang.String uploadType) {
        return (Delete) super.setUploadType(uploadType);
      }

      @Override
      public Delete setUploadProtocol(java.lang.String uploadProtocol) {
        return (Delete) super.setUploadProtocol(uploadProtocol);
      }

      /** The name of the operation resource to be deleted. */
      @com.google.api.client.util.Key
      private java.lang.String name;

      /** The name of the operation resource to be deleted.
       */
      public java.lang.String getName() {
        return name;
      }

      /** The name of the operation resource to be deleted. */
      public Delete setName(java.lang.String name) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
              "Parameter name must conform to the pattern " +
              "^operations/.*$");
        }
        this.name = name;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Gets the latest state of a long-running operation. Clients can use this method to poll the
     * operation result at intervals as recommended by the API service.
     *
     * Create a request for the method "operations.get".
     *
     * This request holds the parameters needed by the serviceusage server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param name The name of the operation resource.
     * @return the request
     */
    public Get get(java.lang.String name) throws java.io.IOException {
      Get result = new Get(name);
      initialize(result);
      return result;
    }

    public class Get extends ServiceUsageRequest<com.google.api.services.serviceusage.v1.model.Operation> {

      private static final String REST_PATH = "v1/{+name}";

      private final java.util.regex.Pattern NAME_PATTERN =
          java.util.regex.Pattern.compile("^operations/[^/]+$");

      /**
       * Gets the latest state of a long-running operation. Clients can use this method to poll the
       * operation result at intervals as recommended by the API service.
       *
       * Create a request for the method "operations.get".
       *
       * This request holds the parameters needed by the the serviceusage server.  After setting any
       * optional parameters, call the {@link Get#execute()} method to invoke the remote operation. <p>
       * {@link Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param name The name of the operation resource.
       * @since 1.13
       */
      protected Get(java.lang.String name) {
        super(ServiceUsage.this, "GET", REST_PATH, null, com.google.api.services.serviceusage.v1.model.Operation.class);
        this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
              "Parameter name must conform to the pattern " +
              "^operations/[^/]+$");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get set$Xgafv(java.lang.String $Xgafv) {
        return (Get) super.set$Xgafv($Xgafv);
      }

      @Override
      public Get setAccessToken(java.lang.String accessToken) {
        return (Get) super.setAccessToken(accessToken);
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setCallback(java.lang.String callback) {
        return (Get) super.setCallback(callback);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUploadType(java.lang.String uploadType) {
        return (Get) super.setUploadType(uploadType);
      }

      @Override
      public Get setUploadProtocol(java.lang.String uploadProtocol) {
        return (Get) super.setUploadProtocol(uploadProtocol);
      }

      /** The name of the operation resource. */
      @com.google.api.client.util.Key
      private java.lang.String name;

      /** The name of the operation resource.
       */
      public java.lang.String getName() {
        return name;
      }

      /** The name of the operation resource. */
      public Get setName(java.lang.String name) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
              "Parameter name must conform to the pattern " +
              "^operations/[^/]+$");
        }
        this.name = name;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Lists operations that match the specified filter in the request. If the server doesn't support
     * this method, it returns `UNIMPLEMENTED`. NOTE: the `name` binding allows API services to override
     * the binding to use different resource name schemes, such as `users/operations`. To override the
     * binding, API services can add a binding such as `"/v1/{name=users}/operations"` to their service
     * configuration. For backwards compatibility, the default name includes the operations collection
     * id, however overriding users must ensure the name binding is the parent resource, without the
     * operations collection id.
     *
     * Create a request for the method "operations.list".
     *
     * This request holds the parameters needed by the serviceusage server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @return the request
     */
    public List list() throws java.io.IOException {
      List result = new List();
      initialize(result);
      return result;
    }

    public class List extends ServiceUsageRequest<com.google.api.services.serviceusage.v1.model.ListOperationsResponse> {

      private static final String REST_PATH = "v1/operations";

      /**
       * Lists operations that match the specified filter in the request. If the server doesn't support
       * this method, it returns `UNIMPLEMENTED`. NOTE: the `name` binding allows API services to
       * override the binding to use different resource name schemes, such as `users/operations`. To
       * override the binding, API services can add a binding such as `"/v1/{name=users}/operations"` to
       * their service configuration. For backwards compatibility, the default name includes the
       * operations collection id, however overriding users must ensure the name binding is the parent
       * resource, without the operations collection id.
       *
       * Create a request for the method "operations.list".
       *
       * This request holds the parameters needed by the the serviceusage server.  After setting any
       * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
       * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @since 1.13
       */
      protected List() {
        super(ServiceUsage.this, "GET", REST_PATH, null, com.google.api.services.serviceusage.v1.model.ListOperationsResponse.class);
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List set$Xgafv(java.lang.String $Xgafv) {
        return (List) super.set$Xgafv($Xgafv);
      }

      @Override
      public List setAccessToken(java.lang.String accessToken) {
        return (List) super.setAccessToken(accessToken);
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setCallback(java.lang.String callback) {
        return (List) super.setCallback(callback);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUploadType(java.lang.String uploadType) {
        return (List) super.setUploadType(uploadType);
      }

      @Override
      public List setUploadProtocol(java.lang.String uploadProtocol) {
        return (List) super.setUploadProtocol(uploadProtocol);
      }

      /** The standard list filter. */
      @com.google.api.client.util.Key
      private java.lang.String filter;

      /** The standard list filter.
       */
      public java.lang.String getFilter() {
        return filter;
      }

      /** The standard list filter. */
      public List setFilter(java.lang.String filter) {
        this.filter = filter;
        return this;
      }

      /** The name of the operation's parent resource. */
      @com.google.api.client.util.Key
      private java.lang.String name;

      /** The name of the operation's parent resource.
       */
      public java.lang.String getName() {
        return name;
      }

      /** The name of the operation's parent resource. */
      public List setName(java.lang.String name) {
        this.name = name;
        return this;
      }

      /** The standard list page size. */
      @com.google.api.client.util.Key
      private java.lang.Integer pageSize;

      /** The standard list page size.
       */
      public java.lang.Integer getPageSize() {
        return pageSize;
      }

      /** The standard list page size. */
      public List setPageSize(java.lang.Integer pageSize) {
        this.pageSize = pageSize;
        return this;
      }

      /** The standard list page token. */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** The standard list page token.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /** The standard list page token. */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Services collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code ServiceUsage serviceusage = new ServiceUsage(...);}
   *   {@code ServiceUsage.Services.List request = serviceusage.services().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Services services() {
    return new Services();
  }

  /**
   * The "services" collection of methods.
   */
  public class Services {

    /**
     * Enable multiple services on a project. The operation is atomic: if enabling any service fails,
     * then the entire batch fails, and no state changes occur. To enable a single service, use the
     * `EnableService` method instead.
     *
     * Create a request for the method "services.batchEnable".
     *
     * This request holds the parameters needed by the serviceusage server.  After setting any optional
     * parameters, call the {@link BatchEnable#execute()} method to invoke the remote operation.
     *
     * @param parent Parent to enable services on. An example name would be: `projects/123` where `123` is the project
     *        number. The `BatchEnableServices` method currently only supports projects.
     * @param content the {@link com.google.api.services.serviceusage.v1.model.BatchEnableServicesRequest}
     * @return the request
     */
    public BatchEnable batchEnable(java.lang.String parent, com.google.api.services.serviceusage.v1.model.BatchEnableServicesRequest content) throws java.io.IOException {
      BatchEnable result = new BatchEnable(parent, content);
      initialize(result);
      return result;
    }

    public class BatchEnable extends ServiceUsageRequest<com.google.api.services.serviceusage.v1.model.Operation> {

      private static final String REST_PATH = "v1/{+parent}/services:batchEnable";

      private final java.util.regex.Pattern PARENT_PATTERN =
          java.util.regex.Pattern.compile("^[^/]+/[^/]+$");

      /**
       * Enable multiple services on a project. The operation is atomic: if enabling any service fails,
       * then the entire batch fails, and no state changes occur. To enable a single service, use the
       * `EnableService` method instead.
       *
       * Create a request for the method "services.batchEnable".
       *
       * This request holds the parameters needed by the the serviceusage server.  After setting any
       * optional parameters, call the {@link BatchEnable#execute()} method to invoke the remote
       * operation. <p> {@link
       * BatchEnable#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param parent Parent to enable services on. An example name would be: `projects/123` where `123` is the project
     *        number. The `BatchEnableServices` method currently only supports projects.
       * @param content the {@link com.google.api.services.serviceusage.v1.model.BatchEnableServicesRequest}
       * @since 1.13
       */
      protected BatchEnable(java.lang.String parent, com.google.api.services.serviceusage.v1.model.BatchEnableServicesRequest content) {
        super(ServiceUsage.this, "POST", REST_PATH, content, com.google.api.services.serviceusage.v1.model.Operation.class);
        this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
              "Parameter parent must conform to the pattern " +
              "^[^/]+/[^/]+$");
        }
      }

      @Override
      public BatchEnable set$Xgafv(java.lang.String $Xgafv) {
        return (BatchEnable) super.set$Xgafv($Xgafv);
      }

      @Override
      public BatchEnable setAccessToken(java.lang.String accessToken) {
        return (BatchEnable) super.setAccessToken(accessToken);
      }

      @Override
      public BatchEnable setAlt(java.lang.String alt) {
        return (BatchEnable) super.setAlt(alt);
      }

      @Override
      public BatchEnable setCallback(java.lang.String callback) {
        return (BatchEnable) super.setCallback(callback);
      }

      @Override
      public BatchEnable setFields(java.lang.String fields) {
        return (BatchEnable) super.setFields(fields);
      }

      @Override
      public BatchEnable setKey(java.lang.String key) {
        return (BatchEnable) super.setKey(key);
      }

      @Override
      public BatchEnable setOauthToken(java.lang.String oauthToken) {
        return (BatchEnable) super.setOauthToken(oauthToken);
      }

      @Override
      public BatchEnable setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (BatchEnable) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public BatchEnable setQuotaUser(java.lang.String quotaUser) {
        return (BatchEnable) super.setQuotaUser(quotaUser);
      }

      @Override
      public BatchEnable setUploadType(java.lang.String uploadType) {
        return (BatchEnable) super.setUploadType(uploadType);
      }

      @Override
      public BatchEnable setUploadProtocol(java.lang.String uploadProtocol) {
        return (BatchEnable) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * Parent to enable services on. An example name would be: `projects/123` where `123` is the
       * project number. The `BatchEnableServices` method currently only supports projects.
       */
      @com.google.api.client.util.Key
      private java.lang.String parent;

      /** Parent to enable services on. An example name would be: `projects/123` where `123` is the project
     number. The `BatchEnableServices` method currently only supports projects.
       */
      public java.lang.String getParent() {
        return parent;
      }

      /**
       * Parent to enable services on. An example name would be: `projects/123` where `123` is the
       * project number. The `BatchEnableServices` method currently only supports projects.
       */
      public BatchEnable setParent(java.lang.String parent) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
              "Parameter parent must conform to the pattern " +
              "^[^/]+/[^/]+$");
        }
        this.parent = parent;
        return this;
      }

      @Override
      public BatchEnable set(String parameterName, Object value) {
        return (BatchEnable) super.set(parameterName, value);
      }
    }
    /**
     * Returns the service configurations and enabled states for a given list of services.
     *
     * Create a request for the method "services.batchGet".
     *
     * This request holds the parameters needed by the serviceusage server.  After setting any optional
     * parameters, call the {@link BatchGet#execute()} method to invoke the remote operation.
     *
     * @param parent Parent to retrieve services from. If this is set, the parent of all of the services specified in
     *        `names` must match this field. An example name would be: `projects/123` where `123` is the
     *        project number. The `BatchGetServices` method currently only supports projects.
     * @return the request
     */
    public BatchGet batchGet(java.lang.String parent) throws java.io.IOException {
      BatchGet result = new BatchGet(parent);
      initialize(result);
      return result;
    }

    public class BatchGet extends ServiceUsageRequest<com.google.api.services.serviceusage.v1.model.BatchGetServicesResponse> {

      private static final String REST_PATH = "v1/{+parent}/services:batchGet";

      private final java.util.regex.Pattern PARENT_PATTERN =
          java.util.regex.Pattern.compile("^[^/]+/[^/]+$");

      /**
       * Returns the service configurations and enabled states for a given list of services.
       *
       * Create a request for the method "services.batchGet".
       *
       * This request holds the parameters needed by the the serviceusage server.  After setting any
       * optional parameters, call the {@link BatchGet#execute()} method to invoke the remote operation.
       * <p> {@link
       * BatchGet#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param parent Parent to retrieve services from. If this is set, the parent of all of the services specified in
     *        `names` must match this field. An example name would be: `projects/123` where `123` is the
     *        project number. The `BatchGetServices` method currently only supports projects.
       * @since 1.13
       */
      protected BatchGet(java.lang.String parent) {
        super(ServiceUsage.this, "GET", REST_PATH, null, com.google.api.services.serviceusage.v1.model.BatchGetServicesResponse.class);
        this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
              "Parameter parent must conform to the pattern " +
              "^[^/]+/[^/]+$");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public BatchGet set$Xgafv(java.lang.String $Xgafv) {
        return (BatchGet) super.set$Xgafv($Xgafv);
      }

      @Override
      public BatchGet setAccessToken(java.lang.String accessToken) {
        return (BatchGet) super.setAccessToken(accessToken);
      }

      @Override
      public BatchGet setAlt(java.lang.String alt) {
        return (BatchGet) super.setAlt(alt);
      }

      @Override
      public BatchGet setCallback(java.lang.String callback) {
        return (BatchGet) super.setCallback(callback);
      }

      @Override
      public BatchGet setFields(java.lang.String fields) {
        return (BatchGet) super.setFields(fields);
      }

      @Override
      public BatchGet setKey(java.lang.String key) {
        return (BatchGet) super.setKey(key);
      }

      @Override
      public BatchGet setOauthToken(java.lang.String oauthToken) {
        return (BatchGet) super.setOauthToken(oauthToken);
      }

      @Override
      public BatchGet setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (BatchGet) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public BatchGet setQuotaUser(java.lang.String quotaUser) {
        return (BatchGet) super.setQuotaUser(quotaUser);
      }

      @Override
      public BatchGet setUploadType(java.lang.String uploadType) {
        return (BatchGet) super.setUploadType(uploadType);
      }

      @Override
      public BatchGet setUploadProtocol(java.lang.String uploadProtocol) {
        return (BatchGet) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * Parent to retrieve services from. If this is set, the parent of all of the services
       * specified in `names` must match this field. An example name would be: `projects/123` where
       * `123` is the project number. The `BatchGetServices` method currently only supports
       * projects.
       */
      @com.google.api.client.util.Key
      private java.lang.String parent;

      /** Parent to retrieve services from. If this is set, the parent of all of the services specified in
     `names` must match this field. An example name would be: `projects/123` where `123` is the project
     number. The `BatchGetServices` method currently only supports projects.
       */
      public java.lang.String getParent() {
        return parent;
      }

      /**
       * Parent to retrieve services from. If this is set, the parent of all of the services
       * specified in `names` must match this field. An example name would be: `projects/123` where
       * `123` is the project number. The `BatchGetServices` method currently only supports
       * projects.
       */
      public BatchGet setParent(java.lang.String parent) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
              "Parameter parent must conform to the pattern " +
              "^[^/]+/[^/]+$");
        }
        this.parent = parent;
        return this;
      }

      /**
       * Names of the services to retrieve. An example name would be:
       * `projects/123/services/serviceusage.googleapis.com` where `123` is the project number. A
       * single request can get a maximum of 30 services at a time.
       */
      @com.google.api.client.util.Key
      private java.util.List<java.lang.String> names;

      /** Names of the services to retrieve. An example name would be:
     `projects/123/services/serviceusage.googleapis.com` where `123` is the project number. A single
     request can get a maximum of 30 services at a time.
       */
      public java.util.List<java.lang.String> getNames() {
        return names;
      }

      /**
       * Names of the services to retrieve. An example name would be:
       * `projects/123/services/serviceusage.googleapis.com` where `123` is the project number. A
       * single request can get a maximum of 30 services at a time.
       */
      public BatchGet setNames(java.util.List<java.lang.String> names) {
        this.names = names;
        return this;
      }

      @Override
      public BatchGet set(String parameterName, Object value) {
        return (BatchGet) super.set(parameterName, value);
      }
    }
    /**
     * Disable a service so that it can no longer be used with a project. This prevents unintended usage
     * that may cause unexpected billing charges or security leaks. It is not valid to call the disable
     * method on a service that is not currently enabled. Callers will receive a `FAILED_PRECONDITION`
     * status if the target service is not currently enabled.
     *
     * Create a request for the method "services.disable".
     *
     * This request holds the parameters needed by the serviceusage server.  After setting any optional
     * parameters, call the {@link Disable#execute()} method to invoke the remote operation.
     *
     * @param name Name of the consumer and service to disable the service on. The enable and disable methods currently
     *        only support projects. An example name would be:
     *        `projects/123/services/serviceusage.googleapis.com` where `123` is the project number.
     * @param content the {@link com.google.api.services.serviceusage.v1.model.DisableServiceRequest}
     * @return the request
     */
    public Disable disable(java.lang.String name, com.google.api.services.serviceusage.v1.model.DisableServiceRequest content) throws java.io.IOException {
      Disable result = new Disable(name, content);
      initialize(result);
      return result;
    }

    public class Disable extends ServiceUsageRequest<com.google.api.services.serviceusage.v1.model.Operation> {

      private static final String REST_PATH = "v1/{+name}:disable";

      private final java.util.regex.Pattern NAME_PATTERN =
          java.util.regex.Pattern.compile("^[^/]+/[^/]+/services/[^/]+$");

      /**
       * Disable a service so that it can no longer be used with a project. This prevents unintended
       * usage that may cause unexpected billing charges or security leaks. It is not valid to call the
       * disable method on a service that is not currently enabled. Callers will receive a
       * `FAILED_PRECONDITION` status if the target service is not currently enabled.
       *
       * Create a request for the method "services.disable".
       *
       * This request holds the parameters needed by the the serviceusage server.  After setting any
       * optional parameters, call the {@link Disable#execute()} method to invoke the remote operation.
       * <p> {@link
       * Disable#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param name Name of the consumer and service to disable the service on. The enable and disable methods currently
     *        only support projects. An example name would be:
     *        `projects/123/services/serviceusage.googleapis.com` where `123` is the project number.
       * @param content the {@link com.google.api.services.serviceusage.v1.model.DisableServiceRequest}
       * @since 1.13
       */
      protected Disable(java.lang.String name, com.google.api.services.serviceusage.v1.model.DisableServiceRequest content) {
        super(ServiceUsage.this, "POST", REST_PATH, content, com.google.api.services.serviceusage.v1.model.Operation.class);
        this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
              "Parameter name must conform to the pattern " +
              "^[^/]+/[^/]+/services/[^/]+$");
        }
      }

      @Override
      public Disable set$Xgafv(java.lang.String $Xgafv) {
        return (Disable) super.set$Xgafv($Xgafv);
      }

      @Override
      public Disable setAccessToken(java.lang.String accessToken) {
        return (Disable) super.setAccessToken(accessToken);
      }

      @Override
      public Disable setAlt(java.lang.String alt) {
        return (Disable) super.setAlt(alt);
      }

      @Override
      public Disable setCallback(java.lang.String callback) {
        return (Disable) super.setCallback(callback);
      }

      @Override
      public Disable setFields(java.lang.String fields) {
        return (Disable) super.setFields(fields);
      }

      @Override
      public Disable setKey(java.lang.String key) {
        return (Disable) super.setKey(key);
      }

      @Override
      public Disable setOauthToken(java.lang.String oauthToken) {
        return (Disable) super.setOauthToken(oauthToken);
      }

      @Override
      public Disable setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Disable) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Disable setQuotaUser(java.lang.String quotaUser) {
        return (Disable) super.setQuotaUser(quotaUser);
      }

      @Override
      public Disable setUploadType(java.lang.String uploadType) {
        return (Disable) super.setUploadType(uploadType);
      }

      @Override
      public Disable setUploadProtocol(java.lang.String uploadProtocol) {
        return (Disable) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * Name of the consumer and service to disable the service on. The enable and disable methods
       * currently only support projects. An example name would be:
       * `projects/123/services/serviceusage.googleapis.com` where `123` is the project number.
       */
      @com.google.api.client.util.Key
      private java.lang.String name;

      /** Name of the consumer and service to disable the service on. The enable and disable methods
     currently only support projects. An example name would be:
     `projects/123/services/serviceusage.googleapis.com` where `123` is the project number.
       */
      public java.lang.String getName() {
        return name;
      }

      /**
       * Name of the consumer and service to disable the service on. The enable and disable methods
       * currently only support projects. An example name would be:
       * `projects/123/services/serviceusage.googleapis.com` where `123` is the project number.
       */
      public Disable setName(java.lang.String name) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
              "Parameter name must conform to the pattern " +
              "^[^/]+/[^/]+/services/[^/]+$");
        }
        this.name = name;
        return this;
      }

      @Override
      public Disable set(String parameterName, Object value) {
        return (Disable) super.set(parameterName, value);
      }
    }
    /**
     * Enable a service so that it can be used with a project.
     *
     * Create a request for the method "services.enable".
     *
     * This request holds the parameters needed by the serviceusage server.  After setting any optional
     * parameters, call the {@link Enable#execute()} method to invoke the remote operation.
     *
     * @param name Name of the consumer and service to enable the service on. The `EnableService` and `DisableService`
     *        methods currently only support projects. Enabling a service requires that the service is
     *        public or is shared with the user enabling the service. An example name would be:
     *        `projects/123/services/serviceusage.googleapis.com` where `123` is the project number.
     * @param content the {@link com.google.api.services.serviceusage.v1.model.EnableServiceRequest}
     * @return the request
     */
    public Enable enable(java.lang.String name, com.google.api.services.serviceusage.v1.model.EnableServiceRequest content) throws java.io.IOException {
      Enable result = new Enable(name, content);
      initialize(result);
      return result;
    }

    public class Enable extends ServiceUsageRequest<com.google.api.services.serviceusage.v1.model.Operation> {

      private static final String REST_PATH = "v1/{+name}:enable";

      private final java.util.regex.Pattern NAME_PATTERN =
          java.util.regex.Pattern.compile("^[^/]+/[^/]+/services/[^/]+$");

      /**
       * Enable a service so that it can be used with a project.
       *
       * Create a request for the method "services.enable".
       *
       * This request holds the parameters needed by the the serviceusage server.  After setting any
       * optional parameters, call the {@link Enable#execute()} method to invoke the remote operation.
       * <p> {@link
       * Enable#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param name Name of the consumer and service to enable the service on. The `EnableService` and `DisableService`
     *        methods currently only support projects. Enabling a service requires that the service is
     *        public or is shared with the user enabling the service. An example name would be:
     *        `projects/123/services/serviceusage.googleapis.com` where `123` is the project number.
       * @param content the {@link com.google.api.services.serviceusage.v1.model.EnableServiceRequest}
       * @since 1.13
       */
      protected Enable(java.lang.String name, com.google.api.services.serviceusage.v1.model.EnableServiceRequest content) {
        super(ServiceUsage.this, "POST", REST_PATH, content, com.google.api.services.serviceusage.v1.model.Operation.class);
        this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
              "Parameter name must conform to the pattern " +
              "^[^/]+/[^/]+/services/[^/]+$");
        }
      }

      @Override
      public Enable set$Xgafv(java.lang.String $Xgafv) {
        return (Enable) super.set$Xgafv($Xgafv);
      }

      @Override
      public Enable setAccessToken(java.lang.String accessToken) {
        return (Enable) super.setAccessToken(accessToken);
      }

      @Override
      public Enable setAlt(java.lang.String alt) {
        return (Enable) super.setAlt(alt);
      }

      @Override
      public Enable setCallback(java.lang.String callback) {
        return (Enable) super.setCallback(callback);
      }

      @Override
      public Enable setFields(java.lang.String fields) {
        return (Enable) super.setFields(fields);
      }

      @Override
      public Enable setKey(java.lang.String key) {
        return (Enable) super.setKey(key);
      }

      @Override
      public Enable setOauthToken(java.lang.String oauthToken) {
        return (Enable) super.setOauthToken(oauthToken);
      }

      @Override
      public Enable setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Enable) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Enable setQuotaUser(java.lang.String quotaUser) {
        return (Enable) super.setQuotaUser(quotaUser);
      }

      @Override
      public Enable setUploadType(java.lang.String uploadType) {
        return (Enable) super.setUploadType(uploadType);
      }

      @Override
      public Enable setUploadProtocol(java.lang.String uploadProtocol) {
        return (Enable) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * Name of the consumer and service to enable the service on. The `EnableService` and
       * `DisableService` methods currently only support projects. Enabling a service requires that
       * the service is public or is shared with the user enabling the service. An example name
       * would be: `projects/123/services/serviceusage.googleapis.com` where `123` is the project
       * number.
       */
      @com.google.api.client.util.Key
      private java.lang.String name;

      /** Name of the consumer and service to enable the service on. The `EnableService` and `DisableService`
     methods currently only support projects. Enabling a service requires that the service is public or
     is shared with the user enabling the service. An example name would be:
     `projects/123/services/serviceusage.googleapis.com` where `123` is the project number.
       */
      public java.lang.String getName() {
        return name;
      }

      /**
       * Name of the consumer and service to enable the service on. The `EnableService` and
       * `DisableService` methods currently only support projects. Enabling a service requires that
       * the service is public or is shared with the user enabling the service. An example name
       * would be: `projects/123/services/serviceusage.googleapis.com` where `123` is the project
       * number.
       */
      public Enable setName(java.lang.String name) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
              "Parameter name must conform to the pattern " +
              "^[^/]+/[^/]+/services/[^/]+$");
        }
        this.name = name;
        return this;
      }

      @Override
      public Enable set(String parameterName, Object value) {
        return (Enable) super.set(parameterName, value);
      }
    }
    /**
     * Returns the service configuration and enabled state for a given service.
     *
     * Create a request for the method "services.get".
     *
     * This request holds the parameters needed by the serviceusage server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param name Name of the consumer and service to get the `ConsumerState` for. An example name would be:
     *        `projects/123/services/serviceusage.googleapis.com` where `123` is the project number.
     * @return the request
     */
    public Get get(java.lang.String name) throws java.io.IOException {
      Get result = new Get(name);
      initialize(result);
      return result;
    }

    public class Get extends ServiceUsageRequest<com.google.api.services.serviceusage.v1.model.GoogleApiServiceusageV1Service> {

      private static final String REST_PATH = "v1/{+name}";

      private final java.util.regex.Pattern NAME_PATTERN =
          java.util.regex.Pattern.compile("^[^/]+/[^/]+/services/[^/]+$");

      /**
       * Returns the service configuration and enabled state for a given service.
       *
       * Create a request for the method "services.get".
       *
       * This request holds the parameters needed by the the serviceusage server.  After setting any
       * optional parameters, call the {@link Get#execute()} method to invoke the remote operation. <p>
       * {@link Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param name Name of the consumer and service to get the `ConsumerState` for. An example name would be:
     *        `projects/123/services/serviceusage.googleapis.com` where `123` is the project number.
       * @since 1.13
       */
      protected Get(java.lang.String name) {
        super(ServiceUsage.this, "GET", REST_PATH, null, com.google.api.services.serviceusage.v1.model.GoogleApiServiceusageV1Service.class);
        this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
              "Parameter name must conform to the pattern " +
              "^[^/]+/[^/]+/services/[^/]+$");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get set$Xgafv(java.lang.String $Xgafv) {
        return (Get) super.set$Xgafv($Xgafv);
      }

      @Override
      public Get setAccessToken(java.lang.String accessToken) {
        return (Get) super.setAccessToken(accessToken);
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setCallback(java.lang.String callback) {
        return (Get) super.setCallback(callback);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUploadType(java.lang.String uploadType) {
        return (Get) super.setUploadType(uploadType);
      }

      @Override
      public Get setUploadProtocol(java.lang.String uploadProtocol) {
        return (Get) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * Name of the consumer and service to get the `ConsumerState` for. An example name would be:
       * `projects/123/services/serviceusage.googleapis.com` where `123` is the project number.
       */
      @com.google.api.client.util.Key
      private java.lang.String name;

      /** Name of the consumer and service to get the `ConsumerState` for. An example name would be:
     `projects/123/services/serviceusage.googleapis.com` where `123` is the project number.
       */
      public java.lang.String getName() {
        return name;
      }

      /**
       * Name of the consumer and service to get the `ConsumerState` for. An example name would be:
       * `projects/123/services/serviceusage.googleapis.com` where `123` is the project number.
       */
      public Get setName(java.lang.String name) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
              "Parameter name must conform to the pattern " +
              "^[^/]+/[^/]+/services/[^/]+$");
        }
        this.name = name;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * List all services available to the specified project, and the current state of those services
     * with respect to the project. The list includes all public services, all services for which the
     * calling user has the `servicemanagement.services.bind` permission, and all services that have
     * already been enabled on the project. The list can be filtered to only include services in a
     * specific state, for example to only include services enabled on the project. WARNING: If you need
     * to query enabled services frequently or across an organization, you should use [Cloud Asset
     * Inventory API](https://cloud.google.com/asset-inventory/docs/apis), which provides higher
     * throughput and richer filtering capability.
     *
     * Create a request for the method "services.list".
     *
     * This request holds the parameters needed by the serviceusage server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param parent Parent to search for services on. An example name would be: `projects/123` where `123` is the
     *        project number.
     * @return the request
     */
    public List list(java.lang.String parent) throws java.io.IOException {
      List result = new List(parent);
      initialize(result);
      return result;
    }

    public class List extends ServiceUsageRequest<com.google.api.services.serviceusage.v1.model.ListServicesResponse> {

      private static final String REST_PATH = "v1/{+parent}/services";

      private final java.util.regex.Pattern PARENT_PATTERN =
          java.util.regex.Pattern.compile("^[^/]+/[^/]+$");

      /**
       * List all services available to the specified project, and the current state of those services
       * with respect to the project. The list includes all public services, all services for which the
       * calling user has the `servicemanagement.services.bind` permission, and all services that have
       * already been enabled on the project. The list can be filtered to only include services in a
       * specific state, for example to only include services enabled on the project. WARNING: If you
       * need to query enabled services frequently or across an organization, you should use [Cloud
       * Asset Inventory API](https://cloud.google.com/asset-inventory/docs/apis), which provides higher
       * throughput and richer filtering capability.
       *
       * Create a request for the method "services.list".
       *
       * This request holds the parameters needed by the the serviceusage server.  After setting any
       * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
       * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param parent Parent to search for services on. An example name would be: `projects/123` where `123` is the
     *        project number.
       * @since 1.13
       */
      protected List(java.lang.String parent) {
        super(ServiceUsage.this, "GET", REST_PATH, null, com.google.api.services.serviceusage.v1.model.ListServicesResponse.class);
        this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
              "Parameter parent must conform to the pattern " +
              "^[^/]+/[^/]+$");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List set$Xgafv(java.lang.String $Xgafv) {
        return (List) super.set$Xgafv($Xgafv);
      }

      @Override
      public List setAccessToken(java.lang.String accessToken) {
        return (List) super.setAccessToken(accessToken);
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setCallback(java.lang.String callback) {
        return (List) super.setCallback(callback);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUploadType(java.lang.String uploadType) {
        return (List) super.setUploadType(uploadType);
      }

      @Override
      public List setUploadProtocol(java.lang.String uploadProtocol) {
        return (List) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * Parent to search for services on. An example name would be: `projects/123` where `123` is
       * the project number.
       */
      @com.google.api.client.util.Key
      private java.lang.String parent;

      /** Parent to search for services on. An example name would be: `projects/123` where `123` is the
     project number.
       */
      public java.lang.String getParent() {
        return parent;
      }

      /**
       * Parent to search for services on. An example name would be: `projects/123` where `123` is
       * the project number.
       */
      public List setParent(java.lang.String parent) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
              "Parameter parent must conform to the pattern " +
              "^[^/]+/[^/]+$");
        }
        this.parent = parent;
        return this;
      }

      /**
       * Only list services that conform to the given filter. The allowed filter strings are
       * `state:ENABLED` and `state:DISABLED`.
       */
      @com.google.api.client.util.Key
      private java.lang.String filter;

      /** Only list services that conform to the given filter. The allowed filter strings are `state:ENABLED`
     and `state:DISABLED`.
       */
      public java.lang.String getFilter() {
        return filter;
      }

      /**
       * Only list services that conform to the given filter. The allowed filter strings are
       * `state:ENABLED` and `state:DISABLED`.
       */
      public List setFilter(java.lang.String filter) {
        this.filter = filter;
        return this;
      }

      /**
       * Requested size of the next page of data. Requested page size cannot exceed 200. If not set,
       * the default page size is 50.
       */
      @com.google.api.client.util.Key
      private java.lang.Integer pageSize;

      /** Requested size of the next page of data. Requested page size cannot exceed 200. If not set, the
     default page size is 50.
       */
      public java.lang.Integer getPageSize() {
        return pageSize;
      }

      /**
       * Requested size of the next page of data. Requested page size cannot exceed 200. If not set,
       * the default page size is 50.
       */
      public List setPageSize(java.lang.Integer pageSize) {
        this.pageSize = pageSize;
        return this;
      }

      /**
       * Token identifying which result to start with, which is returned by a previous list call.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Token identifying which result to start with, which is returned by a previous list call.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * Token identifying which result to start with, which is returned by a previous list call.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }

  }

  /**
   * Builder for {@link ServiceUsage}.
   *
   * <p>
   * Implementation is not thread-safe.
   * </p>
   *
   * @since 1.3.0
   */
  public static final class Builder extends com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient.Builder {

    private static String chooseEndpoint(com.google.api.client.http.HttpTransport transport) {
      // If the GOOGLE_API_USE_MTLS_ENDPOINT environment variable value is "always", use mTLS endpoint.
      // If the env variable is "auto", use mTLS endpoint if and only if the transport is mTLS.
      // Use the regular endpoint for all other cases.
      String useMtlsEndpoint = System.getenv("GOOGLE_API_USE_MTLS_ENDPOINT");
      useMtlsEndpoint = useMtlsEndpoint == null ? "auto" : useMtlsEndpoint;
      if ("always".equals(useMtlsEndpoint) || ("auto".equals(useMtlsEndpoint) && transport != null && transport.isMtls())) {
        return DEFAULT_MTLS_ROOT_URL;
      }
      return DEFAULT_ROOT_URL;
    }

    /**
     * Returns an instance of a new builder.
     *
     * @param transport HTTP transport, which should normally be:
     *        <ul>
     *        <li>Google App Engine:
     *        {@code com.google.api.client.extensions.appengine.http.UrlFetchTransport}</li>
     *        <li>Android: {@code newCompatibleTransport} from
     *        {@code com.google.api.client.extensions.android.http.AndroidHttp}</li>
     *        <li>Java: {@link com.google.api.client.googleapis.javanet.GoogleNetHttpTransport#newTrustedTransport()}
     *        </li>
     *        </ul>
     * @param jsonFactory JSON factory, which may be:
     *        <ul>
     *        <li>Jackson: {@code com.google.api.client.json.jackson2.JacksonFactory}</li>
     *        <li>Google GSON: {@code com.google.api.client.json.gson.GsonFactory}</li>
     *        <li>Android Honeycomb or higher:
     *        {@code com.google.api.client.extensions.android.json.AndroidJsonFactory}</li>
     *        </ul>
     * @param httpRequestInitializer HTTP request initializer or {@code null} for none
     * @since 1.7
     */
    public Builder(com.google.api.client.http.HttpTransport transport, com.google.api.client.json.JsonFactory jsonFactory,
        com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
      super(
          transport,
          jsonFactory,
          Builder.chooseEndpoint(transport),
          DEFAULT_SERVICE_PATH,
          httpRequestInitializer,
          false);
      setBatchPath(DEFAULT_BATCH_PATH);
    }

    /** Builds a new instance of {@link ServiceUsage}. */
    @Override
    public ServiceUsage build() {
      return new ServiceUsage(this);
    }

    @Override
    public Builder setRootUrl(String rootUrl) {
      return (Builder) super.setRootUrl(rootUrl);
    }

    @Override
    public Builder setServicePath(String servicePath) {
      return (Builder) super.setServicePath(servicePath);
    }

    @Override
    public Builder setBatchPath(String batchPath) {
      return (Builder) super.setBatchPath(batchPath);
    }

    @Override
    public Builder setHttpRequestInitializer(com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
      return (Builder) super.setHttpRequestInitializer(httpRequestInitializer);
    }

    @Override
    public Builder setApplicationName(String applicationName) {
      return (Builder) super.setApplicationName(applicationName);
    }

    @Override
    public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
      return (Builder) super.setSuppressPatternChecks(suppressPatternChecks);
    }

    @Override
    public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
      return (Builder) super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
    }

    @Override
    public Builder setSuppressAllChecks(boolean suppressAllChecks) {
      return (Builder) super.setSuppressAllChecks(suppressAllChecks);
    }

    /**
     * Set the {@link ServiceUsageRequestInitializer}.
     *
     * @since 1.12
     */
    public Builder setServiceUsageRequestInitializer(
        ServiceUsageRequestInitializer serviceusageRequestInitializer) {
      return (Builder) super.setGoogleClientRequestInitializer(serviceusageRequestInitializer);
    }

    @Override
    public Builder setGoogleClientRequestInitializer(
        com.google.api.client.googleapis.services.GoogleClientRequestInitializer googleClientRequestInitializer) {
      return (Builder) super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
    }
  }
}
