/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.serviceusage.v1.model;

/**
 * A custom pattern is used for defining custom HTTP verb.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Service Usage API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class CustomHttpPattern extends com.google.api.client.json.GenericJson {

  /**
   * The name of this custom HTTP verb.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * The path matched by this custom verb.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String path;

  /**
   * The name of this custom HTTP verb.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * The name of this custom HTTP verb.
   * @param kind kind or {@code null} for none
   */
  public CustomHttpPattern setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * The path matched by this custom verb.
   * @return value or {@code null} for none
   */
  public java.lang.String getPath() {
    return path;
  }

  /**
   * The path matched by this custom verb.
   * @param path path or {@code null} for none
   */
  public CustomHttpPattern setPath(java.lang.String path) {
    this.path = path;
    return this;
  }

  @Override
  public CustomHttpPattern set(String fieldName, Object value) {
    return (CustomHttpPattern) super.set(fieldName, value);
  }

  @Override
  public CustomHttpPattern clone() {
    return (CustomHttpPattern) super.clone();
  }

}
