/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.serviceusage.v1.model;

/**
 * Request message for the `DisableService` method.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Service Usage API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class DisableServiceRequest extends com.google.api.client.json.GenericJson {

  /**
   * Defines the behavior for checking service usage when disabling a service.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String checkIfServiceHasUsage;

  /**
   * Indicates if services that are enabled and which depend on this service should also be
   * disabled. If not set, an error will be generated if any enabled services depend on the service
   * to be disabled. When set, the service, and any enabled services that depend on it, will be
   * disabled together.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean disableDependentServices;

  /**
   * Defines the behavior for checking service usage when disabling a service.
   * @return value or {@code null} for none
   */
  public java.lang.String getCheckIfServiceHasUsage() {
    return checkIfServiceHasUsage;
  }

  /**
   * Defines the behavior for checking service usage when disabling a service.
   * @param checkIfServiceHasUsage checkIfServiceHasUsage or {@code null} for none
   */
  public DisableServiceRequest setCheckIfServiceHasUsage(java.lang.String checkIfServiceHasUsage) {
    this.checkIfServiceHasUsage = checkIfServiceHasUsage;
    return this;
  }

  /**
   * Indicates if services that are enabled and which depend on this service should also be
   * disabled. If not set, an error will be generated if any enabled services depend on the service
   * to be disabled. When set, the service, and any enabled services that depend on it, will be
   * disabled together.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getDisableDependentServices() {
    return disableDependentServices;
  }

  /**
   * Indicates if services that are enabled and which depend on this service should also be
   * disabled. If not set, an error will be generated if any enabled services depend on the service
   * to be disabled. When set, the service, and any enabled services that depend on it, will be
   * disabled together.
   * @param disableDependentServices disableDependentServices or {@code null} for none
   */
  public DisableServiceRequest setDisableDependentServices(java.lang.Boolean disableDependentServices) {
    this.disableDependentServices = disableDependentServices;
    return this;
  }

  @Override
  public DisableServiceRequest set(String fieldName, Object value) {
    return (DisableServiceRequest) super.set(fieldName, value);
  }

  @Override
  public DisableServiceRequest clone() {
    return (DisableServiceRequest) super.clone();
  }

}
