/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.serviceusage.v1.model;

/**
 * Response message for getting service identity.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Service Usage API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class GoogleApiServiceusageV1beta1GetServiceIdentityResponse extends com.google.api.client.json.GenericJson {

  /**
   * Service identity that service producer can use to access consumer resources. If exists is true,
   * it contains email and unique_id. If exists is false, it contains pre-constructed email and
   * empty unique_id.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private GoogleApiServiceusageV1beta1ServiceIdentity identity;

  /**
   * Service identity state.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String state;

  /**
   * Service identity that service producer can use to access consumer resources. If exists is true,
   * it contains email and unique_id. If exists is false, it contains pre-constructed email and
   * empty unique_id.
   * @return value or {@code null} for none
   */
  public GoogleApiServiceusageV1beta1ServiceIdentity getIdentity() {
    return identity;
  }

  /**
   * Service identity that service producer can use to access consumer resources. If exists is true,
   * it contains email and unique_id. If exists is false, it contains pre-constructed email and
   * empty unique_id.
   * @param identity identity or {@code null} for none
   */
  public GoogleApiServiceusageV1beta1GetServiceIdentityResponse setIdentity(GoogleApiServiceusageV1beta1ServiceIdentity identity) {
    this.identity = identity;
    return this;
  }

  /**
   * Service identity state.
   * @return value or {@code null} for none
   */
  public java.lang.String getState() {
    return state;
  }

  /**
   * Service identity state.
   * @param state state or {@code null} for none
   */
  public GoogleApiServiceusageV1beta1GetServiceIdentityResponse setState(java.lang.String state) {
    this.state = state;
    return this;
  }

  @Override
  public GoogleApiServiceusageV1beta1GetServiceIdentityResponse set(String fieldName, Object value) {
    return (GoogleApiServiceusageV1beta1GetServiceIdentityResponse) super.set(fieldName, value);
  }

  @Override
  public GoogleApiServiceusageV1beta1GetServiceIdentityResponse clone() {
    return (GoogleApiServiceusageV1beta1GetServiceIdentityResponse) super.clone();
  }

}
