/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.serviceusage.v1.model;

/**
 * Define a parameter's name and location. The parameter may be passed as either an HTTP header or a
 * URL query parameter, and if both are passed the behavior is implementation-dependent.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Service Usage API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class SystemParameter extends com.google.api.client.json.GenericJson {

  /**
   * Define the HTTP header name to use for the parameter. It is case insensitive.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String httpHeader;

  /**
   * Define the name of the parameter, such as "api_key" . It is case sensitive.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * Define the URL query parameter name to use for the parameter. It is case sensitive.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String urlQueryParameter;

  /**
   * Define the HTTP header name to use for the parameter. It is case insensitive.
   * @return value or {@code null} for none
   */
  public java.lang.String getHttpHeader() {
    return httpHeader;
  }

  /**
   * Define the HTTP header name to use for the parameter. It is case insensitive.
   * @param httpHeader httpHeader or {@code null} for none
   */
  public SystemParameter setHttpHeader(java.lang.String httpHeader) {
    this.httpHeader = httpHeader;
    return this;
  }

  /**
   * Define the name of the parameter, such as "api_key" . It is case sensitive.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Define the name of the parameter, such as "api_key" . It is case sensitive.
   * @param name name or {@code null} for none
   */
  public SystemParameter setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * Define the URL query parameter name to use for the parameter. It is case sensitive.
   * @return value or {@code null} for none
   */
  public java.lang.String getUrlQueryParameter() {
    return urlQueryParameter;
  }

  /**
   * Define the URL query parameter name to use for the parameter. It is case sensitive.
   * @param urlQueryParameter urlQueryParameter or {@code null} for none
   */
  public SystemParameter setUrlQueryParameter(java.lang.String urlQueryParameter) {
    this.urlQueryParameter = urlQueryParameter;
    return this;
  }

  @Override
  public SystemParameter set(String fieldName, Object value) {
    return (SystemParameter) super.set(fieldName, value);
  }

  @Override
  public SystemParameter clone() {
    return (SystemParameter) super.clone();
  }

}
