/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.serviceusage.v1;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.serviceusage.v1.ServiceUsageRequest;
import com.google.api.services.serviceusage.v1.ServiceUsageRequestInitializer;
import com.google.api.services.serviceusage.v1.model.BatchEnableServicesRequest;
import com.google.api.services.serviceusage.v1.model.BatchGetServicesResponse;
import com.google.api.services.serviceusage.v1.model.CancelOperationRequest;
import com.google.api.services.serviceusage.v1.model.DisableServiceRequest;
import com.google.api.services.serviceusage.v1.model.Empty;
import com.google.api.services.serviceusage.v1.model.EnableServiceRequest;
import com.google.api.services.serviceusage.v1.model.GoogleApiServiceusageV1Service;
import com.google.api.services.serviceusage.v1.model.ListOperationsResponse;
import com.google.api.services.serviceusage.v1.model.ListServicesResponse;
import com.google.api.services.serviceusage.v1.model.Operation;
import java.io.IOException;
import java.util.List;
import java.util.regex.Pattern;

public class ServiceUsage
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://serviceusage.googleapis.com/";
    public static final String DEFAULT_MTLS_ROOT_URL = "https://serviceusage.mtls.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "";
    public static final String DEFAULT_BATCH_PATH = "batch";
    public static final String DEFAULT_BASE_URL = "https://serviceusage.googleapis.com/";

    public ServiceUsage(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(transport, jsonFactory, httpRequestInitializer));
    }

    ServiceUsage(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> httpClientRequest) throws IOException {
        super.initialize(httpClientRequest);
    }

    public Operations operations() {
        return new Operations();
    }

    public Services services() {
        return new Services();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && (GoogleUtils.MINOR_VERSION >= 32 || GoogleUtils.MINOR_VERSION == 31 && GoogleUtils.BUGFIX_VERSION >= 1) || GoogleUtils.MAJOR_VERSION >= 2 ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.31.1 of google-api-client to run version 2.0.0 of the Service Usage API library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        private static String chooseEndpoint(HttpTransport transport) {
            String useMtlsEndpoint = System.getenv("GOOGLE_API_USE_MTLS_ENDPOINT");
            String string = useMtlsEndpoint = useMtlsEndpoint == null ? "auto" : useMtlsEndpoint;
            if ("always".equals(useMtlsEndpoint) || "auto".equals(useMtlsEndpoint) && transport != null && transport.isMtls()) {
                return ServiceUsage.DEFAULT_MTLS_ROOT_URL;
            }
            return "https://serviceusage.googleapis.com/";
        }

        public Builder(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(transport, jsonFactory, Builder.chooseEndpoint(transport), ServiceUsage.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
            this.setBatchPath(ServiceUsage.DEFAULT_BATCH_PATH);
        }

        public ServiceUsage build() {
            return new ServiceUsage(this);
        }

        public Builder setRootUrl(String rootUrl) {
            return (Builder)super.setRootUrl(rootUrl);
        }

        public Builder setServicePath(String servicePath) {
            return (Builder)super.setServicePath(servicePath);
        }

        public Builder setBatchPath(String batchPath) {
            return (Builder)super.setBatchPath(batchPath);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String applicationName) {
            return (Builder)super.setApplicationName(applicationName);
        }

        public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
            return (Builder)super.setSuppressPatternChecks(suppressPatternChecks);
        }

        public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
            return (Builder)super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
        }

        public Builder setSuppressAllChecks(boolean suppressAllChecks) {
            return (Builder)super.setSuppressAllChecks(suppressAllChecks);
        }

        public Builder setServiceUsageRequestInitializer(ServiceUsageRequestInitializer serviceusageRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)serviceusageRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }

        public Builder setUniverseDomain(String universeDomain) {
            return (Builder)super.setUniverseDomain(universeDomain);
        }
    }

    public class Services {
        public BatchEnable batchEnable(String parent, BatchEnableServicesRequest content) throws IOException {
            BatchEnable result = new BatchEnable(parent, content);
            ServiceUsage.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public BatchGet batchGet(String parent) throws IOException {
            BatchGet result = new BatchGet(parent);
            ServiceUsage.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Disable disable(String name, DisableServiceRequest content) throws IOException {
            Disable result = new Disable(name, content);
            ServiceUsage.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Enable enable(String name, EnableServiceRequest content) throws IOException {
            Enable result = new Enable(name, content);
            ServiceUsage.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(String name) throws IOException {
            Get result = new Get(name);
            ServiceUsage.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(String parent) throws IOException {
            List result = new List(parent);
            ServiceUsage.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class List
        extends ServiceUsageRequest<ListServicesResponse> {
            private static final String REST_PATH = "v1/{+parent}/services";
            private final Pattern PARENT_PATTERN;
            @Key
            private String parent;
            @Key
            private String filter;
            @Key
            private Integer pageSize;
            @Key
            private String pageToken;

            protected List(String parent) {
                super(ServiceUsage.this, "GET", REST_PATH, null, ListServicesResponse.class);
                this.PARENT_PATTERN = Pattern.compile("^[^/]+/[^/]+$");
                this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                if (!ServiceUsage.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^[^/]+/[^/]+$");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public String getParent() {
                return this.parent;
            }

            public List setParent(String parent) {
                if (!ServiceUsage.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^[^/]+/[^/]+$");
                }
                this.parent = parent;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public List setFilter(String filter) {
                this.filter = filter;
                return this;
            }

            public Integer getPageSize() {
                return this.pageSize;
            }

            public List setPageSize(Integer pageSize) {
                this.pageSize = pageSize;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Get
        extends ServiceUsageRequest<GoogleApiServiceusageV1Service> {
            private static final String REST_PATH = "v1/{+name}";
            private final Pattern NAME_PATTERN;
            @Key
            private String name;

            protected Get(String name) {
                super(ServiceUsage.this, "GET", REST_PATH, null, GoogleApiServiceusageV1Service.class);
                this.NAME_PATTERN = Pattern.compile("^[^/]+/[^/]+/services/[^/]+$");
                this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                if (!ServiceUsage.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^[^/]+/[^/]+/services/[^/]+$");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public String getName() {
                return this.name;
            }

            public Get setName(String name) {
                if (!ServiceUsage.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^[^/]+/[^/]+/services/[^/]+$");
                }
                this.name = name;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class Enable
        extends ServiceUsageRequest<Operation> {
            private static final String REST_PATH = "v1/{+name}:enable";
            private final Pattern NAME_PATTERN;
            @Key
            private String name;

            protected Enable(String name, EnableServiceRequest content) {
                super(ServiceUsage.this, "POST", REST_PATH, (Object)content, Operation.class);
                this.NAME_PATTERN = Pattern.compile("^[^/]+/[^/]+/services/[^/]+$");
                this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                if (!ServiceUsage.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^[^/]+/[^/]+/services/[^/]+$");
                }
            }

            public Enable set$Xgafv(String $Xgafv) {
                return (Enable)super.set$Xgafv($Xgafv);
            }

            public Enable setAccessToken(String accessToken) {
                return (Enable)super.setAccessToken(accessToken);
            }

            public Enable setAlt(String alt) {
                return (Enable)super.setAlt(alt);
            }

            public Enable setCallback(String callback) {
                return (Enable)super.setCallback(callback);
            }

            public Enable setFields(String fields) {
                return (Enable)super.setFields(fields);
            }

            public Enable setKey(String key) {
                return (Enable)super.setKey(key);
            }

            public Enable setOauthToken(String oauthToken) {
                return (Enable)super.setOauthToken(oauthToken);
            }

            public Enable setPrettyPrint(Boolean prettyPrint) {
                return (Enable)super.setPrettyPrint(prettyPrint);
            }

            public Enable setQuotaUser(String quotaUser) {
                return (Enable)super.setQuotaUser(quotaUser);
            }

            public Enable setUploadType(String uploadType) {
                return (Enable)super.setUploadType(uploadType);
            }

            public Enable setUploadProtocol(String uploadProtocol) {
                return (Enable)super.setUploadProtocol(uploadProtocol);
            }

            public String getName() {
                return this.name;
            }

            public Enable setName(String name) {
                if (!ServiceUsage.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^[^/]+/[^/]+/services/[^/]+$");
                }
                this.name = name;
                return this;
            }

            @Override
            public Enable set(String parameterName, Object value) {
                return (Enable)super.set(parameterName, value);
            }
        }

        public class Disable
        extends ServiceUsageRequest<Operation> {
            private static final String REST_PATH = "v1/{+name}:disable";
            private final Pattern NAME_PATTERN;
            @Key
            private String name;

            protected Disable(String name, DisableServiceRequest content) {
                super(ServiceUsage.this, "POST", REST_PATH, (Object)content, Operation.class);
                this.NAME_PATTERN = Pattern.compile("^[^/]+/[^/]+/services/[^/]+$");
                this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                if (!ServiceUsage.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^[^/]+/[^/]+/services/[^/]+$");
                }
            }

            public Disable set$Xgafv(String $Xgafv) {
                return (Disable)super.set$Xgafv($Xgafv);
            }

            public Disable setAccessToken(String accessToken) {
                return (Disable)super.setAccessToken(accessToken);
            }

            public Disable setAlt(String alt) {
                return (Disable)super.setAlt(alt);
            }

            public Disable setCallback(String callback) {
                return (Disable)super.setCallback(callback);
            }

            public Disable setFields(String fields) {
                return (Disable)super.setFields(fields);
            }

            public Disable setKey(String key) {
                return (Disable)super.setKey(key);
            }

            public Disable setOauthToken(String oauthToken) {
                return (Disable)super.setOauthToken(oauthToken);
            }

            public Disable setPrettyPrint(Boolean prettyPrint) {
                return (Disable)super.setPrettyPrint(prettyPrint);
            }

            public Disable setQuotaUser(String quotaUser) {
                return (Disable)super.setQuotaUser(quotaUser);
            }

            public Disable setUploadType(String uploadType) {
                return (Disable)super.setUploadType(uploadType);
            }

            public Disable setUploadProtocol(String uploadProtocol) {
                return (Disable)super.setUploadProtocol(uploadProtocol);
            }

            public String getName() {
                return this.name;
            }

            public Disable setName(String name) {
                if (!ServiceUsage.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^[^/]+/[^/]+/services/[^/]+$");
                }
                this.name = name;
                return this;
            }

            @Override
            public Disable set(String parameterName, Object value) {
                return (Disable)super.set(parameterName, value);
            }
        }

        public class BatchGet
        extends ServiceUsageRequest<BatchGetServicesResponse> {
            private static final String REST_PATH = "v1/{+parent}/services:batchGet";
            private final Pattern PARENT_PATTERN;
            @Key
            private String parent;
            @Key
            private java.util.List<String> names;

            protected BatchGet(String parent) {
                super(ServiceUsage.this, "GET", REST_PATH, null, BatchGetServicesResponse.class);
                this.PARENT_PATTERN = Pattern.compile("^[^/]+/[^/]+$");
                this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                if (!ServiceUsage.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^[^/]+/[^/]+$");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public BatchGet set$Xgafv(String $Xgafv) {
                return (BatchGet)super.set$Xgafv($Xgafv);
            }

            public BatchGet setAccessToken(String accessToken) {
                return (BatchGet)super.setAccessToken(accessToken);
            }

            public BatchGet setAlt(String alt) {
                return (BatchGet)super.setAlt(alt);
            }

            public BatchGet setCallback(String callback) {
                return (BatchGet)super.setCallback(callback);
            }

            public BatchGet setFields(String fields) {
                return (BatchGet)super.setFields(fields);
            }

            public BatchGet setKey(String key) {
                return (BatchGet)super.setKey(key);
            }

            public BatchGet setOauthToken(String oauthToken) {
                return (BatchGet)super.setOauthToken(oauthToken);
            }

            public BatchGet setPrettyPrint(Boolean prettyPrint) {
                return (BatchGet)super.setPrettyPrint(prettyPrint);
            }

            public BatchGet setQuotaUser(String quotaUser) {
                return (BatchGet)super.setQuotaUser(quotaUser);
            }

            public BatchGet setUploadType(String uploadType) {
                return (BatchGet)super.setUploadType(uploadType);
            }

            public BatchGet setUploadProtocol(String uploadProtocol) {
                return (BatchGet)super.setUploadProtocol(uploadProtocol);
            }

            public String getParent() {
                return this.parent;
            }

            public BatchGet setParent(String parent) {
                if (!ServiceUsage.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^[^/]+/[^/]+$");
                }
                this.parent = parent;
                return this;
            }

            public java.util.List<String> getNames() {
                return this.names;
            }

            public BatchGet setNames(java.util.List<String> names) {
                this.names = names;
                return this;
            }

            @Override
            public BatchGet set(String parameterName, Object value) {
                return (BatchGet)super.set(parameterName, value);
            }
        }

        public class BatchEnable
        extends ServiceUsageRequest<Operation> {
            private static final String REST_PATH = "v1/{+parent}/services:batchEnable";
            private final Pattern PARENT_PATTERN;
            @Key
            private String parent;

            protected BatchEnable(String parent, BatchEnableServicesRequest content) {
                super(ServiceUsage.this, "POST", REST_PATH, (Object)content, Operation.class);
                this.PARENT_PATTERN = Pattern.compile("^[^/]+/[^/]+$");
                this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                if (!ServiceUsage.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^[^/]+/[^/]+$");
                }
            }

            public BatchEnable set$Xgafv(String $Xgafv) {
                return (BatchEnable)super.set$Xgafv($Xgafv);
            }

            public BatchEnable setAccessToken(String accessToken) {
                return (BatchEnable)super.setAccessToken(accessToken);
            }

            public BatchEnable setAlt(String alt) {
                return (BatchEnable)super.setAlt(alt);
            }

            public BatchEnable setCallback(String callback) {
                return (BatchEnable)super.setCallback(callback);
            }

            public BatchEnable setFields(String fields) {
                return (BatchEnable)super.setFields(fields);
            }

            public BatchEnable setKey(String key) {
                return (BatchEnable)super.setKey(key);
            }

            public BatchEnable setOauthToken(String oauthToken) {
                return (BatchEnable)super.setOauthToken(oauthToken);
            }

            public BatchEnable setPrettyPrint(Boolean prettyPrint) {
                return (BatchEnable)super.setPrettyPrint(prettyPrint);
            }

            public BatchEnable setQuotaUser(String quotaUser) {
                return (BatchEnable)super.setQuotaUser(quotaUser);
            }

            public BatchEnable setUploadType(String uploadType) {
                return (BatchEnable)super.setUploadType(uploadType);
            }

            public BatchEnable setUploadProtocol(String uploadProtocol) {
                return (BatchEnable)super.setUploadProtocol(uploadProtocol);
            }

            public String getParent() {
                return this.parent;
            }

            public BatchEnable setParent(String parent) {
                if (!ServiceUsage.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^[^/]+/[^/]+$");
                }
                this.parent = parent;
                return this;
            }

            @Override
            public BatchEnable set(String parameterName, Object value) {
                return (BatchEnable)super.set(parameterName, value);
            }
        }
    }

    public class Operations {
        public Cancel cancel(String name, CancelOperationRequest content) throws IOException {
            Cancel result = new Cancel(name, content);
            ServiceUsage.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Delete delete(String name) throws IOException {
            Delete result = new Delete(name);
            ServiceUsage.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(String name) throws IOException {
            Get result = new Get(name);
            ServiceUsage.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list() throws IOException {
            List result = new List();
            ServiceUsage.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class List
        extends ServiceUsageRequest<ListOperationsResponse> {
            private static final String REST_PATH = "v1/operations";
            @Key
            private String filter;
            @Key
            private String name;
            @Key
            private Integer pageSize;
            @Key
            private String pageToken;

            protected List() {
                super(ServiceUsage.this, "GET", REST_PATH, null, ListOperationsResponse.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public String getFilter() {
                return this.filter;
            }

            public List setFilter(String filter) {
                this.filter = filter;
                return this;
            }

            public String getName() {
                return this.name;
            }

            public List setName(String name) {
                this.name = name;
                return this;
            }

            public Integer getPageSize() {
                return this.pageSize;
            }

            public List setPageSize(Integer pageSize) {
                this.pageSize = pageSize;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Get
        extends ServiceUsageRequest<Operation> {
            private static final String REST_PATH = "v1/{+name}";
            private final Pattern NAME_PATTERN;
            @Key
            private String name;

            protected Get(String name) {
                super(ServiceUsage.this, "GET", REST_PATH, null, Operation.class);
                this.NAME_PATTERN = Pattern.compile("^operations/[^/]+$");
                this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                if (!ServiceUsage.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^operations/[^/]+$");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public String getName() {
                return this.name;
            }

            public Get setName(String name) {
                if (!ServiceUsage.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^operations/[^/]+$");
                }
                this.name = name;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class Delete
        extends ServiceUsageRequest<Empty> {
            private static final String REST_PATH = "v1/{+name}";
            private final Pattern NAME_PATTERN;
            @Key
            private String name;

            protected Delete(String name) {
                super(ServiceUsage.this, "DELETE", REST_PATH, null, Empty.class);
                this.NAME_PATTERN = Pattern.compile("^operations/.*$");
                this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                if (!ServiceUsage.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^operations/.*$");
                }
            }

            public Delete set$Xgafv(String $Xgafv) {
                return (Delete)super.set$Xgafv($Xgafv);
            }

            public Delete setAccessToken(String accessToken) {
                return (Delete)super.setAccessToken(accessToken);
            }

            public Delete setAlt(String alt) {
                return (Delete)super.setAlt(alt);
            }

            public Delete setCallback(String callback) {
                return (Delete)super.setCallback(callback);
            }

            public Delete setFields(String fields) {
                return (Delete)super.setFields(fields);
            }

            public Delete setKey(String key) {
                return (Delete)super.setKey(key);
            }

            public Delete setOauthToken(String oauthToken) {
                return (Delete)super.setOauthToken(oauthToken);
            }

            public Delete setPrettyPrint(Boolean prettyPrint) {
                return (Delete)super.setPrettyPrint(prettyPrint);
            }

            public Delete setQuotaUser(String quotaUser) {
                return (Delete)super.setQuotaUser(quotaUser);
            }

            public Delete setUploadType(String uploadType) {
                return (Delete)super.setUploadType(uploadType);
            }

            public Delete setUploadProtocol(String uploadProtocol) {
                return (Delete)super.setUploadProtocol(uploadProtocol);
            }

            public String getName() {
                return this.name;
            }

            public Delete setName(String name) {
                if (!ServiceUsage.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^operations/.*$");
                }
                this.name = name;
                return this;
            }

            @Override
            public Delete set(String parameterName, Object value) {
                return (Delete)super.set(parameterName, value);
            }
        }

        public class Cancel
        extends ServiceUsageRequest<Empty> {
            private static final String REST_PATH = "v1/{+name}:cancel";
            private final Pattern NAME_PATTERN;
            @Key
            private String name;

            protected Cancel(String name, CancelOperationRequest content) {
                super(ServiceUsage.this, "POST", REST_PATH, (Object)content, Empty.class);
                this.NAME_PATTERN = Pattern.compile("^operations/.*$");
                this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                if (!ServiceUsage.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^operations/.*$");
                }
            }

            public Cancel set$Xgafv(String $Xgafv) {
                return (Cancel)super.set$Xgafv($Xgafv);
            }

            public Cancel setAccessToken(String accessToken) {
                return (Cancel)super.setAccessToken(accessToken);
            }

            public Cancel setAlt(String alt) {
                return (Cancel)super.setAlt(alt);
            }

            public Cancel setCallback(String callback) {
                return (Cancel)super.setCallback(callback);
            }

            public Cancel setFields(String fields) {
                return (Cancel)super.setFields(fields);
            }

            public Cancel setKey(String key) {
                return (Cancel)super.setKey(key);
            }

            public Cancel setOauthToken(String oauthToken) {
                return (Cancel)super.setOauthToken(oauthToken);
            }

            public Cancel setPrettyPrint(Boolean prettyPrint) {
                return (Cancel)super.setPrettyPrint(prettyPrint);
            }

            public Cancel setQuotaUser(String quotaUser) {
                return (Cancel)super.setQuotaUser(quotaUser);
            }

            public Cancel setUploadType(String uploadType) {
                return (Cancel)super.setUploadType(uploadType);
            }

            public Cancel setUploadProtocol(String uploadProtocol) {
                return (Cancel)super.setUploadProtocol(uploadProtocol);
            }

            public String getName() {
                return this.name;
            }

            public Cancel setName(String name) {
                if (!ServiceUsage.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^operations/.*$");
                }
                this.name = name;
                return this;
            }

            @Override
            public Cancel set(String parameterName, Object value) {
                return (Cancel)super.set(parameterName, value);
            }
        }
    }
}

