/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.serviceusage.v1beta1;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.serviceusage.v1beta1.ServiceUsageRequest;
import com.google.api.services.serviceusage.v1beta1.ServiceUsageRequestInitializer;
import com.google.api.services.serviceusage.v1beta1.model.BatchEnableServicesRequest;
import com.google.api.services.serviceusage.v1beta1.model.ConsumerQuotaLimit;
import com.google.api.services.serviceusage.v1beta1.model.ConsumerQuotaMetric;
import com.google.api.services.serviceusage.v1beta1.model.DisableServiceRequest;
import com.google.api.services.serviceusage.v1beta1.model.EnableServiceRequest;
import com.google.api.services.serviceusage.v1beta1.model.ImportAdminOverridesRequest;
import com.google.api.services.serviceusage.v1beta1.model.ImportConsumerOverridesRequest;
import com.google.api.services.serviceusage.v1beta1.model.ListAdminOverridesResponse;
import com.google.api.services.serviceusage.v1beta1.model.ListConsumerOverridesResponse;
import com.google.api.services.serviceusage.v1beta1.model.ListConsumerQuotaMetricsResponse;
import com.google.api.services.serviceusage.v1beta1.model.ListOperationsResponse;
import com.google.api.services.serviceusage.v1beta1.model.ListServicesResponse;
import com.google.api.services.serviceusage.v1beta1.model.Operation;
import com.google.api.services.serviceusage.v1beta1.model.QuotaOverride;
import com.google.api.services.serviceusage.v1beta1.model.Service;
import java.io.IOException;
import java.util.List;
import java.util.regex.Pattern;

public class ServiceUsage
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://serviceusage.googleapis.com/";
    public static final String DEFAULT_MTLS_ROOT_URL = "https://serviceusage.mtls.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "";
    public static final String DEFAULT_BATCH_PATH = "batch";
    public static final String DEFAULT_BASE_URL = "https://serviceusage.googleapis.com/";

    public ServiceUsage(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(transport, jsonFactory, httpRequestInitializer));
    }

    ServiceUsage(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> httpClientRequest) throws IOException {
        super.initialize(httpClientRequest);
    }

    public Operations operations() {
        return new Operations();
    }

    public Services services() {
        return new Services();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && (GoogleUtils.MINOR_VERSION >= 32 || GoogleUtils.MINOR_VERSION == 31 && GoogleUtils.BUGFIX_VERSION >= 1) || GoogleUtils.MAJOR_VERSION >= 2 ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.31.1 of google-api-client to run version 2.0.0 of the Service Usage API library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        private static String chooseEndpoint(HttpTransport transport) {
            String useMtlsEndpoint = System.getenv("GOOGLE_API_USE_MTLS_ENDPOINT");
            String string = useMtlsEndpoint = useMtlsEndpoint == null ? "auto" : useMtlsEndpoint;
            if ("always".equals(useMtlsEndpoint) || "auto".equals(useMtlsEndpoint) && transport != null && transport.isMtls()) {
                return ServiceUsage.DEFAULT_MTLS_ROOT_URL;
            }
            return "https://serviceusage.googleapis.com/";
        }

        public Builder(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(transport, jsonFactory, Builder.chooseEndpoint(transport), ServiceUsage.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
            this.setBatchPath(ServiceUsage.DEFAULT_BATCH_PATH);
        }

        public ServiceUsage build() {
            return new ServiceUsage(this);
        }

        public Builder setRootUrl(String rootUrl) {
            return (Builder)super.setRootUrl(rootUrl);
        }

        public Builder setServicePath(String servicePath) {
            return (Builder)super.setServicePath(servicePath);
        }

        public Builder setBatchPath(String batchPath) {
            return (Builder)super.setBatchPath(batchPath);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String applicationName) {
            return (Builder)super.setApplicationName(applicationName);
        }

        public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
            return (Builder)super.setSuppressPatternChecks(suppressPatternChecks);
        }

        public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
            return (Builder)super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
        }

        public Builder setSuppressAllChecks(boolean suppressAllChecks) {
            return (Builder)super.setSuppressAllChecks(suppressAllChecks);
        }

        public Builder setServiceUsageRequestInitializer(ServiceUsageRequestInitializer serviceusageRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)serviceusageRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }

        public Builder setUniverseDomain(String universeDomain) {
            return (Builder)super.setUniverseDomain(universeDomain);
        }
    }

    public class Services {
        public BatchEnable batchEnable(String parent, BatchEnableServicesRequest content) throws IOException {
            BatchEnable result = new BatchEnable(parent, content);
            ServiceUsage.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Disable disable(String name, DisableServiceRequest content) throws IOException {
            Disable result = new Disable(name, content);
            ServiceUsage.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Enable enable(String name, EnableServiceRequest content) throws IOException {
            Enable result = new Enable(name, content);
            ServiceUsage.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public GenerateServiceIdentity generateServiceIdentity(String parent) throws IOException {
            GenerateServiceIdentity result = new GenerateServiceIdentity(parent);
            ServiceUsage.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(String name) throws IOException {
            Get result = new Get(name);
            ServiceUsage.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(String parent) throws IOException {
            List result = new List(parent);
            ServiceUsage.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public ConsumerQuotaMetrics consumerQuotaMetrics() {
            return new ConsumerQuotaMetrics();
        }

        public class ConsumerQuotaMetrics {
            public Get get(String name) throws IOException {
                Get result = new Get(name);
                ServiceUsage.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public ImportAdminOverrides importAdminOverrides(String parent, ImportAdminOverridesRequest content) throws IOException {
                ImportAdminOverrides result = new ImportAdminOverrides(parent, content);
                ServiceUsage.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public ImportConsumerOverrides importConsumerOverrides(String parent, ImportConsumerOverridesRequest content) throws IOException {
                ImportConsumerOverrides result = new ImportConsumerOverrides(parent, content);
                ServiceUsage.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public List list(String parent) throws IOException {
                List result = new List(parent);
                ServiceUsage.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Limits limits() {
                return new Limits();
            }

            public class Limits {
                public Get get(String name) throws IOException {
                    Get result = new Get(name);
                    ServiceUsage.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public AdminOverrides adminOverrides() {
                    return new AdminOverrides();
                }

                public ConsumerOverrides consumerOverrides() {
                    return new ConsumerOverrides();
                }

                public class ConsumerOverrides {
                    public Create create(String parent, QuotaOverride content) throws IOException {
                        Create result = new Create(parent, content);
                        ServiceUsage.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public Delete delete(String name) throws IOException {
                        Delete result = new Delete(name);
                        ServiceUsage.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public List list(String parent) throws IOException {
                        List result = new List(parent);
                        ServiceUsage.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public Patch patch(String name, QuotaOverride content) throws IOException {
                        Patch result = new Patch(name, content);
                        ServiceUsage.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public class Patch
                    extends ServiceUsageRequest<Operation> {
                        private static final String REST_PATH = "v1beta1/{+name}";
                        private final Pattern NAME_PATTERN;
                        @Key
                        private String name;
                        @Key
                        private Boolean force;
                        @Key
                        private java.util.List<String> forceOnly;
                        @Key
                        private String updateMask;

                        protected Patch(String name, QuotaOverride content) {
                            super(ServiceUsage.this, "PATCH", REST_PATH, (Object)content, Operation.class);
                            this.NAME_PATTERN = Pattern.compile("^[^/]+/[^/]+/services/[^/]+/consumerQuotaMetrics/[^/]+/limits/[^/]+/consumerOverrides/[^/]+$");
                            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                            if (!ServiceUsage.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^[^/]+/[^/]+/services/[^/]+/consumerQuotaMetrics/[^/]+/limits/[^/]+/consumerOverrides/[^/]+$");
                            }
                        }

                        public Patch set$Xgafv(String $Xgafv) {
                            return (Patch)super.set$Xgafv($Xgafv);
                        }

                        public Patch setAccessToken(String accessToken) {
                            return (Patch)super.setAccessToken(accessToken);
                        }

                        public Patch setAlt(String alt) {
                            return (Patch)super.setAlt(alt);
                        }

                        public Patch setCallback(String callback) {
                            return (Patch)super.setCallback(callback);
                        }

                        public Patch setFields(String fields) {
                            return (Patch)super.setFields(fields);
                        }

                        public Patch setKey(String key) {
                            return (Patch)super.setKey(key);
                        }

                        public Patch setOauthToken(String oauthToken) {
                            return (Patch)super.setOauthToken(oauthToken);
                        }

                        public Patch setPrettyPrint(Boolean prettyPrint) {
                            return (Patch)super.setPrettyPrint(prettyPrint);
                        }

                        public Patch setQuotaUser(String quotaUser) {
                            return (Patch)super.setQuotaUser(quotaUser);
                        }

                        public Patch setUploadType(String uploadType) {
                            return (Patch)super.setUploadType(uploadType);
                        }

                        public Patch setUploadProtocol(String uploadProtocol) {
                            return (Patch)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getName() {
                            return this.name;
                        }

                        public Patch setName(String name) {
                            if (!ServiceUsage.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^[^/]+/[^/]+/services/[^/]+/consumerQuotaMetrics/[^/]+/limits/[^/]+/consumerOverrides/[^/]+$");
                            }
                            this.name = name;
                            return this;
                        }

                        public Boolean getForce() {
                            return this.force;
                        }

                        public Patch setForce(Boolean force) {
                            this.force = force;
                            return this;
                        }

                        public java.util.List<String> getForceOnly() {
                            return this.forceOnly;
                        }

                        public Patch setForceOnly(java.util.List<String> forceOnly) {
                            this.forceOnly = forceOnly;
                            return this;
                        }

                        public String getUpdateMask() {
                            return this.updateMask;
                        }

                        public Patch setUpdateMask(String updateMask) {
                            this.updateMask = updateMask;
                            return this;
                        }

                        @Override
                        public Patch set(String parameterName, Object value) {
                            return (Patch)super.set(parameterName, value);
                        }
                    }

                    public class List
                    extends ServiceUsageRequest<ListConsumerOverridesResponse> {
                        private static final String REST_PATH = "v1beta1/{+parent}/consumerOverrides";
                        private final Pattern PARENT_PATTERN;
                        @Key
                        private String parent;
                        @Key
                        private Integer pageSize;
                        @Key
                        private String pageToken;

                        protected List(String parent) {
                            super(ServiceUsage.this, "GET", REST_PATH, null, ListConsumerOverridesResponse.class);
                            this.PARENT_PATTERN = Pattern.compile("^[^/]+/[^/]+/services/[^/]+/consumerQuotaMetrics/[^/]+/limits/[^/]+$");
                            this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                            if (!ServiceUsage.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^[^/]+/[^/]+/services/[^/]+/consumerQuotaMetrics/[^/]+/limits/[^/]+$");
                            }
                        }

                        public HttpResponse executeUsingHead() throws IOException {
                            return super.executeUsingHead();
                        }

                        public HttpRequest buildHttpRequestUsingHead() throws IOException {
                            return super.buildHttpRequestUsingHead();
                        }

                        public List set$Xgafv(String $Xgafv) {
                            return (List)super.set$Xgafv($Xgafv);
                        }

                        public List setAccessToken(String accessToken) {
                            return (List)super.setAccessToken(accessToken);
                        }

                        public List setAlt(String alt) {
                            return (List)super.setAlt(alt);
                        }

                        public List setCallback(String callback) {
                            return (List)super.setCallback(callback);
                        }

                        public List setFields(String fields) {
                            return (List)super.setFields(fields);
                        }

                        public List setKey(String key) {
                            return (List)super.setKey(key);
                        }

                        public List setOauthToken(String oauthToken) {
                            return (List)super.setOauthToken(oauthToken);
                        }

                        public List setPrettyPrint(Boolean prettyPrint) {
                            return (List)super.setPrettyPrint(prettyPrint);
                        }

                        public List setQuotaUser(String quotaUser) {
                            return (List)super.setQuotaUser(quotaUser);
                        }

                        public List setUploadType(String uploadType) {
                            return (List)super.setUploadType(uploadType);
                        }

                        public List setUploadProtocol(String uploadProtocol) {
                            return (List)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getParent() {
                            return this.parent;
                        }

                        public List setParent(String parent) {
                            if (!ServiceUsage.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^[^/]+/[^/]+/services/[^/]+/consumerQuotaMetrics/[^/]+/limits/[^/]+$");
                            }
                            this.parent = parent;
                            return this;
                        }

                        public Integer getPageSize() {
                            return this.pageSize;
                        }

                        public List setPageSize(Integer pageSize) {
                            this.pageSize = pageSize;
                            return this;
                        }

                        public String getPageToken() {
                            return this.pageToken;
                        }

                        public List setPageToken(String pageToken) {
                            this.pageToken = pageToken;
                            return this;
                        }

                        @Override
                        public List set(String parameterName, Object value) {
                            return (List)super.set(parameterName, value);
                        }
                    }

                    public class Delete
                    extends ServiceUsageRequest<Operation> {
                        private static final String REST_PATH = "v1beta1/{+name}";
                        private final Pattern NAME_PATTERN;
                        @Key
                        private String name;
                        @Key
                        private Boolean force;
                        @Key
                        private java.util.List<String> forceOnly;

                        protected Delete(String name) {
                            super(ServiceUsage.this, "DELETE", REST_PATH, null, Operation.class);
                            this.NAME_PATTERN = Pattern.compile("^[^/]+/[^/]+/services/[^/]+/consumerQuotaMetrics/[^/]+/limits/[^/]+/consumerOverrides/[^/]+$");
                            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                            if (!ServiceUsage.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^[^/]+/[^/]+/services/[^/]+/consumerQuotaMetrics/[^/]+/limits/[^/]+/consumerOverrides/[^/]+$");
                            }
                        }

                        public Delete set$Xgafv(String $Xgafv) {
                            return (Delete)super.set$Xgafv($Xgafv);
                        }

                        public Delete setAccessToken(String accessToken) {
                            return (Delete)super.setAccessToken(accessToken);
                        }

                        public Delete setAlt(String alt) {
                            return (Delete)super.setAlt(alt);
                        }

                        public Delete setCallback(String callback) {
                            return (Delete)super.setCallback(callback);
                        }

                        public Delete setFields(String fields) {
                            return (Delete)super.setFields(fields);
                        }

                        public Delete setKey(String key) {
                            return (Delete)super.setKey(key);
                        }

                        public Delete setOauthToken(String oauthToken) {
                            return (Delete)super.setOauthToken(oauthToken);
                        }

                        public Delete setPrettyPrint(Boolean prettyPrint) {
                            return (Delete)super.setPrettyPrint(prettyPrint);
                        }

                        public Delete setQuotaUser(String quotaUser) {
                            return (Delete)super.setQuotaUser(quotaUser);
                        }

                        public Delete setUploadType(String uploadType) {
                            return (Delete)super.setUploadType(uploadType);
                        }

                        public Delete setUploadProtocol(String uploadProtocol) {
                            return (Delete)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getName() {
                            return this.name;
                        }

                        public Delete setName(String name) {
                            if (!ServiceUsage.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^[^/]+/[^/]+/services/[^/]+/consumerQuotaMetrics/[^/]+/limits/[^/]+/consumerOverrides/[^/]+$");
                            }
                            this.name = name;
                            return this;
                        }

                        public Boolean getForce() {
                            return this.force;
                        }

                        public Delete setForce(Boolean force) {
                            this.force = force;
                            return this;
                        }

                        public java.util.List<String> getForceOnly() {
                            return this.forceOnly;
                        }

                        public Delete setForceOnly(java.util.List<String> forceOnly) {
                            this.forceOnly = forceOnly;
                            return this;
                        }

                        @Override
                        public Delete set(String parameterName, Object value) {
                            return (Delete)super.set(parameterName, value);
                        }
                    }

                    public class Create
                    extends ServiceUsageRequest<Operation> {
                        private static final String REST_PATH = "v1beta1/{+parent}/consumerOverrides";
                        private final Pattern PARENT_PATTERN;
                        @Key
                        private String parent;
                        @Key
                        private Boolean force;
                        @Key
                        private java.util.List<String> forceOnly;

                        protected Create(String parent, QuotaOverride content) {
                            super(ServiceUsage.this, "POST", REST_PATH, (Object)content, Operation.class);
                            this.PARENT_PATTERN = Pattern.compile("^[^/]+/[^/]+/services/[^/]+/consumerQuotaMetrics/[^/]+/limits/[^/]+$");
                            this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                            if (!ServiceUsage.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^[^/]+/[^/]+/services/[^/]+/consumerQuotaMetrics/[^/]+/limits/[^/]+$");
                            }
                        }

                        public Create set$Xgafv(String $Xgafv) {
                            return (Create)super.set$Xgafv($Xgafv);
                        }

                        public Create setAccessToken(String accessToken) {
                            return (Create)super.setAccessToken(accessToken);
                        }

                        public Create setAlt(String alt) {
                            return (Create)super.setAlt(alt);
                        }

                        public Create setCallback(String callback) {
                            return (Create)super.setCallback(callback);
                        }

                        public Create setFields(String fields) {
                            return (Create)super.setFields(fields);
                        }

                        public Create setKey(String key) {
                            return (Create)super.setKey(key);
                        }

                        public Create setOauthToken(String oauthToken) {
                            return (Create)super.setOauthToken(oauthToken);
                        }

                        public Create setPrettyPrint(Boolean prettyPrint) {
                            return (Create)super.setPrettyPrint(prettyPrint);
                        }

                        public Create setQuotaUser(String quotaUser) {
                            return (Create)super.setQuotaUser(quotaUser);
                        }

                        public Create setUploadType(String uploadType) {
                            return (Create)super.setUploadType(uploadType);
                        }

                        public Create setUploadProtocol(String uploadProtocol) {
                            return (Create)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getParent() {
                            return this.parent;
                        }

                        public Create setParent(String parent) {
                            if (!ServiceUsage.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^[^/]+/[^/]+/services/[^/]+/consumerQuotaMetrics/[^/]+/limits/[^/]+$");
                            }
                            this.parent = parent;
                            return this;
                        }

                        public Boolean getForce() {
                            return this.force;
                        }

                        public Create setForce(Boolean force) {
                            this.force = force;
                            return this;
                        }

                        public java.util.List<String> getForceOnly() {
                            return this.forceOnly;
                        }

                        public Create setForceOnly(java.util.List<String> forceOnly) {
                            this.forceOnly = forceOnly;
                            return this;
                        }

                        @Override
                        public Create set(String parameterName, Object value) {
                            return (Create)super.set(parameterName, value);
                        }
                    }
                }

                public class AdminOverrides {
                    public Create create(String parent, QuotaOverride content) throws IOException {
                        Create result = new Create(parent, content);
                        ServiceUsage.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public Delete delete(String name) throws IOException {
                        Delete result = new Delete(name);
                        ServiceUsage.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public List list(String parent) throws IOException {
                        List result = new List(parent);
                        ServiceUsage.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public Patch patch(String name, QuotaOverride content) throws IOException {
                        Patch result = new Patch(name, content);
                        ServiceUsage.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public class Patch
                    extends ServiceUsageRequest<Operation> {
                        private static final String REST_PATH = "v1beta1/{+name}";
                        private final Pattern NAME_PATTERN;
                        @Key
                        private String name;
                        @Key
                        private Boolean force;
                        @Key
                        private java.util.List<String> forceOnly;
                        @Key
                        private String updateMask;

                        protected Patch(String name, QuotaOverride content) {
                            super(ServiceUsage.this, "PATCH", REST_PATH, (Object)content, Operation.class);
                            this.NAME_PATTERN = Pattern.compile("^[^/]+/[^/]+/services/[^/]+/consumerQuotaMetrics/[^/]+/limits/[^/]+/adminOverrides/[^/]+$");
                            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                            if (!ServiceUsage.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^[^/]+/[^/]+/services/[^/]+/consumerQuotaMetrics/[^/]+/limits/[^/]+/adminOverrides/[^/]+$");
                            }
                        }

                        public Patch set$Xgafv(String $Xgafv) {
                            return (Patch)super.set$Xgafv($Xgafv);
                        }

                        public Patch setAccessToken(String accessToken) {
                            return (Patch)super.setAccessToken(accessToken);
                        }

                        public Patch setAlt(String alt) {
                            return (Patch)super.setAlt(alt);
                        }

                        public Patch setCallback(String callback) {
                            return (Patch)super.setCallback(callback);
                        }

                        public Patch setFields(String fields) {
                            return (Patch)super.setFields(fields);
                        }

                        public Patch setKey(String key) {
                            return (Patch)super.setKey(key);
                        }

                        public Patch setOauthToken(String oauthToken) {
                            return (Patch)super.setOauthToken(oauthToken);
                        }

                        public Patch setPrettyPrint(Boolean prettyPrint) {
                            return (Patch)super.setPrettyPrint(prettyPrint);
                        }

                        public Patch setQuotaUser(String quotaUser) {
                            return (Patch)super.setQuotaUser(quotaUser);
                        }

                        public Patch setUploadType(String uploadType) {
                            return (Patch)super.setUploadType(uploadType);
                        }

                        public Patch setUploadProtocol(String uploadProtocol) {
                            return (Patch)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getName() {
                            return this.name;
                        }

                        public Patch setName(String name) {
                            if (!ServiceUsage.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^[^/]+/[^/]+/services/[^/]+/consumerQuotaMetrics/[^/]+/limits/[^/]+/adminOverrides/[^/]+$");
                            }
                            this.name = name;
                            return this;
                        }

                        public Boolean getForce() {
                            return this.force;
                        }

                        public Patch setForce(Boolean force) {
                            this.force = force;
                            return this;
                        }

                        public java.util.List<String> getForceOnly() {
                            return this.forceOnly;
                        }

                        public Patch setForceOnly(java.util.List<String> forceOnly) {
                            this.forceOnly = forceOnly;
                            return this;
                        }

                        public String getUpdateMask() {
                            return this.updateMask;
                        }

                        public Patch setUpdateMask(String updateMask) {
                            this.updateMask = updateMask;
                            return this;
                        }

                        @Override
                        public Patch set(String parameterName, Object value) {
                            return (Patch)super.set(parameterName, value);
                        }
                    }

                    public class List
                    extends ServiceUsageRequest<ListAdminOverridesResponse> {
                        private static final String REST_PATH = "v1beta1/{+parent}/adminOverrides";
                        private final Pattern PARENT_PATTERN;
                        @Key
                        private String parent;
                        @Key
                        private Integer pageSize;
                        @Key
                        private String pageToken;

                        protected List(String parent) {
                            super(ServiceUsage.this, "GET", REST_PATH, null, ListAdminOverridesResponse.class);
                            this.PARENT_PATTERN = Pattern.compile("^[^/]+/[^/]+/services/[^/]+/consumerQuotaMetrics/[^/]+/limits/[^/]+$");
                            this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                            if (!ServiceUsage.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^[^/]+/[^/]+/services/[^/]+/consumerQuotaMetrics/[^/]+/limits/[^/]+$");
                            }
                        }

                        public HttpResponse executeUsingHead() throws IOException {
                            return super.executeUsingHead();
                        }

                        public HttpRequest buildHttpRequestUsingHead() throws IOException {
                            return super.buildHttpRequestUsingHead();
                        }

                        public List set$Xgafv(String $Xgafv) {
                            return (List)super.set$Xgafv($Xgafv);
                        }

                        public List setAccessToken(String accessToken) {
                            return (List)super.setAccessToken(accessToken);
                        }

                        public List setAlt(String alt) {
                            return (List)super.setAlt(alt);
                        }

                        public List setCallback(String callback) {
                            return (List)super.setCallback(callback);
                        }

                        public List setFields(String fields) {
                            return (List)super.setFields(fields);
                        }

                        public List setKey(String key) {
                            return (List)super.setKey(key);
                        }

                        public List setOauthToken(String oauthToken) {
                            return (List)super.setOauthToken(oauthToken);
                        }

                        public List setPrettyPrint(Boolean prettyPrint) {
                            return (List)super.setPrettyPrint(prettyPrint);
                        }

                        public List setQuotaUser(String quotaUser) {
                            return (List)super.setQuotaUser(quotaUser);
                        }

                        public List setUploadType(String uploadType) {
                            return (List)super.setUploadType(uploadType);
                        }

                        public List setUploadProtocol(String uploadProtocol) {
                            return (List)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getParent() {
                            return this.parent;
                        }

                        public List setParent(String parent) {
                            if (!ServiceUsage.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^[^/]+/[^/]+/services/[^/]+/consumerQuotaMetrics/[^/]+/limits/[^/]+$");
                            }
                            this.parent = parent;
                            return this;
                        }

                        public Integer getPageSize() {
                            return this.pageSize;
                        }

                        public List setPageSize(Integer pageSize) {
                            this.pageSize = pageSize;
                            return this;
                        }

                        public String getPageToken() {
                            return this.pageToken;
                        }

                        public List setPageToken(String pageToken) {
                            this.pageToken = pageToken;
                            return this;
                        }

                        @Override
                        public List set(String parameterName, Object value) {
                            return (List)super.set(parameterName, value);
                        }
                    }

                    public class Delete
                    extends ServiceUsageRequest<Operation> {
                        private static final String REST_PATH = "v1beta1/{+name}";
                        private final Pattern NAME_PATTERN;
                        @Key
                        private String name;
                        @Key
                        private Boolean force;
                        @Key
                        private java.util.List<String> forceOnly;

                        protected Delete(String name) {
                            super(ServiceUsage.this, "DELETE", REST_PATH, null, Operation.class);
                            this.NAME_PATTERN = Pattern.compile("^[^/]+/[^/]+/services/[^/]+/consumerQuotaMetrics/[^/]+/limits/[^/]+/adminOverrides/[^/]+$");
                            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                            if (!ServiceUsage.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^[^/]+/[^/]+/services/[^/]+/consumerQuotaMetrics/[^/]+/limits/[^/]+/adminOverrides/[^/]+$");
                            }
                        }

                        public Delete set$Xgafv(String $Xgafv) {
                            return (Delete)super.set$Xgafv($Xgafv);
                        }

                        public Delete setAccessToken(String accessToken) {
                            return (Delete)super.setAccessToken(accessToken);
                        }

                        public Delete setAlt(String alt) {
                            return (Delete)super.setAlt(alt);
                        }

                        public Delete setCallback(String callback) {
                            return (Delete)super.setCallback(callback);
                        }

                        public Delete setFields(String fields) {
                            return (Delete)super.setFields(fields);
                        }

                        public Delete setKey(String key) {
                            return (Delete)super.setKey(key);
                        }

                        public Delete setOauthToken(String oauthToken) {
                            return (Delete)super.setOauthToken(oauthToken);
                        }

                        public Delete setPrettyPrint(Boolean prettyPrint) {
                            return (Delete)super.setPrettyPrint(prettyPrint);
                        }

                        public Delete setQuotaUser(String quotaUser) {
                            return (Delete)super.setQuotaUser(quotaUser);
                        }

                        public Delete setUploadType(String uploadType) {
                            return (Delete)super.setUploadType(uploadType);
                        }

                        public Delete setUploadProtocol(String uploadProtocol) {
                            return (Delete)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getName() {
                            return this.name;
                        }

                        public Delete setName(String name) {
                            if (!ServiceUsage.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^[^/]+/[^/]+/services/[^/]+/consumerQuotaMetrics/[^/]+/limits/[^/]+/adminOverrides/[^/]+$");
                            }
                            this.name = name;
                            return this;
                        }

                        public Boolean getForce() {
                            return this.force;
                        }

                        public Delete setForce(Boolean force) {
                            this.force = force;
                            return this;
                        }

                        public java.util.List<String> getForceOnly() {
                            return this.forceOnly;
                        }

                        public Delete setForceOnly(java.util.List<String> forceOnly) {
                            this.forceOnly = forceOnly;
                            return this;
                        }

                        @Override
                        public Delete set(String parameterName, Object value) {
                            return (Delete)super.set(parameterName, value);
                        }
                    }

                    public class Create
                    extends ServiceUsageRequest<Operation> {
                        private static final String REST_PATH = "v1beta1/{+parent}/adminOverrides";
                        private final Pattern PARENT_PATTERN;
                        @Key
                        private String parent;
                        @Key
                        private Boolean force;
                        @Key
                        private java.util.List<String> forceOnly;

                        protected Create(String parent, QuotaOverride content) {
                            super(ServiceUsage.this, "POST", REST_PATH, (Object)content, Operation.class);
                            this.PARENT_PATTERN = Pattern.compile("^[^/]+/[^/]+/services/[^/]+/consumerQuotaMetrics/[^/]+/limits/[^/]+$");
                            this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                            if (!ServiceUsage.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^[^/]+/[^/]+/services/[^/]+/consumerQuotaMetrics/[^/]+/limits/[^/]+$");
                            }
                        }

                        public Create set$Xgafv(String $Xgafv) {
                            return (Create)super.set$Xgafv($Xgafv);
                        }

                        public Create setAccessToken(String accessToken) {
                            return (Create)super.setAccessToken(accessToken);
                        }

                        public Create setAlt(String alt) {
                            return (Create)super.setAlt(alt);
                        }

                        public Create setCallback(String callback) {
                            return (Create)super.setCallback(callback);
                        }

                        public Create setFields(String fields) {
                            return (Create)super.setFields(fields);
                        }

                        public Create setKey(String key) {
                            return (Create)super.setKey(key);
                        }

                        public Create setOauthToken(String oauthToken) {
                            return (Create)super.setOauthToken(oauthToken);
                        }

                        public Create setPrettyPrint(Boolean prettyPrint) {
                            return (Create)super.setPrettyPrint(prettyPrint);
                        }

                        public Create setQuotaUser(String quotaUser) {
                            return (Create)super.setQuotaUser(quotaUser);
                        }

                        public Create setUploadType(String uploadType) {
                            return (Create)super.setUploadType(uploadType);
                        }

                        public Create setUploadProtocol(String uploadProtocol) {
                            return (Create)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getParent() {
                            return this.parent;
                        }

                        public Create setParent(String parent) {
                            if (!ServiceUsage.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^[^/]+/[^/]+/services/[^/]+/consumerQuotaMetrics/[^/]+/limits/[^/]+$");
                            }
                            this.parent = parent;
                            return this;
                        }

                        public Boolean getForce() {
                            return this.force;
                        }

                        public Create setForce(Boolean force) {
                            this.force = force;
                            return this;
                        }

                        public java.util.List<String> getForceOnly() {
                            return this.forceOnly;
                        }

                        public Create setForceOnly(java.util.List<String> forceOnly) {
                            this.forceOnly = forceOnly;
                            return this;
                        }

                        @Override
                        public Create set(String parameterName, Object value) {
                            return (Create)super.set(parameterName, value);
                        }
                    }
                }

                public class Get
                extends ServiceUsageRequest<ConsumerQuotaLimit> {
                    private static final String REST_PATH = "v1beta1/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;
                    @Key
                    private String view;

                    protected Get(String name) {
                        super(ServiceUsage.this, "GET", REST_PATH, null, ConsumerQuotaLimit.class);
                        this.NAME_PATTERN = Pattern.compile("^[^/]+/[^/]+/services/[^/]+/consumerQuotaMetrics/[^/]+/limits/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!ServiceUsage.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^[^/]+/[^/]+/services/[^/]+/consumerQuotaMetrics/[^/]+/limits/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public Get set$Xgafv(String $Xgafv) {
                        return (Get)super.set$Xgafv($Xgafv);
                    }

                    public Get setAccessToken(String accessToken) {
                        return (Get)super.setAccessToken(accessToken);
                    }

                    public Get setAlt(String alt) {
                        return (Get)super.setAlt(alt);
                    }

                    public Get setCallback(String callback) {
                        return (Get)super.setCallback(callback);
                    }

                    public Get setFields(String fields) {
                        return (Get)super.setFields(fields);
                    }

                    public Get setKey(String key) {
                        return (Get)super.setKey(key);
                    }

                    public Get setOauthToken(String oauthToken) {
                        return (Get)super.setOauthToken(oauthToken);
                    }

                    public Get setPrettyPrint(Boolean prettyPrint) {
                        return (Get)super.setPrettyPrint(prettyPrint);
                    }

                    public Get setQuotaUser(String quotaUser) {
                        return (Get)super.setQuotaUser(quotaUser);
                    }

                    public Get setUploadType(String uploadType) {
                        return (Get)super.setUploadType(uploadType);
                    }

                    public Get setUploadProtocol(String uploadProtocol) {
                        return (Get)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Get setName(String name) {
                        if (!ServiceUsage.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^[^/]+/[^/]+/services/[^/]+/consumerQuotaMetrics/[^/]+/limits/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    public String getView() {
                        return this.view;
                    }

                    public Get setView(String view) {
                        this.view = view;
                        return this;
                    }

                    @Override
                    public Get set(String parameterName, Object value) {
                        return (Get)super.set(parameterName, value);
                    }
                }
            }

            public class List
            extends ServiceUsageRequest<ListConsumerQuotaMetricsResponse> {
                private static final String REST_PATH = "v1beta1/{+parent}/consumerQuotaMetrics";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;
                @Key
                private Integer pageSize;
                @Key
                private String pageToken;
                @Key
                private String view;

                protected List(String parent) {
                    super(ServiceUsage.this, "GET", REST_PATH, null, ListConsumerQuotaMetricsResponse.class);
                    this.PARENT_PATTERN = Pattern.compile("^[^/]+/[^/]+/services/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                    if (!ServiceUsage.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^[^/]+/[^/]+/services/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String $Xgafv) {
                    return (List)super.set$Xgafv($Xgafv);
                }

                public List setAccessToken(String accessToken) {
                    return (List)super.setAccessToken(accessToken);
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setCallback(String callback) {
                    return (List)super.setCallback(callback);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUploadType(String uploadType) {
                    return (List)super.setUploadType(uploadType);
                }

                public List setUploadProtocol(String uploadProtocol) {
                    return (List)super.setUploadProtocol(uploadProtocol);
                }

                public String getParent() {
                    return this.parent;
                }

                public List setParent(String parent) {
                    if (!ServiceUsage.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^[^/]+/[^/]+/services/[^/]+$");
                    }
                    this.parent = parent;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer pageSize) {
                    this.pageSize = pageSize;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String pageToken) {
                    this.pageToken = pageToken;
                    return this;
                }

                public String getView() {
                    return this.view;
                }

                public List setView(String view) {
                    this.view = view;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }

            public class ImportConsumerOverrides
            extends ServiceUsageRequest<Operation> {
                private static final String REST_PATH = "v1beta1/{+parent}/consumerQuotaMetrics:importConsumerOverrides";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;

                protected ImportConsumerOverrides(String parent, ImportConsumerOverridesRequest content) {
                    super(ServiceUsage.this, "POST", REST_PATH, (Object)content, Operation.class);
                    this.PARENT_PATTERN = Pattern.compile("^[^/]+/[^/]+/services/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                    if (!ServiceUsage.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^[^/]+/[^/]+/services/[^/]+$");
                    }
                }

                public ImportConsumerOverrides set$Xgafv(String $Xgafv) {
                    return (ImportConsumerOverrides)super.set$Xgafv($Xgafv);
                }

                public ImportConsumerOverrides setAccessToken(String accessToken) {
                    return (ImportConsumerOverrides)super.setAccessToken(accessToken);
                }

                public ImportConsumerOverrides setAlt(String alt) {
                    return (ImportConsumerOverrides)super.setAlt(alt);
                }

                public ImportConsumerOverrides setCallback(String callback) {
                    return (ImportConsumerOverrides)super.setCallback(callback);
                }

                public ImportConsumerOverrides setFields(String fields) {
                    return (ImportConsumerOverrides)super.setFields(fields);
                }

                public ImportConsumerOverrides setKey(String key) {
                    return (ImportConsumerOverrides)super.setKey(key);
                }

                public ImportConsumerOverrides setOauthToken(String oauthToken) {
                    return (ImportConsumerOverrides)super.setOauthToken(oauthToken);
                }

                public ImportConsumerOverrides setPrettyPrint(Boolean prettyPrint) {
                    return (ImportConsumerOverrides)super.setPrettyPrint(prettyPrint);
                }

                public ImportConsumerOverrides setQuotaUser(String quotaUser) {
                    return (ImportConsumerOverrides)super.setQuotaUser(quotaUser);
                }

                public ImportConsumerOverrides setUploadType(String uploadType) {
                    return (ImportConsumerOverrides)super.setUploadType(uploadType);
                }

                public ImportConsumerOverrides setUploadProtocol(String uploadProtocol) {
                    return (ImportConsumerOverrides)super.setUploadProtocol(uploadProtocol);
                }

                public String getParent() {
                    return this.parent;
                }

                public ImportConsumerOverrides setParent(String parent) {
                    if (!ServiceUsage.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^[^/]+/[^/]+/services/[^/]+$");
                    }
                    this.parent = parent;
                    return this;
                }

                @Override
                public ImportConsumerOverrides set(String parameterName, Object value) {
                    return (ImportConsumerOverrides)super.set(parameterName, value);
                }
            }

            public class ImportAdminOverrides
            extends ServiceUsageRequest<Operation> {
                private static final String REST_PATH = "v1beta1/{+parent}/consumerQuotaMetrics:importAdminOverrides";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;

                protected ImportAdminOverrides(String parent, ImportAdminOverridesRequest content) {
                    super(ServiceUsage.this, "POST", REST_PATH, (Object)content, Operation.class);
                    this.PARENT_PATTERN = Pattern.compile("^[^/]+/[^/]+/services/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                    if (!ServiceUsage.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^[^/]+/[^/]+/services/[^/]+$");
                    }
                }

                public ImportAdminOverrides set$Xgafv(String $Xgafv) {
                    return (ImportAdminOverrides)super.set$Xgafv($Xgafv);
                }

                public ImportAdminOverrides setAccessToken(String accessToken) {
                    return (ImportAdminOverrides)super.setAccessToken(accessToken);
                }

                public ImportAdminOverrides setAlt(String alt) {
                    return (ImportAdminOverrides)super.setAlt(alt);
                }

                public ImportAdminOverrides setCallback(String callback) {
                    return (ImportAdminOverrides)super.setCallback(callback);
                }

                public ImportAdminOverrides setFields(String fields) {
                    return (ImportAdminOverrides)super.setFields(fields);
                }

                public ImportAdminOverrides setKey(String key) {
                    return (ImportAdminOverrides)super.setKey(key);
                }

                public ImportAdminOverrides setOauthToken(String oauthToken) {
                    return (ImportAdminOverrides)super.setOauthToken(oauthToken);
                }

                public ImportAdminOverrides setPrettyPrint(Boolean prettyPrint) {
                    return (ImportAdminOverrides)super.setPrettyPrint(prettyPrint);
                }

                public ImportAdminOverrides setQuotaUser(String quotaUser) {
                    return (ImportAdminOverrides)super.setQuotaUser(quotaUser);
                }

                public ImportAdminOverrides setUploadType(String uploadType) {
                    return (ImportAdminOverrides)super.setUploadType(uploadType);
                }

                public ImportAdminOverrides setUploadProtocol(String uploadProtocol) {
                    return (ImportAdminOverrides)super.setUploadProtocol(uploadProtocol);
                }

                public String getParent() {
                    return this.parent;
                }

                public ImportAdminOverrides setParent(String parent) {
                    if (!ServiceUsage.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^[^/]+/[^/]+/services/[^/]+$");
                    }
                    this.parent = parent;
                    return this;
                }

                @Override
                public ImportAdminOverrides set(String parameterName, Object value) {
                    return (ImportAdminOverrides)super.set(parameterName, value);
                }
            }

            public class Get
            extends ServiceUsageRequest<ConsumerQuotaMetric> {
                private static final String REST_PATH = "v1beta1/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;
                @Key
                private String view;

                protected Get(String name) {
                    super(ServiceUsage.this, "GET", REST_PATH, null, ConsumerQuotaMetric.class);
                    this.NAME_PATTERN = Pattern.compile("^[^/]+/[^/]+/services/[^/]+/consumerQuotaMetrics/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!ServiceUsage.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^[^/]+/[^/]+/services/[^/]+/consumerQuotaMetrics/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String $Xgafv) {
                    return (Get)super.set$Xgafv($Xgafv);
                }

                public Get setAccessToken(String accessToken) {
                    return (Get)super.setAccessToken(accessToken);
                }

                public Get setAlt(String alt) {
                    return (Get)super.setAlt(alt);
                }

                public Get setCallback(String callback) {
                    return (Get)super.setCallback(callback);
                }

                public Get setFields(String fields) {
                    return (Get)super.setFields(fields);
                }

                public Get setKey(String key) {
                    return (Get)super.setKey(key);
                }

                public Get setOauthToken(String oauthToken) {
                    return (Get)super.setOauthToken(oauthToken);
                }

                public Get setPrettyPrint(Boolean prettyPrint) {
                    return (Get)super.setPrettyPrint(prettyPrint);
                }

                public Get setQuotaUser(String quotaUser) {
                    return (Get)super.setQuotaUser(quotaUser);
                }

                public Get setUploadType(String uploadType) {
                    return (Get)super.setUploadType(uploadType);
                }

                public Get setUploadProtocol(String uploadProtocol) {
                    return (Get)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public Get setName(String name) {
                    if (!ServiceUsage.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^[^/]+/[^/]+/services/[^/]+/consumerQuotaMetrics/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                public String getView() {
                    return this.view;
                }

                public Get setView(String view) {
                    this.view = view;
                    return this;
                }

                @Override
                public Get set(String parameterName, Object value) {
                    return (Get)super.set(parameterName, value);
                }
            }
        }

        public class List
        extends ServiceUsageRequest<ListServicesResponse> {
            private static final String REST_PATH = "v1beta1/{+parent}/services";
            private final Pattern PARENT_PATTERN;
            @Key
            private String parent;
            @Key
            private String filter;
            @Key
            private Integer pageSize;
            @Key
            private String pageToken;

            protected List(String parent) {
                super(ServiceUsage.this, "GET", REST_PATH, null, ListServicesResponse.class);
                this.PARENT_PATTERN = Pattern.compile("^[^/]+/[^/]+$");
                this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                if (!ServiceUsage.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^[^/]+/[^/]+$");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public String getParent() {
                return this.parent;
            }

            public List setParent(String parent) {
                if (!ServiceUsage.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^[^/]+/[^/]+$");
                }
                this.parent = parent;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public List setFilter(String filter) {
                this.filter = filter;
                return this;
            }

            public Integer getPageSize() {
                return this.pageSize;
            }

            public List setPageSize(Integer pageSize) {
                this.pageSize = pageSize;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Get
        extends ServiceUsageRequest<Service> {
            private static final String REST_PATH = "v1beta1/{+name}";
            private final Pattern NAME_PATTERN;
            @Key
            private String name;

            protected Get(String name) {
                super(ServiceUsage.this, "GET", REST_PATH, null, Service.class);
                this.NAME_PATTERN = Pattern.compile("^[^/]+/[^/]+/services/[^/]+$");
                this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                if (!ServiceUsage.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^[^/]+/[^/]+/services/[^/]+$");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public String getName() {
                return this.name;
            }

            public Get setName(String name) {
                if (!ServiceUsage.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^[^/]+/[^/]+/services/[^/]+$");
                }
                this.name = name;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class GenerateServiceIdentity
        extends ServiceUsageRequest<Operation> {
            private static final String REST_PATH = "v1beta1/{+parent}:generateServiceIdentity";
            private final Pattern PARENT_PATTERN;
            @Key
            private String parent;

            protected GenerateServiceIdentity(String parent) {
                super(ServiceUsage.this, "POST", REST_PATH, null, Operation.class);
                this.PARENT_PATTERN = Pattern.compile("^[^/]+/[^/]+/services/[^/]+$");
                this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                if (!ServiceUsage.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^[^/]+/[^/]+/services/[^/]+$");
                }
            }

            public GenerateServiceIdentity set$Xgafv(String $Xgafv) {
                return (GenerateServiceIdentity)super.set$Xgafv($Xgafv);
            }

            public GenerateServiceIdentity setAccessToken(String accessToken) {
                return (GenerateServiceIdentity)super.setAccessToken(accessToken);
            }

            public GenerateServiceIdentity setAlt(String alt) {
                return (GenerateServiceIdentity)super.setAlt(alt);
            }

            public GenerateServiceIdentity setCallback(String callback) {
                return (GenerateServiceIdentity)super.setCallback(callback);
            }

            public GenerateServiceIdentity setFields(String fields) {
                return (GenerateServiceIdentity)super.setFields(fields);
            }

            public GenerateServiceIdentity setKey(String key) {
                return (GenerateServiceIdentity)super.setKey(key);
            }

            public GenerateServiceIdentity setOauthToken(String oauthToken) {
                return (GenerateServiceIdentity)super.setOauthToken(oauthToken);
            }

            public GenerateServiceIdentity setPrettyPrint(Boolean prettyPrint) {
                return (GenerateServiceIdentity)super.setPrettyPrint(prettyPrint);
            }

            public GenerateServiceIdentity setQuotaUser(String quotaUser) {
                return (GenerateServiceIdentity)super.setQuotaUser(quotaUser);
            }

            public GenerateServiceIdentity setUploadType(String uploadType) {
                return (GenerateServiceIdentity)super.setUploadType(uploadType);
            }

            public GenerateServiceIdentity setUploadProtocol(String uploadProtocol) {
                return (GenerateServiceIdentity)super.setUploadProtocol(uploadProtocol);
            }

            public String getParent() {
                return this.parent;
            }

            public GenerateServiceIdentity setParent(String parent) {
                if (!ServiceUsage.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^[^/]+/[^/]+/services/[^/]+$");
                }
                this.parent = parent;
                return this;
            }

            @Override
            public GenerateServiceIdentity set(String parameterName, Object value) {
                return (GenerateServiceIdentity)super.set(parameterName, value);
            }
        }

        public class Enable
        extends ServiceUsageRequest<Operation> {
            private static final String REST_PATH = "v1beta1/{+name}:enable";
            private final Pattern NAME_PATTERN;
            @Key
            private String name;

            protected Enable(String name, EnableServiceRequest content) {
                super(ServiceUsage.this, "POST", REST_PATH, (Object)content, Operation.class);
                this.NAME_PATTERN = Pattern.compile("^[^/]+/[^/]+/services/[^/]+$");
                this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                if (!ServiceUsage.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^[^/]+/[^/]+/services/[^/]+$");
                }
            }

            public Enable set$Xgafv(String $Xgafv) {
                return (Enable)super.set$Xgafv($Xgafv);
            }

            public Enable setAccessToken(String accessToken) {
                return (Enable)super.setAccessToken(accessToken);
            }

            public Enable setAlt(String alt) {
                return (Enable)super.setAlt(alt);
            }

            public Enable setCallback(String callback) {
                return (Enable)super.setCallback(callback);
            }

            public Enable setFields(String fields) {
                return (Enable)super.setFields(fields);
            }

            public Enable setKey(String key) {
                return (Enable)super.setKey(key);
            }

            public Enable setOauthToken(String oauthToken) {
                return (Enable)super.setOauthToken(oauthToken);
            }

            public Enable setPrettyPrint(Boolean prettyPrint) {
                return (Enable)super.setPrettyPrint(prettyPrint);
            }

            public Enable setQuotaUser(String quotaUser) {
                return (Enable)super.setQuotaUser(quotaUser);
            }

            public Enable setUploadType(String uploadType) {
                return (Enable)super.setUploadType(uploadType);
            }

            public Enable setUploadProtocol(String uploadProtocol) {
                return (Enable)super.setUploadProtocol(uploadProtocol);
            }

            public String getName() {
                return this.name;
            }

            public Enable setName(String name) {
                if (!ServiceUsage.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^[^/]+/[^/]+/services/[^/]+$");
                }
                this.name = name;
                return this;
            }

            @Override
            public Enable set(String parameterName, Object value) {
                return (Enable)super.set(parameterName, value);
            }
        }

        public class Disable
        extends ServiceUsageRequest<Operation> {
            private static final String REST_PATH = "v1beta1/{+name}:disable";
            private final Pattern NAME_PATTERN;
            @Key
            private String name;

            protected Disable(String name, DisableServiceRequest content) {
                super(ServiceUsage.this, "POST", REST_PATH, (Object)content, Operation.class);
                this.NAME_PATTERN = Pattern.compile("^[^/]+/[^/]+/services/[^/]+$");
                this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                if (!ServiceUsage.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^[^/]+/[^/]+/services/[^/]+$");
                }
            }

            public Disable set$Xgafv(String $Xgafv) {
                return (Disable)super.set$Xgafv($Xgafv);
            }

            public Disable setAccessToken(String accessToken) {
                return (Disable)super.setAccessToken(accessToken);
            }

            public Disable setAlt(String alt) {
                return (Disable)super.setAlt(alt);
            }

            public Disable setCallback(String callback) {
                return (Disable)super.setCallback(callback);
            }

            public Disable setFields(String fields) {
                return (Disable)super.setFields(fields);
            }

            public Disable setKey(String key) {
                return (Disable)super.setKey(key);
            }

            public Disable setOauthToken(String oauthToken) {
                return (Disable)super.setOauthToken(oauthToken);
            }

            public Disable setPrettyPrint(Boolean prettyPrint) {
                return (Disable)super.setPrettyPrint(prettyPrint);
            }

            public Disable setQuotaUser(String quotaUser) {
                return (Disable)super.setQuotaUser(quotaUser);
            }

            public Disable setUploadType(String uploadType) {
                return (Disable)super.setUploadType(uploadType);
            }

            public Disable setUploadProtocol(String uploadProtocol) {
                return (Disable)super.setUploadProtocol(uploadProtocol);
            }

            public String getName() {
                return this.name;
            }

            public Disable setName(String name) {
                if (!ServiceUsage.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^[^/]+/[^/]+/services/[^/]+$");
                }
                this.name = name;
                return this;
            }

            @Override
            public Disable set(String parameterName, Object value) {
                return (Disable)super.set(parameterName, value);
            }
        }

        public class BatchEnable
        extends ServiceUsageRequest<Operation> {
            private static final String REST_PATH = "v1beta1/{+parent}/services:batchEnable";
            private final Pattern PARENT_PATTERN;
            @Key
            private String parent;

            protected BatchEnable(String parent, BatchEnableServicesRequest content) {
                super(ServiceUsage.this, "POST", REST_PATH, (Object)content, Operation.class);
                this.PARENT_PATTERN = Pattern.compile("^[^/]+/[^/]+$");
                this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                if (!ServiceUsage.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^[^/]+/[^/]+$");
                }
            }

            public BatchEnable set$Xgafv(String $Xgafv) {
                return (BatchEnable)super.set$Xgafv($Xgafv);
            }

            public BatchEnable setAccessToken(String accessToken) {
                return (BatchEnable)super.setAccessToken(accessToken);
            }

            public BatchEnable setAlt(String alt) {
                return (BatchEnable)super.setAlt(alt);
            }

            public BatchEnable setCallback(String callback) {
                return (BatchEnable)super.setCallback(callback);
            }

            public BatchEnable setFields(String fields) {
                return (BatchEnable)super.setFields(fields);
            }

            public BatchEnable setKey(String key) {
                return (BatchEnable)super.setKey(key);
            }

            public BatchEnable setOauthToken(String oauthToken) {
                return (BatchEnable)super.setOauthToken(oauthToken);
            }

            public BatchEnable setPrettyPrint(Boolean prettyPrint) {
                return (BatchEnable)super.setPrettyPrint(prettyPrint);
            }

            public BatchEnable setQuotaUser(String quotaUser) {
                return (BatchEnable)super.setQuotaUser(quotaUser);
            }

            public BatchEnable setUploadType(String uploadType) {
                return (BatchEnable)super.setUploadType(uploadType);
            }

            public BatchEnable setUploadProtocol(String uploadProtocol) {
                return (BatchEnable)super.setUploadProtocol(uploadProtocol);
            }

            public String getParent() {
                return this.parent;
            }

            public BatchEnable setParent(String parent) {
                if (!ServiceUsage.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^[^/]+/[^/]+$");
                }
                this.parent = parent;
                return this;
            }

            @Override
            public BatchEnable set(String parameterName, Object value) {
                return (BatchEnable)super.set(parameterName, value);
            }
        }
    }

    public class Operations {
        public Get get(String name) throws IOException {
            Get result = new Get(name);
            ServiceUsage.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list() throws IOException {
            List result = new List();
            ServiceUsage.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class List
        extends ServiceUsageRequest<ListOperationsResponse> {
            private static final String REST_PATH = "v1beta1/operations";
            @Key
            private String filter;
            @Key
            private String name;
            @Key
            private Integer pageSize;
            @Key
            private String pageToken;

            protected List() {
                super(ServiceUsage.this, "GET", REST_PATH, null, ListOperationsResponse.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public String getFilter() {
                return this.filter;
            }

            public List setFilter(String filter) {
                this.filter = filter;
                return this;
            }

            public String getName() {
                return this.name;
            }

            public List setName(String name) {
                this.name = name;
                return this;
            }

            public Integer getPageSize() {
                return this.pageSize;
            }

            public List setPageSize(Integer pageSize) {
                this.pageSize = pageSize;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Get
        extends ServiceUsageRequest<Operation> {
            private static final String REST_PATH = "v1beta1/{+name}";
            private final Pattern NAME_PATTERN;
            @Key
            private String name;

            protected Get(String name) {
                super(ServiceUsage.this, "GET", REST_PATH, null, Operation.class);
                this.NAME_PATTERN = Pattern.compile("^operations/[^/]+$");
                this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                if (!ServiceUsage.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^operations/[^/]+$");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public String getName() {
                return this.name;
            }

            public Get setName(String name) {
                if (!ServiceUsage.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^operations/[^/]+$");
                }
                this.name = name;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }
    }
}

