/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2016-05-27 16:00:31 UTC)
 * on 2016-07-12 at 17:11:10 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.sheets.v4.model;

/**
 * Updates the borders of a range. If a field is not set in the request, that means the border
 * remains as-is. For example, with two subsequent UpdateBordersRequest:
 *
 *  1. range: A1:A5 `{ top: RED, bottom: WHITE }`  2. range: A1:A5 `{ left: BLUE }`
 *
 * That would result in A1:A5 having a borders of `{ top: RED, bottom: WHITE, left: BLUE }`. If you
 * want to clear a border, explicitly set the style to NONE.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Sheets API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class UpdateBordersRequest extends com.google.api.client.json.GenericJson {

  /**
   * The border to put at the bottom of the range.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Border bottom;

  /**
   * The horizontal border to put within the range.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Border innerHorizontal;

  /**
   * The vertical border to put within the range.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Border innerVertical;

  /**
   * The border to put at the left of the range.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Border left;

  /**
   * The range whose borders should be updated.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private GridRange range;

  /**
   * The border to put at the right of the range.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Border right;

  /**
   * The border to put at the top of the range.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Border top;

  /**
   * The border to put at the bottom of the range.
   * @return value or {@code null} for none
   */
  public Border getBottom() {
    return bottom;
  }

  /**
   * The border to put at the bottom of the range.
   * @param bottom bottom or {@code null} for none
   */
  public UpdateBordersRequest setBottom(Border bottom) {
    this.bottom = bottom;
    return this;
  }

  /**
   * The horizontal border to put within the range.
   * @return value or {@code null} for none
   */
  public Border getInnerHorizontal() {
    return innerHorizontal;
  }

  /**
   * The horizontal border to put within the range.
   * @param innerHorizontal innerHorizontal or {@code null} for none
   */
  public UpdateBordersRequest setInnerHorizontal(Border innerHorizontal) {
    this.innerHorizontal = innerHorizontal;
    return this;
  }

  /**
   * The vertical border to put within the range.
   * @return value or {@code null} for none
   */
  public Border getInnerVertical() {
    return innerVertical;
  }

  /**
   * The vertical border to put within the range.
   * @param innerVertical innerVertical or {@code null} for none
   */
  public UpdateBordersRequest setInnerVertical(Border innerVertical) {
    this.innerVertical = innerVertical;
    return this;
  }

  /**
   * The border to put at the left of the range.
   * @return value or {@code null} for none
   */
  public Border getLeft() {
    return left;
  }

  /**
   * The border to put at the left of the range.
   * @param left left or {@code null} for none
   */
  public UpdateBordersRequest setLeft(Border left) {
    this.left = left;
    return this;
  }

  /**
   * The range whose borders should be updated.
   * @return value or {@code null} for none
   */
  public GridRange getRange() {
    return range;
  }

  /**
   * The range whose borders should be updated.
   * @param range range or {@code null} for none
   */
  public UpdateBordersRequest setRange(GridRange range) {
    this.range = range;
    return this;
  }

  /**
   * The border to put at the right of the range.
   * @return value or {@code null} for none
   */
  public Border getRight() {
    return right;
  }

  /**
   * The border to put at the right of the range.
   * @param right right or {@code null} for none
   */
  public UpdateBordersRequest setRight(Border right) {
    this.right = right;
    return this;
  }

  /**
   * The border to put at the top of the range.
   * @return value or {@code null} for none
   */
  public Border getTop() {
    return top;
  }

  /**
   * The border to put at the top of the range.
   * @param top top or {@code null} for none
   */
  public UpdateBordersRequest setTop(Border top) {
    this.top = top;
    return this;
  }

  @Override
  public UpdateBordersRequest set(String fieldName, Object value) {
    return (UpdateBordersRequest) super.set(fieldName, value);
  }

  @Override
  public UpdateBordersRequest clone() {
    return (UpdateBordersRequest) super.clone();
  }

}
