/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2016-05-27 16:00:31 UTC)
 * on 2016-07-12 at 17:11:19 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.sheets.v4.model;

/**
 * Finds and replaces data in cells over a range, sheet, or all sheets.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Sheets API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class FindReplaceRequest extends com.google.api.client.json.GenericJson {

  /**
   * True to find/replace over all sheets.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean allSheets;

  /**
   * The value to search.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String find;

  /**
   * True if the search should include cells with formulas. False to skip cells with formulas.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean includeFormulas;

  /**
   * True if the search is case sensitive.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean matchCase;

  /**
   * True if the find value should match the entire cell.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean matchEntireCell;

  /**
   * The range to find/replace over.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private GridRange range;

  /**
   * The value to use as the replacement.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String replacement;

  /**
   * True if the find value is a regex. The regular expression and replacement should follow Java
   * regex rules at https://docs.oracle.com/javase/8/docs/api/java/util/regex/Pattern.html. The
   * replacement string is allowed to refer to capturing groups. For example, if one cell has the
   * contents `"Google Sheets"` and another has `"Google Docs"`, then searching for `"o.* (.*)"`
   * with a replacement of `"$1 Rocks"` would change the contents of the cells to `"GSheets Rocks"`
   * and `"GDocs Rocks"` respectively.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean searchByRegex;

  /**
   * The sheet to find/replace over.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer sheetId;

  /**
   * True to find/replace over all sheets.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getAllSheets() {
    return allSheets;
  }

  /**
   * True to find/replace over all sheets.
   * @param allSheets allSheets or {@code null} for none
   */
  public FindReplaceRequest setAllSheets(java.lang.Boolean allSheets) {
    this.allSheets = allSheets;
    return this;
  }

  /**
   * The value to search.
   * @return value or {@code null} for none
   */
  public java.lang.String getFind() {
    return find;
  }

  /**
   * The value to search.
   * @param find find or {@code null} for none
   */
  public FindReplaceRequest setFind(java.lang.String find) {
    this.find = find;
    return this;
  }

  /**
   * True if the search should include cells with formulas. False to skip cells with formulas.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getIncludeFormulas() {
    return includeFormulas;
  }

  /**
   * True if the search should include cells with formulas. False to skip cells with formulas.
   * @param includeFormulas includeFormulas or {@code null} for none
   */
  public FindReplaceRequest setIncludeFormulas(java.lang.Boolean includeFormulas) {
    this.includeFormulas = includeFormulas;
    return this;
  }

  /**
   * True if the search is case sensitive.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getMatchCase() {
    return matchCase;
  }

  /**
   * True if the search is case sensitive.
   * @param matchCase matchCase or {@code null} for none
   */
  public FindReplaceRequest setMatchCase(java.lang.Boolean matchCase) {
    this.matchCase = matchCase;
    return this;
  }

  /**
   * True if the find value should match the entire cell.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getMatchEntireCell() {
    return matchEntireCell;
  }

  /**
   * True if the find value should match the entire cell.
   * @param matchEntireCell matchEntireCell or {@code null} for none
   */
  public FindReplaceRequest setMatchEntireCell(java.lang.Boolean matchEntireCell) {
    this.matchEntireCell = matchEntireCell;
    return this;
  }

  /**
   * The range to find/replace over.
   * @return value or {@code null} for none
   */
  public GridRange getRange() {
    return range;
  }

  /**
   * The range to find/replace over.
   * @param range range or {@code null} for none
   */
  public FindReplaceRequest setRange(GridRange range) {
    this.range = range;
    return this;
  }

  /**
   * The value to use as the replacement.
   * @return value or {@code null} for none
   */
  public java.lang.String getReplacement() {
    return replacement;
  }

  /**
   * The value to use as the replacement.
   * @param replacement replacement or {@code null} for none
   */
  public FindReplaceRequest setReplacement(java.lang.String replacement) {
    this.replacement = replacement;
    return this;
  }

  /**
   * True if the find value is a regex. The regular expression and replacement should follow Java
   * regex rules at https://docs.oracle.com/javase/8/docs/api/java/util/regex/Pattern.html. The
   * replacement string is allowed to refer to capturing groups. For example, if one cell has the
   * contents `"Google Sheets"` and another has `"Google Docs"`, then searching for `"o.* (.*)"`
   * with a replacement of `"$1 Rocks"` would change the contents of the cells to `"GSheets Rocks"`
   * and `"GDocs Rocks"` respectively.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getSearchByRegex() {
    return searchByRegex;
  }

  /**
   * True if the find value is a regex. The regular expression and replacement should follow Java
   * regex rules at https://docs.oracle.com/javase/8/docs/api/java/util/regex/Pattern.html. The
   * replacement string is allowed to refer to capturing groups. For example, if one cell has the
   * contents `"Google Sheets"` and another has `"Google Docs"`, then searching for `"o.* (.*)"`
   * with a replacement of `"$1 Rocks"` would change the contents of the cells to `"GSheets Rocks"`
   * and `"GDocs Rocks"` respectively.
   * @param searchByRegex searchByRegex or {@code null} for none
   */
  public FindReplaceRequest setSearchByRegex(java.lang.Boolean searchByRegex) {
    this.searchByRegex = searchByRegex;
    return this;
  }

  /**
   * The sheet to find/replace over.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getSheetId() {
    return sheetId;
  }

  /**
   * The sheet to find/replace over.
   * @param sheetId sheetId or {@code null} for none
   */
  public FindReplaceRequest setSheetId(java.lang.Integer sheetId) {
    this.sheetId = sheetId;
    return this;
  }

  @Override
  public FindReplaceRequest set(String fieldName, Object value) {
    return (FindReplaceRequest) super.set(fieldName, value);
  }

  @Override
  public FindReplaceRequest clone() {
    return (FindReplaceRequest) super.clone();
  }

}
