/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2017-01-11 18:31:16 UTC)
 * on 2017-01-25 at 20:47:15 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.sheets.v4.model;

/**
 * The request for updating any aspect of a spreadsheet.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Sheets API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class BatchUpdateSpreadsheetRequest extends com.google.api.client.json.GenericJson {

  /**
   * Determines if the update response should include the spreadsheet resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean includeSpreadsheetInResponse;

  /**
   * A list of updates to apply to the spreadsheet.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Request> requests;

  static {
    // hack to force ProGuard to consider Request used, since otherwise it would be stripped out
    // see http://code.google.com/p/google-api-java-client/issues/detail?id=528
    com.google.api.client.util.Data.nullOf(Request.class);
  }

  /**
   * True if grid data should be returned. Meaningful only if if include_spreadsheet_response is
   * 'true'. This parameter is ignored if a field mask was set in the request.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean responseIncludeGridData;

  /**
   * Limits the ranges included in the response spreadsheet. Meaningful only if
   * include_spreadsheet_response is 'true'.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> responseRanges;

  /**
   * Determines if the update response should include the spreadsheet resource.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getIncludeSpreadsheetInResponse() {
    return includeSpreadsheetInResponse;
  }

  /**
   * Determines if the update response should include the spreadsheet resource.
   * @param includeSpreadsheetInResponse includeSpreadsheetInResponse or {@code null} for none
   */
  public BatchUpdateSpreadsheetRequest setIncludeSpreadsheetInResponse(java.lang.Boolean includeSpreadsheetInResponse) {
    this.includeSpreadsheetInResponse = includeSpreadsheetInResponse;
    return this;
  }

  /**
   * A list of updates to apply to the spreadsheet.
   * @return value or {@code null} for none
   */
  public java.util.List<Request> getRequests() {
    return requests;
  }

  /**
   * A list of updates to apply to the spreadsheet.
   * @param requests requests or {@code null} for none
   */
  public BatchUpdateSpreadsheetRequest setRequests(java.util.List<Request> requests) {
    this.requests = requests;
    return this;
  }

  /**
   * True if grid data should be returned. Meaningful only if if include_spreadsheet_response is
   * 'true'. This parameter is ignored if a field mask was set in the request.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getResponseIncludeGridData() {
    return responseIncludeGridData;
  }

  /**
   * True if grid data should be returned. Meaningful only if if include_spreadsheet_response is
   * 'true'. This parameter is ignored if a field mask was set in the request.
   * @param responseIncludeGridData responseIncludeGridData or {@code null} for none
   */
  public BatchUpdateSpreadsheetRequest setResponseIncludeGridData(java.lang.Boolean responseIncludeGridData) {
    this.responseIncludeGridData = responseIncludeGridData;
    return this;
  }

  /**
   * Limits the ranges included in the response spreadsheet. Meaningful only if
   * include_spreadsheet_response is 'true'.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getResponseRanges() {
    return responseRanges;
  }

  /**
   * Limits the ranges included in the response spreadsheet. Meaningful only if
   * include_spreadsheet_response is 'true'.
   * @param responseRanges responseRanges or {@code null} for none
   */
  public BatchUpdateSpreadsheetRequest setResponseRanges(java.util.List<java.lang.String> responseRanges) {
    this.responseRanges = responseRanges;
    return this;
  }

  @Override
  public BatchUpdateSpreadsheetRequest set(String fieldName, Object value) {
    return (BatchUpdateSpreadsheetRequest) super.set(fieldName, value);
  }

  @Override
  public BatchUpdateSpreadsheetRequest clone() {
    return (BatchUpdateSpreadsheetRequest) super.clone();
  }

}
