/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2016-07-08 17:28:43 UTC)
 * on 2016-07-25 at 20:09:41 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.sheets.v4.model;

/**
 * The request for updating more than one range of values in a spreadsheet.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Sheets API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class BatchUpdateValuesRequest extends com.google.api.client.json.GenericJson {

  /**
   * The new values to apply to the spreadsheet.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<ValueRange> data;

  /**
   * How the input data should be interpreted.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String valueInputOption;

  /**
   * The new values to apply to the spreadsheet.
   * @return value or {@code null} for none
   */
  public java.util.List<ValueRange> getData() {
    return data;
  }

  /**
   * The new values to apply to the spreadsheet.
   * @param data data or {@code null} for none
   */
  public BatchUpdateValuesRequest setData(java.util.List<ValueRange> data) {
    this.data = data;
    return this;
  }

  /**
   * How the input data should be interpreted.
   * @return value or {@code null} for none
   */
  public java.lang.String getValueInputOption() {
    return valueInputOption;
  }

  /**
   * How the input data should be interpreted.
   * @param valueInputOption valueInputOption or {@code null} for none
   */
  public BatchUpdateValuesRequest setValueInputOption(java.lang.String valueInputOption) {
    this.valueInputOption = valueInputOption;
    return this;
  }

  @Override
  public BatchUpdateValuesRequest set(String fieldName, Object value) {
    return (BatchUpdateValuesRequest) super.set(fieldName, value);
  }

  @Override
  public BatchUpdateValuesRequest clone() {
    return (BatchUpdateValuesRequest) super.clone();
  }

}
