/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2016-05-27 16:00:31 UTC)
 * on 2016-08-01 at 17:26:50 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.sheets.v4;

/**
 * Service definition for Sheets (v4).
 *
 * <p>
 * Reads and writes Google Sheets.
 * </p>
 *
 * <p>
 * For more information about this service, see the
 * <a href="https://developers.google.com/sheets/" target="_blank">API Documentation</a>
 * </p>
 *
 * <p>
 * This service uses {@link SheetsRequestInitializer} to initialize global parameters via its
 * {@link Builder}.
 * </p>
 *
 * @since 1.3
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public class Sheets extends com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient {

  // Note: Leave this static initializer at the top of the file.
  static {
    com.google.api.client.util.Preconditions.checkState(
        com.google.api.client.googleapis.GoogleUtils.MAJOR_VERSION == 1 &&
        com.google.api.client.googleapis.GoogleUtils.MINOR_VERSION >= 15,
        "You are currently running with version %s of google-api-client. " +
        "You need at least version 1.15 of google-api-client to run version " +
        "1.21.0 of the Google Sheets API library.", com.google.api.client.googleapis.GoogleUtils.VERSION);
  }

  /**
   * The default encoded root URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   *
   * @since 1.7
   */
  public static final String DEFAULT_ROOT_URL = "https://sheets.googleapis.com/";

  /**
   * The default encoded service path of the service. This is determined when the library is
   * generated and normally should not be changed.
   *
   * @since 1.7
   */
  public static final String DEFAULT_SERVICE_PATH = "";

  /**
   * The default encoded base URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   */
  public static final String DEFAULT_BASE_URL = DEFAULT_ROOT_URL + DEFAULT_SERVICE_PATH;

  /**
   * Constructor.
   *
   * <p>
   * Use {@link Builder} if you need to specify any of the optional parameters.
   * </p>
   *
   * @param transport HTTP transport, which should normally be:
   *        <ul>
   *        <li>Google App Engine:
   *        {@code com.google.api.client.extensions.appengine.http.UrlFetchTransport}</li>
   *        <li>Android: {@code newCompatibleTransport} from
   *        {@code com.google.api.client.extensions.android.http.AndroidHttp}</li>
   *        <li>Java: {@link com.google.api.client.googleapis.javanet.GoogleNetHttpTransport#newTrustedTransport()}
   *        </li>
   *        </ul>
   * @param jsonFactory JSON factory, which may be:
   *        <ul>
   *        <li>Jackson: {@code com.google.api.client.json.jackson2.JacksonFactory}</li>
   *        <li>Google GSON: {@code com.google.api.client.json.gson.GsonFactory}</li>
   *        <li>Android Honeycomb or higher:
   *        {@code com.google.api.client.extensions.android.json.AndroidJsonFactory}</li>
   *        </ul>
   * @param httpRequestInitializer HTTP request initializer or {@code null} for none
   * @since 1.7
   */
  public Sheets(com.google.api.client.http.HttpTransport transport, com.google.api.client.json.JsonFactory jsonFactory,
      com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
    this(new Builder(transport, jsonFactory, httpRequestInitializer));
  }

  /**
   * @param builder builder
   */
  Sheets(Builder builder) {
    super(builder);
  }

  @Override
  protected void initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest<?> httpClientRequest) throws java.io.IOException {
    super.initialize(httpClientRequest);
  }

  /**
   * An accessor for creating requests from the Spreadsheets collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Sheets sheets = new Sheets(...);}
   *   {@code Sheets.Spreadsheets.List request = sheets.spreadsheets().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Spreadsheets spreadsheets() {
    return new Spreadsheets();
  }

  /**
   * The "spreadsheets" collection of methods.
   */
  public class Spreadsheets {

    /**
     * Applies one or more updates to the spreadsheet.
     *
     * Each request is validated before being applied. If any request is not valid then the entire
     * request will fail and nothing will be applied.
     *
     * Some requests have replies to give you some information about how they are applied. The replies
     * will mirror the requests.  For example, if you applied 4 updates and the 3rd one had a reply,
     * then the response will have 2 empty replies, the actual reply, and another empty reply, in that
     * order.
     *
     * Due to the collaborative nature of spreadsheets, it is not guaranteed that the spreadsheet will
     * reflect exactly your changes after this completes, however it is guaranteed that the updates in
     * the request will be applied together atomically. Your changes may be altered with respect to
     * collaborator changes. If there are no collaborators, the spreadsheet should reflect your changes.
     *
     * Create a request for the method "spreadsheets.batchUpdate".
     *
     * This request holds the parameters needed by the sheets server.  After setting any optional
     * parameters, call the {@link BatchUpdate#execute()} method to invoke the remote operation.
     *
     * @param spreadsheetId The spreadsheet to apply the updates to.
     * @param content the {@link com.google.api.services.sheets.v4.model.BatchUpdateSpreadsheetRequest}
     * @return the request
     */
    public BatchUpdate batchUpdate(java.lang.String spreadsheetId, com.google.api.services.sheets.v4.model.BatchUpdateSpreadsheetRequest content) throws java.io.IOException {
      BatchUpdate result = new BatchUpdate(spreadsheetId, content);
      initialize(result);
      return result;
    }

    public class BatchUpdate extends SheetsRequest<com.google.api.services.sheets.v4.model.BatchUpdateSpreadsheetResponse> {

      private static final String REST_PATH = "v4/spreadsheets/{spreadsheetId}:batchUpdate";

      /**
       * Applies one or more updates to the spreadsheet.
       *
       * Each request is validated before being applied. If any request is not valid then the entire
       * request will fail and nothing will be applied.
       *
       * Some requests have replies to give you some information about how they are applied. The replies
       * will mirror the requests.  For example, if you applied 4 updates and the 3rd one had a reply,
       * then the response will have 2 empty replies, the actual reply, and another empty reply, in that
       * order.
       *
       * Due to the collaborative nature of spreadsheets, it is not guaranteed that the spreadsheet will
       * reflect exactly your changes after this completes, however it is guaranteed that the updates in
       * the request will be applied together atomically. Your changes may be altered with respect to
       * collaborator changes. If there are no collaborators, the spreadsheet should reflect your
       * changes.
       *
       * Create a request for the method "spreadsheets.batchUpdate".
       *
       * This request holds the parameters needed by the the sheets server.  After setting any optional
       * parameters, call the {@link BatchUpdate#execute()} method to invoke the remote operation. <p>
       * {@link
       * BatchUpdate#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param spreadsheetId The spreadsheet to apply the updates to.
       * @param content the {@link com.google.api.services.sheets.v4.model.BatchUpdateSpreadsheetRequest}
       * @since 1.13
       */
      protected BatchUpdate(java.lang.String spreadsheetId, com.google.api.services.sheets.v4.model.BatchUpdateSpreadsheetRequest content) {
        super(Sheets.this, "POST", REST_PATH, content, com.google.api.services.sheets.v4.model.BatchUpdateSpreadsheetResponse.class);
        this.spreadsheetId = com.google.api.client.util.Preconditions.checkNotNull(spreadsheetId, "Required parameter spreadsheetId must be specified.");
      }

      @Override
      public BatchUpdate set$Xgafv(java.lang.String $Xgafv) {
        return (BatchUpdate) super.set$Xgafv($Xgafv);
      }

      @Override
      public BatchUpdate setAccessToken(java.lang.String accessToken) {
        return (BatchUpdate) super.setAccessToken(accessToken);
      }

      @Override
      public BatchUpdate setAlt(java.lang.String alt) {
        return (BatchUpdate) super.setAlt(alt);
      }

      @Override
      public BatchUpdate setBearerToken(java.lang.String bearerToken) {
        return (BatchUpdate) super.setBearerToken(bearerToken);
      }

      @Override
      public BatchUpdate setCallback(java.lang.String callback) {
        return (BatchUpdate) super.setCallback(callback);
      }

      @Override
      public BatchUpdate setFields(java.lang.String fields) {
        return (BatchUpdate) super.setFields(fields);
      }

      @Override
      public BatchUpdate setKey(java.lang.String key) {
        return (BatchUpdate) super.setKey(key);
      }

      @Override
      public BatchUpdate setOauthToken(java.lang.String oauthToken) {
        return (BatchUpdate) super.setOauthToken(oauthToken);
      }

      @Override
      public BatchUpdate setPp(java.lang.Boolean pp) {
        return (BatchUpdate) super.setPp(pp);
      }

      @Override
      public BatchUpdate setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (BatchUpdate) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public BatchUpdate setQuotaUser(java.lang.String quotaUser) {
        return (BatchUpdate) super.setQuotaUser(quotaUser);
      }

      @Override
      public BatchUpdate setUploadType(java.lang.String uploadType) {
        return (BatchUpdate) super.setUploadType(uploadType);
      }

      @Override
      public BatchUpdate setUploadProtocol(java.lang.String uploadProtocol) {
        return (BatchUpdate) super.setUploadProtocol(uploadProtocol);
      }

      /** The spreadsheet to apply the updates to. */
      @com.google.api.client.util.Key
      private java.lang.String spreadsheetId;

      /** The spreadsheet to apply the updates to.
       */
      public java.lang.String getSpreadsheetId() {
        return spreadsheetId;
      }

      /** The spreadsheet to apply the updates to. */
      public BatchUpdate setSpreadsheetId(java.lang.String spreadsheetId) {
        this.spreadsheetId = spreadsheetId;
        return this;
      }

      @Override
      public BatchUpdate set(String parameterName, Object value) {
        return (BatchUpdate) super.set(parameterName, value);
      }
    }
    /**
     * Creates a spreadsheet, returning the newly created spreadsheet.
     *
     * Create a request for the method "spreadsheets.create".
     *
     * This request holds the parameters needed by the sheets server.  After setting any optional
     * parameters, call the {@link Create#execute()} method to invoke the remote operation.
     *
     * @param content the {@link com.google.api.services.sheets.v4.model.Spreadsheet}
     * @return the request
     */
    public Create create(com.google.api.services.sheets.v4.model.Spreadsheet content) throws java.io.IOException {
      Create result = new Create(content);
      initialize(result);
      return result;
    }

    public class Create extends SheetsRequest<com.google.api.services.sheets.v4.model.Spreadsheet> {

      private static final String REST_PATH = "v4/spreadsheets";

      /**
       * Creates a spreadsheet, returning the newly created spreadsheet.
       *
       * Create a request for the method "spreadsheets.create".
       *
       * This request holds the parameters needed by the the sheets server.  After setting any optional
       * parameters, call the {@link Create#execute()} method to invoke the remote operation. <p> {@link
       * Create#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param content the {@link com.google.api.services.sheets.v4.model.Spreadsheet}
       * @since 1.13
       */
      protected Create(com.google.api.services.sheets.v4.model.Spreadsheet content) {
        super(Sheets.this, "POST", REST_PATH, content, com.google.api.services.sheets.v4.model.Spreadsheet.class);
      }

      @Override
      public Create set$Xgafv(java.lang.String $Xgafv) {
        return (Create) super.set$Xgafv($Xgafv);
      }

      @Override
      public Create setAccessToken(java.lang.String accessToken) {
        return (Create) super.setAccessToken(accessToken);
      }

      @Override
      public Create setAlt(java.lang.String alt) {
        return (Create) super.setAlt(alt);
      }

      @Override
      public Create setBearerToken(java.lang.String bearerToken) {
        return (Create) super.setBearerToken(bearerToken);
      }

      @Override
      public Create setCallback(java.lang.String callback) {
        return (Create) super.setCallback(callback);
      }

      @Override
      public Create setFields(java.lang.String fields) {
        return (Create) super.setFields(fields);
      }

      @Override
      public Create setKey(java.lang.String key) {
        return (Create) super.setKey(key);
      }

      @Override
      public Create setOauthToken(java.lang.String oauthToken) {
        return (Create) super.setOauthToken(oauthToken);
      }

      @Override
      public Create setPp(java.lang.Boolean pp) {
        return (Create) super.setPp(pp);
      }

      @Override
      public Create setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Create) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Create setQuotaUser(java.lang.String quotaUser) {
        return (Create) super.setQuotaUser(quotaUser);
      }

      @Override
      public Create setUploadType(java.lang.String uploadType) {
        return (Create) super.setUploadType(uploadType);
      }

      @Override
      public Create setUploadProtocol(java.lang.String uploadProtocol) {
        return (Create) super.setUploadProtocol(uploadProtocol);
      }

      @Override
      public Create set(String parameterName, Object value) {
        return (Create) super.set(parameterName, value);
      }
    }
    /**
     * Returns the spreadsheet at the given ID. The caller must specify the spreadsheet ID.
     *
     * By default, data within grids will not be returned. You can include grid data one of two ways:
     *
     * * Specify a field mask listing your desired fields using the `fields` URL parameter in HTTP
     *
     * * Set the includeGridData URL parameter to true.  If a field mask is set, the `includeGridData`
     * parameter is ignored
     *
     * For large spreadsheets, it is recommended to retrieve only the specific fields of the spreadsheet
     * that you want.
     *
     * To retrieve only subsets of the spreadsheet, use the ranges URL parameter. Multiple ranges can be
     * specified.  Limiting the range will return only the portions of the spreadsheet that intersect
     * the requested ranges. Ranges are specified using A1 notation.
     *
     * Create a request for the method "spreadsheets.get".
     *
     * This request holds the parameters needed by the sheets server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param spreadsheetId The spreadsheet to request.
     * @return the request
     */
    public Get get(java.lang.String spreadsheetId) throws java.io.IOException {
      Get result = new Get(spreadsheetId);
      initialize(result);
      return result;
    }

    public class Get extends SheetsRequest<com.google.api.services.sheets.v4.model.Spreadsheet> {

      private static final String REST_PATH = "v4/spreadsheets/{spreadsheetId}";

      /**
       * Returns the spreadsheet at the given ID. The caller must specify the spreadsheet ID.
       *
       * By default, data within grids will not be returned. You can include grid data one of two ways:
       *
       * * Specify a field mask listing your desired fields using the `fields` URL parameter in HTTP
       *
       * * Set the includeGridData URL parameter to true.  If a field mask is set, the `includeGridData`
       * parameter is ignored
       *
       * For large spreadsheets, it is recommended to retrieve only the specific fields of the
       * spreadsheet that you want.
       *
       * To retrieve only subsets of the spreadsheet, use the ranges URL parameter. Multiple ranges can
       * be specified.  Limiting the range will return only the portions of the spreadsheet that
       * intersect the requested ranges. Ranges are specified using A1 notation.
       *
       * Create a request for the method "spreadsheets.get".
       *
       * This request holds the parameters needed by the the sheets server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param spreadsheetId The spreadsheet to request.
       * @since 1.13
       */
      protected Get(java.lang.String spreadsheetId) {
        super(Sheets.this, "GET", REST_PATH, null, com.google.api.services.sheets.v4.model.Spreadsheet.class);
        this.spreadsheetId = com.google.api.client.util.Preconditions.checkNotNull(spreadsheetId, "Required parameter spreadsheetId must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get set$Xgafv(java.lang.String $Xgafv) {
        return (Get) super.set$Xgafv($Xgafv);
      }

      @Override
      public Get setAccessToken(java.lang.String accessToken) {
        return (Get) super.setAccessToken(accessToken);
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setBearerToken(java.lang.String bearerToken) {
        return (Get) super.setBearerToken(bearerToken);
      }

      @Override
      public Get setCallback(java.lang.String callback) {
        return (Get) super.setCallback(callback);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPp(java.lang.Boolean pp) {
        return (Get) super.setPp(pp);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUploadType(java.lang.String uploadType) {
        return (Get) super.setUploadType(uploadType);
      }

      @Override
      public Get setUploadProtocol(java.lang.String uploadProtocol) {
        return (Get) super.setUploadProtocol(uploadProtocol);
      }

      /** The spreadsheet to request. */
      @com.google.api.client.util.Key
      private java.lang.String spreadsheetId;

      /** The spreadsheet to request.
       */
      public java.lang.String getSpreadsheetId() {
        return spreadsheetId;
      }

      /** The spreadsheet to request. */
      public Get setSpreadsheetId(java.lang.String spreadsheetId) {
        this.spreadsheetId = spreadsheetId;
        return this;
      }

      /** The ranges to retrieve from the spreadsheet. */
      @com.google.api.client.util.Key
      private java.util.List<java.lang.String> ranges;

      /** The ranges to retrieve from the spreadsheet.
       */
      public java.util.List<java.lang.String> getRanges() {
        return ranges;
      }

      /** The ranges to retrieve from the spreadsheet. */
      public Get setRanges(java.util.List<java.lang.String> ranges) {
        this.ranges = ranges;
        return this;
      }

      /**
       * True if grid data should be returned. This parameter is ignored if a field mask was set in
       * the request.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean includeGridData;

      /** True if grid data should be returned. This parameter is ignored if a field mask was set in the
     request.
       */
      public java.lang.Boolean getIncludeGridData() {
        return includeGridData;
      }

      /**
       * True if grid data should be returned. This parameter is ignored if a field mask was set in
       * the request.
       */
      public Get setIncludeGridData(java.lang.Boolean includeGridData) {
        this.includeGridData = includeGridData;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }

    /**
     * An accessor for creating requests from the SheetsOperations collection.
     *
     * <p>The typical use is:</p>
     * <pre>
     *   {@code Sheets sheets = new Sheets(...);}
     *   {@code Sheets.SheetsOperations.List request = sheets.sheets().list(parameters ...)}
     * </pre>
     *
     * @return the resource collection
     */
    public SheetsOperations sheets() {
      return new SheetsOperations();
    }

    /**
     * The "sheets" collection of methods.
     */
    public class SheetsOperations {

      /**
       * Copies a single sheet from a spreadsheet to another spreadsheet. Returns the properties of the
       * newly created sheet.
       *
       * Create a request for the method "sheets.copyTo".
       *
       * This request holds the parameters needed by the sheets server.  After setting any optional
       * parameters, call the {@link CopyTo#execute()} method to invoke the remote operation.
       *
       * @param spreadsheetId The ID of the spreadsheet containing the sheet to copy.
       * @param sheetId The ID of the sheet to copy.
       * @param content the {@link com.google.api.services.sheets.v4.model.CopySheetToAnotherSpreadsheetRequest}
       * @return the request
       */
      public CopyTo copyTo(java.lang.String spreadsheetId, java.lang.Integer sheetId, com.google.api.services.sheets.v4.model.CopySheetToAnotherSpreadsheetRequest content) throws java.io.IOException {
        CopyTo result = new CopyTo(spreadsheetId, sheetId, content);
        initialize(result);
        return result;
      }

      public class CopyTo extends SheetsRequest<com.google.api.services.sheets.v4.model.SheetProperties> {

        private static final String REST_PATH = "v4/spreadsheets/{spreadsheetId}/sheets/{sheetId}:copyTo";

        /**
         * Copies a single sheet from a spreadsheet to another spreadsheet. Returns the properties of the
         * newly created sheet.
         *
         * Create a request for the method "sheets.copyTo".
         *
         * This request holds the parameters needed by the the sheets server.  After setting any optional
         * parameters, call the {@link CopyTo#execute()} method to invoke the remote operation. <p> {@link
         * CopyTo#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param spreadsheetId The ID of the spreadsheet containing the sheet to copy.
         * @param sheetId The ID of the sheet to copy.
         * @param content the {@link com.google.api.services.sheets.v4.model.CopySheetToAnotherSpreadsheetRequest}
         * @since 1.13
         */
        protected CopyTo(java.lang.String spreadsheetId, java.lang.Integer sheetId, com.google.api.services.sheets.v4.model.CopySheetToAnotherSpreadsheetRequest content) {
          super(Sheets.this, "POST", REST_PATH, content, com.google.api.services.sheets.v4.model.SheetProperties.class);
          this.spreadsheetId = com.google.api.client.util.Preconditions.checkNotNull(spreadsheetId, "Required parameter spreadsheetId must be specified.");
          this.sheetId = com.google.api.client.util.Preconditions.checkNotNull(sheetId, "Required parameter sheetId must be specified.");
        }

        @Override
        public CopyTo set$Xgafv(java.lang.String $Xgafv) {
          return (CopyTo) super.set$Xgafv($Xgafv);
        }

        @Override
        public CopyTo setAccessToken(java.lang.String accessToken) {
          return (CopyTo) super.setAccessToken(accessToken);
        }

        @Override
        public CopyTo setAlt(java.lang.String alt) {
          return (CopyTo) super.setAlt(alt);
        }

        @Override
        public CopyTo setBearerToken(java.lang.String bearerToken) {
          return (CopyTo) super.setBearerToken(bearerToken);
        }

        @Override
        public CopyTo setCallback(java.lang.String callback) {
          return (CopyTo) super.setCallback(callback);
        }

        @Override
        public CopyTo setFields(java.lang.String fields) {
          return (CopyTo) super.setFields(fields);
        }

        @Override
        public CopyTo setKey(java.lang.String key) {
          return (CopyTo) super.setKey(key);
        }

        @Override
        public CopyTo setOauthToken(java.lang.String oauthToken) {
          return (CopyTo) super.setOauthToken(oauthToken);
        }

        @Override
        public CopyTo setPp(java.lang.Boolean pp) {
          return (CopyTo) super.setPp(pp);
        }

        @Override
        public CopyTo setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (CopyTo) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public CopyTo setQuotaUser(java.lang.String quotaUser) {
          return (CopyTo) super.setQuotaUser(quotaUser);
        }

        @Override
        public CopyTo setUploadType(java.lang.String uploadType) {
          return (CopyTo) super.setUploadType(uploadType);
        }

        @Override
        public CopyTo setUploadProtocol(java.lang.String uploadProtocol) {
          return (CopyTo) super.setUploadProtocol(uploadProtocol);
        }

        /** The ID of the spreadsheet containing the sheet to copy. */
        @com.google.api.client.util.Key
        private java.lang.String spreadsheetId;

        /** The ID of the spreadsheet containing the sheet to copy.
         */
        public java.lang.String getSpreadsheetId() {
          return spreadsheetId;
        }

        /** The ID of the spreadsheet containing the sheet to copy. */
        public CopyTo setSpreadsheetId(java.lang.String spreadsheetId) {
          this.spreadsheetId = spreadsheetId;
          return this;
        }

        /** The ID of the sheet to copy. */
        @com.google.api.client.util.Key
        private java.lang.Integer sheetId;

        /** The ID of the sheet to copy.
         */
        public java.lang.Integer getSheetId() {
          return sheetId;
        }

        /** The ID of the sheet to copy. */
        public CopyTo setSheetId(java.lang.Integer sheetId) {
          this.sheetId = sheetId;
          return this;
        }

        @Override
        public CopyTo set(String parameterName, Object value) {
          return (CopyTo) super.set(parameterName, value);
        }
      }

    }
    /**
     * An accessor for creating requests from the Values collection.
     *
     * <p>The typical use is:</p>
     * <pre>
     *   {@code Sheets sheets = new Sheets(...);}
     *   {@code Sheets.Values.List request = sheets.values().list(parameters ...)}
     * </pre>
     *
     * @return the resource collection
     */
    public Values values() {
      return new Values();
    }

    /**
     * The "values" collection of methods.
     */
    public class Values {

      /**
       * Appends values to a spreadsheet. The input range is used to search for existing data and find a
       * "table" within that range. Values will be appended to the next row of the table, starting with
       * the first column of the table. See the [guide](/sheets/guides/values#appending_values) and
       * [sample code](/sheets/samples/writing#append_values) for specific details of how tables are
       * detected and data is appended.
       *
       * The caller must specify the spreadsheet ID, range, and a valueInputOption.  The
       * `valueInputOption` only controls how the input data will be added to the sheet (column-wise or
       * row-wise), it does not influence what cell the data starts being written to.
       *
       * Create a request for the method "values.append".
       *
       * This request holds the parameters needed by the sheets server.  After setting any optional
       * parameters, call the {@link Append#execute()} method to invoke the remote operation.
       *
       * @param spreadsheetId The ID of the spreadsheet to update.
       * @param range The A1 notation of a range to search for a logical table of data.
      Values will be appended after the
       *        last row of the table.
       * @param content the {@link com.google.api.services.sheets.v4.model.ValueRange}
       * @return the request
       */
      public Append append(java.lang.String spreadsheetId, java.lang.String range, com.google.api.services.sheets.v4.model.ValueRange content) throws java.io.IOException {
        Append result = new Append(spreadsheetId, range, content);
        initialize(result);
        return result;
      }

      public class Append extends SheetsRequest<com.google.api.services.sheets.v4.model.AppendValuesResponse> {

        private static final String REST_PATH = "v4/spreadsheets/{spreadsheetId}/values/{range}:append";

        /**
         * Appends values to a spreadsheet. The input range is used to search for existing data and find a
         * "table" within that range. Values will be appended to the next row of the table, starting with
         * the first column of the table. See the [guide](/sheets/guides/values#appending_values) and
         * [sample code](/sheets/samples/writing#append_values) for specific details of how tables are
         * detected and data is appended.
         *
         * The caller must specify the spreadsheet ID, range, and a valueInputOption.  The
         * `valueInputOption` only controls how the input data will be added to the sheet (column-wise or
         * row-wise), it does not influence what cell the data starts being written to.
         *
         * Create a request for the method "values.append".
         *
         * This request holds the parameters needed by the the sheets server.  After setting any optional
         * parameters, call the {@link Append#execute()} method to invoke the remote operation. <p> {@link
         * Append#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param spreadsheetId The ID of the spreadsheet to update.
         * @param range The A1 notation of a range to search for a logical table of data.
      Values will be appended after the
       *        last row of the table.
         * @param content the {@link com.google.api.services.sheets.v4.model.ValueRange}
         * @since 1.13
         */
        protected Append(java.lang.String spreadsheetId, java.lang.String range, com.google.api.services.sheets.v4.model.ValueRange content) {
          super(Sheets.this, "POST", REST_PATH, content, com.google.api.services.sheets.v4.model.AppendValuesResponse.class);
          this.spreadsheetId = com.google.api.client.util.Preconditions.checkNotNull(spreadsheetId, "Required parameter spreadsheetId must be specified.");
          this.range = com.google.api.client.util.Preconditions.checkNotNull(range, "Required parameter range must be specified.");
        }

        @Override
        public Append set$Xgafv(java.lang.String $Xgafv) {
          return (Append) super.set$Xgafv($Xgafv);
        }

        @Override
        public Append setAccessToken(java.lang.String accessToken) {
          return (Append) super.setAccessToken(accessToken);
        }

        @Override
        public Append setAlt(java.lang.String alt) {
          return (Append) super.setAlt(alt);
        }

        @Override
        public Append setBearerToken(java.lang.String bearerToken) {
          return (Append) super.setBearerToken(bearerToken);
        }

        @Override
        public Append setCallback(java.lang.String callback) {
          return (Append) super.setCallback(callback);
        }

        @Override
        public Append setFields(java.lang.String fields) {
          return (Append) super.setFields(fields);
        }

        @Override
        public Append setKey(java.lang.String key) {
          return (Append) super.setKey(key);
        }

        @Override
        public Append setOauthToken(java.lang.String oauthToken) {
          return (Append) super.setOauthToken(oauthToken);
        }

        @Override
        public Append setPp(java.lang.Boolean pp) {
          return (Append) super.setPp(pp);
        }

        @Override
        public Append setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Append) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Append setQuotaUser(java.lang.String quotaUser) {
          return (Append) super.setQuotaUser(quotaUser);
        }

        @Override
        public Append setUploadType(java.lang.String uploadType) {
          return (Append) super.setUploadType(uploadType);
        }

        @Override
        public Append setUploadProtocol(java.lang.String uploadProtocol) {
          return (Append) super.setUploadProtocol(uploadProtocol);
        }

        /** The ID of the spreadsheet to update. */
        @com.google.api.client.util.Key
        private java.lang.String spreadsheetId;

        /** The ID of the spreadsheet to update.
         */
        public java.lang.String getSpreadsheetId() {
          return spreadsheetId;
        }

        /** The ID of the spreadsheet to update. */
        public Append setSpreadsheetId(java.lang.String spreadsheetId) {
          this.spreadsheetId = spreadsheetId;
          return this;
        }

        /**
         * The A1 notation of a range to search for a logical table of data. Values will be appended
         * after the last row of the table.
         */
        @com.google.api.client.util.Key
        private java.lang.String range;

        /** The A1 notation of a range to search for a logical table of data. Values will be appended after the
       last row of the table.
         */
        public java.lang.String getRange() {
          return range;
        }

        /**
         * The A1 notation of a range to search for a logical table of data. Values will be appended
         * after the last row of the table.
         */
        public Append setRange(java.lang.String range) {
          this.range = range;
          return this;
        }

        /** How the input data should be interpreted. */
        @com.google.api.client.util.Key
        private java.lang.String valueInputOption;

        /** How the input data should be interpreted.
         */
        public java.lang.String getValueInputOption() {
          return valueInputOption;
        }

        /** How the input data should be interpreted. */
        public Append setValueInputOption(java.lang.String valueInputOption) {
          this.valueInputOption = valueInputOption;
          return this;
        }

        /** How the input data should be inserted. */
        @com.google.api.client.util.Key
        private java.lang.String insertDataOption;

        /** How the input data should be inserted.
         */
        public java.lang.String getInsertDataOption() {
          return insertDataOption;
        }

        /** How the input data should be inserted. */
        public Append setInsertDataOption(java.lang.String insertDataOption) {
          this.insertDataOption = insertDataOption;
          return this;
        }

        @Override
        public Append set(String parameterName, Object value) {
          return (Append) super.set(parameterName, value);
        }
      }
      /**
       * Returns one or more ranges of values from a spreadsheet. The caller must specify the spreadsheet
       * ID and one or more ranges.
       *
       * Create a request for the method "values.batchGet".
       *
       * This request holds the parameters needed by the sheets server.  After setting any optional
       * parameters, call the {@link BatchGet#execute()} method to invoke the remote operation.
       *
       * @param spreadsheetId The ID of the spreadsheet to retrieve data from.
       * @return the request
       */
      public BatchGet batchGet(java.lang.String spreadsheetId) throws java.io.IOException {
        BatchGet result = new BatchGet(spreadsheetId);
        initialize(result);
        return result;
      }

      public class BatchGet extends SheetsRequest<com.google.api.services.sheets.v4.model.BatchGetValuesResponse> {

        private static final String REST_PATH = "v4/spreadsheets/{spreadsheetId}/values:batchGet";

        /**
         * Returns one or more ranges of values from a spreadsheet. The caller must specify the
         * spreadsheet ID and one or more ranges.
         *
         * Create a request for the method "values.batchGet".
         *
         * This request holds the parameters needed by the the sheets server.  After setting any optional
         * parameters, call the {@link BatchGet#execute()} method to invoke the remote operation. <p>
         * {@link
         * BatchGet#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param spreadsheetId The ID of the spreadsheet to retrieve data from.
         * @since 1.13
         */
        protected BatchGet(java.lang.String spreadsheetId) {
          super(Sheets.this, "GET", REST_PATH, null, com.google.api.services.sheets.v4.model.BatchGetValuesResponse.class);
          this.spreadsheetId = com.google.api.client.util.Preconditions.checkNotNull(spreadsheetId, "Required parameter spreadsheetId must be specified.");
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public BatchGet set$Xgafv(java.lang.String $Xgafv) {
          return (BatchGet) super.set$Xgafv($Xgafv);
        }

        @Override
        public BatchGet setAccessToken(java.lang.String accessToken) {
          return (BatchGet) super.setAccessToken(accessToken);
        }

        @Override
        public BatchGet setAlt(java.lang.String alt) {
          return (BatchGet) super.setAlt(alt);
        }

        @Override
        public BatchGet setBearerToken(java.lang.String bearerToken) {
          return (BatchGet) super.setBearerToken(bearerToken);
        }

        @Override
        public BatchGet setCallback(java.lang.String callback) {
          return (BatchGet) super.setCallback(callback);
        }

        @Override
        public BatchGet setFields(java.lang.String fields) {
          return (BatchGet) super.setFields(fields);
        }

        @Override
        public BatchGet setKey(java.lang.String key) {
          return (BatchGet) super.setKey(key);
        }

        @Override
        public BatchGet setOauthToken(java.lang.String oauthToken) {
          return (BatchGet) super.setOauthToken(oauthToken);
        }

        @Override
        public BatchGet setPp(java.lang.Boolean pp) {
          return (BatchGet) super.setPp(pp);
        }

        @Override
        public BatchGet setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (BatchGet) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public BatchGet setQuotaUser(java.lang.String quotaUser) {
          return (BatchGet) super.setQuotaUser(quotaUser);
        }

        @Override
        public BatchGet setUploadType(java.lang.String uploadType) {
          return (BatchGet) super.setUploadType(uploadType);
        }

        @Override
        public BatchGet setUploadProtocol(java.lang.String uploadProtocol) {
          return (BatchGet) super.setUploadProtocol(uploadProtocol);
        }

        /** The ID of the spreadsheet to retrieve data from. */
        @com.google.api.client.util.Key
        private java.lang.String spreadsheetId;

        /** The ID of the spreadsheet to retrieve data from.
         */
        public java.lang.String getSpreadsheetId() {
          return spreadsheetId;
        }

        /** The ID of the spreadsheet to retrieve data from. */
        public BatchGet setSpreadsheetId(java.lang.String spreadsheetId) {
          this.spreadsheetId = spreadsheetId;
          return this;
        }

        /** The A1 notation of the values to retrieve. */
        @com.google.api.client.util.Key
        private java.util.List<java.lang.String> ranges;

        /** The A1 notation of the values to retrieve.
         */
        public java.util.List<java.lang.String> getRanges() {
          return ranges;
        }

        /** The A1 notation of the values to retrieve. */
        public BatchGet setRanges(java.util.List<java.lang.String> ranges) {
          this.ranges = ranges;
          return this;
        }

        /** How values should be represented in the output. */
        @com.google.api.client.util.Key
        private java.lang.String valueRenderOption;

        /** How values should be represented in the output.
         */
        public java.lang.String getValueRenderOption() {
          return valueRenderOption;
        }

        /** How values should be represented in the output. */
        public BatchGet setValueRenderOption(java.lang.String valueRenderOption) {
          this.valueRenderOption = valueRenderOption;
          return this;
        }

        /**
         * How dates, times, and durations should be represented in the output. This is ignored if
         * value_render_option is FORMATTED_VALUE.
         */
        @com.google.api.client.util.Key
        private java.lang.String dateTimeRenderOption;

        /** How dates, times, and durations should be represented in the output. This is ignored if
       value_render_option is FORMATTED_VALUE.
         */
        public java.lang.String getDateTimeRenderOption() {
          return dateTimeRenderOption;
        }

        /**
         * How dates, times, and durations should be represented in the output. This is ignored if
         * value_render_option is FORMATTED_VALUE.
         */
        public BatchGet setDateTimeRenderOption(java.lang.String dateTimeRenderOption) {
          this.dateTimeRenderOption = dateTimeRenderOption;
          return this;
        }

        /**
         * The major dimension that results should use.
         *
         * For example, if the spreadsheet data is: `A1=1,B1=2,A2=3,B2=4`, then requesting
         * `range=A1:B2,majorDimension=ROWS` will return `[[1,2],[3,4]]`, whereas requesting
         * `range=A1:B2,majorDimension=COLUMNS` will return `[[1,3],[2,4]]`.
         */
        @com.google.api.client.util.Key
        private java.lang.String majorDimension;

        /** The major dimension that results should use.

       For example, if the spreadsheet data is: `A1=1,B1=2,A2=3,B2=4`, then requesting
       `range=A1:B2,majorDimension=ROWS` will return `[[1,2],[3,4]]`, whereas requesting
       `range=A1:B2,majorDimension=COLUMNS` will return `[[1,3],[2,4]]`.
         */
        public java.lang.String getMajorDimension() {
          return majorDimension;
        }

        /**
         * The major dimension that results should use.
         *
         * For example, if the spreadsheet data is: `A1=1,B1=2,A2=3,B2=4`, then requesting
         * `range=A1:B2,majorDimension=ROWS` will return `[[1,2],[3,4]]`, whereas requesting
         * `range=A1:B2,majorDimension=COLUMNS` will return `[[1,3],[2,4]]`.
         */
        public BatchGet setMajorDimension(java.lang.String majorDimension) {
          this.majorDimension = majorDimension;
          return this;
        }

        @Override
        public BatchGet set(String parameterName, Object value) {
          return (BatchGet) super.set(parameterName, value);
        }
      }
      /**
       * Sets values in one or more ranges of a spreadsheet. The caller must specify the spreadsheet ID, a
       * valueInputOption, and one or more ValueRanges.
       *
       * Create a request for the method "values.batchUpdate".
       *
       * This request holds the parameters needed by the sheets server.  After setting any optional
       * parameters, call the {@link BatchUpdate#execute()} method to invoke the remote operation.
       *
       * @param spreadsheetId The ID of the spreadsheet to update.
       * @param content the {@link com.google.api.services.sheets.v4.model.BatchUpdateValuesRequest}
       * @return the request
       */
      public BatchUpdate batchUpdate(java.lang.String spreadsheetId, com.google.api.services.sheets.v4.model.BatchUpdateValuesRequest content) throws java.io.IOException {
        BatchUpdate result = new BatchUpdate(spreadsheetId, content);
        initialize(result);
        return result;
      }

      public class BatchUpdate extends SheetsRequest<com.google.api.services.sheets.v4.model.BatchUpdateValuesResponse> {

        private static final String REST_PATH = "v4/spreadsheets/{spreadsheetId}/values:batchUpdate";

        /**
         * Sets values in one or more ranges of a spreadsheet. The caller must specify the spreadsheet ID,
         * a valueInputOption, and one or more ValueRanges.
         *
         * Create a request for the method "values.batchUpdate".
         *
         * This request holds the parameters needed by the the sheets server.  After setting any optional
         * parameters, call the {@link BatchUpdate#execute()} method to invoke the remote operation. <p>
         * {@link
         * BatchUpdate#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param spreadsheetId The ID of the spreadsheet to update.
         * @param content the {@link com.google.api.services.sheets.v4.model.BatchUpdateValuesRequest}
         * @since 1.13
         */
        protected BatchUpdate(java.lang.String spreadsheetId, com.google.api.services.sheets.v4.model.BatchUpdateValuesRequest content) {
          super(Sheets.this, "POST", REST_PATH, content, com.google.api.services.sheets.v4.model.BatchUpdateValuesResponse.class);
          this.spreadsheetId = com.google.api.client.util.Preconditions.checkNotNull(spreadsheetId, "Required parameter spreadsheetId must be specified.");
        }

        @Override
        public BatchUpdate set$Xgafv(java.lang.String $Xgafv) {
          return (BatchUpdate) super.set$Xgafv($Xgafv);
        }

        @Override
        public BatchUpdate setAccessToken(java.lang.String accessToken) {
          return (BatchUpdate) super.setAccessToken(accessToken);
        }

        @Override
        public BatchUpdate setAlt(java.lang.String alt) {
          return (BatchUpdate) super.setAlt(alt);
        }

        @Override
        public BatchUpdate setBearerToken(java.lang.String bearerToken) {
          return (BatchUpdate) super.setBearerToken(bearerToken);
        }

        @Override
        public BatchUpdate setCallback(java.lang.String callback) {
          return (BatchUpdate) super.setCallback(callback);
        }

        @Override
        public BatchUpdate setFields(java.lang.String fields) {
          return (BatchUpdate) super.setFields(fields);
        }

        @Override
        public BatchUpdate setKey(java.lang.String key) {
          return (BatchUpdate) super.setKey(key);
        }

        @Override
        public BatchUpdate setOauthToken(java.lang.String oauthToken) {
          return (BatchUpdate) super.setOauthToken(oauthToken);
        }

        @Override
        public BatchUpdate setPp(java.lang.Boolean pp) {
          return (BatchUpdate) super.setPp(pp);
        }

        @Override
        public BatchUpdate setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (BatchUpdate) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public BatchUpdate setQuotaUser(java.lang.String quotaUser) {
          return (BatchUpdate) super.setQuotaUser(quotaUser);
        }

        @Override
        public BatchUpdate setUploadType(java.lang.String uploadType) {
          return (BatchUpdate) super.setUploadType(uploadType);
        }

        @Override
        public BatchUpdate setUploadProtocol(java.lang.String uploadProtocol) {
          return (BatchUpdate) super.setUploadProtocol(uploadProtocol);
        }

        /** The ID of the spreadsheet to update. */
        @com.google.api.client.util.Key
        private java.lang.String spreadsheetId;

        /** The ID of the spreadsheet to update.
         */
        public java.lang.String getSpreadsheetId() {
          return spreadsheetId;
        }

        /** The ID of the spreadsheet to update. */
        public BatchUpdate setSpreadsheetId(java.lang.String spreadsheetId) {
          this.spreadsheetId = spreadsheetId;
          return this;
        }

        @Override
        public BatchUpdate set(String parameterName, Object value) {
          return (BatchUpdate) super.set(parameterName, value);
        }
      }
      /**
       * Returns a range of values from a spreadsheet. The caller must specify the spreadsheet ID and a
       * range.
       *
       * Create a request for the method "values.get".
       *
       * This request holds the parameters needed by the sheets server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation.
       *
       * @param spreadsheetId The ID of the spreadsheet to retrieve data from.
       * @param range The A1 notation of the values to retrieve.
       * @return the request
       */
      public Get get(java.lang.String spreadsheetId, java.lang.String range) throws java.io.IOException {
        Get result = new Get(spreadsheetId, range);
        initialize(result);
        return result;
      }

      public class Get extends SheetsRequest<com.google.api.services.sheets.v4.model.ValueRange> {

        private static final String REST_PATH = "v4/spreadsheets/{spreadsheetId}/values/{range}";

        /**
         * Returns a range of values from a spreadsheet. The caller must specify the spreadsheet ID and a
         * range.
         *
         * Create a request for the method "values.get".
         *
         * This request holds the parameters needed by the the sheets server.  After setting any optional
         * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
         * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
         * called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param spreadsheetId The ID of the spreadsheet to retrieve data from.
         * @param range The A1 notation of the values to retrieve.
         * @since 1.13
         */
        protected Get(java.lang.String spreadsheetId, java.lang.String range) {
          super(Sheets.this, "GET", REST_PATH, null, com.google.api.services.sheets.v4.model.ValueRange.class);
          this.spreadsheetId = com.google.api.client.util.Preconditions.checkNotNull(spreadsheetId, "Required parameter spreadsheetId must be specified.");
          this.range = com.google.api.client.util.Preconditions.checkNotNull(range, "Required parameter range must be specified.");
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public Get set$Xgafv(java.lang.String $Xgafv) {
          return (Get) super.set$Xgafv($Xgafv);
        }

        @Override
        public Get setAccessToken(java.lang.String accessToken) {
          return (Get) super.setAccessToken(accessToken);
        }

        @Override
        public Get setAlt(java.lang.String alt) {
          return (Get) super.setAlt(alt);
        }

        @Override
        public Get setBearerToken(java.lang.String bearerToken) {
          return (Get) super.setBearerToken(bearerToken);
        }

        @Override
        public Get setCallback(java.lang.String callback) {
          return (Get) super.setCallback(callback);
        }

        @Override
        public Get setFields(java.lang.String fields) {
          return (Get) super.setFields(fields);
        }

        @Override
        public Get setKey(java.lang.String key) {
          return (Get) super.setKey(key);
        }

        @Override
        public Get setOauthToken(java.lang.String oauthToken) {
          return (Get) super.setOauthToken(oauthToken);
        }

        @Override
        public Get setPp(java.lang.Boolean pp) {
          return (Get) super.setPp(pp);
        }

        @Override
        public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Get) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Get setQuotaUser(java.lang.String quotaUser) {
          return (Get) super.setQuotaUser(quotaUser);
        }

        @Override
        public Get setUploadType(java.lang.String uploadType) {
          return (Get) super.setUploadType(uploadType);
        }

        @Override
        public Get setUploadProtocol(java.lang.String uploadProtocol) {
          return (Get) super.setUploadProtocol(uploadProtocol);
        }

        /** The ID of the spreadsheet to retrieve data from. */
        @com.google.api.client.util.Key
        private java.lang.String spreadsheetId;

        /** The ID of the spreadsheet to retrieve data from.
         */
        public java.lang.String getSpreadsheetId() {
          return spreadsheetId;
        }

        /** The ID of the spreadsheet to retrieve data from. */
        public Get setSpreadsheetId(java.lang.String spreadsheetId) {
          this.spreadsheetId = spreadsheetId;
          return this;
        }

        /** The A1 notation of the values to retrieve. */
        @com.google.api.client.util.Key
        private java.lang.String range;

        /** The A1 notation of the values to retrieve.
         */
        public java.lang.String getRange() {
          return range;
        }

        /** The A1 notation of the values to retrieve. */
        public Get setRange(java.lang.String range) {
          this.range = range;
          return this;
        }

        /** How values should be represented in the output. */
        @com.google.api.client.util.Key
        private java.lang.String valueRenderOption;

        /** How values should be represented in the output.
         */
        public java.lang.String getValueRenderOption() {
          return valueRenderOption;
        }

        /** How values should be represented in the output. */
        public Get setValueRenderOption(java.lang.String valueRenderOption) {
          this.valueRenderOption = valueRenderOption;
          return this;
        }

        /**
         * How dates, times, and durations should be represented in the output. This is ignored if
         * value_render_option is FORMATTED_VALUE.
         */
        @com.google.api.client.util.Key
        private java.lang.String dateTimeRenderOption;

        /** How dates, times, and durations should be represented in the output. This is ignored if
       value_render_option is FORMATTED_VALUE.
         */
        public java.lang.String getDateTimeRenderOption() {
          return dateTimeRenderOption;
        }

        /**
         * How dates, times, and durations should be represented in the output. This is ignored if
         * value_render_option is FORMATTED_VALUE.
         */
        public Get setDateTimeRenderOption(java.lang.String dateTimeRenderOption) {
          this.dateTimeRenderOption = dateTimeRenderOption;
          return this;
        }

        /**
         * The major dimension that results should use.
         *
         * For example, if the spreadsheet data is: `A1=1,B1=2,A2=3,B2=4`, then requesting
         * `range=A1:B2,majorDimension=ROWS` will return `[[1,2],[3,4]]`, whereas requesting
         * `range=A1:B2,majorDimension=COLUMNS` will return `[[1,3],[2,4]]`.
         */
        @com.google.api.client.util.Key
        private java.lang.String majorDimension;

        /** The major dimension that results should use.

       For example, if the spreadsheet data is: `A1=1,B1=2,A2=3,B2=4`, then requesting
       `range=A1:B2,majorDimension=ROWS` will return `[[1,2],[3,4]]`, whereas requesting
       `range=A1:B2,majorDimension=COLUMNS` will return `[[1,3],[2,4]]`.
         */
        public java.lang.String getMajorDimension() {
          return majorDimension;
        }

        /**
         * The major dimension that results should use.
         *
         * For example, if the spreadsheet data is: `A1=1,B1=2,A2=3,B2=4`, then requesting
         * `range=A1:B2,majorDimension=ROWS` will return `[[1,2],[3,4]]`, whereas requesting
         * `range=A1:B2,majorDimension=COLUMNS` will return `[[1,3],[2,4]]`.
         */
        public Get setMajorDimension(java.lang.String majorDimension) {
          this.majorDimension = majorDimension;
          return this;
        }

        @Override
        public Get set(String parameterName, Object value) {
          return (Get) super.set(parameterName, value);
        }
      }
      /**
       * Sets values in a range of a spreadsheet. The caller must specify the spreadsheet ID, range, and a
       * valueInputOption.
       *
       * Create a request for the method "values.update".
       *
       * This request holds the parameters needed by the sheets server.  After setting any optional
       * parameters, call the {@link Update#execute()} method to invoke the remote operation.
       *
       * @param spreadsheetId The ID of the spreadsheet to update.
       * @param range The A1 notation of the values to update.
       * @param content the {@link com.google.api.services.sheets.v4.model.ValueRange}
       * @return the request
       */
      public Update update(java.lang.String spreadsheetId, java.lang.String range, com.google.api.services.sheets.v4.model.ValueRange content) throws java.io.IOException {
        Update result = new Update(spreadsheetId, range, content);
        initialize(result);
        return result;
      }

      public class Update extends SheetsRequest<com.google.api.services.sheets.v4.model.UpdateValuesResponse> {

        private static final String REST_PATH = "v4/spreadsheets/{spreadsheetId}/values/{range}";

        /**
         * Sets values in a range of a spreadsheet. The caller must specify the spreadsheet ID, range, and
         * a valueInputOption.
         *
         * Create a request for the method "values.update".
         *
         * This request holds the parameters needed by the the sheets server.  After setting any optional
         * parameters, call the {@link Update#execute()} method to invoke the remote operation. <p> {@link
         * Update#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param spreadsheetId The ID of the spreadsheet to update.
         * @param range The A1 notation of the values to update.
         * @param content the {@link com.google.api.services.sheets.v4.model.ValueRange}
         * @since 1.13
         */
        protected Update(java.lang.String spreadsheetId, java.lang.String range, com.google.api.services.sheets.v4.model.ValueRange content) {
          super(Sheets.this, "PUT", REST_PATH, content, com.google.api.services.sheets.v4.model.UpdateValuesResponse.class);
          this.spreadsheetId = com.google.api.client.util.Preconditions.checkNotNull(spreadsheetId, "Required parameter spreadsheetId must be specified.");
          this.range = com.google.api.client.util.Preconditions.checkNotNull(range, "Required parameter range must be specified.");
        }

        @Override
        public Update set$Xgafv(java.lang.String $Xgafv) {
          return (Update) super.set$Xgafv($Xgafv);
        }

        @Override
        public Update setAccessToken(java.lang.String accessToken) {
          return (Update) super.setAccessToken(accessToken);
        }

        @Override
        public Update setAlt(java.lang.String alt) {
          return (Update) super.setAlt(alt);
        }

        @Override
        public Update setBearerToken(java.lang.String bearerToken) {
          return (Update) super.setBearerToken(bearerToken);
        }

        @Override
        public Update setCallback(java.lang.String callback) {
          return (Update) super.setCallback(callback);
        }

        @Override
        public Update setFields(java.lang.String fields) {
          return (Update) super.setFields(fields);
        }

        @Override
        public Update setKey(java.lang.String key) {
          return (Update) super.setKey(key);
        }

        @Override
        public Update setOauthToken(java.lang.String oauthToken) {
          return (Update) super.setOauthToken(oauthToken);
        }

        @Override
        public Update setPp(java.lang.Boolean pp) {
          return (Update) super.setPp(pp);
        }

        @Override
        public Update setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Update) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Update setQuotaUser(java.lang.String quotaUser) {
          return (Update) super.setQuotaUser(quotaUser);
        }

        @Override
        public Update setUploadType(java.lang.String uploadType) {
          return (Update) super.setUploadType(uploadType);
        }

        @Override
        public Update setUploadProtocol(java.lang.String uploadProtocol) {
          return (Update) super.setUploadProtocol(uploadProtocol);
        }

        /** The ID of the spreadsheet to update. */
        @com.google.api.client.util.Key
        private java.lang.String spreadsheetId;

        /** The ID of the spreadsheet to update.
         */
        public java.lang.String getSpreadsheetId() {
          return spreadsheetId;
        }

        /** The ID of the spreadsheet to update. */
        public Update setSpreadsheetId(java.lang.String spreadsheetId) {
          this.spreadsheetId = spreadsheetId;
          return this;
        }

        /** The A1 notation of the values to update. */
        @com.google.api.client.util.Key
        private java.lang.String range;

        /** The A1 notation of the values to update.
         */
        public java.lang.String getRange() {
          return range;
        }

        /** The A1 notation of the values to update. */
        public Update setRange(java.lang.String range) {
          this.range = range;
          return this;
        }

        /** How the input data should be interpreted. */
        @com.google.api.client.util.Key
        private java.lang.String valueInputOption;

        /** How the input data should be interpreted.
         */
        public java.lang.String getValueInputOption() {
          return valueInputOption;
        }

        /** How the input data should be interpreted. */
        public Update setValueInputOption(java.lang.String valueInputOption) {
          this.valueInputOption = valueInputOption;
          return this;
        }

        @Override
        public Update set(String parameterName, Object value) {
          return (Update) super.set(parameterName, value);
        }
      }

    }
  }

  /**
   * Builder for {@link Sheets}.
   *
   * <p>
   * Implementation is not thread-safe.
   * </p>
   *
   * @since 1.3.0
   */
  public static final class Builder extends com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient.Builder {

    /**
     * Returns an instance of a new builder.
     *
     * @param transport HTTP transport, which should normally be:
     *        <ul>
     *        <li>Google App Engine:
     *        {@code com.google.api.client.extensions.appengine.http.UrlFetchTransport}</li>
     *        <li>Android: {@code newCompatibleTransport} from
     *        {@code com.google.api.client.extensions.android.http.AndroidHttp}</li>
     *        <li>Java: {@link com.google.api.client.googleapis.javanet.GoogleNetHttpTransport#newTrustedTransport()}
     *        </li>
     *        </ul>
     * @param jsonFactory JSON factory, which may be:
     *        <ul>
     *        <li>Jackson: {@code com.google.api.client.json.jackson2.JacksonFactory}</li>
     *        <li>Google GSON: {@code com.google.api.client.json.gson.GsonFactory}</li>
     *        <li>Android Honeycomb or higher:
     *        {@code com.google.api.client.extensions.android.json.AndroidJsonFactory}</li>
     *        </ul>
     * @param httpRequestInitializer HTTP request initializer or {@code null} for none
     * @since 1.7
     */
    public Builder(com.google.api.client.http.HttpTransport transport, com.google.api.client.json.JsonFactory jsonFactory,
        com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
      super(
          transport,
          jsonFactory,
          DEFAULT_ROOT_URL,
          DEFAULT_SERVICE_PATH,
          httpRequestInitializer,
          false);
    }

    /** Builds a new instance of {@link Sheets}. */
    @Override
    public Sheets build() {
      return new Sheets(this);
    }

    @Override
    public Builder setRootUrl(String rootUrl) {
      return (Builder) super.setRootUrl(rootUrl);
    }

    @Override
    public Builder setServicePath(String servicePath) {
      return (Builder) super.setServicePath(servicePath);
    }

    @Override
    public Builder setHttpRequestInitializer(com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
      return (Builder) super.setHttpRequestInitializer(httpRequestInitializer);
    }

    @Override
    public Builder setApplicationName(String applicationName) {
      return (Builder) super.setApplicationName(applicationName);
    }

    @Override
    public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
      return (Builder) super.setSuppressPatternChecks(suppressPatternChecks);
    }

    @Override
    public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
      return (Builder) super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
    }

    @Override
    public Builder setSuppressAllChecks(boolean suppressAllChecks) {
      return (Builder) super.setSuppressAllChecks(suppressAllChecks);
    }

    /**
     * Set the {@link SheetsRequestInitializer}.
     *
     * @since 1.12
     */
    public Builder setSheetsRequestInitializer(
        SheetsRequestInitializer sheetsRequestInitializer) {
      return (Builder) super.setGoogleClientRequestInitializer(sheetsRequestInitializer);
    }

    @Override
    public Builder setGoogleClientRequestInitializer(
        com.google.api.client.googleapis.services.GoogleClientRequestInitializer googleClientRequestInitializer) {
      return (Builder) super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
    }
  }
}
