/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2016-05-27 16:00:31 UTC)
 * on 2016-08-01 at 17:26:50 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.sheets.v4.model;

/**
 * A rule that applies a gradient color scale format, based on the interpolation points listed. The
 * format of a cell will vary based on its contents as compared to the values of the interpolation
 * points.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Sheets API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class GradientRule extends com.google.api.client.json.GenericJson {

  /**
   * The final interpolation point.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private InterpolationPoint maxpoint;

  /**
   * An optional midway interpolation point.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private InterpolationPoint midpoint;

  /**
   * The starting interpolation point.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private InterpolationPoint minpoint;

  /**
   * The final interpolation point.
   * @return value or {@code null} for none
   */
  public InterpolationPoint getMaxpoint() {
    return maxpoint;
  }

  /**
   * The final interpolation point.
   * @param maxpoint maxpoint or {@code null} for none
   */
  public GradientRule setMaxpoint(InterpolationPoint maxpoint) {
    this.maxpoint = maxpoint;
    return this;
  }

  /**
   * An optional midway interpolation point.
   * @return value or {@code null} for none
   */
  public InterpolationPoint getMidpoint() {
    return midpoint;
  }

  /**
   * An optional midway interpolation point.
   * @param midpoint midpoint or {@code null} for none
   */
  public GradientRule setMidpoint(InterpolationPoint midpoint) {
    this.midpoint = midpoint;
    return this;
  }

  /**
   * The starting interpolation point.
   * @return value or {@code null} for none
   */
  public InterpolationPoint getMinpoint() {
    return minpoint;
  }

  /**
   * The starting interpolation point.
   * @param minpoint minpoint or {@code null} for none
   */
  public GradientRule setMinpoint(InterpolationPoint minpoint) {
    this.minpoint = minpoint;
    return this;
  }

  @Override
  public GradientRule set(String fieldName, Object value) {
    return (GradientRule) super.set(fieldName, value);
  }

  @Override
  public GradientRule clone() {
    return (GradientRule) super.clone();
  }

}
