/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2016-05-27 16:00:31 UTC)
 * on 2016-08-03 at 19:34:56 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.sheets.v4.model;

/**
 * The position of an embedded object such as a chart.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Sheets API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class EmbeddedObjectPosition extends com.google.api.client.json.GenericJson {

  /**
   * If true, the embedded object will be put on a new sheet whose ID is chosen for you. Used only
   * when writing.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean newSheet;

  /**
   * The position at which the object is overlaid on top of a grid.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private OverlayPosition overlayPosition;

  /**
   * The sheet this is on. Set only if the embedded object is on its own sheet. Must be non-
   * negative.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer sheetId;

  /**
   * If true, the embedded object will be put on a new sheet whose ID is chosen for you. Used only
   * when writing.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getNewSheet() {
    return newSheet;
  }

  /**
   * If true, the embedded object will be put on a new sheet whose ID is chosen for you. Used only
   * when writing.
   * @param newSheet newSheet or {@code null} for none
   */
  public EmbeddedObjectPosition setNewSheet(java.lang.Boolean newSheet) {
    this.newSheet = newSheet;
    return this;
  }

  /**
   * The position at which the object is overlaid on top of a grid.
   * @return value or {@code null} for none
   */
  public OverlayPosition getOverlayPosition() {
    return overlayPosition;
  }

  /**
   * The position at which the object is overlaid on top of a grid.
   * @param overlayPosition overlayPosition or {@code null} for none
   */
  public EmbeddedObjectPosition setOverlayPosition(OverlayPosition overlayPosition) {
    this.overlayPosition = overlayPosition;
    return this;
  }

  /**
   * The sheet this is on. Set only if the embedded object is on its own sheet. Must be non-
   * negative.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getSheetId() {
    return sheetId;
  }

  /**
   * The sheet this is on. Set only if the embedded object is on its own sheet. Must be non-
   * negative.
   * @param sheetId sheetId or {@code null} for none
   */
  public EmbeddedObjectPosition setSheetId(java.lang.Integer sheetId) {
    this.sheetId = sheetId;
    return this;
  }

  @Override
  public EmbeddedObjectPosition set(String fieldName, Object value) {
    return (EmbeddedObjectPosition) super.set(fieldName, value);
  }

  @Override
  public EmbeddedObjectPosition clone() {
    return (EmbeddedObjectPosition) super.clone();
  }

}
