/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2016-07-08 17:28:43 UTC)
 * on 2016-08-23 at 01:06:28 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.sheets.v4.model;

/**
 * An axis of the chart. A chart may not have more than one axis per axis position.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Sheets API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class BasicChartAxis extends com.google.api.client.json.GenericJson {

  /**
   * The format of the title. Only valid if the axis is not associated with the domain.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private TextFormat format;

  /**
   * The position of this axis.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String position;

  /**
   * The title of this axis. If set, this overrides any title inferred from headers of the data.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String title;

  /**
   * The format of the title. Only valid if the axis is not associated with the domain.
   * @return value or {@code null} for none
   */
  public TextFormat getFormat() {
    return format;
  }

  /**
   * The format of the title. Only valid if the axis is not associated with the domain.
   * @param format format or {@code null} for none
   */
  public BasicChartAxis setFormat(TextFormat format) {
    this.format = format;
    return this;
  }

  /**
   * The position of this axis.
   * @return value or {@code null} for none
   */
  public java.lang.String getPosition() {
    return position;
  }

  /**
   * The position of this axis.
   * @param position position or {@code null} for none
   */
  public BasicChartAxis setPosition(java.lang.String position) {
    this.position = position;
    return this;
  }

  /**
   * The title of this axis. If set, this overrides any title inferred from headers of the data.
   * @return value or {@code null} for none
   */
  public java.lang.String getTitle() {
    return title;
  }

  /**
   * The title of this axis. If set, this overrides any title inferred from headers of the data.
   * @param title title or {@code null} for none
   */
  public BasicChartAxis setTitle(java.lang.String title) {
    this.title = title;
    return this;
  }

  @Override
  public BasicChartAxis set(String fieldName, Object value) {
    return (BasicChartAxis) super.set(fieldName, value);
  }

  @Override
  public BasicChartAxis clone() {
    return (BasicChartAxis) super.clone();
  }

}
