/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2016-07-08 17:28:43 UTC)
 * on 2016-08-23 at 01:06:54 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.sheets.v4.model;

/**
 * Inserts rows or columns in a sheet at a particular index.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Sheets API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class InsertDimensionRequest extends com.google.api.client.json.GenericJson {

  /**
   * Whether dimension properties should be extended from the dimensions before or after the newly
   * inserted dimensions. True to inherit from the dimensions before (in which case the start index
   * must be greater than 0), and false to inherit from the dimensions after.
   *
   * For example, if row index 0 has red background and row index 1 has a green background, then
   * inserting 2 rows at index 1 can inherit either the green or red background.  If
   * `inheritFromBefore` is true, the two new rows will be red (because the row before the insertion
   * point was red), whereas if `inheritFromBefore` is false, the two new rows will be green
   * (because the row after the insertion point was green).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean inheritFromBefore;

  /**
   * The dimensions to insert.  Both the start and end indexes must be bounded.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DimensionRange range;

  /**
   * Whether dimension properties should be extended from the dimensions before or after the newly
   * inserted dimensions. True to inherit from the dimensions before (in which case the start index
   * must be greater than 0), and false to inherit from the dimensions after.
   *
   * For example, if row index 0 has red background and row index 1 has a green background, then
   * inserting 2 rows at index 1 can inherit either the green or red background.  If
   * `inheritFromBefore` is true, the two new rows will be red (because the row before the insertion
   * point was red), whereas if `inheritFromBefore` is false, the two new rows will be green
   * (because the row after the insertion point was green).
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getInheritFromBefore() {
    return inheritFromBefore;
  }

  /**
   * Whether dimension properties should be extended from the dimensions before or after the newly
   * inserted dimensions. True to inherit from the dimensions before (in which case the start index
   * must be greater than 0), and false to inherit from the dimensions after.
   *
   * For example, if row index 0 has red background and row index 1 has a green background, then
   * inserting 2 rows at index 1 can inherit either the green or red background.  If
   * `inheritFromBefore` is true, the two new rows will be red (because the row before the insertion
   * point was red), whereas if `inheritFromBefore` is false, the two new rows will be green
   * (because the row after the insertion point was green).
   * @param inheritFromBefore inheritFromBefore or {@code null} for none
   */
  public InsertDimensionRequest setInheritFromBefore(java.lang.Boolean inheritFromBefore) {
    this.inheritFromBefore = inheritFromBefore;
    return this;
  }

  /**
   * The dimensions to insert.  Both the start and end indexes must be bounded.
   * @return value or {@code null} for none
   */
  public DimensionRange getRange() {
    return range;
  }

  /**
   * The dimensions to insert.  Both the start and end indexes must be bounded.
   * @param range range or {@code null} for none
   */
  public InsertDimensionRequest setRange(DimensionRange range) {
    this.range = range;
    return this;
  }

  @Override
  public InsertDimensionRequest set(String fieldName, Object value) {
    return (InsertDimensionRequest) super.set(fieldName, value);
  }

  @Override
  public InsertDimensionRequest clone() {
    return (InsertDimensionRequest) super.clone();
  }

}
