/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2016-07-08 17:28:43 UTC)
 * on 2016-08-23 at 01:06:46 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.sheets.v4.model;

/**
 * Updates properties of the filter view.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Sheets API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class UpdateFilterViewRequest extends com.google.api.client.json.GenericJson {

  /**
   * The fields that should be updated.  At least one field must be specified. The root `filter` is
   * implied and should not be specified. A single `"*"` can be used as short-hand for listing every
   * field.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String fields;

  /**
   * The new properties of the filter view.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private FilterView filter;

  /**
   * The fields that should be updated.  At least one field must be specified. The root `filter` is
   * implied and should not be specified. A single `"*"` can be used as short-hand for listing every
   * field.
   * @return value or {@code null} for none
   */
  public String getFields() {
    return fields;
  }

  /**
   * The fields that should be updated.  At least one field must be specified. The root `filter` is
   * implied and should not be specified. A single `"*"` can be used as short-hand for listing every
   * field.
   * @param fields fields or {@code null} for none
   */
  public UpdateFilterViewRequest setFields(String fields) {
    this.fields = fields;
    return this;
  }

  /**
   * The new properties of the filter view.
   * @return value or {@code null} for none
   */
  public FilterView getFilter() {
    return filter;
  }

  /**
   * The new properties of the filter view.
   * @param filter filter or {@code null} for none
   */
  public UpdateFilterViewRequest setFilter(FilterView filter) {
    this.filter = filter;
    return this;
  }

  @Override
  public UpdateFilterViewRequest set(String fieldName, Object value) {
    return (UpdateFilterViewRequest) super.set(fieldName, value);
  }

  @Override
  public UpdateFilterViewRequest clone() {
    return (UpdateFilterViewRequest) super.clone();
  }

}
