/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2016-05-04 15:59:39 UTC)
 * on 2016-05-16 at 19:38:35 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.sheets.v4.model;

/**
 * A sheet in a spreadsheet.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Sheets API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Sheet extends com.google.api.client.json.GenericJson {

  /**
   * The filter on this sheet, if any.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private BasicFilter basicFilter;

  /**
   * The specifications of every chart on this sheet.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<EmbeddedChart> charts;

  static {
    // hack to force ProGuard to consider EmbeddedChart used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(EmbeddedChart.class);
  }

  /**
   * The conditional format rules in this sheet.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<ConditionalFormatRule> conditionalFormats;

  static {
    // hack to force ProGuard to consider ConditionalFormatRule used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(ConditionalFormatRule.class);
  }

  /**
   * Data in the grid, if this is a grid sheet. The number of GridData objects returned is dependent
   * on the number of ranges requested on this sheet. For example, if this is representing `Sheet1`,
   * and the spreadsheet was requested with ranges `Sheet1!A1:C10` and `Sheet1!D15:E20`, then the
   * first GridData will have a startRow/startColumn of `0`, while the second one will have
   * `startRow 14` (zero-based row 15), and `startColumn 3` (zero-based column D).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<GridData> data;

  static {
    // hack to force ProGuard to consider GridData used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(GridData.class);
  }

  /**
   * The filter views in this sheet.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<FilterView> filterViews;

  static {
    // hack to force ProGuard to consider FilterView used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(FilterView.class);
  }

  /**
   * The ranges that are merged together.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<GridRange> merges;

  static {
    // hack to force ProGuard to consider GridRange used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(GridRange.class);
  }

  /**
   * The properties of the sheet.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private SheetProperties properties;

  /**
   * The protected ranges in this sheet.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<ProtectedRange> protectedRanges;

  static {
    // hack to force ProGuard to consider ProtectedRange used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(ProtectedRange.class);
  }

  /**
   * The filter on this sheet, if any.
   * @return value or {@code null} for none
   */
  public BasicFilter getBasicFilter() {
    return basicFilter;
  }

  /**
   * The filter on this sheet, if any.
   * @param basicFilter basicFilter or {@code null} for none
   */
  public Sheet setBasicFilter(BasicFilter basicFilter) {
    this.basicFilter = basicFilter;
    return this;
  }

  /**
   * The specifications of every chart on this sheet.
   * @return value or {@code null} for none
   */
  public java.util.List<EmbeddedChart> getCharts() {
    return charts;
  }

  /**
   * The specifications of every chart on this sheet.
   * @param charts charts or {@code null} for none
   */
  public Sheet setCharts(java.util.List<EmbeddedChart> charts) {
    this.charts = charts;
    return this;
  }

  /**
   * The conditional format rules in this sheet.
   * @return value or {@code null} for none
   */
  public java.util.List<ConditionalFormatRule> getConditionalFormats() {
    return conditionalFormats;
  }

  /**
   * The conditional format rules in this sheet.
   * @param conditionalFormats conditionalFormats or {@code null} for none
   */
  public Sheet setConditionalFormats(java.util.List<ConditionalFormatRule> conditionalFormats) {
    this.conditionalFormats = conditionalFormats;
    return this;
  }

  /**
   * Data in the grid, if this is a grid sheet. The number of GridData objects returned is dependent
   * on the number of ranges requested on this sheet. For example, if this is representing `Sheet1`,
   * and the spreadsheet was requested with ranges `Sheet1!A1:C10` and `Sheet1!D15:E20`, then the
   * first GridData will have a startRow/startColumn of `0`, while the second one will have
   * `startRow 14` (zero-based row 15), and `startColumn 3` (zero-based column D).
   * @return value or {@code null} for none
   */
  public java.util.List<GridData> getData() {
    return data;
  }

  /**
   * Data in the grid, if this is a grid sheet. The number of GridData objects returned is dependent
   * on the number of ranges requested on this sheet. For example, if this is representing `Sheet1`,
   * and the spreadsheet was requested with ranges `Sheet1!A1:C10` and `Sheet1!D15:E20`, then the
   * first GridData will have a startRow/startColumn of `0`, while the second one will have
   * `startRow 14` (zero-based row 15), and `startColumn 3` (zero-based column D).
   * @param data data or {@code null} for none
   */
  public Sheet setData(java.util.List<GridData> data) {
    this.data = data;
    return this;
  }

  /**
   * The filter views in this sheet.
   * @return value or {@code null} for none
   */
  public java.util.List<FilterView> getFilterViews() {
    return filterViews;
  }

  /**
   * The filter views in this sheet.
   * @param filterViews filterViews or {@code null} for none
   */
  public Sheet setFilterViews(java.util.List<FilterView> filterViews) {
    this.filterViews = filterViews;
    return this;
  }

  /**
   * The ranges that are merged together.
   * @return value or {@code null} for none
   */
  public java.util.List<GridRange> getMerges() {
    return merges;
  }

  /**
   * The ranges that are merged together.
   * @param merges merges or {@code null} for none
   */
  public Sheet setMerges(java.util.List<GridRange> merges) {
    this.merges = merges;
    return this;
  }

  /**
   * The properties of the sheet.
   * @return value or {@code null} for none
   */
  public SheetProperties getProperties() {
    return properties;
  }

  /**
   * The properties of the sheet.
   * @param properties properties or {@code null} for none
   */
  public Sheet setProperties(SheetProperties properties) {
    this.properties = properties;
    return this;
  }

  /**
   * The protected ranges in this sheet.
   * @return value or {@code null} for none
   */
  public java.util.List<ProtectedRange> getProtectedRanges() {
    return protectedRanges;
  }

  /**
   * The protected ranges in this sheet.
   * @param protectedRanges protectedRanges or {@code null} for none
   */
  public Sheet setProtectedRanges(java.util.List<ProtectedRange> protectedRanges) {
    this.protectedRanges = protectedRanges;
    return this;
  }

  @Override
  public Sheet set(String fieldName, Object value) {
    return (Sheet) super.set(fieldName, value);
  }

  @Override
  public Sheet clone() {
    return (Sheet) super.clone();
  }

}
