/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.sheets.v4.model;

/**
 * The request for retrieving a range of values in a spreadsheet selected by a set of DataFilters.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Sheets API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class BatchGetValuesByDataFilterRequest extends com.google.api.client.json.GenericJson {

  /**
   * The data filters used to match the ranges of values to retrieve. Ranges that match any of the
   * specified data filters are included in the response.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<DataFilter> dataFilters;

  /**
   * How dates, times, and durations should be represented in the output. This is ignored if
   * value_render_option is FORMATTED_VALUE. The default dateTime render option is
   * [DateTimeRenderOption.SERIAL_NUMBER].
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String dateTimeRenderOption;

  /**
   * The major dimension that results should use.
   *
   * For example, if the spreadsheet data is: `A1=1,B1=2,A2=3,B2=4`, then a request that selects
   * that range and sets `majorDimension=ROWS` returns `[[1,2],[3,4]]`, whereas a request that sets
   * `majorDimension=COLUMNS` returns `[[1,3],[2,4]]`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String majorDimension;

  /**
   * How values should be represented in the output. The default render option is
   * ValueRenderOption.FORMATTED_VALUE.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String valueRenderOption;

  /**
   * The data filters used to match the ranges of values to retrieve. Ranges that match any of the
   * specified data filters are included in the response.
   * @return value or {@code null} for none
   */
  public java.util.List<DataFilter> getDataFilters() {
    return dataFilters;
  }

  /**
   * The data filters used to match the ranges of values to retrieve. Ranges that match any of the
   * specified data filters are included in the response.
   * @param dataFilters dataFilters or {@code null} for none
   */
  public BatchGetValuesByDataFilterRequest setDataFilters(java.util.List<DataFilter> dataFilters) {
    this.dataFilters = dataFilters;
    return this;
  }

  /**
   * How dates, times, and durations should be represented in the output. This is ignored if
   * value_render_option is FORMATTED_VALUE. The default dateTime render option is
   * [DateTimeRenderOption.SERIAL_NUMBER].
   * @return value or {@code null} for none
   */
  public java.lang.String getDateTimeRenderOption() {
    return dateTimeRenderOption;
  }

  /**
   * How dates, times, and durations should be represented in the output. This is ignored if
   * value_render_option is FORMATTED_VALUE. The default dateTime render option is
   * [DateTimeRenderOption.SERIAL_NUMBER].
   * @param dateTimeRenderOption dateTimeRenderOption or {@code null} for none
   */
  public BatchGetValuesByDataFilterRequest setDateTimeRenderOption(java.lang.String dateTimeRenderOption) {
    this.dateTimeRenderOption = dateTimeRenderOption;
    return this;
  }

  /**
   * The major dimension that results should use.
   *
   * For example, if the spreadsheet data is: `A1=1,B1=2,A2=3,B2=4`, then a request that selects
   * that range and sets `majorDimension=ROWS` returns `[[1,2],[3,4]]`, whereas a request that sets
   * `majorDimension=COLUMNS` returns `[[1,3],[2,4]]`.
   * @return value or {@code null} for none
   */
  public java.lang.String getMajorDimension() {
    return majorDimension;
  }

  /**
   * The major dimension that results should use.
   *
   * For example, if the spreadsheet data is: `A1=1,B1=2,A2=3,B2=4`, then a request that selects
   * that range and sets `majorDimension=ROWS` returns `[[1,2],[3,4]]`, whereas a request that sets
   * `majorDimension=COLUMNS` returns `[[1,3],[2,4]]`.
   * @param majorDimension majorDimension or {@code null} for none
   */
  public BatchGetValuesByDataFilterRequest setMajorDimension(java.lang.String majorDimension) {
    this.majorDimension = majorDimension;
    return this;
  }

  /**
   * How values should be represented in the output. The default render option is
   * ValueRenderOption.FORMATTED_VALUE.
   * @return value or {@code null} for none
   */
  public java.lang.String getValueRenderOption() {
    return valueRenderOption;
  }

  /**
   * How values should be represented in the output. The default render option is
   * ValueRenderOption.FORMATTED_VALUE.
   * @param valueRenderOption valueRenderOption or {@code null} for none
   */
  public BatchGetValuesByDataFilterRequest setValueRenderOption(java.lang.String valueRenderOption) {
    this.valueRenderOption = valueRenderOption;
    return this;
  }

  @Override
  public BatchGetValuesByDataFilterRequest set(String fieldName, Object value) {
    return (BatchGetValuesByDataFilterRequest) super.set(fieldName, value);
  }

  @Override
  public BatchGetValuesByDataFilterRequest clone() {
    return (BatchGetValuesByDataFilterRequest) super.clone();
  }

}
