/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.sheets.v4.model;

/**
 * Properties referring a single dimension (either row or column). If both
 * BandedRange.row_properties and BandedRange.column_properties are set, the fill colors are applied
 * to cells according to the following rules:
 *
 * * header_color and footer_color take priority over band colors. * first_band_color takes priority
 * over second_band_color. * row_properties takes priority over column_properties.
 *
 * For example, the first row color takes priority over the first column color, but the first column
 * color takes priority over the second row color. Similarly, the row header takes priority over the
 * column header in the top left cell, but the column header takes priority over the first row color
 * if the row header is not set.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Sheets API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class BandingProperties extends com.google.api.client.json.GenericJson {

  /**
   * The first color that is alternating. (Required)
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Color firstBandColor;

  /**
   * The first color that is alternating. (Required) If first_band_color is also set, this field
   * takes precedence.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ColorStyle firstBandColorStyle;

  /**
   * The color of the last row or column. If this field is not set, the last row or column is filled
   * with either first_band_color or second_band_color, depending on the color of the previous row
   * or column.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Color footerColor;

  /**
   * The color of the last row or column. If this field is not set, the last row or column is filled
   * with either first_band_color or second_band_color, depending on the color of the previous row
   * or column. If footer_color is also set, this field takes precedence.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ColorStyle footerColorStyle;

  /**
   * The color of the first row or column. If this field is set, the first row or column is filled
   * with this color and the colors alternate between first_band_color and second_band_color
   * starting from the second row or column. Otherwise, the first row or column is filled with
   * first_band_color and the colors proceed to alternate as they normally would.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Color headerColor;

  /**
   * The color of the first row or column. If this field is set, the first row or column is filled
   * with this color and the colors alternate between first_band_color and second_band_color
   * starting from the second row or column. Otherwise, the first row or column is filled with
   * first_band_color and the colors proceed to alternate as they normally would. If header_color is
   * also set, this field takes precedence.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ColorStyle headerColorStyle;

  /**
   * The second color that is alternating. (Required)
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Color secondBandColor;

  /**
   * The second color that is alternating. (Required) If second_band_color is also set, this field
   * takes precedence.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ColorStyle secondBandColorStyle;

  /**
   * The first color that is alternating. (Required)
   * @return value or {@code null} for none
   */
  public Color getFirstBandColor() {
    return firstBandColor;
  }

  /**
   * The first color that is alternating. (Required)
   * @param firstBandColor firstBandColor or {@code null} for none
   */
  public BandingProperties setFirstBandColor(Color firstBandColor) {
    this.firstBandColor = firstBandColor;
    return this;
  }

  /**
   * The first color that is alternating. (Required) If first_band_color is also set, this field
   * takes precedence.
   * @return value or {@code null} for none
   */
  public ColorStyle getFirstBandColorStyle() {
    return firstBandColorStyle;
  }

  /**
   * The first color that is alternating. (Required) If first_band_color is also set, this field
   * takes precedence.
   * @param firstBandColorStyle firstBandColorStyle or {@code null} for none
   */
  public BandingProperties setFirstBandColorStyle(ColorStyle firstBandColorStyle) {
    this.firstBandColorStyle = firstBandColorStyle;
    return this;
  }

  /**
   * The color of the last row or column. If this field is not set, the last row or column is filled
   * with either first_band_color or second_band_color, depending on the color of the previous row
   * or column.
   * @return value or {@code null} for none
   */
  public Color getFooterColor() {
    return footerColor;
  }

  /**
   * The color of the last row or column. If this field is not set, the last row or column is filled
   * with either first_band_color or second_band_color, depending on the color of the previous row
   * or column.
   * @param footerColor footerColor or {@code null} for none
   */
  public BandingProperties setFooterColor(Color footerColor) {
    this.footerColor = footerColor;
    return this;
  }

  /**
   * The color of the last row or column. If this field is not set, the last row or column is filled
   * with either first_band_color or second_band_color, depending on the color of the previous row
   * or column. If footer_color is also set, this field takes precedence.
   * @return value or {@code null} for none
   */
  public ColorStyle getFooterColorStyle() {
    return footerColorStyle;
  }

  /**
   * The color of the last row or column. If this field is not set, the last row or column is filled
   * with either first_band_color or second_band_color, depending on the color of the previous row
   * or column. If footer_color is also set, this field takes precedence.
   * @param footerColorStyle footerColorStyle or {@code null} for none
   */
  public BandingProperties setFooterColorStyle(ColorStyle footerColorStyle) {
    this.footerColorStyle = footerColorStyle;
    return this;
  }

  /**
   * The color of the first row or column. If this field is set, the first row or column is filled
   * with this color and the colors alternate between first_band_color and second_band_color
   * starting from the second row or column. Otherwise, the first row or column is filled with
   * first_band_color and the colors proceed to alternate as they normally would.
   * @return value or {@code null} for none
   */
  public Color getHeaderColor() {
    return headerColor;
  }

  /**
   * The color of the first row or column. If this field is set, the first row or column is filled
   * with this color and the colors alternate between first_band_color and second_band_color
   * starting from the second row or column. Otherwise, the first row or column is filled with
   * first_band_color and the colors proceed to alternate as they normally would.
   * @param headerColor headerColor or {@code null} for none
   */
  public BandingProperties setHeaderColor(Color headerColor) {
    this.headerColor = headerColor;
    return this;
  }

  /**
   * The color of the first row or column. If this field is set, the first row or column is filled
   * with this color and the colors alternate between first_band_color and second_band_color
   * starting from the second row or column. Otherwise, the first row or column is filled with
   * first_band_color and the colors proceed to alternate as they normally would. If header_color is
   * also set, this field takes precedence.
   * @return value or {@code null} for none
   */
  public ColorStyle getHeaderColorStyle() {
    return headerColorStyle;
  }

  /**
   * The color of the first row or column. If this field is set, the first row or column is filled
   * with this color and the colors alternate between first_band_color and second_band_color
   * starting from the second row or column. Otherwise, the first row or column is filled with
   * first_band_color and the colors proceed to alternate as they normally would. If header_color is
   * also set, this field takes precedence.
   * @param headerColorStyle headerColorStyle or {@code null} for none
   */
  public BandingProperties setHeaderColorStyle(ColorStyle headerColorStyle) {
    this.headerColorStyle = headerColorStyle;
    return this;
  }

  /**
   * The second color that is alternating. (Required)
   * @return value or {@code null} for none
   */
  public Color getSecondBandColor() {
    return secondBandColor;
  }

  /**
   * The second color that is alternating. (Required)
   * @param secondBandColor secondBandColor or {@code null} for none
   */
  public BandingProperties setSecondBandColor(Color secondBandColor) {
    this.secondBandColor = secondBandColor;
    return this;
  }

  /**
   * The second color that is alternating. (Required) If second_band_color is also set, this field
   * takes precedence.
   * @return value or {@code null} for none
   */
  public ColorStyle getSecondBandColorStyle() {
    return secondBandColorStyle;
  }

  /**
   * The second color that is alternating. (Required) If second_band_color is also set, this field
   * takes precedence.
   * @param secondBandColorStyle secondBandColorStyle or {@code null} for none
   */
  public BandingProperties setSecondBandColorStyle(ColorStyle secondBandColorStyle) {
    this.secondBandColorStyle = secondBandColorStyle;
    return this;
  }

  @Override
  public BandingProperties set(String fieldName, Object value) {
    return (BandingProperties) super.set(fieldName, value);
  }

  @Override
  public BandingProperties clone() {
    return (BandingProperties) super.clone();
  }

}
