/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.sheets.v4.model;

/**
 * Additional properties of a SheetType.DATA_SOURCE sheet.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Sheets API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class DataSourceSheetProperties extends com.google.api.client.json.GenericJson {

  /**
   * The columns displayed on the sheet, corresponding to the values in RowData.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<DataSourceColumn> columns;

  static {
    // hack to force ProGuard to consider DataSourceColumn used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(DataSourceColumn.class);
  }

  /**
   * The data execution status.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DataExecutionStatus dataExecutionStatus;

  /**
   * ID of the DataSource the sheet connected with.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String dataSourceId;

  /**
   * The columns displayed on the sheet, corresponding to the values in RowData.
   * @return value or {@code null} for none
   */
  public java.util.List<DataSourceColumn> getColumns() {
    return columns;
  }

  /**
   * The columns displayed on the sheet, corresponding to the values in RowData.
   * @param columns columns or {@code null} for none
   */
  public DataSourceSheetProperties setColumns(java.util.List<DataSourceColumn> columns) {
    this.columns = columns;
    return this;
  }

  /**
   * The data execution status.
   * @return value or {@code null} for none
   */
  public DataExecutionStatus getDataExecutionStatus() {
    return dataExecutionStatus;
  }

  /**
   * The data execution status.
   * @param dataExecutionStatus dataExecutionStatus or {@code null} for none
   */
  public DataSourceSheetProperties setDataExecutionStatus(DataExecutionStatus dataExecutionStatus) {
    this.dataExecutionStatus = dataExecutionStatus;
    return this;
  }

  /**
   * ID of the DataSource the sheet connected with.
   * @return value or {@code null} for none
   */
  public java.lang.String getDataSourceId() {
    return dataSourceId;
  }

  /**
   * ID of the DataSource the sheet connected with.
   * @param dataSourceId dataSourceId or {@code null} for none
   */
  public DataSourceSheetProperties setDataSourceId(java.lang.String dataSourceId) {
    this.dataSourceId = dataSourceId;
    return this;
  }

  @Override
  public DataSourceSheetProperties set(String fieldName, Object value) {
    return (DataSourceSheetProperties) super.set(fieldName, value);
  }

  @Override
  public DataSourceSheetProperties clone() {
    return (DataSourceSheetProperties) super.clone();
  }

}
