/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.sheets.v4.model;

/**
 * The specification of a data source.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Sheets API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class DataSourceSpec extends com.google.api.client.json.GenericJson {

  /**
   * A BigQueryDataSourceSpec.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private BigQueryDataSourceSpec bigQuery;

  /**
   * The parameters of the data source.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<DataSourceParameter> parameters;

  static {
    // hack to force ProGuard to consider DataSourceParameter used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(DataSourceParameter.class);
  }

  /**
   * A BigQueryDataSourceSpec.
   * @return value or {@code null} for none
   */
  public BigQueryDataSourceSpec getBigQuery() {
    return bigQuery;
  }

  /**
   * A BigQueryDataSourceSpec.
   * @param bigQuery bigQuery or {@code null} for none
   */
  public DataSourceSpec setBigQuery(BigQueryDataSourceSpec bigQuery) {
    this.bigQuery = bigQuery;
    return this;
  }

  /**
   * The parameters of the data source.
   * @return value or {@code null} for none
   */
  public java.util.List<DataSourceParameter> getParameters() {
    return parameters;
  }

  /**
   * The parameters of the data source.
   * @param parameters parameters or {@code null} for none
   */
  public DataSourceSpec setParameters(java.util.List<DataSourceParameter> parameters) {
    this.parameters = parameters;
    return this;
  }

  @Override
  public DataSourceSpec set(String fieldName, Object value) {
    return (DataSourceSpec) super.set(fieldName, value);
  }

  @Override
  public DataSourceSpec clone() {
    return (DataSourceSpec) super.clone();
  }

}
